/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.gpg;

import com.intellij.credentialStore.gpg.GpgToolWrapper;
import com.intellij.credentialStore.gpg.GpgUtilKt;
import com.intellij.credentialStore.gpg.PgpKey;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/credentialStore/gpg/Pgp;", "", "gpgTool", "Lcom/intellij/credentialStore/gpg/GpgToolWrapper;", "(Lcom/intellij/credentialStore/gpg/GpgToolWrapper;)V", "decrypt", "", "data", "encrypt", "recipient", "", "listKeys", "", "Lcom/intellij/credentialStore/gpg/PgpKey;", "intellij.platform.credentialStore"})
public final class Pgp {
    private final GpgToolWrapper gpgTool;

    @NotNull
    public final List<PgpKey> listKeys() {
        SmartList result = new SmartList();
        String keyId = null;
        String capabilities = null;
        String string = StringUtilRt.convertLineSeparators((String)this.gpgTool.listSecretKeys());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtilRt.convertLine\u2026gpgTool.listSecretKeys())");
        for (String line : StringsKt.splitToSequence$default((CharSequence)string, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null)) {
            String tag;
            Iterator fields = StringsKt.splitToSequence$default((CharSequence)line, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null).iterator();
            if (!fields.hasNext()) continue;
            switch (tag = (String)fields.next()) {
                case "sec": {
                    int i;
                    int n = 2;
                    int n2 = 5;
                    while (n < n2) {
                        fields.next();
                        ++i;
                    }
                    keyId = (String)fields.next();
                    n2 = 12;
                    for (i = 6; i < n2; ++i) {
                        fields.next();
                    }
                    capabilities = (String)fields.next();
                    break;
                }
                case "uid": {
                    int i;
                    String string2 = capabilities;
                    Intrinsics.checkNotNull((Object)string2);
                    if (StringsKt.contains$default((CharSequence)string2, (char)'D', (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)capabilities, (char)'E', (boolean)false, (int)2, null)) break;
                    int n2 = 10;
                    for (i = 2; i < n2; ++i) {
                        fields.next();
                    }
                    String string3 = keyId;
                    Intrinsics.checkNotNull((Object)string3);
                    result.add((Object)new PgpKey(string3, StringsKt.replace$default((String)((String)fields.next()), (String)"=\\x3a=", (String)":", (boolean)false, (int)4, null)));
                    break;
                }
            }
        }
        return (List)result;
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.gpgTool.decrypt(data);
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] data, @NotNull String recipient) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        return this.gpgTool.encrypt(data, recipient);
    }

    public Pgp(@NotNull GpgToolWrapper gpgTool) {
        Intrinsics.checkNotNullParameter((Object)gpgTool, (String)"gpgTool");
        this.gpgTool = gpgTool;
    }

    public /* synthetic */ Pgp(GpgToolWrapper gpgToolWrapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gpgToolWrapper = GpgUtilKt.createGpg();
        }
        this(gpgToolWrapper);
    }

    public Pgp() {
        this(null, 1, null);
    }
}

