/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.request;

import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpResponse;
import com.intellij.internal.statistic.eventLog.connection.request.StatsProxyInfo;
import com.intellij.internal.statistic.eventLog.connection.request.StatsRequestResult;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseHandler;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;

public class StatsRequestBuilder {
    private final String myUserAgent;
    private final StatsProxyInfo myProxyInfo;
    private final SSLContext mySSLContext;
    private final String myUrl;
    private final String myMethod;
    private StringEntity myBody;
    private StatsResponseHandler onSucceed;
    private StatsResponseHandler onFail;

    public StatsRequestBuilder(@NotNull String method, @NotNull String url, @NotNull EventLogConnectionSettings settings) {
        if (method == null) {
            StatsRequestBuilder.$$$reportNull$$$0(0);
        }
        if (url == null) {
            StatsRequestBuilder.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            StatsRequestBuilder.$$$reportNull$$$0(2);
        }
        this.myMethod = method;
        this.myUrl = url;
        this.myUserAgent = settings.getUserAgent();
        this.myProxyInfo = settings.selectProxy(this.myUrl);
        this.mySSLContext = settings.getSSLContext();
    }

    @NotNull
    public StatsRequestBuilder withBody(@NotNull String body, @NotNull ContentType contentType) {
        if (body == null) {
            StatsRequestBuilder.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            StatsRequestBuilder.$$$reportNull$$$0(4);
        }
        this.myBody = new StringEntity(body, contentType);
        StatsRequestBuilder statsRequestBuilder = this;
        if (statsRequestBuilder == null) {
            StatsRequestBuilder.$$$reportNull$$$0(5);
        }
        return statsRequestBuilder;
    }

    @NotNull
    public StatsRequestBuilder fail(@NotNull StatsResponseHandler processor) {
        if (processor == null) {
            StatsRequestBuilder.$$$reportNull$$$0(6);
        }
        this.onFail = processor;
        StatsRequestBuilder statsRequestBuilder = this;
        if (statsRequestBuilder == null) {
            StatsRequestBuilder.$$$reportNull$$$0(7);
        }
        return statsRequestBuilder;
    }

    @NotNull
    public StatsRequestBuilder succeed(@NotNull StatsResponseHandler processor) {
        if (processor == null) {
            StatsRequestBuilder.$$$reportNull$$$0(8);
        }
        this.onSucceed = processor;
        StatsRequestBuilder statsRequestBuilder = this;
        if (statsRequestBuilder == null) {
            StatsRequestBuilder.$$$reportNull$$$0(9);
        }
        return statsRequestBuilder;
    }

    public void send() throws IOException, StatsResponseException {
        this.send(response -> {
            if (this.onSucceed != null) {
                this.onSucceed.handle(response, 200);
            }
            return true;
        });
    }

    public <T> StatsRequestResult<T> send(StatsResponseProcessor<? extends T> processor) throws IOException, StatsResponseException {
        HttpRequestBase request = this.newRequest();
        try (CloseableHttpClient client = this.newClient(this.myUserAgent);){
            StatsRequestResult statsRequestResult;
            block17: {
                int code;
                CloseableHttpResponse response;
                block15: {
                    StatsRequestResult<T> statsRequestResult2;
                    block16: {
                        response = client.execute((HttpUriRequest)request);
                        try {
                            StatusLine statusLine = response.getStatusLine();
                            int n = code = statusLine != null ? statusLine.getStatusCode() : -1;
                            if (code != 200) break block15;
                            T result = processor.onSucceed(new StatsHttpResponse((HttpResponse)response, code));
                            statsRequestResult2 = StatsRequestResult.succeed(result);
                            if (response == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return statsRequestResult2;
                }
                if (this.onFail != null) {
                    this.onFail.handle(new StatsHttpResponse((HttpResponse)response, code), code);
                }
                statsRequestResult = StatsRequestResult.error(code);
                if (response == null) break block17;
                response.close();
            }
            return statsRequestResult;
        }
    }

    private CloseableHttpClient newClient(@NotNull String userAgent) {
        if (userAgent == null) {
            StatsRequestBuilder.$$$reportNull$$$0(10);
        }
        HttpClientBuilder builder = HttpClientBuilder.create().setUserAgent(userAgent);
        if (this.myProxyInfo != null && !this.myProxyInfo.isNoProxy()) {
            StatsRequestBuilder.configureProxy(builder, this.myProxyInfo);
        }
        if (this.mySSLContext != null) {
            builder.setSSLContext(this.mySSLContext);
        }
        return builder.build();
    }

    private static void configureProxy(@NotNull HttpClientBuilder builder, @NotNull StatsProxyInfo info) {
        SocketAddress proxyAddress;
        Proxy proxy;
        if (builder == null) {
            StatsRequestBuilder.$$$reportNull$$$0(11);
        }
        if (info == null) {
            StatsRequestBuilder.$$$reportNull$$$0(12);
        }
        if ((proxy = info.getProxy()).type() == Proxy.Type.HTTP && (proxyAddress = proxy.address()) instanceof InetSocketAddress) {
            String login;
            InetSocketAddress address = (InetSocketAddress)proxyAddress;
            String hostName = address.getHostName();
            int port = address.getPort();
            builder.setProxy(new HttpHost(hostName, port));
            StatsProxyInfo.StatsProxyAuthProvider auth = info.getProxyAuth();
            if (auth != null && (login = auth.getProxyLogin()) != null) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(new AuthScope(hostName, port), (Credentials)new UsernamePasswordCredentials(login, auth.getProxyPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
        }
    }

    @NotNull
    private HttpRequestBase newRequest() {
        if ("HEAD".equals(this.myMethod)) {
            return new HttpHead(this.myUrl);
        }
        if ("POST".equals(this.myMethod)) {
            HttpPost post = new HttpPost(this.myUrl);
            if (this.myBody != null) {
                post.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)this.myBody));
            }
            HttpPost httpPost = post;
            if (httpPost == null) {
                StatsRequestBuilder.$$$reportNull$$$0(13);
            }
            return httpPost;
        }
        if ("GET".equals(this.myMethod)) {
            return new HttpGet(this.myUrl);
        }
        throw new IllegalArgumentException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/request/StatsRequestBuilder";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAgent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/request/StatsRequestBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withBody";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fail";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "succeed";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withBody";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fail";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "succeed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newClient";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configureProxy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

