/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupRemoteDescriptors;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataLoadException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUpdateError;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.storage.BaseValidationRulesPersistedStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.EventLogMetadataLoader;
import com.intellij.internal.statistic.eventLog.validator.storage.EventLogServerMetadataLoader;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataPersistence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ValidationRulesPersistedStorage
extends BaseValidationRulesPersistedStorage {
    private static final Logger LOG = Logger.getInstance(ValidationRulesPersistedStorage.class);
    protected final ConcurrentMap<String, EventGroupRules> eventsValidators;
    @NotNull
    private final Semaphore mySemaphore;
    @NotNull
    private final String myRecorderId;
    @Nullable
    private String myVersion;
    @NotNull
    private final EventLogMetadataPersistence myMetadataPersistence;
    @NotNull
    private final EventLogMetadataLoader myMetadataLoader;

    ValidationRulesPersistedStorage(@NotNull String recorderId) {
        if (recorderId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(0);
        }
        this.eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myMetadataPersistence = new EventLogMetadataPersistence(recorderId);
        this.myMetadataLoader = new EventLogServerMetadataLoader(recorderId);
        this.myVersion = this.loadValidatorsFromLocalCache(recorderId);
    }

    @TestOnly
    protected ValidationRulesPersistedStorage(@NotNull String recorderId, @NotNull EventLogMetadataPersistence persistence, @NotNull EventLogMetadataLoader loader) {
        if (recorderId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(1);
        }
        if (persistence == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(2);
        }
        if (loader == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(3);
        }
        this.eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myMetadataPersistence = persistence;
        this.myMetadataLoader = loader;
        this.myVersion = this.loadValidatorsFromLocalCache(recorderId);
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        if (groupId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(4);
        }
        return (EventGroupRules)this.eventsValidators.get(groupId);
    }

    @Nullable
    private String loadValidatorsFromLocalCache(@NotNull String recorderId) {
        String rawEventsScheme;
        if (recorderId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(5);
        }
        if ((rawEventsScheme = this.myMetadataPersistence.getCachedEventsScheme()) != null) {
            try {
                String newVersion = this.updateValidators(rawEventsScheme);
                EventLogSystemLogger.logMetadataLoad(recorderId, newVersion);
                return newVersion;
            }
            catch (EventLogMetadataParseException e) {
                EventLogSystemLogger.logMetadataErrorOnLoad(this.myRecorderId, (EventLogMetadataUpdateError)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String updateValidators(@NotNull String rawEventsScheme) throws EventLogMetadataParseException {
        if (rawEventsScheme == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(6);
        }
        this.mySemaphore.down();
        try {
            EventGroupRemoteDescriptors groups = EventLogMetadataUtils.parseGroupRemoteDescriptors((String)rawEventsScheme);
            EventLogBuild build2 = EventLogBuild.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
            Map<String, EventGroupRules> result = this.createValidators(build2, groups);
            this.isInitialized.set(false);
            this.eventsValidators.clear();
            this.eventsValidators.putAll(result);
            this.isInitialized.set(true);
            String string = groups.version;
            return string;
        }
        finally {
            this.mySemaphore.up();
        }
    }

    @Override
    public void update() {
        EventLogConfigOptionsService.getInstance().updateOptions(this.myRecorderId, this.myMetadataLoader);
        long lastModifiedLocally = this.myMetadataPersistence.getLastModified();
        long lastModifiedOnServer = this.myMetadataLoader.getLastModifiedOnServer();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading events scheme, last modified cached=" + lastModifiedLocally + ", last modified on the server=" + lastModifiedOnServer);
        }
        try {
            if (lastModifiedOnServer <= 0L || lastModifiedOnServer > lastModifiedLocally || this.isUnreachable()) {
                String rawEventsSchemeFromServer = this.myMetadataLoader.loadMetadataFromServer();
                String version = this.updateValidators(rawEventsSchemeFromServer);
                this.myMetadataPersistence.cacheEventsScheme(rawEventsSchemeFromServer, lastModifiedOnServer);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Update local events scheme, last modified cached=" + this.myMetadataPersistence.getLastModified());
                }
                if (version != null && !StringUtil.equals((CharSequence)version, (CharSequence)this.myVersion)) {
                    this.myVersion = version;
                    EventLogSystemLogger.logMetadataUpdated(this.myRecorderId, this.myVersion);
                }
            }
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            EventLogSystemLogger.logMetadataErrorOnUpdate(this.myRecorderId, (EventLogMetadataUpdateError)e);
        }
    }

    @Override
    public void reload() {
        this.myVersion = this.loadValidatorsFromLocalCache(this.myRecorderId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawEventsScheme";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/ValidationRulesPersistedStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupRules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadValidatorsFromLocalCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateValidators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

