/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;

@State(name="TextMateSettings", storages={@Storage(value="$CACHE_FILE$")})
@Service
public final class TextMateSettings
implements PersistentStateComponent<TextMateSettingsState> {
    private TextMateSettingsState myState;

    public static TextMateSettings getInstance() {
        return (TextMateSettings)ApplicationManager.getApplication().getService(TextMateSettings.class);
    }

    @Nullable
    public TextMateSettingsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull TextMateSettingsState state) {
        if (state == null) {
            TextMateSettings.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    public Collection<BundleConfigBean> getBundles() {
        return this.myState != null ? this.myState.getBundles() : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/textmate/configuration/TextMateSettings", "loadState"));
    }

    public static final class TextMateSettingsState {
        @XCollection(style=XCollection.Style.v2)
        private final ArrayList<BundleConfigBean> bundles = new ArrayList();

        @Transient
        public List<BundleConfigBean> getBundles() {
            return this.bundles;
        }

        @Transient
        public void setBundles(@NotNull Collection<BundleConfigBean> value) {
            if (value == null) {
                TextMateSettingsState.$$$reportNull$$$0(0);
            }
            this.bundles.clear();
            this.bundles.ensureCapacity(value.size());
            for (BundleConfigBean bundle : value) {
                this.bundles.add(bundle.copy());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextMateSettingsState state = (TextMateSettingsState)o;
            return this.bundles.equals(state.bundles);
        }

        public int hashCode() {
            return this.bundles.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/textmate/configuration/TextMateSettings$TextMateSettingsState", "setBundles"));
        }
    }
}

