/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.timing;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;

public final class Wait {
    private final Timeout myTimeout;

    private Wait(@Nonnull Timeout timeout) {
        this.myTimeout = timeout;
    }

    public static Wait seconds(long secondsToWait) {
        return new Wait(Timeout.timeout(secondsToWait, TimeUnit.SECONDS));
    }

    public WithDescription expecting(@Nonnull String description) {
        return new WithDescription(description);
    }

    public static interface Objective {
        public boolean isMet();
    }

    public final class WithDescription {
        private final String myDescription;

        private WithDescription(String description) {
            this.myDescription = description;
        }

        public void until(final @Nonnull Objective objective) {
            Condition condition = new Condition(this.myDescription){

                @Override
                public boolean test() {
                    return objective.isMet();
                }
            };
            Pause.pause(condition, Wait.this.myTimeout);
        }
    }
}

