/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JApplet;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JAppletDriver
extends ComponentDriver
implements AppletStub {
    private JApplet applet;

    public JAppletDriver(@Nonnull Robot robot) {
        super(robot);
    }

    public JAppletDriver(@Nonnull Robot robot, @Nonnull JApplet newApplet) {
        this(robot);
        this.applet = newApplet;
    }

    @RunsInEDT
    private static void doResize(final @Nonnull JApplet applet, final int width, final int height) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                applet.resize(width, height);
            }
        });
    }

    @Nullable
    @RunsInEDT
    private static URL codeBase(final @Nonnull JApplet applet) {
        return GuiActionRunner.execute(new GuiQuery<URL>(){

            @Override
            @Nullable
            protected URL executeInEDT() {
                return applet.getCodeBase();
            }
        });
    }

    @Nullable
    @RunsInEDT
    private static URL documentBase(final @Nonnull JApplet applet) {
        return GuiActionRunner.execute(new GuiQuery<URL>(){

            @Override
            protected URL executeInEDT() {
                return applet.getDocumentBase();
            }
        });
    }

    @Nullable
    @RunsInEDT
    private static String parameter(final @Nonnull JApplet applet, final @Nullable String parameterName) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            @Nullable
            protected String executeInEDT() {
                return applet.getParameter(parameterName);
            }
        });
    }

    @RunsInEDT
    private static boolean active(final @Nonnull JApplet applet) {
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            @Nullable
            protected Boolean executeInEDT() {
                return applet.isActive();
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    @Override
    @RunsInEDT
    public void appletResize(int width, int height) {
        this.appletResize(this.applet, width, height);
    }

    @RunsInEDT
    public void appletResize(@Nonnull JApplet applet, int width, int height) {
        JAppletDriver.doResize(applet, width, height);
    }

    @Override
    @RunsInEDT
    public AppletContext getAppletContext() {
        return this.getAppletContext(this.applet);
    }

    @RunsInEDT
    public AppletContext getAppletContext(JApplet applet) {
        return JAppletDriver.appletContext(applet);
    }

    @Nullable
    @RunsInEDT
    private static AppletContext appletContext(final @Nonnull JApplet applet) {
        return GuiActionRunner.execute(new GuiQuery<AppletContext>(){

            @Override
            @Nullable
            protected AppletContext executeInEDT() {
                return applet.getAppletContext();
            }
        });
    }

    @Override
    @Nullable
    @RunsInEDT
    public URL getCodeBase() {
        return this.getCodeBase(this.applet);
    }

    @Nullable
    @RunsInEDT
    public URL getCodeBase(@Nonnull JApplet applet) {
        return JAppletDriver.codeBase(applet);
    }

    @Override
    @Nullable
    @RunsInEDT
    public URL getDocumentBase() {
        return this.getDocumentBase(this.applet);
    }

    @Nullable
    @RunsInEDT
    public URL getDocumentBase(@Nonnull JApplet applet) {
        return JAppletDriver.documentBase(applet);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String getParameter(@Nullable String name) {
        return this.getParameter(this.applet, name);
    }

    @RunsInEDT
    public String getParameter(@Nonnull JApplet applet, @Nullable String name) {
        return JAppletDriver.parameter(applet, name);
    }

    @Override
    @RunsInEDT
    public boolean isActive() {
        return this.isActive(this.applet);
    }

    @RunsInEDT
    public boolean isActive(@Nonnull JApplet applet) {
        return JAppletDriver.active(applet);
    }

    @RunsInEDT
    public Applet getApplet(@Nonnull String name) {
        return this.applet.getAppletContext().getApplet(name);
    }

    @Nonnull
    @RunsInEDT
    public Enumeration<Applet> getApplets() {
        Enumeration<Applet> applets = this.applet.getAppletContext().getApplets();
        return applets != null ? applets : Collections.enumeration(Collections.emptyList());
    }
}

