/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.testFrameworks.ForkedDebuggerHelper;
import com.intellij.rt.execution.testFrameworks.ProcessBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public abstract class ForkedByModuleSplitter {
    protected final ForkedDebuggerHelper myForkedDebuggerHelper = new ForkedDebuggerHelper();
    protected final String myWorkingDirsPath;
    protected final String myForkMode;
    protected final List<String> myNewArgs;
    protected String myDynamicClasspath;
    protected List<String> myVMParameters;

    public ForkedByModuleSplitter(String workingDirsPath, String forkMode, List<String> newArgs) {
        this.myWorkingDirsPath = workingDirsPath;
        this.myForkMode = forkMode;
        this.myNewArgs = newArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startSplitting(String[] args, String configName, String commandLinePath, String repeatCount) throws Exception {
        args = this.myForkedDebuggerHelper.excludeDebugPortFromArgs(args);
        this.myVMParameters = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(commandLinePath));
        this.myDynamicClasspath = bufferedReader.readLine();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.myVMParameters.add(line);
            }
        }
        finally {
            bufferedReader.close();
        }
        int result = this.startSplitting(args, configName, repeatCount);
        this.myForkedDebuggerHelper.closeDebugSocket();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int startChildFork(List<String> args, File workingDir, String classpath, List<String> moduleOptions, String repeatCount) throws IOException, InterruptedException {
        ProcessBuilder builder;
        block12: {
            ArrayList<String> vmParameters = new ArrayList<String>(this.myVMParameters);
            this.myForkedDebuggerHelper.setupDebugger(vmParameters);
            builder = new ProcessBuilder();
            builder.add(vmParameters);
            String encoding = System.getProperty("file.encoding");
            if (encoding != null) {
                builder.add("-Dfile.encoding=" + encoding);
            }
            builder.add("-classpath");
            if (this.myDynamicClasspath.length() > 0) {
                try {
                    if ("ARGS_FILE".equals(this.myDynamicClasspath)) {
                        File argFile = File.createTempFile("arg_file", null);
                        argFile.deleteOnExit();
                        FileOutputStream writer = new FileOutputStream(argFile);
                        try {
                            writer.write(classpath.getBytes(Charset.defaultCharset()));
                        }
                        finally {
                            writer.close();
                        }
                        builder.add("@" + argFile.getAbsolutePath());
                        break block12;
                    }
                    builder.add(ForkedByModuleSplitter.createClasspathJarFile(new Manifest(), classpath).getAbsolutePath());
                }
                catch (Throwable e) {
                    builder.add(classpath);
                }
            } else {
                builder.add(classpath);
            }
        }
        if (moduleOptions != null) {
            builder.add(moduleOptions);
        }
        builder.add(this.getStarterName());
        builder.add(args);
        if (repeatCount != null) {
            builder.add(repeatCount);
        }
        builder.setWorkingDir(workingDir);
        Process exec = builder.createProcess();
        new Thread(ForkedByModuleSplitter.createInputReader(exec.getErrorStream(), System.err), "Read forked error output").start();
        new Thread(ForkedByModuleSplitter.createInputReader(exec.getInputStream(), System.out), "Read forked output").start();
        return exec.waitFor();
    }

    private static Runnable createInputReader(final InputStream inputStream, final PrintStream outputStream) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    try {
                        String line;
                        while ((line = inputReader.readLine()) != null) {
                            outputStream.println(line);
                        }
                    }
                    finally {
                        inputReader.close();
                    }
                }
                catch (UnsupportedEncodingException inputReader) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int splitPerModule(String repeatCount) throws IOException {
        int result = 0;
        BufferedReader perDirReader = new BufferedReader(new FileReader(this.myWorkingDirsPath));
        try {
            String workingDir;
            String packageName = perDirReader.readLine();
            while ((workingDir = perDirReader.readLine()) != null) {
                String moduleName = perDirReader.readLine();
                String classpath = perDirReader.readLine();
                ArrayList<String> moduleOptions = new ArrayList<String>();
                String modulePath = perDirReader.readLine();
                if (modulePath != null && modulePath.length() > 0) {
                    moduleOptions.add("-p");
                    moduleOptions.add(modulePath);
                }
                int optionsSize = Integer.parseInt(perDirReader.readLine());
                for (int i = 0; i < optionsSize; ++i) {
                    moduleOptions.add(perDirReader.readLine());
                }
                try {
                    String filters;
                    ArrayList<String> classNames = new ArrayList<String>();
                    int classNamesSize = Integer.parseInt(perDirReader.readLine());
                    for (int i = 0; i < classNamesSize; ++i) {
                        String className = perDirReader.readLine();
                        if (className == null) {
                            System.err.println("Class name is expected. Working dir: " + workingDir);
                            result = -1;
                            break;
                        }
                        classNames.add(className);
                    }
                    int childResult = this.startPerModuleFork(moduleName, classNames, packageName, workingDir, classpath, moduleOptions, repeatCount, result, (filters = perDirReader.readLine()) != null ? filters : "");
                    result = Math.min(childResult, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            perDirReader.close();
        }
        return result;
    }

    protected abstract int startSplitting(String[] var1, String var2, String var3) throws Exception;

    protected abstract int startPerModuleFork(String var1, List<String> var2, String var3, String var4, String var5, List<String> var6, String var7, int var8, String var9) throws Exception;

    protected abstract String getStarterName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createClasspathJarFile(Manifest manifest, String classpath) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        StringBuilder classpathForManifest = new StringBuilder();
        int idx = 0;
        int endIdx = 0;
        while (endIdx >= 0) {
            String path;
            endIdx = classpath.indexOf(File.pathSeparator, idx);
            String string = path = endIdx < 0 ? classpath.substring(idx) : classpath.substring(idx, endIdx);
            if (classpathForManifest.length() > 0) {
                classpathForManifest.append(" ");
            }
            try {
                classpathForManifest.append(new File(path).toURI().toURL().toString());
            }
            catch (NoSuchMethodError e) {
                classpathForManifest.append(new File(path).toURL().toString());
            }
            idx = endIdx + File.pathSeparator.length();
        }
        attributes.put(Attributes.Name.CLASS_PATH, classpathForManifest.toString());
        File jarFile = File.createTempFile("classpath", ".jar");
        ZipOutputStream jarPlugin = null;
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jarFile));
            jarPlugin = new JarOutputStream((OutputStream)out, manifest);
        }
        finally {
            if (jarPlugin != null) {
                jarPlugin.close();
            }
        }
        jarFile.deleteOnExit();
        return jarFile;
    }
}

