/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.EdgesInRowGenerator;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl$WhenMappings;
import com.intellij.vcs.log.graph.impl.print.elements.EdgePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.impl.print.elements.SimplePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 12\u00020\u0001:\u000212B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB/\b\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u0000H\u0002J&\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0006\u0012\u0004\u0018\u00010\u000b0 2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0007H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0006\u0010.\u001a\u00020\u000bJ\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0018\u00100\u001a\u00020\u00072\u0006\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0018\u00100\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u000bH\u0002R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl;", "Lcom/intellij/vcs/log/graph/api/printer/PrintElementGenerator;", "graph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "printElementManager", "Lcom/intellij/vcs/log/graph/api/printer/PrintElementManager;", "showLongEdges", "", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/printer/PrintElementManager;Z)V", "linearGraph", "longEdgeSize", "", "visiblePartSize", "edgeWithArrowSize", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/printer/PrintElementManager;III)V", "cache", "Lcom/intellij/util/containers/SLRUMap;", "", "Lcom/intellij/vcs/log/graph/api/elements/GraphElement;", "edgesInRowGenerator", "Lcom/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator;", "elementComparator", "Ljava/util/Comparator;", "getElementComparator", "()Ljava/util/Comparator;", "recommendedWidth", "collectElements", "", "rowIndex", "builder", "Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$PrintElementBuilder;", "createEndPositionFunction", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/graph/api/elements/GraphEdge;", "visibleRowIndex", "up", "getArrowType", "Lcom/intellij/vcs/log/graph/EdgePrintElement$Type;", "edge", "normalEdge", "Lcom/intellij/vcs/log/graph/utils/NormalEdge;", "getAttachmentDistance", "e1", "getPrintElements", "", "Lcom/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement;", "getRecommendedWidth", "getSortedVisibleElementsInRow", "isEdgeVisibleInRow", "Companion", "PrintElementBuilder", "intellij.platform.vcs.log.graph.impl"})
public final class PrintElementGeneratorImpl
implements PrintElementGenerator {
    private final SLRUMap<Integer, List<GraphElement>> cache;
    private final EdgesInRowGenerator edgesInRowGenerator;
    private int recommendedWidth;
    private final LinearGraph linearGraph;
    private final PrintElementManager printElementManager;
    private final int longEdgeSize;
    private final int visiblePartSize;
    private final int edgeWithArrowSize;
    private static final Logger LOG;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    public static final int LONG_EDGE_SIZE = 30;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int CACHE_SIZE = 100;
    private static final int SAMPLE_SIZE = 20000;
    private static final double K = 0.1;
    public static final Companion Companion;

    private final Comparator<GraphElement> getElementComparator() {
        Comparator<GraphElement> comparator = this.printElementManager.getGraphElementComparator();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"printElementManager.graphElementComparator");
        return comparator;
    }

    /*
     * WARNING - void declaration
     */
    public final int getRecommendedWidth() {
        if (this.recommendedWidth <= 0) {
            int n = Math.min(20000, this.linearGraph.nodesCount());
            double sum = 0.0;
            double sumSquares = 0.0;
            int edgesCount = 0;
            Set set = CollectionFactory.createSmallMemoryFootprintSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CollectionFactory.create\u2026ootprintSet<NormalEdge>()");
            Set currentNormalEdges = set;
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                Object normalEdge;
                List<GraphEdge> adjacentEdges;
                void i;
                Intrinsics.checkNotNullExpressionValue(this.linearGraph.getAdjacentEdges((int)i, EdgeFilter.ALL), (String)"linearGraph.getAdjacentEdges(i, EdgeFilter.ALL)");
                int upArrows = 0;
                int downArrows = 0;
                for (GraphEdge e : adjacentEdges) {
                    normalEdge = LinearGraphUtils.asNormalEdge(e);
                    if (normalEdge != null) {
                        if (LinearGraphUtils.isEdgeUp(e, (int)i)) {
                            currentNormalEdges.remove(normalEdge);
                            continue;
                        }
                        currentNormalEdges.add(normalEdge);
                        continue;
                    }
                    GraphEdge graphEdge = e;
                    Intrinsics.checkNotNullExpressionValue((Object)graphEdge, (String)"e");
                    if (graphEdge.getType() == GraphEdgeType.DOTTED_ARROW_UP) {
                        ++upArrows;
                        continue;
                    }
                    ++downArrows;
                }
                int newEdgesCount = 0;
                normalEdge = currentNormalEdges.iterator();
                while (normalEdge.hasNext()) {
                    NormalEdge e;
                    NormalEdge normalEdge2 = e = (NormalEdge)normalEdge.next();
                    Intrinsics.checkNotNullExpressionValue((Object)normalEdge2, (String)"e");
                    if (this.isEdgeVisibleInRow(normalEdge2, (int)i)) {
                        ++newEdgesCount;
                        continue;
                    }
                    EdgePrintElement.Type arrow = this.getArrowType(e, (int)i);
                    if (arrow == EdgePrintElement.Type.DOWN) {
                        ++downArrows;
                        continue;
                    }
                    if (arrow != EdgePrintElement.Type.UP) continue;
                    ++upArrows;
                }
                int width = Math.max(edgesCount + upArrows, newEdgesCount + downArrows);
                double weight = (double)2 / ((double)n * 1.1) * (1.0 + -0.9 * (double)i / (double)(n - 1));
                sum += (double)width * weight;
                sumSquares += (double)width * (double)width * weight;
                edgesCount = newEdgesCount;
                ++i;
            }
            double average = sum;
            double deviation = Math.sqrt(sumSquares - average * average);
            this.recommendedWidth = (int)Math.round(average + deviation);
        }
        return this.recommendedWidth;
    }

    /*
     * WARNING - void declaration
     */
    private final void collectElements(int rowIndex, PrintElementBuilder builder) {
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(rowIndex);
        Function1<GraphEdge, Integer> upPosition = this.createEndPositionFunction(rowIndex - 1, true);
        Function1<GraphEdge, Integer> downPosition = this.createEndPositionFunction(rowIndex + 1, false);
        Iterable $this$forEachIndexed$iv = visibleElements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphElement graphElement = (GraphElement)item$iv;
            int position = n;
            boolean bl2 = false;
            void var16_16 = element;
            if (var16_16 instanceof GraphNode) {
                int nodeIndex = ((GraphNode)element).getNodeIndex();
                builder.consumeNode((GraphNode)element, position);
                List<GraphEdge> list = this.linearGraph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL);
                Intrinsics.checkNotNullExpressionValue(list, (String)"linearGraph.getAdjacentE\u2026odeIndex, EdgeFilter.ALL)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GraphEdge edge = (GraphEdge)element$iv;
                    boolean bl3 = false;
                    GraphEdge graphEdge = edge;
                    Intrinsics.checkNotNullExpressionValue((Object)graphEdge, (String)"edge");
                    EdgePrintElement.Type arrowType = this.getArrowType(graphEdge, rowIndex);
                    Integer down = (Integer)downPosition.invoke((Object)edge);
                    Integer up = (Integer)upPosition.invoke((Object)edge);
                    if (down != null) {
                        builder.consumeDownEdge(edge, position, down, arrowType == EdgePrintElement.Type.DOWN);
                    }
                    if (up == null) continue;
                    builder.consumeUpEdge(edge, up, position, arrowType == EdgePrintElement.Type.UP);
                }
                continue;
            }
            if (!(var16_16 instanceof GraphEdge)) continue;
            EdgePrintElement.Type arrowType = this.getArrowType((GraphEdge)element, rowIndex);
            Integer down = (Integer)downPosition.invoke((Object)element);
            Integer up = (Integer)upPosition.invoke((Object)element);
            if (down != null) {
                builder.consumeDownEdge((GraphEdge)element, position, down, arrowType == EdgePrintElement.Type.DOWN);
            } else if (arrowType == EdgePrintElement.Type.DOWN) {
                builder.consumeArrow((GraphEdge)element, position, arrowType);
            }
            if (up != null) {
                builder.consumeUpEdge((GraphEdge)element, up, position, arrowType == EdgePrintElement.Type.UP);
                continue;
            }
            if (arrowType != EdgePrintElement.Type.UP) continue;
            builder.consumeArrow((GraphEdge)element, position, arrowType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<GraphEdge, Integer> createEndPositionFunction(int visibleRowIndex, boolean up) {
        if (visibleRowIndex < 0 || visibleRowIndex >= this.linearGraph.nodesCount()) {
            return createEndPositionFunction.1.INSTANCE;
        }
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex);
        HashMap toPosition = new HashMap(visibleElementsInNextRow.size());
        Iterable $this$forEachIndexed$iv = visibleElementsInNextRow;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphElement graphElement = (GraphElement)item$iv;
            int position = n;
            boolean bl2 = false;
            ((Map)toPosition).put(element, position);
        }
        return (Function1)new Function1<GraphEdge, Integer>(this, toPosition, up){
            final /* synthetic */ PrintElementGeneratorImpl this$0;
            final /* synthetic */ HashMap $toPosition;
            final /* synthetic */ boolean $up;

            @Nullable
            public final Integer invoke(@NotNull GraphEdge edge) {
                Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
                Integer n = (Integer)this.$toPosition.get(edge);
                if (n == null) {
                    Integer nodeIndex;
                    PrintElementGeneratorImpl printElementGeneratorImpl = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    PrintElementGeneratorImpl $this$run = printElementGeneratorImpl;
                    boolean bl3 = false;
                    Integer n2 = nodeIndex = this.$up ? edge.getUpNodeIndex() : edge.getDownNodeIndex();
                    n = nodeIndex != null ? (Integer)this.$toPosition.get(PrintElementGeneratorImpl.access$getLinearGraph$p($this$run).getGraphNode(nodeIndex)) : null;
                }
                return n;
            }
            {
                this.this$0 = printElementGeneratorImpl;
                this.$toPosition = hashMap;
                this.$up = bl;
                super(1);
            }
        };
    }

    private final EdgePrintElement.Type getArrowType(GraphEdge edge, int rowIndex) {
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge != null) {
            return this.getArrowType(normalEdge, rowIndex);
        }
        switch (PrintElementGeneratorImpl$WhenMappings.$EnumSwitchMapping$0[edge.getType().ordinal()]) {
            case 1: 
            case 2: {
                if (!LinearGraphUtils.intEqual(edge.getUpNodeIndex(), rowIndex - 1)) break;
                return EdgePrintElement.Type.DOWN;
            }
            case 3: {
                if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), rowIndex + 1)) break;
                return EdgePrintElement.Type.UP;
            }
            default: {
                LOG.error("Unknown special edge type " + (Object)((Object)edge.getType()) + " at row " + rowIndex);
            }
        }
        return null;
    }

    private final EdgePrintElement.Type getArrowType(NormalEdge normalEdge, int rowIndex) {
        int edgeSize = normalEdge.down - normalEdge.up;
        int upOffset = rowIndex - normalEdge.up;
        int downOffset = normalEdge.down - rowIndex;
        if (edgeSize >= this.longEdgeSize) {
            if (upOffset == this.visiblePartSize) {
                LOG.assertTrue(downOffset != this.visiblePartSize, (Object)("Both up and down arrow at row " + rowIndex));
                return EdgePrintElement.Type.DOWN;
            }
            if (downOffset == this.visiblePartSize) {
                return EdgePrintElement.Type.UP;
            }
        }
        if (edgeSize >= this.edgeWithArrowSize) {
            if (upOffset == 1) {
                LOG.assertTrue(downOffset != 1, (Object)("Both up and down arrow at row " + rowIndex));
                return EdgePrintElement.Type.DOWN;
            }
            if (downOffset == 1) {
                return EdgePrintElement.Type.UP;
            }
        }
        return null;
    }

    private final boolean isEdgeVisibleInRow(GraphEdge edge, int visibleRowIndex) {
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)normalEdge, (String)"asNormalEdge(edge) ?: return false");
        NormalEdge normalEdge2 = normalEdge;
        return this.isEdgeVisibleInRow(normalEdge2, visibleRowIndex);
    }

    private final boolean isEdgeVisibleInRow(NormalEdge normalEdge, int visibleRowIndex) {
        return normalEdge.down - normalEdge.up < this.longEdgeSize || this.getAttachmentDistance(normalEdge, visibleRowIndex) <= this.visiblePartSize;
    }

    private final List<GraphElement> getSortedVisibleElementsInRow(int rowIndex) {
        GraphEdge it;
        List graphElements = (List)this.cache.get((Object)rowIndex);
        if (graphElements != null) {
            return graphElements;
        }
        ArrayList<GraphNode> result2 = new ArrayList<GraphNode>();
        result2.add(this.linearGraph.getGraphNode(rowIndex));
        Set<GraphEdge> set = this.edgesInRowGenerator.getEdgesInRow(rowIndex);
        Intrinsics.checkNotNullExpressionValue(set, (String)"edgesInRowGenerator.getEdgesInRow(rowIndex)");
        Iterable $this$filterTo$iv = set;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            it = (GraphEdge)element$iv;
            boolean bl = false;
            GraphEdge graphEdge = it;
            Intrinsics.checkNotNullExpressionValue((Object)graphEdge, (String)"it");
            if (!this.isEdgeVisibleInRow(graphEdge, rowIndex)) continue;
            ((Collection)result2).add(element$iv);
        }
        if (rowIndex > 0) {
            List<GraphEdge> list = this.linearGraph.getAdjacentEdges(rowIndex - 1, EdgeFilter.SPECIAL);
            Intrinsics.checkNotNullExpressionValue(list, (String)"linearGraph.getAdjacentE\u2026 - 1, EdgeFilter.SPECIAL)");
            $this$filterTo$iv = list;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (GraphEdge)element$iv;
                boolean bl = false;
                if (!LinearGraphUtils.isEdgeDown(it, rowIndex - 1)) continue;
                ((Collection)result2).add(element$iv);
            }
        }
        if (rowIndex < this.linearGraph.nodesCount() - 1) {
            List<GraphEdge> list = this.linearGraph.getAdjacentEdges(rowIndex + 1, EdgeFilter.SPECIAL);
            Intrinsics.checkNotNullExpressionValue(list, (String)"linearGraph.getAdjacentE\u2026 + 1, EdgeFilter.SPECIAL)");
            $this$filterTo$iv = list;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (GraphEdge)element$iv;
                boolean bl = false;
                if (!LinearGraphUtils.isEdgeUp(it, rowIndex + 1)) continue;
                ((Collection)result2).add(element$iv);
            }
        }
        Collections.sort((List)result2, this.getElementComparator());
        this.cache.put((Object)rowIndex, result2);
        return result2;
    }

    @Override
    @NotNull
    public Collection<PrintElementWithGraphElement> getPrintElements(int rowIndex) {
        PrintElementBuilder builder = new PrintElementBuilder(rowIndex);
        this.collectElements(rowIndex, builder);
        return builder.build();
    }

    private final int getAttachmentDistance(NormalEdge e1, int rowIndex) {
        return Math.min(rowIndex - e1.up, e1.down - rowIndex);
    }

    @TestOnly
    public PrintElementGeneratorImpl(@NotNull LinearGraph linearGraph, @NotNull PrintElementManager printElementManager, int longEdgeSize, int visiblePartSize, int edgeWithArrowSize) {
        Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
        Intrinsics.checkNotNullParameter((Object)printElementManager, (String)"printElementManager");
        this.linearGraph = linearGraph;
        this.printElementManager = printElementManager;
        this.longEdgeSize = longEdgeSize;
        this.visiblePartSize = visiblePartSize;
        this.edgeWithArrowSize = edgeWithArrowSize;
        this.cache = new SLRUMap(100, 200);
        this.edgesInRowGenerator = new EdgesInRowGenerator(this.linearGraph);
    }

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementManager printElementManager, boolean showLongEdges) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)printElementManager, (String)"printElementManager");
        this(graph, printElementManager, showLongEdges ? 1000 : 30, showLongEdges ? 250 : 1, showLongEdges ? 30 : Integer.MAX_VALUE);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(PrintElementGeneratorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Print\u2026eneratorImpl::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ LinearGraph access$getLinearGraph$p(PrintElementGeneratorImpl $this) {
        return $this.linearGraph;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0003J&\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$PrintElementBuilder;", "", "rowIndex", "", "(Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl;I)V", "nodes", "Ljava/util/ArrayList;", "Lcom/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement;", "result", "build", "", "consumeArrow", "", "edge", "Lcom/intellij/vcs/log/graph/api/elements/GraphEdge;", "position", "arrowType", "Lcom/intellij/vcs/log/graph/EdgePrintElement$Type;", "consumeDownEdge", "upPosition", "downPosition", "hasArrow", "", "consumeNode", "node", "Lcom/intellij/vcs/log/graph/api/elements/GraphNode;", "consumeUpEdge", "intellij.platform.vcs.log.graph.impl"})
    private final class PrintElementBuilder {
        private final ArrayList<PrintElementWithGraphElement> result;
        private final ArrayList<PrintElementWithGraphElement> nodes;
        private final int rowIndex;

        public final void consumeNode(@NotNull GraphNode node, int position) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.nodes.add(new SimplePrintElementImpl(this.rowIndex, position, node, PrintElementGeneratorImpl.this.printElementManager));
        }

        public final void consumeDownEdge(@NotNull GraphEdge edge, int upPosition, int downPosition, boolean hasArrow) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            this.result.add(new EdgePrintElementImpl(this.rowIndex, upPosition, downPosition, EdgePrintElement.Type.DOWN, edge, hasArrow, PrintElementGeneratorImpl.this.printElementManager));
        }

        public final void consumeUpEdge(@NotNull GraphEdge edge, int upPosition, int downPosition, boolean hasArrow) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            this.result.add(new EdgePrintElementImpl(this.rowIndex, downPosition, upPosition, EdgePrintElement.Type.UP, edge, hasArrow, PrintElementGeneratorImpl.this.printElementManager));
        }

        public final void consumeArrow(@NotNull GraphEdge edge, int position, @NotNull EdgePrintElement.Type arrowType) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Intrinsics.checkNotNullParameter((Object)arrowType, (String)"arrowType");
            this.result.add(new TerminalEdgePrintElement(this.rowIndex, position, arrowType, edge, PrintElementGeneratorImpl.this.printElementManager));
        }

        @NotNull
        public final Collection<PrintElementWithGraphElement> build() {
            this.result.addAll((Collection<PrintElementWithGraphElement>)this.nodes);
            return this.result;
        }

        public PrintElementBuilder(int rowIndex) {
            this.rowIndex = rowIndex;
            this.result = new ArrayList();
            this.nodes = new ArrayList();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$Companion;", "", "()V", "CACHE_SIZE", "", "K", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LONG_EDGE_PART_SIZE", "LONG_EDGE_SIZE", "SAMPLE_SIZE", "VERY_LONG_EDGE_PART_SIZE", "VERY_LONG_EDGE_SIZE", "intellij.platform.vcs.log.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

