/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TByteObjectHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    public static final String RENAMES_MAP = "renames-map";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull StorageId storageId, @NotNull VcsLogStorage storage, @NotNull Set<VirtualFile> roots, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(2);
        }
        if (fatalErrorHandler == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(3);
        }
        if (disposableParent == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(4);
        }
        super(storageId, PATHS, new PathsIndexer(storage, VcsLogPathsIndex.createPathsEnumerator(roots, storageId), VcsLogPathsIndex.createRenamesMap(storageId)), new ChangeKindListKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<? super Exception>)((Consumer)e -> fatalErrorHandler.consume(this, (Throwable)e)));
    }

    @NotNull
    private static PersistentEnumeratorBase<LightFilePath> createPathsEnumerator(@NotNull Collection<VirtualFile> roots, @NotNull StorageId storageId) throws IOException {
        if (roots == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(5);
        }
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(6);
        }
        Path storageFile = storageId.getStorageFile(INDEX_PATHS_IDS);
        return new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)new LightFilePathKeyDescriptor(roots), Page.PAGE_SIZE, null, storageId.getVersion());
    }

    @NotNull
    private static PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> createRenamesMap(@NotNull StorageId storageId) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(7);
        }
        Path storageFile = storageId.getStorageFile(RENAMES_MAP);
        return new PersistentHashMap(storageFile, (KeyDescriptor)new CoupleKeyDescriptor(), (DataExternalizer)new CollectionDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
    }

    @Nullable
    private FilePath getPath(int pathId, boolean isDirectory) {
        try {
            return VcsLogPathsIndex.toFilePath((LightFilePath)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId), isDirectory);
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.myRenamesMap.force();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @Nullable
    public EdgeData<FilePath> findRename(int parent, int child, @NotNull VirtualFile root, @NotNull FilePath path2, boolean isChildPath) throws IOException {
        Collection renames;
        if (root == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(8);
        }
        if (path2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(9);
        }
        if ((renames = (Collection)this.myPathsIndexer.myRenamesMap.get((Object)Couple.of((Object)parent, (Object)child))) == null) {
            return null;
        }
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root, path2));
        for (Couple rename : renames) {
            if ((!isChildPath || (Integer)rename.second != pathId) && (isChildPath || (Integer)rename.first != pathId)) continue;
            FilePath path1 = this.getPath((Integer)rename.first, path2.isDirectory());
            FilePath path22 = this.getPath((Integer)rename.second, path2.isDirectory());
            return new EdgeData<FilePath>(path1, path22);
        }
        return null;
    }

    public void iterateCommits(@NotNull VirtualFile root, @NotNull FilePath path2, @NotNull ObjIntConsumer<? super List<ChangeKind>> consumer) throws IOException, StorageException {
        if (root == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(12);
        }
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root, path2));
        this.iterateCommitIdsAndValues(pathId, consumer);
    }

    @NotNull
    VcsLogIndexer.PathsEncoder getPathsEncoder() {
        return new VcsLogIndexer.PathsEncoder(){

            @Override
            public int encode(@NotNull VirtualFile root, @NotNull String relativePath, boolean isDirectory) {
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (relativePath == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    return VcsLogPathsIndex.this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(root, relativePath));
                }
                catch (IOException e) {
                    VcsLogPathsIndex.this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
                    return 0;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "relativePath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$1";
                objectArray[2] = "encode";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.myRenamesMap.close();
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    @Nullable
    private static FilePath toFilePath(@Nullable LightFilePath lightFilePath, boolean isDirectory) {
        if (lightFilePath == null) {
            return null;
        }
        return VcsUtil.getFilePath((String)(lightFilePath.getRoot().getPath() + "/" + lightFilePath.getRelativePath()), (boolean)isDirectory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createPathsEnumerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamesMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findRename";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateCommits";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CollectionDataExternalizer
    implements DataExternalizer<Collection<Couple<Integer>>> {
        private CollectionDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<Couple<Integer>> value) throws IOException {
            if (out == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (Couple<Integer> v : value) {
                out.writeInt((Integer)v.first);
                out.writeInt((Integer)v.second);
            }
        }

        public Collection<Couple<Integer>> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(1);
            }
            SmartList result2 = new SmartList();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                result2.add(Couple.of((Object)in.readInt(), (Object)in.readInt()));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$CollectionDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CoupleKeyDescriptor
    implements KeyDescriptor<Couple<Integer>> {
        private CoupleKeyDescriptor() {
        }

        public int getHashCode(Couple<Integer> value) {
            return value.hashCode();
        }

        public boolean isEqual(Couple<Integer> val1, Couple<Integer> val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, Couple<Integer> value) throws IOException {
            if (out == null) {
                CoupleKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.writeInt((Integer)value.first);
            out.writeInt((Integer)value.second);
        }

        public Couple<Integer> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CoupleKeyDescriptor.$$$reportNull$$$0(1);
            }
            return Couple.of((Object)in.readInt(), (Object)in.readInt());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$CoupleKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LightFilePathKeyDescriptor
    implements KeyDescriptor<LightFilePath> {
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final TObjectIntHashMap<VirtualFile> myRootsReversed;

        private LightFilePathKeyDescriptor(@NotNull Collection<VirtualFile> roots) {
            if (roots == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(0);
            }
            this.myRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
            this.myRootsReversed = new TObjectIntHashMap();
            for (int i = 0; i < this.myRoots.size(); ++i) {
                this.myRootsReversed.put((Object)this.myRoots.get(i), i);
            }
        }

        public int getHashCode(LightFilePath path2) {
            return path2.hashCode();
        }

        public boolean isEqual(LightFilePath path1, LightFilePath path2) {
            return path1.equals(path2);
        }

        public void save(@NotNull DataOutput out, LightFilePath value) throws IOException {
            if (out == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(1);
            }
            out.writeInt(this.myRootsReversed.get((Object)value.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value.getRelativePath());
        }

        public LightFilePath read(@NotNull DataInput in) throws IOException {
            int rootIndex;
            VirtualFile root;
            if (in == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(2);
            }
            if ((root = this.myRoots.get(rootIndex = in.readInt())) == null) {
                throw new IOException("Can not read root for index " + rootIndex + ". All roots " + this.myRoots);
            }
            String path2 = IOUtil.readUTF((DataInput)in);
            return new LightFilePath(root, path2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LightFilePath {
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final String myRelativePath;

        private LightFilePath(@NotNull VirtualFile root, @NotNull String relativePath) {
            if (root == null) {
                LightFilePath.$$$reportNull$$$0(0);
            }
            if (relativePath == null) {
                LightFilePath.$$$reportNull$$$0(1);
            }
            this.myRoot = root;
            this.myRelativePath = relativePath;
        }

        private LightFilePath(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            if (root == null) {
                LightFilePath.$$$reportNull$$$0(2);
            }
            if (filePath == null) {
                LightFilePath.$$$reportNull$$$0(3);
            }
            this(root, VcsFileUtil.relativePath(root, filePath));
        }

        @NotNull
        public VirtualFile getRoot() {
            VirtualFile virtualFile = this.myRoot;
            if (virtualFile == null) {
                LightFilePath.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }

        @NotNull
        public String getRelativePath() {
            String string = this.myRelativePath;
            if (string == null) {
                LightFilePath.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightFilePath path2 = (LightFilePath)o;
            return this.myRoot.equals(path2.myRoot) && this.myRelativePath.equals(path2.myRelativePath);
        }

        public int hashCode() {
            return Objects.hash(this.myRoot, this.myRelativePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        NOT_CHANGED(1),
        ADDED(2),
        REMOVED(3);

        public final byte id;
        private static final TByteObjectHashMap<ChangeKind> KINDS;

        private ChangeKind(byte id) {
            this.id = id;
        }

        @NotNull
        public static ChangeKind getChangeKindById(byte id) throws IOException {
            ChangeKind kind = (ChangeKind)((Object)KINDS.get(id));
            if (kind == null) {
                throw new IOException("Change kind by id " + id + " not found.");
            }
            ChangeKind changeKind = kind;
            if (changeKind == null) {
                ChangeKind.$$$reportNull$$$0(0);
            }
            return changeKind;
        }

        static {
            KINDS = new TByteObjectHashMap();
            for (ChangeKind kind : ChangeKind.values()) {
                KINDS.put(kind.id, (Object)kind);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind", "getChangeKindById"));
        }
    }

    private static class ChangeKindListKeyDescriptor
    implements DataExternalizer<List<ChangeKind>> {
        private ChangeKindListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeKind> value) throws IOException {
            if (out == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (ChangeKind data : value) {
                out.writeByte(data.id);
            }
        }

        public List<ChangeKind> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(1);
            }
            SmartList value = new SmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                value.add(ChangeKind.getChangeKindById(in.readByte()));
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKindListKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PathsIndexer
    implements DataIndexer<Integer, List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final PersistentEnumeratorBase<LightFilePath> myPathsEnumerator;
        @NotNull
        private final PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> myRenamesMap;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer;

        private PathsIndexer(@NotNull VcsLogStorage storage, @NotNull PersistentEnumeratorBase<LightFilePath> enumerator2, @NotNull PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> renamesMap) {
            if (storage == null) {
                PathsIndexer.$$$reportNull$$$0(0);
            }
            if (enumerator2 == null) {
                PathsIndexer.$$$reportNull$$$0(1);
            }
            if (renamesMap == null) {
                PathsIndexer.$$$reportNull$$$0(2);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myStorage = storage;
            this.myPathsEnumerator = enumerator2;
            this.myRenamesMap = renamesMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                PathsIndexer.$$$reportNull$$$0(3);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeKind>> map(@NotNull VcsLogIndexer.CompressedDetails inputData) {
            if (inputData == null) {
                PathsIndexer.$$$reportNull$$$0(4);
            }
            THashMap result2 = new THashMap();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
                try {
                    int finalParentIndex = parentIndex;
                    SmartList renames = new SmartList();
                    inputData.getRenamedPaths(parentIndex).forEachEntry((arg_0, arg_1) -> PathsIndexer.lambda$map$0((Collection)renames, (Map)result2, parentsCount, finalParentIndex, arg_0, arg_1));
                    if (renames.size() > 0) {
                        int commit = this.myStorage.getCommitIndex((Hash)inputData.getId(), inputData.getRoot());
                        int parent = this.myStorage.getCommitIndex((Hash)inputData.getParents().get(parentIndex), inputData.getRoot());
                        this.myRenamesMap.put((Object)Couple.of((Object)parent, (Object)commit), (Object)renames);
                    }
                    inputData.getModifiedPaths(parentIndex).forEachEntry((arg_0, arg_1) -> PathsIndexer.lambda$map$1((Map)result2, parentsCount, finalParentIndex, arg_0, arg_1));
                    continue;
                }
                catch (IOException e) {
                    this.myFatalErrorConsumer.consume((Object)e);
                }
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                PathsIndexer.$$$reportNull$$$0(5);
            }
            return tHashMap;
        }

        @NotNull
        private static List<ChangeKind> getOrCreateChangeKindList(@NotNull Map<Integer, List<ChangeKind>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            SmartList changeDataList;
            if (pathIdToChangeDataListsMap == null) {
                PathsIndexer.$$$reportNull$$$0(6);
            }
            if ((changeDataList = pathIdToChangeDataListsMap.get(pathId)) == null) {
                changeDataList = new SmartList();
                for (int i = 0; i < parentsCount; ++i) {
                    changeDataList.add(ChangeKind.NOT_CHANGED);
                }
                pathIdToChangeDataListsMap.put(pathId, (List<ChangeKind>)changeDataList);
            }
            SmartList smartList = changeDataList;
            if (smartList == null) {
                PathsIndexer.$$$reportNull$$$0(7);
            }
            return smartList;
        }

        @NotNull
        private static ChangeKind createChangeData(@NotNull Change.Type type) {
            if (type == null) {
                PathsIndexer.$$$reportNull$$$0(8);
            }
            switch (type) {
                case NEW: {
                    ChangeKind changeKind = ChangeKind.ADDED;
                    if (changeKind == null) {
                        PathsIndexer.$$$reportNull$$$0(9);
                    }
                    return changeKind;
                }
                case DELETED: {
                    ChangeKind changeKind = ChangeKind.REMOVED;
                    if (changeKind == null) {
                        PathsIndexer.$$$reportNull$$$0(10);
                    }
                    return changeKind;
                }
            }
            ChangeKind changeKind = ChangeKind.MODIFIED;
            if (changeKind == null) {
                PathsIndexer.$$$reportNull$$$0(11);
            }
            return changeKind;
        }

        @NotNull
        public PersistentEnumeratorBase<LightFilePath> getPathsEnumerator() {
            PersistentEnumeratorBase<LightFilePath> persistentEnumeratorBase = this.myPathsEnumerator;
            if (persistentEnumeratorBase == null) {
                PathsIndexer.$$$reportNull$$$0(12);
            }
            return persistentEnumeratorBase;
        }

        private static /* synthetic */ boolean lambda$map$1(Map result2, int parentsCount, int finalParentIndex, int pathId, Change.Type changeType) {
            PathsIndexer.getOrCreateChangeKindList(result2, pathId, parentsCount).set(finalParentIndex, PathsIndexer.createChangeData(changeType));
            return true;
        }

        private static /* synthetic */ boolean lambda$map$0(Collection renames, Map result2, int parentsCount, int finalParentIndex, int beforeId, int afterId) {
            renames.add(Couple.of((Object)beforeId, (Object)afterId));
            PathsIndexer.getOrCreateChangeKindList(result2, beforeId, parentsCount).set(finalParentIndex, ChangeKind.REMOVED);
            PathsIndexer.getOrCreateChangeKindList(result2, afterId, parentsCount).set(finalParentIndex, ChangeKind.ADDED);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renamesMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathIdToChangeDataListsMap";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateChangeKindList";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangeData";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathsEnumerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateChangeKindList";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangeData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

