/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class OldChangesBrowserBase
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    protected final ChangesTreeList<Change> myViewer;
    protected final JScrollPane myViewerScrollPane;
    protected ChangeList mySelectedChangeList;
    protected List<Change> myChangesToDisplay;
    protected final Project myProject;
    private final boolean myCapableOfExcludingChanges;
    private DefaultActionGroup myToolBarGroup;
    private AnAction myDiffAction;
    private final VirtualFile myToSelect;
    @NotNull
    private final DeleteProvider myDeleteProvider;

    public void setChangesToDisplay(List<Change> changes) {
        this.myChangesToDisplay = changes;
        this.myViewer.setChangesToDisplay(changes);
    }

    public void setDecorator(ChangeNodeDecorator decorator) {
        this.myViewer.setChangeDecorator(decorator);
    }

    protected OldChangesBrowserBase(@NotNull Project project, @NotNull List<Change> changes, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable inclusionListener, @NotNull ChangesBrowser.MyUseCase useCase, @Nullable VirtualFile toSelect) {
        if (project == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(1);
        }
        if (useCase == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myDeleteProvider = new VirtualFileDeleteProvider();
        this.setFocusable(false);
        this.myProject = project;
        this.myCapableOfExcludingChanges = capableOfExcludingChanges;
        this.myToSelect = toSelect;
        RemoteStatusChangeNodeDecorator decorator = ChangesBrowser.MyUseCase.LOCAL_CHANGES.equals((Object)useCase) ? RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator() : null;
        this.myViewer = new ChangesTreeList<Change>(this.myProject, changes, capableOfExcludingChanges, highlightProblems, inclusionListener, (ChangeNodeDecorator)decorator){

            @Override
            protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator) {
                return OldChangesBrowserBase.this.buildTreeModel(changes, changeNodeDecorator, this.isShowFlatten());
            }

            @Override
            protected List<Change> getSelectedObjects(ChangesBrowserNode<?> node) {
                return OldChangesBrowserBase.this.getSelectedObjects(node);
            }

            @Override
            @Nullable
            protected Change getLeadSelectedObject(ChangesBrowserNode<?> node) {
                return OldChangesBrowserBase.this.getLeadSelectedObject(node);
            }

            @Override
            public void setScrollPaneBorder(Border border) {
                OldChangesBrowserBase.this.myViewerScrollPane.setBorder(border);
            }
        };
        this.myViewerScrollPane = ScrollPaneFactory.createScrollPane(this.myViewer);
    }

    protected void init() {
        this.add((Component)this.myViewerScrollPane, "Center");
        this.add((Component)this.createToolbar(), "North");
        this.myViewer.installPopupHandler((ActionGroup)this.myToolBarGroup);
        this.myViewer.setDoubleClickAndEnterKeyHandler(() -> this.showDiff());
    }

    @NotNull
    protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
        DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges(this.myProject, this.myViewer.getGrouping(), changes, changeNodeDecorator);
        if (defaultTreeModel == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(3);
        }
        return defaultTreeModel;
    }

    @NotNull
    protected List<Change> getSelectedObjects(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(4);
        }
        List<Change> list = node.getAllChangesUnder();
        if (list == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    protected Change getLeadSelectedObject(@NotNull ChangesBrowserNode<?> node) {
        Object o;
        if (node == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(6);
        }
        if ((o = node.getUserObject()) instanceof Change) {
            return (Change)o;
        }
        return null;
    }

    public void dispose() {
    }

    public void addToolbarAction(AnAction action) {
        this.myToolBarGroup.add(action);
    }

    public ChangesTreeList<Change> getViewer() {
        return this.myViewer;
    }

    @NotNull
    public JScrollPane getViewerScrollPane() {
        JScrollPane jScrollPane = this.myViewerScrollPane;
        if (jScrollPane == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(7);
        }
        return jScrollPane;
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (key == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(9);
        }
        if (key == VcsDataKeys.CHANGES) {
            List<Change> list = this.getSelectedChanges();
            if (list.isEmpty()) {
                list = this.myViewer.getChanges();
            }
            sink.put(VcsDataKeys.CHANGES, (Object)list.toArray(new Change[0]));
        } else if (key == VcsDataKeys.CHANGES_SELECTION) {
            sink.put(VcsDataKeys.CHANGES_SELECTION, this.getChangesSelection());
        } else if (key == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, (Object)this.getSelectedChangeLists());
        } else if (key == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            Change[] changeArray;
            Change highestSelection = this.myViewer.getHighestLeadSelection();
            if (highestSelection == null) {
                changeArray = new Change[]{};
            } else {
                Change[] changeArray2 = new Change[1];
                changeArray = changeArray2;
                changeArray2[0] = highestSelection;
            }
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)changeArray);
        } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)((VirtualFile[])this.getSelectedFiles().toArray(VirtualFile[]::new)));
        } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles()));
        } else if (VcsDataKeys.IO_FILE_ARRAY.equals(key)) {
            sink.put(VcsDataKeys.IO_FILE_ARRAY, (Object)this.getSelectedIoFiles());
        } else if (VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.equals(key)) {
            List<Change> selectedChanges = this.getSelectedChanges();
            sink.put(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS, (Object)selectedChanges.toArray(new Change[0]));
        } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.equals(key)) {
            sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)this.myDeleteProvider);
        } else {
            sink.put(key, this.myViewer.getData(key.getName()));
        }
    }

    public void select(List<Change> changes) {
        this.myViewer.select(changes);
    }

    protected void showDiffForChanges(Change[] changesArray, int indexInSelection) {
        ShowDiffContext context = new ShowDiffContext(OldChangesBrowserBase.isInFrame() ? DiffDialogHints.FRAME : DiffDialogHints.MODAL);
        context.addActions(this.createDiffActions());
        this.updateDiffContext(context);
        ShowDiffAction.showDiffForChange(this.myProject, Arrays.asList(changesArray), indexInSelection, context);
    }

    protected void updateDiffContext(@NotNull ShowDiffContext context) {
        if (context == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(10);
        }
    }

    private boolean canShowDiff() {
        return ShowDiffAction.canShowDiff(this.myProject, this.getChangesSelection().getList());
    }

    private void showDiff() {
        ListSelection<Change> selection = this.getChangesSelection();
        List changes = selection.getList();
        Change[] changesArray = changes.toArray(new Change[0]);
        this.showDiffForChanges(changesArray, selection.getSelectedIndex());
        this.afterDiffRefresh();
    }

    @NotNull
    private ListSelection<Change> getChangesSelection() {
        List<Change> allChanges;
        Change leadSelection = this.myViewer.getLeadSelection();
        List<Change> changes = this.getSelectedChanges();
        if (changes.size() < 2 && ((allChanges = this.myViewer.getChanges()).size() > 1 || changes.isEmpty())) {
            changes = allChanges;
        }
        if (leadSelection != null && !changes.contains(leadSelection)) {
            ListSelection listSelection = ListSelection.createSingleton((Object)leadSelection);
            if (listSelection == null) {
                OldChangesBrowserBase.$$$reportNull$$$0(11);
            }
            return listSelection;
        }
        ListSelection listSelection = ListSelection.create(changes, (Object)leadSelection);
        if (listSelection == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(12);
        }
        return listSelection;
    }

    protected void afterDiffRefresh() {
    }

    private static boolean isInFrame() {
        return ModalityState.current().equals(ModalityState.NON_MODAL);
    }

    private List<AnAction> createDiffActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.myCapableOfExcludingChanges) {
            actions.add((AnAction)new ToggleChangeAction());
        }
        return actions;
    }

    public void rebuildList() {
        this.myViewer.setChangesToDisplay(this.getCurrentDisplayedChanges(), this.myToSelect);
    }

    public void setAlwayExpandList(boolean value) {
        this.myViewer.setAlwaysExpandList(value);
    }

    @NotNull
    private JComponent createToolbar() {
        DefaultActionGroup toolbarGroups = new DefaultActionGroup();
        this.myToolBarGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)this.myToolBarGroup);
        this.buildToolBar(this.myToolBarGroup);
        toolbarGroups.addSeparator();
        DefaultActionGroup treeActionsGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)treeActionsGroup);
        for (AnAction action : this.myViewer.getTreeActions()) {
            treeActionsGroup.add(action);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesBrowser", (ActionGroup)toolbarGroups, true);
        toolbar.setTargetComponent((JComponent)this);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        this.myDiffAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(OldChangesBrowserBase.this.canShowDiff() || e.getInputEvent() instanceof KeyEvent);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                OldChangesBrowserBase.this.showDiff();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/OldChangesBrowserBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ActionUtil.copyFrom((AnAction)this.myDiffAction, (String)"Diff.ShowDiff");
        this.myDiffAction.registerCustomShortcutSet(this.myViewer, null);
        toolBarGroup.add(this.myDiffAction);
    }

    @NotNull
    private List<Change> getCurrentDisplayedChanges() {
        if (this.myChangesToDisplay != null) {
            List<Change> list = this.myChangesToDisplay;
            if (list == null) {
                OldChangesBrowserBase.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList arrayList = this.mySelectedChangeList != null ? new ArrayList(this.mySelectedChangeList.getChanges()) : Collections.emptyList();
        if (arrayList == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    private ChangeList[] getSelectedChangeLists() {
        if (this.mySelectedChangeList != null) {
            return new ChangeList[]{this.mySelectedChangeList};
        }
        return null;
    }

    private File[] getSelectedIoFiles() {
        List<Change> changes = this.getSelectedChanges();
        ArrayList<File> files = new ArrayList<File>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null) continue;
            FilePath file = afterRevision.getFile();
            File ioFile = file.getIOFile();
            files.add(ioFile);
        }
        return files.toArray(new File[0]);
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list = this.myViewer.getSelectedChanges();
        if (list == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges().stream()), ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), null)).distinct();
        if (stream == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(17);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getNavigatableFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getFiles(this.getSelectedChanges().stream()), ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), null)).distinct();
        if (stream == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(18);
        }
        return stream;
    }

    public AnAction getDiffAction() {
        return this.myDiffAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useCase";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/OldChangesBrowserBase";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/OldChangesBrowserBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedObjects";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewerScrollPane";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesSelection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDisplayedChanges";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedObjects";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLeadSelectedObject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToggleChangeAction
    extends CheckboxAction {
        ToggleChangeAction() {
            super(VcsBundle.messagePointer((String)"commit.dialog.include.action.name", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Change change;
            if (e == null) {
                ToggleChangeAction.$$$reportNull$$$0(0);
            }
            if ((change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                return false;
            }
            return OldChangesBrowserBase.this.myViewer.isIncluded(change);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Change change;
            if (e == null) {
                ToggleChangeAction.$$$reportNull$$$0(1);
            }
            if ((change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                return;
            }
            if (state) {
                OldChangesBrowserBase.this.myViewer.includeChange(change);
            } else {
                OldChangesBrowserBase.this.myViewer.excludeChange(change);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/OldChangesBrowserBase$ToggleChangeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

