/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsCatchingRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportToShelfExecutor
implements ApplyPatchExecutor<TextFilePatchInProgress> {
    private static final Logger LOG = Logger.getInstance(ImportToShelfExecutor.class);
    private final Project myProject;

    public ImportToShelfExecutor(Project project) {
        this.myProject = project;
    }

    @Override
    public String getName() {
        return VcsBundle.message((String)"action.import.to.shelf", (Object[])new Object[0]);
    }

    @Override
    public void apply(@NotNull List<? extends FilePatch> remaining, final @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, final @Nullable String fileName, final @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (remaining == null) {
            ImportToShelfExecutor.$$$reportNull$$$0(0);
        }
        if (patchGroupsToApply == null) {
            ImportToShelfExecutor.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            LOG.error("Patch file name shouldn't be null");
            return;
        }
        VcsCatchingRunnable vcsCatchingRunnable = new VcsCatchingRunnable(){

            public void runImpl() throws VcsException {
                VirtualFile baseDir = ImportToShelfExecutor.this.myProject.getBaseDir();
                File ioBase = new File(baseDir.getPath());
                ArrayList allPatches = new ArrayList();
                for (VirtualFile virtualFile : patchGroupsToApply.keySet()) {
                    File ioCurrentBase = new File(virtualFile.getPath());
                    allPatches.addAll(ContainerUtil.map((Collection)patchGroupsToApply.get((Object)virtualFile), patchInProgress -> {
                        TextFilePatch was = (TextFilePatch)patchInProgress.getPatch();
                        was.setBeforeName(PathUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)ioBase, (File)new File(ioCurrentBase, was.getBeforeName()))));
                        was.setAfterName(PathUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)ioBase, (File)new File(ioCurrentBase, was.getAfterName()))));
                        return was;
                    }));
                }
                if (!allPatches.isEmpty()) {
                    ArrayList patchTransitExtensions = null;
                    if (additionalInfo != null) {
                        try {
                            HashMap<String, TransitExtension> extensions = new HashMap<String, TransitExtension>();
                            for (Map.Entry entry : ((Map)additionalInfo.compute()).entrySet()) {
                                String filePath = (String)entry.getKey();
                                Map extToValue = (Map)entry.getValue();
                                for (Map.Entry innerEntry : extToValue.entrySet()) {
                                    TransitExtension patchEP = (TransitExtension)extensions.get(innerEntry.getKey());
                                    if (patchEP == null) {
                                        patchEP = new TransitExtension((String)innerEntry.getKey());
                                        extensions.put((String)innerEntry.getKey(), patchEP);
                                    }
                                    patchEP.put(filePath, (CharSequence)innerEntry.getValue());
                                }
                            }
                            patchTransitExtensions = new ArrayList(extensions.values());
                        }
                        catch (PatchSyntaxException e) {
                            VcsBalloonProblemNotifier.showOverChangesView(ImportToShelfExecutor.this.myProject, VcsBundle.message((String)"patch.import.additional.info.error", (Object[])new Object[]{e.getMessage()}), MessageType.ERROR, new NamedRunnable[0]);
                        }
                    }
                    try {
                        ShelvedChangeList shelvedChangeList = ShelveChangesManager.getInstance(ImportToShelfExecutor.this.myProject).importFilePatches(fileName, allPatches, patchTransitExtensions);
                        ShelvedChangesViewManager.getInstance(ImportToShelfExecutor.this.myProject).activateView(shelvedChangeList);
                    }
                    catch (IOException e) {
                        throw new VcsException((Throwable)e);
                    }
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)vcsCatchingRunnable, VcsBundle.message((String)"patch.import.to.shelf.progress.title", (Object[])new Object[0]), true, this.myProject);
        if (!vcsCatchingRunnable.get().isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(vcsCatchingRunnable.get(), VcsBundle.message((String)"action.import.to.shelf", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "remaining";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "patchGroupsToApply";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TransitExtension
    implements PatchEP {
        private final String myName;
        private final Map<String, CharSequence> myMap;

        private TransitExtension(String name) {
            this.myName = name;
            this.myMap = new HashMap<String, CharSequence>();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TransitExtension.$$$reportNull$$$0(0);
            }
            return string;
        }

        public CharSequence provideContent(@NotNull Project project, @NotNull String path2, CommitContext commitContext) {
            if (project == null) {
                TransitExtension.$$$reportNull$$$0(1);
            }
            if (path2 == null) {
                TransitExtension.$$$reportNull$$$0(2);
            }
            return this.myMap.get(path2);
        }

        public void consumeContentBeforePatchApplied(@NotNull Project project, @NotNull String path2, @NotNull CharSequence content2, CommitContext commitContext) {
            if (project == null) {
                TransitExtension.$$$reportNull$$$0(3);
            }
            if (path2 == null) {
                TransitExtension.$$$reportNull$$$0(4);
            }
            if (content2 == null) {
                TransitExtension.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException();
        }

        public void put(String fileName, CharSequence value) {
            this.myMap.put(fileName, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ImportToShelfExecutor$TransitExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "provideContent";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "consumeContentBeforePatchApplied";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

