/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShredManager {
    private static final String PSI_EXPR_MASK = "missingValue";
    private static final String PSI_CONDITIONAL_EXPR_MASK = " ";
    private final PsiElement myPsiElement;
    private final InjectedLanguageManager myInstance;
    private final PsiLanguageInjectionHost myHost;

    ShredManager(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ShredManager.$$$reportNull$$$0(0);
        }
        this.myPsiElement = psiElement;
        this.myInstance = InjectedLanguageManager.getInstance((Project)psiElement.getProject());
        this.myHost = this.myInstance.getInjectionHost(psiElement);
    }

    @Nullable
    ShredInfo getShredInfo(@NotNull String text2) {
        if (text2 == null) {
            ShredManager.$$$reportNull$$$0(1);
        }
        if (this.myHost == null) {
            return null;
        }
        Ref result2 = Ref.create();
        this.myInstance.enumerate((PsiElement)this.myHost, (file2, shreds) -> {
            ShredsIterator shredsIterator = new ShredsIterator(shreds);
            int shredSymbolCounter = 0;
            ShredInfo nextShred = null;
            int elementOffset = this.calculateElementOffset(text2);
            while (shredsIterator.hasNext() && shredSymbolCounter <= elementOffset) {
                nextShred = (ShredInfo)shredsIterator.next();
                if (nextShred.symbol == ' ') continue;
                ++shredSymbolCounter;
            }
            result2.set(nextShred);
        });
        return (ShredInfo)result2.get();
    }

    boolean containsCloseRealWhiteSpace(@NotNull ShredInfo shredInfo, boolean after2) {
        if (shredInfo == null) {
            ShredManager.$$$reportNull$$$0(2);
        }
        Ref result2 = Ref.create((Object)false);
        this.myInstance.enumerate((PsiElement)this.myHost, (file2, shreds) -> {
            int whiteSpaceIndex;
            if (shredInfo.shredIndex >= shreds.size()) {
                return;
            }
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(shredInfo.shredIndex);
            String shredText = ShredManager.extractShredText(shred);
            if (shredText == null) {
                return;
            }
            int n = whiteSpaceIndex = after2 ? shredInfo.symbolIndex + 1 : shredInfo.symbolIndex - 1;
            if (whiteSpaceIndex < 0 || whiteSpaceIndex >= shredText.length()) {
                return;
            }
            result2.set((Object)(shredText.charAt(whiteSpaceIndex) == ' ' ? 1 : 0));
        });
        return (Boolean)result2.get();
    }

    private int calculateElementOffset(@NotNull String text2) {
        if (text2 == null) {
            ShredManager.$$$reportNull$$$0(3);
        }
        String cutText = text2.substring(0, this.myPsiElement.getTextOffset());
        String cutTextWithoutBogusWords = cutText.replaceAll(PSI_EXPR_MASK, "").replaceAll(PSI_CONDITIONAL_EXPR_MASK, "");
        return this.myPsiElement.getTextOffset() - (cutText.length() - cutTextWithoutBogusWords.length());
    }

    @Nullable
    private static String extractShredText(@NotNull PsiLanguageInjectionHost.Shred shred) {
        PsiLiteralValue shredLiteralVal;
        if (shred == null) {
            ShredManager.$$$reportNull$$$0(4);
        }
        if ((shredLiteralVal = (PsiLiteralValue)ObjectUtils.tryCast((Object)shred.getHost(), PsiLiteralValue.class)) == null || shredLiteralVal.getValue() == null) {
            return null;
        }
        return String.valueOf(shredLiteralVal.getValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shredInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shred";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/inspection/ShredManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getShredInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsCloseRealWhiteSpace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateElementOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "extractShredText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ShredInfo {
        private final int symbolIndex;
        private final char symbol;
        private final int shredIndex;
        private final PsiElement myHost;

        private ShredInfo(int shredIndex, char symbol, int symbolIndex, @Nullable PsiElement host) {
            this.shredIndex = shredIndex;
            this.symbol = symbol;
            this.symbolIndex = symbolIndex;
            this.myHost = host;
        }

        @Nullable
        PsiElement getHost() {
            return this.myHost;
        }
    }

    private static class ShredsIterator
    implements Iterator<ShredInfo> {
        private final List<PsiLanguageInjectionHost.Shred> myShreds;
        private int myShredIndex;
        private String myShredText;
        private int mySymbolIndex;

        private ShredsIterator(@NotNull List<PsiLanguageInjectionHost.Shred> shreds) {
            if (shreds == null) {
                ShredsIterator.$$$reportNull$$$0(0);
            }
            this.myShredIndex = -1;
            this.mySymbolIndex = -1;
            this.myShreds = shreds;
            if (!shreds.isEmpty()) {
                this.myShredIndex = 0;
            }
        }

        @Override
        public boolean hasNext() {
            return this.myShredIndex != -1 && this.findFirstNonEmptyShredIndex() != -1;
        }

        @Override
        @NotNull
        public ShredInfo next() {
            if (this.myShredIndex == -1) {
                throw new IllegalStateException("Iterator doesn't contain any shreds");
            }
            this.myShredIndex = this.findFirstNonEmptyShredIndex();
            if (this.myShredIndex == -1) {
                throw new IllegalStateException("Iterator doesn't contain non-empty shreds");
            }
            if (this.myShredText == null) {
                this.myShredText = ShredManager.extractShredText(this.myShreds.get(this.myShredIndex));
                if (StringUtil.isEmpty((String)this.myShredText)) {
                    throw new IllegalStateException("Current shred text is empty");
                }
                this.mySymbolIndex = 0;
            }
            int shredIndex = this.myShredIndex;
            char shredSymbol = this.myShredText.charAt(this.mySymbolIndex);
            int symbolIndex = this.mySymbolIndex;
            PsiLanguageInjectionHost.Shred shred = this.myShreds.get(this.myShredIndex);
            this.updateIndexes();
            return new ShredInfo(shredIndex, shredSymbol, symbolIndex, (PsiElement)shred.getHost());
        }

        private int findFirstNonEmptyShredIndex() {
            for (int shredIndex = this.myShredIndex; shredIndex < this.myShreds.size(); ++shredIndex) {
                String shredText = ShredManager.extractShredText(this.myShreds.get(shredIndex));
                if (StringUtil.isEmpty((String)shredText)) continue;
                return shredIndex;
            }
            return -1;
        }

        private void updateIndexes() {
            if (this.mySymbolIndex < this.myShredText.length() - 1) {
                ++this.mySymbolIndex;
            } else if (this.myShredIndex < this.myShreds.size() - 1) {
                ++this.myShredIndex;
                this.myShredText = null;
            } else {
                this.myShredIndex = -1;
                this.myShredText = null;
                this.mySymbolIndex = -1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shreds", "org/intellij/lang/regexp/inspection/ShredManager$ShredsIterator", "<init>"));
        }
    }
}

