/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.storage.KeyHashLog;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VfsAwareMapIndexStorage<Key, Value>
extends MapIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private final boolean myBuildKeyHashToVirtualFileMapping;
    @Nullable
    private KeyHashLog<Key> myKeyHashToVirtualFileMapping;

    @TestOnly
    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean readOnly) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(2);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, true, readOnly, null);
        this.myBuildKeyHashToVirtualFileMapping = false;
    }

    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(3);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(4);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(5);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false, null);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    protected void initMapAndCache() throws IOException {
        super.initMapAndCache();
        if (this.myBuildKeyHashToVirtualFileMapping) {
            FileSystem projectFileFS = this.myBaseStorageFile.getFileSystem();
            assert (!projectFileFS.isReadOnly()) : "File system " + projectFileFS + " is read only";
            this.myKeyHashToVirtualFileMapping = new KeyHashLog(this.myKeyDescriptor, this.myBaseStorageFile);
        } else {
            this.myKeyHashToVirtualFileMapping = null;
        }
    }

    protected void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    public void flush() {
        this.l.lock();
        try {
            super.flush();
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.force();
            }
        }
        finally {
            this.l.unlock();
        }
    }

    public void close() throws StorageException {
        super.close();
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.close();
            }
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
        }
    }

    public void clear() throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor2, GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(6);
        }
        this.l.lock();
        try {
            IntSet hashMaskSet;
            this.myCache.clear();
            Project project = scope.getProject();
            if (this.myKeyHashToVirtualFileMapping != null && project != null && idFilter != null && (hashMaskSet = this.myKeyHashToVirtualFileMapping.getSuitableKeyHashes(idFilter, project)) != null) {
                boolean bl = this.doProcessKeys(key -> {
                    if (!hashMaskSet.contains(this.myKeyDescriptor.getHashCode(key))) {
                        return true;
                    }
                    return processor2.process(key);
                });
                return bl;
            }
            boolean bl = this.doProcessKeys(processor2);
            return bl;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        catch (RuntimeException e) {
            boolean bl = (Boolean)VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
            return bl;
        }
        finally {
            this.l.unlock();
        }
    }

    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(7);
        }
        if (this.myKeyHashToVirtualFileMapping != null) {
            this.myKeyHashToVirtualFileMapping.removeKeyHashToVirtualFileMapping(key, inputId);
        }
        super.removeAllValues(key, inputId);
    }

    public void addValue(Key key, int inputId, Value value2) throws StorageException {
        if (this.myKeyHashToVirtualFileMapping != null) {
            this.myKeyHashToVirtualFileMapping.addKeyHashToVirtualFileMapping(key, inputId);
        }
        super.addValue(key, inputId, value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/storage/VfsAwareMapIndexStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

