/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.PossiblyIncorrectUsage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureProcessorBase
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ChangeSignatureProcessorBase.class);
    protected static final String REFACTORING_ID = "refactoring.changeSignature";
    protected final ChangeInfo myChangeInfo;
    protected final PsiManager myManager;

    protected ChangeSignatureProcessorBase(Project project, ChangeInfo changeInfo) {
        super(project);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    @Override
    protected UsageInfo @NotNull [] findUsages() {
        return ChangeSignatureProcessorBase.findUsages(this.myChangeInfo);
    }

    public static void collectConflictsFromExtensions(@NotNull Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> conflictDescriptions, ChangeInfo changeInfo) {
        if (refUsages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(0);
        }
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts = usageProcessor.findConflicts(changeInfo, refUsages);
            for (PsiElement key : conflicts.keySet()) {
                HashSet collection = conflictDescriptions.get((Object)key);
                if (collection.isEmpty()) {
                    collection = new HashSet();
                }
                collection.addAll(conflicts.get((Object)key));
                conflictDescriptions.put((Object)key, collection);
            }
        }
    }

    public static UsageInfo @NotNull [] findUsages(ChangeInfo changeInfo) {
        ChangeSignatureUsageProcessor[] processors;
        List<Object> infos = new ArrayList();
        for (ChangeSignatureUsageProcessor processor2 : processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            for (UsageInfo info : processor2.findUsages(changeInfo)) {
                LOG.assertTrue(info != null, (Object)processor2);
                infos.add(info);
            }
        }
        infos = ChangeSignatureProcessorBase.filterUsages(infos);
        UsageInfo[] usageInfoArray = infos.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    protected static List<UsageInfo> filterUsages(List<? extends UsageInfo> infos) {
        HashMap<PsiElement, MoveRenameUsageInfo> moveRenameInfos = new HashMap<PsiElement, MoveRenameUsageInfo>();
        HashSet<PsiElement> usedElements = new HashSet<PsiElement>();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(infos.size() / 2);
        for (UsageInfo usageInfo : infos) {
            LOG.assertTrue(usageInfo != null);
            PsiElement element2 = usageInfo.getElement();
            if (usageInfo instanceof MoveRenameUsageInfo) {
                if (usedElements.contains(element2)) continue;
                moveRenameInfos.put(element2, (MoveRenameUsageInfo)usageInfo);
                continue;
            }
            moveRenameInfos.remove(element2);
            usedElements.add(element2);
            if (usageInfo instanceof PossiblyIncorrectUsage && !((PossiblyIncorrectUsage)usageInfo).isCorrect()) continue;
            result2.add(usageInfo);
        }
        result2.addAll(moveRenameInfos.values());
        return result2;
    }

    @Override
    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(2);
        }
        for (ChangeSignatureUsageProcessor processor2 : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (!processor2.shouldPreviewUsages(this.myChangeInfo, usages)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return REFACTORING_ID;
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.getChangeInfo().getMethod());
        return data2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(3);
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.getChangeInfo().getMethod());
        return data2;
    }

    @Override
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(4);
        }
        RefactoringTransaction transaction = this.getTransaction();
        final ChangeInfo changeInfo = this.myChangeInfo;
        final RefactoringElementListener elementListener = transaction == null ? null : transaction.getElementListener(changeInfo.getMethod());
        final String fqn = CopyReferenceAction.elementToFqn(changeInfo.getMethod());
        if (fqn != null) {
            BasicUndoableAction action2 = new BasicUndoableAction(){

                public void undo() {
                    if (elementListener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)elementListener).undoElementMovedOrRenamed(changeInfo.getMethod(), fqn);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action2);
        }
        try {
            ChangeSignatureProcessorBase.doChangeSignature(changeInfo, usages);
            PsiElement method2 = changeInfo.getMethod();
            LOG.assertTrue(method2.isValid());
            if (elementListener != null && changeInfo.isNameChanged()) {
                elementListener.elementRenamed(method2);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void doChangeSignature(ChangeInfo changeInfo, UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(5);
        }
        ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
        ResolveSnapshotProvider resolveSnapshotProvider = changeInfo.isParameterNamesChanged() ? (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(changeInfo.getMethod().getLanguage()) : null;
        ArrayList snapshots = new ArrayList();
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (resolveSnapshotProvider == null) continue;
            changeSignatureUsageProcessor.registerConflictResolvers(snapshots, resolveSnapshotProvider, usages, changeInfo);
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor3 : processors) {
                if (processor3.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, true, usages)) break;
            }
        }
        LOG.assertTrue(changeInfo.getMethod().isValid());
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (changeSignatureUsageProcessor.processPrimaryMethod(changeInfo)) break;
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor2 : processors) {
                if (processor2.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, false, usages)) break;
            }
        }
        if (!snapshots.isEmpty()) {
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : changeInfo.getNewParameters()) {
                for (ResolveSnapshotProvider.ResolveSnapshot snapshot : snapshots) {
                    snapshot.apply(changeSignatureUsageProcessor.getName());
                }
            }
        }
    }

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myChangeInfo.getMethod())});
        if (string == null) {
            ChangeSignatureProcessorBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    public ChangeInfo getChangeInfo() {
        return this.myChangeInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/ChangeSignatureProcessorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectConflictsFromExtensions";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doChangeSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

