/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalArchivedTemplate
extends ArchivedProjectTemplate {
    @NonNls
    public static final String DESCRIPTION_PATH = ".idea/description.html";
    @NonNls
    static final String TEMPLATE_DESCRIPTOR = ".idea/project-template.xml";
    @NonNls
    static final String TEMPLATE_META_XML = "template-meta.xml";
    static final String META_TEMPLATE_DESCRIPTOR_PATH = ".idea/template-meta.xml";
    @NonNls
    public static final String UNENCODED_ATTRIBUTE = "unencoded";
    @NonNls
    static final String ROOT_FILE_NAME = "root";
    private final URL myArchivePath;
    private final ModuleType<?> myModuleType;
    @Nullable
    private final List<RootDescription> myModuleDescriptions;
    private boolean myEscaped;
    private Icon myIcon;

    public LocalArchivedTemplate(@NotNull URL archivePath, @NotNull ClassLoader classLoader) {
        String meta;
        if (archivePath == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(0);
        }
        if (classLoader == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(1);
        }
        super(LocalArchivedTemplate.getTemplateName(archivePath), null);
        this.myEscaped = true;
        this.myArchivePath = archivePath;
        this.myModuleType = LocalArchivedTemplate.computeModuleType(this);
        String s = this.readEntry(TEMPLATE_DESCRIPTOR);
        if (s != null) {
            try {
                Element templateElement2 = JDOMUtil.load((CharSequence)s);
                this.populateFromElement(templateElement2);
                String iconPath = templateElement2.getChildText("icon-path");
                if (iconPath != null) {
                    this.myIcon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((meta = this.readEntry(META_TEMPLATE_DESCRIPTOR_PATH)) != null) {
            try {
                Element templateElement3 = JDOMUtil.load((CharSequence)meta);
                String unencoded = templateElement3.getAttributeValue(UNENCODED_ATTRIBUTE);
                if (unencoded != null) {
                    this.myEscaped = Boolean.valueOf(unencoded) == false;
                }
                this.myModuleDescriptions = RootDescription.readRoots(templateElement3);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.myModuleDescriptions = null;
        }
    }

    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(2);
        }
        if (this.myModuleDescriptions != null && !this.myModuleDescriptions.isEmpty()) {
            File baseDirFile = new File(baseDirPath);
            for (RootDescription description : this.myModuleDescriptions) {
                File rootFile = new File(baseDirFile + "/" + description.myRelativePath);
                try {
                    if (!(rootFile = rootFile.getCanonicalFile()).exists()) continue;
                    String[] list2 = rootFile.list();
                    if (list2 == null) {
                        return new ValidationResult(LangBundle.message((String)"dialog.message.already.exists.so.project.root.can.t.be.created.html", (Object[])new Object[]{rootFile.getAbsolutePath()}));
                    }
                    if (list2.length <= 0) continue;
                    return new ValidationResult(LangBundle.message((String)"dialog.message.directory.already.exists.and.is.not.empty", (Object[])new Object[]{rootFile.getAbsolutePath()}));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @NlsSafe
    private static String getTemplateName(URL url) {
        String fileName = new File(url.getPath()).getName();
        return fileName.substring(0, fileName.length() - ".zip".length()).replace('_', ' ');
    }

    public String getDescription() {
        return this.readEntry(DESCRIPTION_PATH);
    }

    @Override
    public Icon getIcon() {
        return this.myIcon == null ? super.getIcon() : this.myIcon;
    }

    public boolean isEscaped() {
        return this.myEscaped;
    }

    @Nullable
    @NlsSafe
    String readEntry(final @NotNull String endsWith) {
        if (endsWith == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(3);
        }
        try {
            return this.processStream(new ArchivedProjectTemplate.StreamProcessor<String>(){

                @Override
                public String consume(@NotNull ZipInputStream stream) throws IOException {
                    ZipEntry entry;
                    if (stream == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    while ((entry = stream.getNextEntry()) != null) {
                        if (!entry.getName().endsWith(endsWith)) continue;
                        return new String(StreamUtil.readBytes((InputStream)stream), StandardCharsets.UTF_8);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/platform/templates/LocalArchivedTemplate$1", "consume"));
                }
            });
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @NotNull
    private static ModuleType computeModuleType(LocalArchivedTemplate template) {
        ModuleType moduleType;
        String iml = template.readEntry(".iml");
        if (iml == null) {
            ModuleType moduleType2 = ModuleType.EMPTY;
            if (moduleType2 == null) {
                LocalArchivedTemplate.$$$reportNull$$$0(4);
            }
            return moduleType2;
        }
        try {
            String type = JDOMUtil.load((CharSequence)iml).getAttributeValue("type");
            moduleType = ModuleTypeManager.getInstance().findByID(type);
        }
        catch (Exception e) {
            ModuleType moduleType3 = ModuleType.EMPTY;
            if (moduleType3 == null) {
                LocalArchivedTemplate.$$$reportNull$$$0(6);
            }
            return moduleType3;
        }
        if (moduleType == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(5);
        }
        return moduleType;
    }

    protected ModuleType getModuleType() {
        return this.myModuleType;
    }

    @Override
    public <T> T processStream(@NotNull ArchivedProjectTemplate.StreamProcessor<T> consumer2) throws IOException {
        if (consumer2 == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(7);
        }
        try (ZipInputStream zip = new ZipInputStream(this.myArchivePath.openStream());){
            T t = consumer2.consume(zip);
            return t;
        }
    }

    public URL getArchivePath() {
        return this.myArchivePath;
    }

    @Override
    public void handleUnzippedDirectories(@NotNull File dir, @NotNull List<? super File> filesToRefresh) throws IOException {
        if (dir == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(8);
        }
        if (filesToRefresh == null) {
            LocalArchivedTemplate.$$$reportNull$$$0(9);
        }
        if (this.myModuleDescriptions == null) {
            filesToRefresh.add(dir);
            return;
        }
        for (RootDescription description : this.myModuleDescriptions) {
            File root = new File(dir, ROOT_FILE_NAME + description.myIndex);
            File target2 = new File(dir.getAbsolutePath() + "/" + description.myRelativePath);
            target2.mkdirs();
            FileUtil.copyDir((File)root, (File)target2);
            FileUtil.delete((File)root);
            filesToRefresh.add(target2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archivePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endsWith";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/LocalArchivedTemplate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToRefresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/LocalArchivedTemplate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModuleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readEntry";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processStream";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleUnzippedDirectories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RootDescription {
        @NonNls
        private static final String ROOTS_ELEMENT = "roots";
        @NonNls
        private static final String ROOT_ELEMENT = "root";
        @NonNls
        private static final String INDEX_ATTRIBUTE = "index";
        @NonNls
        private static final String PATH_ATTRIBUTE = "path";
        final VirtualFile myFile;
        final String myRelativePath;
        final int myIndex;

        RootDescription(VirtualFile file2, String path, int index) {
            this.myFile = file2;
            this.myRelativePath = path;
            this.myIndex = index;
        }

        private void write(Element parent) {
            Element rootChild = new Element("root");
            rootChild.setAttribute(INDEX_ATTRIBUTE, String.valueOf(this.myIndex));
            rootChild.setAttribute(PATH_ATTRIBUTE, this.myRelativePath);
            parent.addContent(rootChild);
        }

        private static List<RootDescription> read(Element parent) {
            List children2 = parent.getChildren("root");
            ArrayList<RootDescription> result2 = new ArrayList<RootDescription>(children2.size());
            for (Element child2 : children2) {
                int index = Integer.parseInt(child2.getAttributeValue(INDEX_ATTRIBUTE));
                String path = child2.getAttributeValue(PATH_ATTRIBUTE);
                result2.add(index, new RootDescription(null, path, index));
            }
            return result2;
        }

        static void writeRoots(Element element2, List<? extends RootDescription> rootDescriptions) {
            Element rootsElement = new Element(ROOTS_ELEMENT);
            for (RootDescription rootDescription : rootDescriptions) {
                rootDescription.write(rootsElement);
            }
            element2.addContent(rootsElement);
        }

        @Nullable
        static List<RootDescription> readRoots(Element element2) {
            Element modulesElement = element2.getChild(ROOTS_ELEMENT);
            if (modulesElement != null) {
                return RootDescription.read(modulesElement);
            }
            return null;
        }
    }
}

