/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.win32.Win32FsCache;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Win32LocalFileSystem
extends LocalFileSystemBase {
    private static final ThreadLocal<Win32LocalFileSystem> THREAD_LOCAL = ThreadLocal.withInitial(Win32LocalFileSystem::new);
    private final Win32FsCache myFsCache = new Win32FsCache();

    public static boolean isAvailable() {
        return IdeaWin32.isAvailable();
    }

    @NotNull
    public static Win32LocalFileSystem getWin32Instance() {
        if (!Win32LocalFileSystem.isAvailable()) {
            throw new RuntimeException("Native filesystem for Windows is not loaded");
        }
        Win32LocalFileSystem fileSystem = THREAD_LOCAL.get();
        fileSystem.myFsCache.clearCache();
        Win32LocalFileSystem win32LocalFileSystem = fileSystem;
        if (win32LocalFileSystem == null) {
            Win32LocalFileSystem.$$$reportNull$$$0(0);
        }
        return win32LocalFileSystem;
    }

    private Win32LocalFileSystem() {
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            Win32LocalFileSystem.$$$reportNull$$$0(1);
        }
        String[] stringArray = this.myFsCache.list(file2);
        if (stringArray == null) {
            Win32LocalFileSystem.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            Win32LocalFileSystem.$$$reportNull$$$0(3);
        }
        return this.myFsCache.getAttributes(file2);
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        if (watchRequests == null) {
            Win32LocalFileSystem.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWin32Instance";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

