/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloadDialogKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderModel;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorCombobox;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorElement;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorItem;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010 \u001a\u00020\u0011H\u0014J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0012\u0010'\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0012\u0010(\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002J\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020+\u0018\u00010*J1\u0010,\u001a\u00020$\"\u0006\b\u0000\u0010-\u0018\u0001*\b\u0012\u0004\u0012\u0002H-0\u001e2\u0014\b\u0004\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H-\u0012\u0004\u0012\u00020$0/H\u0082\bJ#\u00100\u001a\u00020$*\u00020\r2\u0014\b\u0004\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020$0/H\u0082\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloadDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "items", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Lcom/intellij/openapi/projectRoots/SdkTypeId;Ljava/util/List;)V", "installDirTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getItems", "()Ljava/util/List;", "panel", "Ljavax/swing/JComponent;", "getParentComponent", "()Ljava/awt/Component;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "selectedItem", "selectedPath", "", "vendorComboBox", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionVendorCombobox;", "versionComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionItem;", "createCenterPanel", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "onVendorActionItemSelected", "", "it", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkVersionVendorElement;", "onVendorSelectionChange", "onVersionSelectionChange", "selectJdkAndPath", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "onSelectionChange", "T", "action", "Lkotlin/Function1;", "onTextChange", "intellij.platform.lang.impl"})
public final class JdkDownloadDialog
extends DialogWrapper {
    private final JComponent panel;
    private final ComboBox<JdkVersionItem> versionComboBox;
    private final JdkVersionVendorCombobox vendorComboBox;
    private final TextFieldWithBrowseButton installDirTextField;
    private JdkItem selectedItem;
    private String selectedPath;
    @Nullable
    private final Project project;
    @Nullable
    private final Component parentComponent;
    @NotNull
    private final SdkTypeId sdkType;
    @NotNull
    private final List<JdkItem> items;

    private final void onVendorActionItemSelected(JdkVersionVendorElement it) {
        if (!(it instanceof JdkVersionVendorItem)) {
            return;
        }
        JdkVersionItem jdkVersionItem = ((JdkVersionVendorItem)it).getParent();
        if (jdkVersionItem == null) {
            return;
        }
        JdkVersionItem parent = jdkVersionItem;
        this.onVersionSelectionChange(parent);
        this.vendorComboBox.setSelectedItem(((JdkVersionVendorItem)it).getSelectItem());
    }

    private final void onVendorSelectionChange(JdkVersionVendorElement it) {
        if (!(it instanceof JdkVersionVendorItem) || !((JdkVersionVendorItem)it).getCanBeSelected()) {
            return;
        }
        this.vendorComboBox.setSelectedItem(((JdkVersionVendorItem)it).getSelectItem());
        JdkItem newVersion = ((JdkVersionVendorItem)it).getItem();
        String path = ((Object)JdkInstaller.Companion.getInstance().defaultInstallDir(newVersion)).toString();
        this.installDirTextField.setText(FileUtil.getLocationRelativeToUserHome((String)path));
        this.selectedPath = path;
        this.selectedItem = newVersion;
    }

    private final void onVersionSelectionChange(JdkVersionItem it) {
        if (it == null) {
            return;
        }
        this.versionComboBox.setSelectedItem((Object)it);
        this.vendorComboBox.setModel(it.getModel());
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfo;
        String error;
        ValidationInfo validationInfo2 = super.doValidate();
        if (validationInfo2 != null) {
            ValidationInfo validationInfo3 = validationInfo2;
            boolean bl = false;
            boolean bl2 = false;
            ValidationInfo it = validationInfo3;
            boolean bl3 = false;
            return it;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string = this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        Object object = jdkInstaller.validateInstallDir(string);
        String string2 = error = (String)object.component2();
        if (string2 != null) {
            object = string2;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            validationInfo = new ValidationInfo(error, (JComponent)this.installDirTextField);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @Nullable
    public final Pair<JdkItem, Path> selectJdkAndPath() {
        Pair<Path, String> pair;
        Path selectedFile;
        if (!this.showAndGet()) {
            return null;
        }
        JdkInstaller jdkInstaller = JdkInstaller.Companion.getInstance();
        String string = this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        if ((selectedFile = (Path)(pair = jdkInstaller.validateInstallDir(string)).component1()) == null) {
            return null;
        }
        JdkItem jdkItem = this.selectedItem;
        if (jdkItem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedItem");
        }
        return TuplesKt.to((Object)jdkItem, (Object)selectedFile);
    }

    private final void onTextChange(TextFieldWithBrowseButton $this$onTextChange, Function1<? super String, Unit> action2) {
        int $i$f$onTextChange = 0;
        JTextField jTextField = $this$onTextChange.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter($this$onTextChange, action2){
            final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
            final /* synthetic */ Function1 $action;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$this_onTextChange.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                this.$action.invoke((Object)string);
            }
            {
                this.$this_onTextChange = $receiver;
                this.$action = $captured_local_variable$1;
            }
        });
    }

    private final /* synthetic */ <T> void onSelectionChange(ComboBox<T> $this$onSelectionChange, Function1<? super T, Unit> action2) {
        int $i$f$onSelectionChange = 0;
        Intrinsics.needClassReification();
        $this$onSelectionChange.addItemListener(new ItemListener(action2){
            final /* synthetic */ Function1 $action;

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    Object object = e.getItem();
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    this.$action.invoke(object);
                }
            }
            {
                this.$action = function1;
            }
        });
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Component getParentComponent() {
        return this.parentComponent;
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        return this.sdkType;
    }

    @NotNull
    public final List<JdkItem> getItems() {
        return this.items;
    }

    /*
     * WARNING - void declaration
     */
    public JdkDownloadDialog(@Nullable Project project, @Nullable Component parentComponent, @NotNull SdkTypeId sdkType, @NotNull List<JdkItem> items) {
        void $this$panel;
        LayoutBuilder builder$iv;
        void $this$onTextChange$iv;
        TextFieldWithBrowseButton $this$onSelectionChange$iv;
        Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        super(project, parentComponent, false, DialogWrapper.IdeModalityType.PROJECT);
        this.project = project;
        this.parentComponent = parentComponent;
        this.sdkType = sdkType;
        this.items = items;
        this.setTitle(ProjectBundle.message((String)"dialog.title.download.jdk", (Object[])new Object[0]));
        this.setResizable(false);
        JdkDownloaderModel model2 = JdkDownloadDialogKt.buildJdkDownloaderModel(this.items);
        Object $this$toTypedArray$iv = model2.getVersionGroups();
        boolean $i$f$toTypedArray22 = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new JdkVersionItem[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.versionComboBox = new ComboBox(objectArray);
        this.versionComboBox.setRenderer((ListCellRenderer)((Object)JdkDownloadDialogKt.access$getJdkVersionItemRenderer$p()));
        this.versionComboBox.setSwingPopup(false);
        this.vendorComboBox = new JdkVersionVendorCombobox();
        String string = ProjectBundle.message((String)"dialog.title.select.path.to.install.jdk", (Object[])new Object[0]);
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor2, (String)"FileChooserDescriptorFac\u2026eSingleFolderDescriptor()");
        this.installDirTextField = ComponentsKt.textFieldWithBrowseButton$default(this.project, string, fileChooserDescriptor2, null, 8, null);
        this.vendorComboBox.onActionItemSelected((Function1<? super JdkVersionVendorItem, Unit>)((Function1)new Function1<JdkVersionVendorElement, Unit>(this){

            public final void invoke(@Nullable JdkVersionVendorElement p1) {
                ((JdkDownloadDialog)((Object)this.receiver)).onVendorActionItemSelected(p1);
            }
        }));
        ComboBox $i$f$toTypedArray22 = this.vendorComboBox;
        $this$toTypedArray$iv = this;
        thisCollection$iv = this;
        boolean $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener((JdkDownloadDialog)((Object)thisCollection$iv)){
            final /* synthetic */ JdkDownloadDialog receiver$0$inlined;
            {
                this.receiver$0$inlined = jdkDownloadDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    Object object = e.getItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionVendorElement");
                    }
                    JdkVersionVendorElement p1 = (JdkVersionVendorElement)object;
                    boolean bl = false;
                    JdkDownloadDialog.access$onVendorSelectionChange(this.receiver$0$inlined, p1);
                }
            }
        });
        $this$onSelectionChange$iv = this.versionComboBox;
        JdkDownloadDialog this_$iv = this;
        thisCollection$iv = this;
        $i$f$onSelectionChange = false;
        $this$onSelectionChange$iv.addItemListener(new ItemListener((JdkDownloadDialog)((Object)thisCollection$iv)){
            final /* synthetic */ JdkDownloadDialog receiver$0$inlined;
            {
                this.receiver$0$inlined = jdkDownloadDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    Object object = e.getItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkVersionItem");
                    }
                    JdkVersionItem p1 = (JdkVersionItem)object;
                    boolean bl = false;
                    JdkDownloadDialog.access$onVersionSelectionChange(this.receiver$0$inlined, p1);
                }
            }
        });
        $this$onSelectionChange$iv = this.installDirTextField;
        this_$iv = this;
        boolean $i$f$onTextChange = false;
        JTextField jTextField = $this$onTextChange$iv.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((TextFieldWithBrowseButton)$this$onTextChange$iv, this){
            final /* synthetic */ TextFieldWithBrowseButton $this_onTextChange;
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.$this_onTextChange = $receiver;
                this.this$0 = jdkDownloadDialog;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$this_onTextChange.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                String it = string;
                boolean bl = false;
                String string2 = FileUtil.expandUserHome((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.expandUserHome(it)");
                JdkDownloadDialog.access$setSelectedPath$p(this.this$0, string2);
            }
        });
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
        JdkDownloadDialog jdkDownloadDialog = this;
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.version", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.this$0 = jdkDownloadDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)JdkDownloadDialog.access$getVersionComboBox$p(this.this$0), new CCFlags[0], null, null, 6, null).sizeGroup("combo");
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.vendor", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.this$0 = jdkDownloadDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)((Object)JdkDownloadDialog.access$getVendorComboBox$p(this.this$0)), new CCFlags[0], null, null, 6, null).sizeGroup("combo").focused();
            }
        }, 2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, ProjectBundle.message((String)"dialog.row.jdk.location", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkDownloadDialog this$0;
            {
                this.this$0 = jdkDownloadDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, (JComponent)JdkDownloadDialog.access$getInstallDirTextField$p(this.this$0), new CCFlags[0], null, null, 6, null);
            }
        }, 2, null);
        Unit unit = Unit.INSTANCE;
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        jdkDownloadDialog.panel = (JComponent)panel$iv;
        this.myOKAction.putValue("Name", ProjectBundle.message((String)"dialog.button.download.jdk", (Object[])new Object[0]));
        this.init();
        this.onVersionSelectionChange(model2.getDefaultVersion());
        this.onVendorSelectionChange(model2.getDefaultVersionVendor());
    }

    public static final /* synthetic */ void access$onVendorSelectionChange(JdkDownloadDialog $this, JdkVersionVendorElement it) {
        $this.onVendorSelectionChange(it);
    }

    public static final /* synthetic */ void access$onVersionSelectionChange(JdkDownloadDialog $this, JdkVersionItem it) {
        $this.onVersionSelectionChange(it);
    }

    public static final /* synthetic */ String access$getSelectedPath$p(JdkDownloadDialog $this) {
        String string = $this.selectedPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPath");
        }
        return string;
    }

    public static final /* synthetic */ void access$setSelectedPath$p(JdkDownloadDialog $this, String string) {
        $this.selectedPath = string;
    }

    public static final /* synthetic */ ComboBox access$getVersionComboBox$p(JdkDownloadDialog $this) {
        return $this.versionComboBox;
    }

    public static final /* synthetic */ JdkVersionVendorCombobox access$getVendorComboBox$p(JdkDownloadDialog $this) {
        return $this.vendorComboBox;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getInstallDirTextField$p(JdkDownloadDialog $this) {
        return $this.installDirTextField;
    }
}

