/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UnknownInvalidSdkFix
implements UnknownSdkFix {
    private static final Logger LOG = Logger.getInstance(UnknownInvalidSdkFix.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String mySdkName;
    @NotNull
    private final UnknownInvalidSdk mySdk;
    @Nullable
    private final UnknownSdkFixAction myAction;

    UnknownInvalidSdkFix(@NotNull Project project, @NotNull UnknownInvalidSdk invalidSdk, @Nullable UnknownSdkFixAction action2) {
        if (project == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(0);
        }
        if (invalidSdk == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySdkName = invalidSdk.getSdkName();
        this.mySdk = invalidSdk;
        this.myAction = action2;
    }

    @Override
    public boolean isRelevantFor(@NotNull Project project) {
        if (project == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(2);
        }
        return this.myProject == project;
    }

    @Override
    public boolean isRelevantFor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(4);
        }
        return this.isRelevantFor(project) && this.mySdk.getSdkType().isRelevantForFile(project, file2);
    }

    @NotNull
    private SdkType getSdkType() {
        SdkType sdkType = this.mySdk.mySdkType;
        if (sdkType == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(5);
        }
        return sdkType;
    }

    @Override
    @Nls
    @NotNull
    public String getConfigureActionText() {
        String string = ProjectBundle.message((String)"action.text.config.invalid.sdk.configure", (Object[])new Object[0]);
        if (string == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public EditorNotificationPanel.ActionHandler getConfigureActionHandler(@NotNull Project project) {
        if (project == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(7);
        }
        String sdkName = this.mySdk.mySdk.getName();
        EditorNotificationPanel.ActionHandler actionHandler = SdkPopupFactory.newBuilder().withProject(project).withSdkFilter((Condition<Sdk>)((Condition)sdk2 -> !Objects.equals(sdk2.getName(), sdkName))).withSdkTypeFilter((Condition<SdkTypeId>)((Condition)type -> Objects.equals(type, this.mySdk.mySdkType))).onSdkSelected(sdk2 -> {
            String homePath = sdk2.getHomePath();
            String versionString = sdk2.getVersionString();
            if (homePath != null && versionString != null) {
                this.mySdk.copySdk(versionString, homePath);
            } else {
                LOG.warn("Newly added SDK has invalid home or version: " + sdk2 + ", home=" + homePath + " version=" + versionString);
            }
        }).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(8);
        }
        return actionHandler;
    }

    @Override
    @Nls
    @NotNull
    public String getIntentionActionText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string = ProjectBundle.message((String)"config.invalid.sdk.configure.missing", (Object[])new Object[]{sdkTypeName, this.mySdkName});
        if (string == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    public UnknownSdkFixAction getSuggestedFixAction() {
        return this.myAction;
    }

    @Override
    @Nls
    @NotNull
    public String getNotificationText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string = ProjectBundle.message((String)"notification.text.config.invalid.sdk", (Object[])new Object[]{sdkTypeName, this.mySdkName});
        if (string == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getSdkTypeAndNameText() {
        String sdkTypeName = this.mySdk.getSdkType().getPresentableName();
        String string = ProjectBundle.message((String)"dialog.text.resolving.sdks.item", (Object[])new Object[]{sdkTypeName, this.mySdkName});
        if (string == null) {
            UnknownInvalidSdkFix.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String toString() {
        return "InvalidSdkFixInfo { name: " + this.mySdkName + ", " + this.myAction + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidSdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdkFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownInvalidSdkFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureActionText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureActionHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkTypeAndNameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFor";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigureActionHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

