/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a7\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0003\u00a2\u0006\u0002\u0010\n\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"collect", "", "configurableWrappers", "", "Lcom/intellij/openapi/options/ex/ConfigurableWrapper;", "configurablesWithEpDependencies", "Lcom/intellij/openapi/options/Configurable$WithEpDependencies;", "configurables", "", "Lcom/intellij/openapi/options/Configurable;", "(Ljava/util/List;Ljava/util/List;[Lcom/intellij/openapi/options/Configurable;)V", "findExtensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "", "area", "Lcom/intellij/openapi/extensions/ExtensionsArea;", "name", "", "intellij.platform.ide.impl"})
public final class EpBasedConfigurableGroupKt {
    private static final ExtensionPoint<Object> findExtensionPoint(ExtensionsArea area, String name) {
        if (area.hasExtensionPoint(name)) {
            ExtensionPoint extensionPoint = area.getExtensionPoint(name);
            Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"area.getExtensionPoint(name)");
            return extensionPoint;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ExtensionPoint extensionPoint = application.getExtensionArea().getExtensionPoint(name);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"ApplicationManager.getAp\u2026a.getExtensionPoint(name)");
        return extensionPoint;
    }

    @ApiStatus.Internal
    private static final void collect(List<ConfigurableWrapper> configurableWrappers, List<Configurable.WithEpDependencies> configurablesWithEpDependencies, Configurable[] configurables) {
        for (Configurable configurable2 : configurables) {
            Configurable[] configurableArray;
            if (configurable2 instanceof ConfigurableWrapper) {
                Class providerClass;
                ConfigurableEP<?> ep2;
                Intrinsics.checkNotNullExpressionValue(((ConfigurableWrapper)configurable2).getExtensionPoint(), (String)"configurable.extensionPoint");
                if (ep2.childrenEPName != null || ep2.dynamic) {
                    configurableWrappers.add((ConfigurableWrapper)configurable2);
                }
                if (((ConfigurableWrapper)configurable2).getProviderClass() != null && (providerClass = ep2.findClassOrNull(((ConfigurableWrapper)configurable2).getProviderClass())) != null && Configurable.WithEpDependencies.class.isAssignableFrom(providerClass)) {
                    configurableWrappers.add((ConfigurableWrapper)configurable2);
                }
            } else if (configurable2 instanceof Configurable.WithEpDependencies) {
                configurablesWithEpDependencies.add((Configurable.WithEpDependencies)configurable2);
            }
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            Configurable[] children2 = null;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)((Configurable.Composite)configurable2).getConfigurables(), (String)"configurable.configurables");
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                ConfigurableWrapper.LOG.error("Cannot get children " + configurable2, e);
                continue;
            }
            children2 = configurableArray;
            EpBasedConfigurableGroupKt.collect(configurableWrappers, configurablesWithEpDependencies, children2);
        }
    }

    public static final /* synthetic */ ExtensionPoint access$findExtensionPoint(ExtensionsArea area, String name) {
        return EpBasedConfigurableGroupKt.findExtensionPoint(area, name);
    }

    public static final /* synthetic */ void access$collect(List configurableWrappers, List configurablesWithEpDependencies, Configurable[] configurables) {
        EpBasedConfigurableGroupKt.collect(configurableWrappers, configurablesWithEpDependencies, configurables);
    }
}

