/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ProjectTopics;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorContainerFactory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerChange;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutSettingsManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@State(name="FileEditorManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class FileEditorManagerImpl
extends FileEditorManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(FileEditorManagerImpl.class);
    protected static final Key<Boolean> DUMB_AWARE = Key.create((String)"DUMB_AWARE");
    private static final FileEditorProvider[] EMPTY_PROVIDER_ARRAY = new FileEditorProvider[0];
    public static final Key<Boolean> CLOSING_TO_REOPEN = Key.create((String)"CLOSING_TO_REOPEN");
    public static final Key<Boolean> OPEN_IN_PREVIEW_TAB = Key.create((String)"OPEN_IN_PREVIEW_TAB");
    public static final String FILE_EDITOR_MANAGER = "FileEditorManager";
    private EditorsSplitters mySplitters;
    private final Project myProject;
    private final List<Pair<VirtualFile, EditorWindow>> mySelectionHistory;
    private Reference<EditorComposite> myLastSelectedComposite;
    private final MergingUpdateQueue myQueue;
    private final BusyObject.Impl.Simple myBusyObject;
    private final PropertyChangeListener myEditorPropertyChangeListener;
    private final DockManager myDockManager;
    private DockableEditorContainerFactory myContentFactory;
    private static final AtomicInteger ourOpenFilesSetModificationCount = new AtomicInteger();
    static final ModificationTracker OPEN_FILE_SET_MODIFICATION_COUNT = ourOpenFilesSetModificationCount::get;
    private final List<EditorComposite> myOpenedEditors;
    private final MessageListenerList<FileEditorManagerListener> myListenerList;
    private final Object myInitLock;

    public FileEditorManagerImpl(@NotNull Project project) {
        if (project == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(0);
        }
        this.mySelectionHistory = new ArrayList<Pair<VirtualFile, EditorWindow>>();
        this.myLastSelectedComposite = new WeakReference<Object>(null);
        this.myQueue = new MergingUpdateQueue("FileEditorManagerUpdateQueue", 50, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
        this.myBusyObject = new BusyObject.Impl.Simple();
        this.myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
        this.myOpenedEditors = new CopyOnWriteArrayList<EditorComposite>();
        this.myInitLock = new Object();
        this.myProject = project;
        this.myDockManager = DockManager.getInstance((Project)this.myProject);
        this.myListenerList = new MessageListenerList(this.myProject.getMessageBus(), FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (FileEditorAssociateFinder.EP_NAME.hasAnyExtensions()) {
            this.myListenerList.add((Object)new FileEditorManagerListener(){

                public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    EditorsSplitters splitters = FileEditorManagerImpl.this.getSplitters();
                    FileEditorManagerImpl.this.openAssociatedFile(event.getNewFile(), splitters.getCurrentWindow(), splitters);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$1", "selectionChanged"));
                }
            });
        }
        this.myQueue.setTrackUiActivity(true);
        final MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> FileEditorManagerImpl.this.dumbModeFinished(FileEditorManagerImpl.this.myProject), FileEditorManagerImpl.this.myProject.getDisposed());
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.projectOpened(connection);
                }
            }

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (project == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.closeAllFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FileEditorProvider.EP_FILE_EDITOR_PROVIDER.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionRemoved(@NotNull FileEditorProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                block0: for (EditorComposite editor : FileEditorManagerImpl.this.myOpenedEditors) {
                    for (FileEditorProvider provider2 : editor.getProviders()) {
                        if (!provider2.equals(extension)) continue;
                        FileEditorManagerImpl.this.closeFile(editor.getFile());
                        continue block0;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    private void dumbModeFinished(Project project) {
        VirtualFile[] files2;
        for (VirtualFile file2 : files2 = this.getOpenFiles()) {
            HashSet providers = new HashSet();
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            for (EditorWithProviderComposite composite : composites) {
                ContainerUtil.addAll(providers, (Object[])composite.getProviders());
            }
            FileEditorProvider[] newProviders = FileEditorProviderManager.getInstance().getProviders(project, file2);
            ArrayList<FileEditorProvider> toOpen = new ArrayList<FileEditorProvider>(Arrays.asList(newProviders));
            toOpen.removeAll(providers);
            for (EditorWithProviderComposite composite : composites) {
                for (FileEditorProvider provider2 : toOpen) {
                    FileEditor editor = provider2.createEditor(this.myProject, file2);
                    composite.addEditor(editor, provider2);
                }
            }
        }
        this.updateFileName(null);
    }

    public void initDockableContentFactory() {
        if (this.myContentFactory != null) {
            return;
        }
        this.myContentFactory = new DockableEditorContainerFactory(this.myProject, this);
        this.myDockManager.register("file-editors", (DockContainerFactory)this.myContentFactory, (Disposable)this);
    }

    public static boolean isDumbAware(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE.equals(editor.getUserData(DUMB_AWARE)) && (!(editor instanceof PossiblyDumbAware) || ((PossiblyDumbAware)editor).isDumbAware());
    }

    @Override
    public JComponent getComponent() {
        return this.initUI();
    }

    @NotNull
    public EditorsSplitters getMainSplitters() {
        return this.initUI();
    }

    @NotNull
    public Set<EditorsSplitters> getAllSplitters() {
        LinkedHashSet<EditorsSplitters> all = new LinkedHashSet<EditorsSplitters>();
        all.add(this.getMainSplitters());
        Set dockContainers = this.myDockManager.getContainers();
        for (DockContainer each : dockContainers) {
            if (!(each instanceof DockableEditorTabbedContainer)) continue;
            all.add(((DockableEditorTabbedContainer)each).getSplitters());
        }
        Set<EditorsSplitters> set2 = Collections.unmodifiableSet(all);
        if (set2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    private Promise<EditorsSplitters> getActiveSplittersAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        fm.doWhenFocusSettlesDown(() -> {
            if (this.myProject.isDisposed()) {
                result2.cancel();
                return;
            }
            Component focusOwner = fm.getFocusOwner();
            DockContainer container = this.myDockManager.getContainerFor(focusOwner);
            if (container instanceof DockableEditorTabbedContainer) {
                result2.setResult((Object)((DockableEditorTabbedContainer)container).getSplitters());
            } else {
                result2.setResult((Object)this.getMainSplitters());
            }
        }, ModalityState.defaultModalityState());
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    private EditorsSplitters getActiveSplittersSync() {
        DockContainer container;
        ArrayList<EditorsSplitters> splitters;
        FileEditorManagerImpl.assertDispatchThread();
        if (Registry.is((String)"ide.navigate.to.recently.focused.editor", (boolean)false) && !(splitters = new ArrayList<EditorsSplitters>(this.getAllSplitters())).isEmpty()) {
            splitters.sort((o1, o2) -> Long.compare(o2.getLastFocusGainedTime(), o1.getLastFocusGainedTime()));
            return splitters.get(0);
        }
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component focusOwner = fm.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            focusOwner = fm.getLastFocusedFor(fm.getLastFocusedIdeWindow());
        }
        if ((container = this.myDockManager.getContainerFor(focusOwner)) == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            container = this.myDockManager.getContainerFor(focusOwner);
        }
        if (container instanceof DockableEditorTabbedContainer) {
            return ((DockableEditorTabbedContainer)container).getSplitters();
        }
        return this.getMainSplitters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EditorsSplitters initUI() {
        EditorsSplitters result2 = this.mySplitters;
        if (result2 != null) {
            EditorsSplitters editorsSplitters = result2;
            if (editorsSplitters == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(4);
            }
            return editorsSplitters;
        }
        Object object = this.myInitLock;
        synchronized (object) {
            result2 = this.mySplitters;
            if (result2 == null) {
                this.mySplitters = result2 = new EditorsSplitters(this, true, this);
            }
        }
        EditorsSplitters editorsSplitters = result2;
        if (editorsSplitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(5);
        }
        return editorsSplitters;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        EditorWithProviderComposite editor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    @NotNull
    Color getFileColor(@NotNull VirtualFile file2) {
        FileStatusManager fileStatusManager;
        Color statusColor;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(6);
        }
        Color color = statusColor = (fileStatusManager = FileStatusManager.getInstance((Project)this.myProject)) != null ? fileStatusManager.getStatus(file2).getColor() : UIUtil.getLabelForeground();
        if (statusColor == null) {
            statusColor = UIUtil.getLabelForeground();
        }
        Color color2 = statusColor;
        if (color2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(7);
        }
        return color2;
    }

    public boolean isProblem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(8);
        }
        return false;
    }

    @NotNull
    @NlsContexts.Tooltip
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(9);
        }
        List availableProviders = DumbService.getDumbAwareExtensions((Project)this.myProject, EditorTabTitleProvider.EP_NAME);
        for (EditorTabTitleProvider provider2 : availableProviders) {
            String text2 = provider2.getEditorTabTooltipText(this.myProject, file2);
            if (text2 == null) continue;
            String string = text2;
            if (string == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
        if (string == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(12);
        }
        if (!this.isFileOpen(file2)) {
            return;
        }
        this.updateFileName(file2);
        this.queueUpdateFile(file2);
    }

    private void updateFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(13);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileColor(file2);
        }
    }

    private void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(14);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileBackgroundColor(file2);
        }
    }

    protected void updateFileIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(15);
        }
        this.updateFileIcon(file2, false);
    }

    private void resetPreviewFlag(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(16);
        }
        for (EditorsSplitters splitter : this.getAllSplitters()) {
            splitter.findEditorComposites(file2).stream().filter(EditorComposite::isPreview).forEach(c -> c.setPreview(false));
            splitter.updateFileStyle(file2);
        }
    }

    protected void updateFileIcon(@NotNull VirtualFile file2, boolean immediately) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(17);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            if (immediately) {
                each.updateFileIconImmediately(file2, IconUtil.computeFileIcon((VirtualFile)file2, (int)2, (Project)this.myProject));
                continue;
            }
            each.updateFileIcon(file2);
        }
    }

    void updateFileName(final @Nullable VirtualFile file2) {
        this.myQueue.queue(new Update("UpdateFileName " + (file2 == null ? "" : file2.getPath())){

            public boolean isExpired() {
                return FileEditorManagerImpl.this.myProject.isDisposed() || !FileEditorManagerImpl.this.myProject.isOpen() || (file2 == null ? super.isExpired() : !file2.isValid());
            }

            public void run() {
                for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                    each.updateFileName(file2);
                }
            }
        });
    }

    private void updateFrameTitle() {
        this.getActiveSplittersAsync().onSuccess(splitters -> splitters.updateFileName(null));
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        EditorWithProviderComposite editorComposite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(18);
        }
        return (editorComposite = this.getEditorComposite(editor)) == null ? null : editorComposite.getFile();
    }

    @Override
    public void unsplitWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplit(true);
        }
    }

    @Override
    public void unsplitAllWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplitAll();
        }
    }

    @Override
    public int getWindowSplitCount() {
        return this.getActiveSplittersSync().getSplitCount();
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        Set<EditorsSplitters> splitters = this.getAllSplitters();
        if (splitters.size() > 1) {
            return true;
        }
        return this.getWindowSplitCount() > 1;
    }

    @Override
    public EditorWindow @NotNull [] getWindows() {
        ArrayList windows = new ArrayList();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            Object[] eachList = each.getWindows();
            ContainerUtil.addAll(windows, (Object[])eachList);
        }
        EditorWindow[] editorWindowArray = windows.toArray(new EditorWindow[0]);
        if (editorWindowArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(19);
        }
        return editorWindowArray;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(20);
        }
        List<EditorWindow> windows = this.getSplitters().getOrderedWindows();
        for (int i2 = 0; i2 != windows.size(); ++i2) {
            if (!windows.get(i2).equals(window)) continue;
            return windows.get((i2 + 1) % windows.size());
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(21);
        }
        List<EditorWindow> windows = this.getSplitters().getOrderedWindows();
        for (int i2 = 0; i2 != windows.size(); ++i2) {
            if (!windows.get(i2).equals(window)) continue;
            return windows.get((i2 + windows.size() - 1) % windows.size());
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        if (window != null) {
            window.split(orientation, true, null, false);
        } else {
            EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
            if (currentWindow != null) {
                currentWindow.split(orientation, true, null, false);
            }
        }
    }

    @Override
    public void changeSplitterOrientation() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.changeOrientation();
        }
    }

    @Override
    public boolean isInSplitter() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.inSplitter();
    }

    @Override
    public boolean hasOpenedFile() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.getSelectedEditor() != null;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.getActiveSplittersSync().getCurrentFile();
    }

    @Override
    @NotNull
    public Promise<EditorWindow> getActiveWindow() {
        Promise promise = this.getActiveSplittersAsync().then(EditorsSplitters::getCurrentWindow);
        if (promise == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(22);
        }
        return promise;
    }

    @Override
    public EditorWindow getCurrentWindow() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        EditorsSplitters splitters = this.getActiveSplittersSync();
        return splitters == null ? null : splitters.getCurrentWindow();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
        this.getActiveSplittersSync().setCurrentWindow(window, true);
    }

    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window, boolean transferFocus) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(23);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(24);
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (window.isFileOpen(file2)) {
                window.closeFile(file2, true, transferFocus);
            }
        }, IdeBundle.message((String)"command.close.active.editor", (Object[])new Object[0]), null);
        this.removeSelectionRecord(file2, window);
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(25);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(26);
        }
        this.closeFile(file2, window, true);
    }

    public void closeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(27);
        }
        this.closeFile(file2, true, false);
    }

    public void closeFile(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(28);
        }
        FileEditorManagerImpl.assertDispatchThread();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.closeFileImpl(file2, moveFocus, closeAllCopies), "", null);
    }

    private void closeFileImpl(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(29);
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        this.runChange(splitters -> splitters.closeFile(file2, moveFocus), closeAllCopies ? null : this.getActiveSplittersSync());
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        Pair<FileEditor[], FileEditorProvider[]> pair;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(30);
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        OpenMode mode = FileEditorManagerImpl.getOpenMode(IdeEventQueue.getInstance().getTrueCurrentEvent());
        if (mode == OpenMode.NEW_WINDOW) {
            Pair<FileEditor[], FileEditorProvider[]> pair2 = this.openFileInNewWindow(file2);
            if (pair2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(31);
            }
            return pair2;
        }
        if (mode == OpenMode.RIGHT_SPLIT && (pair = this.openInRightSplit(file2)) != null) {
            Pair<FileEditor[], FileEditorProvider[]> pair3 = pair;
            if (pair3 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(32);
            }
            return pair3;
        }
        EditorWindow wndToOpenIn = null;
        if (searchForSplitter && UISettings.getInstance().getEditorTabPlacement() != 0) {
            Set<EditorsSplitters> all = this.getAllSplitters();
            EditorsSplitters active = this.getActiveSplittersSync();
            if (active.getCurrentWindow() != null && active.getCurrentWindow().isFileOpen(file2)) {
                wndToOpenIn = active.getCurrentWindow();
            } else {
                for (EditorsSplitters splitters : all) {
                    EditorWindow window = splitters.getCurrentWindow();
                    if (window == null || !window.isFileOpen(file2)) continue;
                    wndToOpenIn = window;
                    break;
                }
            }
        } else {
            wndToOpenIn = this.getSplitters().getCurrentWindow();
        }
        EditorsSplitters splitters = this.getSplitters();
        if (wndToOpenIn == null) {
            wndToOpenIn = splitters.getOrCreateCurrentWindow(file2);
        }
        this.openAssociatedFile(file2, wndToOpenIn, splitters);
        Pair<FileEditor[], FileEditorProvider[]> pair4 = this.openFileImpl2(wndToOpenIn, file2, focusEditor);
        if (pair4 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(33);
        }
        return pair4;
    }

    public Pair<FileEditor[], FileEditorProvider[]> openFileInNewWindow(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(34);
        }
        return ((DockManagerImpl)DockManager.getInstance((Project)this.getProject())).createNewDockContainerFor(file2, this);
    }

    @Nullable
    private Pair<FileEditor[], FileEditorProvider[]> openInRightSplit(@NotNull VirtualFile file2) {
        EditorsSplitters active;
        EditorWindow window;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(35);
        }
        if ((window = (active = this.getSplitters()).getCurrentWindow()) != null) {
            if (window.inSplitter() && file2.equals(window.getSelectedFile()) && file2.equals(ArrayUtil.getLastElement((Object[])window.getFiles()))) {
                return null;
            }
            EditorWindow split = active.openInRightSplit(file2);
            if (split != null) {
                Ref ref = Ref.create();
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    EditorWithProviderComposite[] editorsWithProvider = split.getEditors();
                    FileEditor[] editors2 = (FileEditor[])Arrays.stream(editorsWithProvider).map(el -> el.getEditors()).flatMap(el -> Arrays.stream(el)).toArray(FileEditor[]::new);
                    FileEditorProvider[] providers = (FileEditorProvider[])Arrays.stream(editorsWithProvider).map(el -> el.getProviders()).flatMap(el -> Arrays.stream(el)).toArray(FileEditorProvider[]::new);
                    ref.set((Object)Pair.create((Object)editors2, (Object)providers));
                }, "", null);
                return (Pair)ref.get();
            }
        }
        return null;
    }

    @NotNull
    public static OpenMode getOpenMode(@NotNull AWTEvent event) {
        if (event == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(36);
        }
        if (event instanceof MouseEvent) {
            boolean isMouseClick = event.getID() == 500 || event.getID() == 501 || event.getID() == 502;
            int modifiers = ((MouseEvent)event).getModifiersEx();
            if (modifiers == 64 && isMouseClick) {
                OpenMode openMode = OpenMode.NEW_WINDOW;
                if (openMode == null) {
                    FileEditorManagerImpl.$$$reportNull$$$0(37);
                }
                return openMode;
            }
        }
        if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            KeymapManager keymapManager2 = KeymapManager.getInstance();
            if (keymapManager2 != null) {
                Keymap keymap2 = keymapManager2.getActiveKeymap();
                String[] ids = keymap2.getActionIds(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
                List<String> strings = Arrays.asList(ids);
                if (strings.contains("OpenElementInNewWindow")) {
                    OpenMode openMode = OpenMode.NEW_WINDOW;
                    if (openMode == null) {
                        FileEditorManagerImpl.$$$reportNull$$$0(38);
                    }
                    return openMode;
                }
                if (strings.contains("OpenInRightSplit")) {
                    OpenMode openMode = OpenMode.RIGHT_SPLIT;
                    if (openMode == null) {
                        FileEditorManagerImpl.$$$reportNull$$$0(39);
                    }
                    return openMode;
                }
            }
        }
        OpenMode openMode = OpenMode.DEFAULT;
        if (openMode == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(40);
        }
        return openMode;
    }

    private void openAssociatedFile(VirtualFile file2, EditorWindow wndToOpenIn, @NotNull EditorsSplitters splitters) {
        if (splitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(41);
        }
        EditorWindow[] windows = splitters.getWindows();
        if (file2 != null && windows.length == 2) {
            for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, file2);
                if (associatedFile == null) continue;
                EditorWindow currentWindow = splitters.getCurrentWindow();
                int idx = windows[0] == wndToOpenIn ? 1 : 0;
                this.openFileImpl2(windows[idx], associatedFile, false);
                if (currentWindow == null) break;
                splitters.setCurrentWindow(currentWindow, false);
                break;
            }
        }
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(42);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(43);
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(window, file2, focusEditor);
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(44);
        }
        return pair;
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(45);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(46);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(window, file2, focusEditor, null)), "", null);
        Pair pair = (Pair)result2.get();
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(47);
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor, @Nullable HistoryEntry entry) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(48);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(49);
        }
        if (file2 instanceof BackedVirtualFile) {
            file2 = ((BackedVirtualFile)file2).getOriginFile();
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl4(window, file2, entry, new FileEditorOpenOptions().withCurrentTab(true).withFocusEditor(focusEditor));
        if (pair == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(50);
        }
        return pair;
    }

    @NotNull
    protected @NotNull Pair<FileEditor @NotNull [], FileEditorProvider @NotNull []> openFileImpl4(@NotNull EditorWindow window, @NotNull VirtualFile file2, @Nullable HistoryEntry entry, @NotNull FileEditorOpenOptions options2) {
        AsyncFileEditorProvider.Builder[] builders;
        FileEditorProvider[] newProviders;
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(51);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(52);
        }
        if (options2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(53);
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "must not open files under read action since we are doing a lot of invokeAndWaits here";
        Ref compositeRef = new Ref();
        if (!options2.isReopeningEditorsOnStartup()) {
            EdtInvocationManager.invokeAndWaitIfNeeded(() -> compositeRef.set((Object)window.findFileComposite(file2)));
        }
        if (compositeRef.isNull()) {
            newProviders = FileEditorProviderManager.getInstance().getProviders(this.myProject, file2);
            if (newProviders.length == 0) {
                Pair.NonNull nonNull = Pair.createNonNull((Object)FileEditor.EMPTY_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
                if (nonNull == null) {
                    FileEditorManagerImpl.$$$reportNull$$$0(54);
                }
                return nonNull;
            }
            builders = new AsyncFileEditorProvider.Builder[newProviders.length];
            for (int i2 = 0; i2 < newProviders.length; ++i2) {
                try {
                    FileEditorProvider provider2 = newProviders[i2];
                    LOG.assertTrue(provider2 != null, (Object)("Provider for file " + file2 + " is null. All providers: " + Arrays.asList(newProviders)));
                    builders[i2] = (AsyncFileEditorProvider.Builder)ReadAction.compute(() -> {
                        if (this.myProject.isDisposed() || !file2.isValid()) {
                            return null;
                        }
                        LOG.assertTrue(provider2.accept(this.myProject, file2), (Object)("Provider " + provider2 + " doesn't accept file " + file2));
                        return provider2 instanceof AsyncFileEditorProvider ? ((AsyncFileEditorProvider)provider2).createEditorAsync(this.myProject, file2) : null;
                    });
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AssertionError | Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            newProviders = null;
            builders = null;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> FileEditorManagerImpl.runBulkTabChange(window.getOwner(), splitters -> this.openFileImpl4Edt(window, file2, entry, options2, (Ref<EditorWithProviderComposite>)compositeRef, newProviders, builders)));
        EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
        return new Pair((Object)(composite == null ? FileEditor.EMPTY_ARRAY : composite.getEditors()), (Object)(composite == null ? EMPTY_PROVIDER_ARRAY : composite.getProviders()));
    }

    private void openFileImpl4Edt(@NotNull EditorWindow window, @NotNull VirtualFile file2, @Nullable HistoryEntry entry, @NotNull FileEditorOpenOptions options2, @NotNull Ref<EditorWithProviderComposite> compositeRef, FileEditorProvider[] newProviders, AsyncFileEditorProvider.Builder[] builders) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(55);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(56);
        }
        if (options2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(57);
        }
        if (compositeRef == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(58);
        }
        if (this.myProject.isDisposed() || !file2.isValid()) {
            return;
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        compositeRef.set((Object)window.findFileComposite(file2));
        boolean newEditor = compositeRef.isNull();
        if (newEditor) {
            ((FileEditorManagerListener.Before)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER)).beforeFileOpened((FileEditorManager)this, file2);
            FileEditor[] newEditors = new FileEditor[newProviders.length];
            for (int i2 = 0; i2 < newProviders.length; ++i2) {
                try {
                    FileEditorProvider provider2 = newProviders[i2];
                    FileEditor editor = builders[i2] == null ? provider2.createEditor(this.myProject, file2) : builders[i2].build();
                    LOG.assertTrue(editor.isValid(), (Object)("Invalid editor created by provider " + (provider2 == null ? null : provider2.getClass().getName())));
                    newEditors[i2] = editor;
                    editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
                    editor.putUserData(DUMB_AWARE, (Object)DumbService.isDumbAware((Object)provider2));
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AssertionError | Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            EditorWithProviderComposite composite = this.createComposite(file2, newEditors, newProviders);
            if (composite == null) {
                return;
            }
            if (options2.getIndex() >= 0) {
                composite.getFile().putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)options2.getIndex());
            }
            compositeRef.set((Object)composite);
            this.myOpenedEditors.add(composite);
        }
        EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
        FileEditor[] editors2 = composite.getEditors();
        FileEditorProvider[] providers = composite.getProviders();
        window.setEditor(composite, options2.isCurrentTab(), options2.isFocusEditor());
        for (int i3 = 0; i3 < editors2.length; ++i3) {
            this.restoreEditorState(file2, providers[i3], editors2[i3], entry, newEditor, options2.isExactState());
        }
        FileEditorProvider selectedProvider = entry == null ? ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).getSelectedFileEditorProvider(EditorHistoryManager.getInstance(this.myProject), file2, providers) : entry.getSelectedProvider();
        if (selectedProvider != null) {
            for (int i4 = editors2.length - 1; i4 >= 0; --i4) {
                FileEditorProvider provider3 = providers[i4];
                if (!provider3.equals(selectedProvider)) continue;
                composite.setSelectedEditor(i4);
                break;
            }
        }
        window.getOwner().setCurrentWindow(window, options2.isFocusEditor());
        window.getOwner().afterFileOpen(file2);
        this.addSelectionRecord(file2, window);
        composite.getSelectedEditor().selectNotify();
        if (!ApplicationManager.getApplication().isUnitTestMode() && options2.isFocusEditor()) {
            window.setAsCurrentWindow(true);
            Window windowAncestor = SwingUtilities.getWindowAncestor(window.myPanel);
            if (windowAncestor != null && windowAncestor.equals(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                EditorsSplitters.focusDefaultComponentInSplittersIfPresent(this.myProject);
                IdeFocusManager.getInstance((Project)this.myProject).toFront((JComponent)((Object)window.getOwner()));
            }
        }
        if (newEditor) {
            ourOpenFilesSetModificationCount.incrementAndGet();
        }
        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
        this.updateFileName(file2);
        IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        if (options2.getPin() != null) {
            window.setFilePinned(file2, options2.getPin());
        }
        if (newEditor) {
            ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpenedSync((FileEditorManager)this, file2, Pair.pair((Object)editors2, (Object)providers));
            this.notifyPublisher(() -> {
                if (this.isFileOpen(file2)) {
                    ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened((FileEditorManager)this, file2);
                }
            });
        }
    }

    @Nullable
    protected final EditorWithProviderComposite createComposite(@NotNull VirtualFile file2, FileEditor @NotNull [] editors2, FileEditorProvider @NotNull [] providers) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(59);
        }
        if (editors2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(60);
        }
        if (providers == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(61);
        }
        if (ArrayUtil.contains(null, (Object[])editors2) || ArrayUtil.contains(null, (Object[])providers)) {
            ArrayList<FileEditor> editorList = new ArrayList<FileEditor>(editors2.length);
            ArrayList<FileEditorProvider> providerList = new ArrayList<FileEditorProvider>(providers.length);
            for (int i2 = 0; i2 < editors2.length; ++i2) {
                FileEditor editor = editors2[i2];
                FileEditorProvider provider2 = providers[i2];
                if (editor == null || provider2 == null) continue;
                editorList.add(editor);
                providerList.add(provider2);
            }
            if (editorList.isEmpty()) {
                return null;
            }
            editors2 = editorList.toArray(FileEditor.EMPTY_ARRAY);
            providers = providerList.toArray(new FileEditorProvider[0]);
        }
        return new EditorWithProviderComposite(file2, editors2, providers, this);
    }

    private void restoreEditorState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider2, @NotNull FileEditor editor, HistoryEntry entry, boolean newEditor, boolean exactState) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(62);
        }
        if (provider2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(63);
        }
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(64);
        }
        FileEditorState state = null;
        if (entry != null) {
            state = entry.getState(provider2);
        }
        if (state == null && newEditor) {
            state = EditorHistoryManager.getInstance(this.myProject).getState(file2, provider2);
        }
        if (state != null) {
            if (!FileEditorManagerImpl.isDumbAware(editor)) {
                FileEditorState finalState = state;
                DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> editor.setState(finalState, exactState));
            } else {
                editor.setState(state, exactState);
            }
        }
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(65);
        }
        final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        final ActionCallback done = new ActionCallback();
        ActionCallback actionCallback = this.myBusyObject.execute(new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                focusManager.doWhenFocusSettlesDown((Runnable)ExpirableRunnable.forProject((Project)FileEditorManagerImpl.this.myProject, () -> {
                    runnable2.run();
                    done.setDone();
                }), ModalityState.current());
                ActionCallback actionCallback = done;
                if (actionCallback == null) {
                    6.$$$reportNull$$$0(0);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$6", "run"));
            }
        });
        if (actionCallback == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(66);
        }
        return actionCallback;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(67);
        }
        if (fileEditorProviderId == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(68);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite == null) {
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            if (composites.isEmpty()) {
                return;
            }
            composite = composites.get(0);
        }
        FileEditorProvider[] editorProviders = composite.getProviders();
        FileEditorProvider selectedProvider = composite.getSelectedWithProvider().getProvider();
        for (int i2 = 0; i2 < editorProviders.length; ++i2) {
            if (!editorProviders[i2].getEditorTypeId().equals(fileEditorProviderId) || selectedProvider.equals(editorProviders[i2])) continue;
            composite.setSelectedEditor(i2);
            composite.getSelectedEditor().selectNotify();
        }
    }

    @Nullable
    EditorWithProviderComposite newEditorComposite(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file2);
        if (providers.length == 0) {
            return null;
        }
        FileEditor[] editors2 = new FileEditor[providers.length];
        for (int i2 = 0; i2 < providers.length; ++i2) {
            FileEditor editor;
            FileEditorProvider provider2 = providers[i2];
            LOG.assertTrue(provider2 != null);
            LOG.assertTrue(provider2.accept(this.myProject, file2));
            editors2[i2] = editor = provider2.createEditor(this.myProject, file2);
            LOG.assertTrue(editor.isValid());
            editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
        }
        EditorWithProviderComposite newComposite = new EditorWithProviderComposite(file2, editors2, providers, this);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (int i3 = 0; i3 < editors2.length; ++i3) {
            FileEditor editor = editors2[i3];
            FileEditorProvider provider3 = providers[i3];
            FileEditorState state = editorHistoryManager.getState(file2, provider3);
            if (state == null) continue;
            editor.setState(state);
        }
        return newComposite;
    }

    @NotNull
    public List<FileEditor> openFileEditor(@NotNull FileEditorNavigatable descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(69);
        }
        List list2 = (List)this.openEditorImpl((FileEditorNavigatable)descriptor2, (boolean)focusEditor).first;
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(70);
        }
        return list2;
    }

    private Pair<List<FileEditor>, FileEditor> openEditorImpl(@NotNull FileEditorNavigatable descriptor2, boolean focusEditor) {
        FileEditorNavigatable realDescriptor;
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(71);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (descriptor2 instanceof OpenFileDescriptor && descriptor2.getFile() instanceof VirtualFileWindow) {
            OpenFileDescriptor openFileDescriptor = (OpenFileDescriptor)descriptor2;
            VirtualFileWindow delegate = (VirtualFileWindow)descriptor2.getFile();
            int hostOffset = delegate.getDocumentWindow().injectedToHost(openFileDescriptor.getOffset());
            OpenFileDescriptor fixedDescriptor = new OpenFileDescriptor(openFileDescriptor.getProject(), delegate.getDelegate(), hostOffset);
            fixedDescriptor.setUseCurrentWindow(openFileDescriptor.isUseCurrentWindow());
            realDescriptor = fixedDescriptor;
        } else {
            realDescriptor = descriptor2;
        }
        SmartList result2 = new SmartList();
        Ref selectedEditor = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.lambda$openEditorImpl$21(realDescriptor, focusEditor, (List)result2, selectedEditor), "", null);
        return Pair.create((Object)result2, (Object)((FileEditor)selectedEditor.get()));
    }

    private boolean navigateAndSelectEditor(@NotNull NavigatableFileEditor editor, @NotNull Navigatable descriptor2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(72);
        }
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(73);
        }
        if (editor.canNavigateTo(descriptor2)) {
            this.setSelectedEditor((FileEditor)editor);
            editor.navigateTo(descriptor2);
            return true;
        }
        return false;
    }

    private void setSelectedEditor(@NotNull FileEditor editor) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(74);
        }
        if ((composite = this.getEditorComposite(editor)) == null) {
            return;
        }
        FileEditor[] editors2 = composite.getEditors();
        for (int i2 = 0; i2 < editors2.length; ++i2) {
            FileEditor each = editors2[i2];
            if (editor != each) continue;
            composite.setSelectedEditor(i2);
            composite.getSelectedEditor().selectNotify();
            break;
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(75);
        }
        return project;
    }

    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        TextEditor textEditor;
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(76);
        }
        return (textEditor = this.doOpenTextEditor((FileEditorNavigatable)descriptor2, focusEditor)) == null ? null : textEditor.getEditor();
    }

    @Nullable
    private TextEditor doOpenTextEditor(@NotNull FileEditorNavigatable descriptor2, boolean focusEditor) {
        TextEditor target2;
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(77);
        }
        Pair<List<FileEditor>, FileEditor> editorsWithSelected = this.openEditorImpl(descriptor2, focusEditor);
        Collection fileEditors = (Collection)editorsWithSelected.first;
        FileEditor selectedEditor = (FileEditor)editorsWithSelected.second;
        if (fileEditors.isEmpty()) {
            return null;
        }
        if (fileEditors.size() == 1) {
            return (TextEditor)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem((Collection)fileEditors), TextEditor.class);
        }
        List textEditors = ContainerUtil.mapNotNull((Collection)fileEditors, e -> (TextEditor)ObjectUtils.tryCast((Object)e, TextEditor.class));
        if (textEditors.isEmpty()) {
            return null;
        }
        TextEditor textEditor = target2 = selectedEditor instanceof TextEditor ? (TextEditor)selectedEditor : (TextEditor)textEditors.get(0);
        if (textEditors.size() > 1) {
            EditorWithProviderComposite composite = this.getEditorComposite((FileEditor)target2);
            assert (composite != null);
            FileEditor[] editors2 = composite.getEditors();
            FileEditorProvider[] providers = composite.getProviders();
            String textProviderId = TextEditorProvider.getInstance().getEditorTypeId();
            for (int i2 = 0; i2 < editors2.length; ++i2) {
                FileEditor editor = editors2[i2];
                if (!(editor instanceof TextEditor) || !providers[i2].getEditorTypeId().equals(textProviderId)) continue;
                target2 = (TextEditor)editor;
                break;
            }
        }
        this.setSelectedEditor((FileEditor)target2);
        return target2;
    }

    public Editor getSelectedTextEditor() {
        return this.getSelectedTextEditor(false);
    }

    public Editor getSelectedTextEditor(boolean lockfree) {
        EditorWithProviderComposite selectedEditor;
        EditorWindow currentWindow;
        if (!lockfree) {
            FileEditorManagerImpl.assertDispatchThread();
        }
        EditorWindow editorWindow = currentWindow = lockfree ? this.getMainSplitters().getCurrentWindow() : this.getSplitters().getCurrentWindow();
        if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && selectedEditor.getSelectedEditor() instanceof TextEditor) {
            return ((TextEditor)selectedEditor.getSelectedEditor()).getEditor();
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(78);
        }
        for (EditorComposite editor : this.myOpenedEditors) {
            if (!editor.getFile().equals(file2)) continue;
            return true;
        }
        return false;
    }

    public VirtualFile @NotNull [] getOpenFiles() {
        LinkedHashSet<VirtualFile> files2 = new LinkedHashSet<VirtualFile>();
        for (EditorComposite composite : this.myOpenedEditors) {
            files2.add(composite.getFile());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files2);
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(79);
        }
        return virtualFileArray;
    }

    public boolean hasOpenFiles() {
        return !this.myOpenedEditors.isEmpty();
    }

    public VirtualFile @NotNull [] getSelectedFiles() {
        LinkedHashSet selectedFiles = new LinkedHashSet();
        EditorsSplitters activeSplitters = this.getSplitters();
        ContainerUtil.addAll(selectedFiles, (Object[])activeSplitters.getSelectedFiles());
        for (EditorsSplitters each : this.getAllSplitters()) {
            if (each == activeSplitters) continue;
            ContainerUtil.addAll(selectedFiles, (Object[])each.getSelectedFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(selectedFiles);
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(80);
        }
        return virtualFileArray;
    }

    public FileEditor @NotNull [] getSelectedEditors() {
        SmartHashSet selectedEditors = new SmartHashSet();
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            splitters.addSelectedEditorsTo((Collection<? super FileEditor>)selectedEditors);
        }
        FileEditor[] fileEditorArray = selectedEditors.toArray(FileEditor.EMPTY_ARRAY);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(81);
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        EditorsSplitters active = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            active = this.getActiveSplittersSync();
        }
        EditorsSplitters editorsSplitters = active == null ? this.getMainSplitters() : active;
        if (editorsSplitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(82);
        }
        return editorsSplitters;
    }

    @Nullable
    public FileEditor getSelectedEditor() {
        EditorWithProviderComposite selected2;
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (selected2 = window.getSelectedEditor()) != null) {
            return selected2.getSelectedEditor();
        }
        return super.getSelectedEditor();
    }

    @Nullable
    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        FileEditorWithProvider editorWithProvider;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(83);
        }
        return (editorWithProvider = this.getSelectedEditorWithProvider(file2)) == null ? null : editorWithProvider.getFileEditor();
    }

    @Override
    @Nullable
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(84);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file2))) != null) {
            return composite.getSelectedWithProvider();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        return composites.isEmpty() ? null : composites.get(0).getSelectedWithProvider();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(85);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite != null) {
            return new Pair((Object)composite.getEditors(), (Object)composite.getProviders());
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            return new Pair((Object)composites.get(0).getEditors(), (Object)composites.get(0).getProviders());
        }
        return new Pair((Object)FileEditor.EMPTY_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
    }

    public FileEditor @NotNull [] getEditors(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(86);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file2))) != null) {
            FileEditor[] fileEditorArray = composite.getEditors();
            if (fileEditorArray == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(87);
            }
            return fileEditorArray;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            FileEditor[] fileEditorArray = composites.get(0).getEditors();
            if (fileEditorArray == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(88);
            }
            return fileEditorArray;
        }
        if (FileEditor.EMPTY_ARRAY == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(89);
        }
        return FileEditor.EMPTY_ARRAY;
    }

    public FileEditor @NotNull [] getAllEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(90);
        }
        ArrayList result2 = new ArrayList();
        this.myOpenedEditors.forEach(composite -> {
            if (composite.getFile().equals(file2)) {
                ContainerUtil.addAll((Collection)result2, (Object[])composite.myEditors);
            }
        });
        FileEditor[] fileEditorArray = result2.toArray(FileEditor.EMPTY_ARRAY);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(91);
        }
        return fileEditorArray;
    }

    @Nullable
    private EditorWithProviderComposite getCurrentEditorWithProviderComposite(@NotNull VirtualFile virtualFile) {
        EditorWindow editorWindow;
        if (virtualFile == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(92);
        }
        if ((editorWindow = this.getSplitters().getCurrentWindow()) != null) {
            return editorWindow.findFileComposite(virtualFile);
        }
        return null;
    }

    @NotNull
    private List<EditorWithProviderComposite> getEditorComposites(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(93);
        }
        ArrayList<EditorWithProviderComposite> result2 = new ArrayList<EditorWithProviderComposite>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            result2.addAll(each.findEditorComposites(file2));
        }
        ArrayList<EditorWithProviderComposite> arrayList = result2;
        if (arrayList == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(94);
        }
        return arrayList;
    }

    public FileEditor @NotNull [] getAllEditors() {
        ArrayList result2 = new ArrayList();
        this.myOpenedEditors.forEach(composite -> ContainerUtil.addAll((Collection)result2, (Object[])composite.myEditors));
        FileEditor[] fileEditorArray = result2.toArray(FileEditor.EMPTY_ARRAY);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(95);
        }
        return fileEditorArray;
    }

    @NotNull
    public List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(96);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        List<JComponent> list2 = composite != null ? composite.getTopComponents(editor) : Collections.emptyList();
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(97);
        }
        return list2;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(98);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(99);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addTopComponent(editor, component2);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(100);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(101);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeTopComponent(editor, component2);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(102);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(103);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addBottomComponent(editor, component2);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(104);
        }
        if (component2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(105);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeBottomComponent(editor, component2);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(106);
        }
        this.myListenerList.add((Object)listener2);
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(107);
        }
        if (parentDisposable == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(108);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(109);
        }
        this.myListenerList.remove((Object)listener2);
    }

    protected void projectOpened(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(110);
        }
        this.getMainSplitters().startListeningFocus();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            fileStatusManager.addFileStatusListener((FileStatusListener)new MyFileStatusListener(), (Disposable)this.myProject);
        }
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootsListener());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyVirtualFileListener());
        connection.subscribe(UISettingsListener.TOPIC, (Object)new MyUISettingsListener());
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().invokeLater(() -> {
                Long startTime = (Long)this.myProject.getUserData(ProjectImpl.CREATION_TIME);
                if (startTime != null) {
                    long time = TimeoutUtil.getDurationMillis((long)startTime);
                    LifecycleUsageTriggerCollector.onProjectOpenFinished(this.myProject, time);
                    LOG.info("Project opening took " + time + " ms");
                }
            }, this.myProject.getDisposed()), "", null), this.myProject.getDisposed());
        });
    }

    @Nullable
    public Element getState() {
        if (this.mySplitters == null) {
            return null;
        }
        Element state = new Element("state");
        this.getMainSplitters().writeExternal(state);
        return state;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(111);
        }
        this.getMainSplitters().readExternal(state);
    }

    @Nullable
    protected EditorWithProviderComposite getEditorComposite(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(112);
        }
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            List<EditorWithProviderComposite> editorsComposites = splitters.getEditorComposites();
            for (int i2 = editorsComposites.size() - 1; i2 >= 0; --i2) {
                EditorWithProviderComposite composite = editorsComposites.get(i2);
                FileEditor[] editors2 = composite.getEditors();
                for (int j = editors2.length - 1; j >= 0; --j) {
                    FileEditor _editor = editors2[j];
                    LOG.assertTrue(_editor != null);
                    if (!editor.equals(_editor)) continue;
                    return composite;
                }
            }
        }
        return null;
    }

    private static void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    public void fireSelectionChanged(@Nullable EditorComposite newSelectedComposite) {
        Trinity<VirtualFile, FileEditor, FileEditorProvider> oldData = FileEditorManagerImpl.extract((EditorComposite)SoftReference.dereference(this.myLastSelectedComposite));
        Trinity<VirtualFile, FileEditor, FileEditorProvider> newData = FileEditorManagerImpl.extract(newSelectedComposite);
        this.myLastSelectedComposite = newSelectedComposite == null ? null : new WeakReference<EditorComposite>(newSelectedComposite);
        boolean filesEqual = Objects.equals(oldData.first, newData.first);
        boolean editorsEqual = Objects.equals(oldData.second, newData.second);
        if (!filesEqual || !editorsEqual) {
            JComponent component2;
            EditorWindowHolder holder;
            if (oldData.first != null && newData.first != null) {
                for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, (VirtualFile)oldData.first);
                    if (!Comparing.equal((Object)associatedFile, (Object)((VirtualFile)newData.first))) continue;
                    return;
                }
            }
            FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, (VirtualFile)oldData.first, (FileEditor)oldData.second, (FileEditorProvider)oldData.third, (VirtualFile)newData.first, (FileEditor)newData.second, (FileEditorProvider)newData.third);
            FileEditorManagerListener publisher = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            if (newData.first != null && (holder = (EditorWindowHolder)ComponentUtil.getParentOfType(EditorWindowHolder.class, (Component)(component2 = ((FileEditor)newData.second).getComponent()))) != null) {
                this.addSelectionRecord((VirtualFile)newData.first, holder.getEditorWindow());
            }
            this.notifyPublisher(() -> publisher.selectionChanged(event));
        }
    }

    @NotNull
    private static Trinity<VirtualFile, FileEditor, FileEditorProvider> extract(@Nullable EditorComposite composite) {
        FileEditorProvider provider2;
        FileEditor editor;
        VirtualFile file2;
        if (composite == null) {
            file2 = null;
            editor = null;
            provider2 = null;
        } else {
            file2 = composite.getFile();
            FileEditorWithProvider pair = composite.getSelectedWithProvider();
            editor = pair.getFileEditor();
            provider2 = pair.getProvider();
        }
        return new Trinity((Object)file2, (Object)editor, (Object)provider2);
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        FileStatusManager fileStatusManager;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(113);
        }
        if ((fileStatusManager = FileStatusManager.getInstance((Project)this.myProject)) == null) {
            return false;
        }
        FileStatus status = fileStatusManager.getStatus(editor.getFile());
        return status != FileStatus.UNKNOWN && status != FileStatus.NOT_CHANGED;
    }

    void disposeComposite(@NotNull EditorWithProviderComposite editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(114);
        }
        this.myOpenedEditors.remove(editor);
        if (this.getAllEditors().length == 0) {
            this.setCurrentWindow(null);
        }
        if (editor.equals(this.getLastSelected())) {
            editor.getSelectedEditor().deselectNotify();
            this.getSplitters().setCurrentWindow(null, false);
        }
        FileEditor[] editors2 = editor.getEditors();
        FileEditorProvider[] providers = editor.getProviders();
        FileEditor selectedEditor = editor.getSelectedEditor();
        for (int i2 = editors2.length - 1; i2 >= 0; --i2) {
            FileEditor editor1 = editors2[i2];
            FileEditorProvider provider2 = providers[i2];
            if (selectedEditor.equals(editor1)) {
                editor1.deselectNotify();
            }
            editor1.removePropertyChangeListener(this.myEditorPropertyChangeListener);
            provider2.disposeEditor(editor1);
        }
        Disposer.dispose((Disposable)editor);
    }

    @Nullable
    private EditorComposite getLastSelected() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            return currentWindow.getSelectedEditor();
        }
        return null;
    }

    private void runChange(@NotNull FileEditorManagerChange change, @Nullable EditorsSplitters splitters) {
        if (change == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(115);
        }
        HashSet<EditorsSplitters> target2 = new HashSet<EditorsSplitters>();
        if (splitters == null) {
            target2.addAll(this.getAllSplitters());
        } else {
            target2.add(splitters);
        }
        for (EditorsSplitters each : target2) {
            FileEditorManagerImpl.runBulkTabChange(each, change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runBulkTabChange(@NotNull EditorsSplitters splitters, @NotNull FileEditorManagerChange change) {
        if (splitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(116);
        }
        if (change == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(117);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            change.run(splitters);
        } else {
            ++splitters.myInsideChange;
            try {
                change.run(splitters);
            }
            finally {
                --splitters.myInsideChange;
                if (!splitters.isInsideChange()) {
                    splitters.validate();
                    for (EditorWindow window : splitters.getWindows()) {
                        ((JBTabsImpl)window.getTabbedPane().getTabs()).revalidateAndRepaint();
                    }
                }
            }
        }
    }

    @Override
    public boolean isInsideChange() {
        return this.getSplitters().isInsideChange();
    }

    @Override
    public void closeAllFiles() {
        FileEditorManagerImpl.runBulkTabChange(this.getSplitters(), splitters -> {
            for (VirtualFile openFile2 : splitters.getOpenFileList()) {
                this.closeFile(openFile2);
            }
        });
    }

    @Override
    public VirtualFile @NotNull [] getSiblings(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(118);
        }
        VirtualFile[] virtualFileArray = this.getOpenFiles();
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(119);
        }
        return virtualFileArray;
    }

    void queueUpdateFile(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(120);
        }
        this.myQueue.queue(new Update(file2){

            public void run() {
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileColor(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                    FileEditorManagerImpl.this.resetPreviewFlag(file2);
                }
            }
        });
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        EditorsSplitters splitters = null;
        DockContainer dockContainer = this.myDockManager.getContainerFor(c);
        if (dockContainer instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)dockContainer).getSplitters();
        }
        if (splitters == null) {
            splitters = this.getMainSplitters();
        }
        return splitters;
    }

    @NotNull
    public List<Pair<VirtualFile, EditorWindow>> getSelectionHistory() {
        ArrayList<Object> copy2 = new ArrayList<Object>();
        for (Pair<VirtualFile, EditorWindow> pair : this.mySelectionHistory) {
            if (((EditorWindow)pair.second).getFiles().length == 0) {
                Pair p;
                EditorWindow[] windows = ((EditorWindow)pair.second).getOwner().getWindows();
                if (windows.length <= 0 || windows[0] == null || windows[0].getFiles().length <= 0 || copy2.contains(p = Pair.create((Object)((VirtualFile)pair.first), (Object)windows[0]))) continue;
                copy2.add(p);
                continue;
            }
            if (copy2.contains(pair)) continue;
            copy2.add(pair);
        }
        this.mySelectionHistory.clear();
        this.mySelectionHistory.addAll(copy2);
        List<Pair<VirtualFile, EditorWindow>> list2 = this.mySelectionHistory;
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(121);
        }
        return list2;
    }

    public void addSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(122);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(123);
        }
        Pair record = Pair.create((Object)file2, (Object)window);
        this.mySelectionHistory.remove(record);
        this.mySelectionHistory.add(0, (Pair<VirtualFile, EditorWindow>)record);
    }

    void removeSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(124);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(125);
        }
        this.mySelectionHistory.remove(Pair.create((Object)file2, (Object)window));
        this.updateFileName(file2);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(126);
        }
        ActionCallback actionCallback = this.myBusyObject.getReady(requestor);
        if (actionCallback == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(127);
        }
        return actionCallback;
    }

    private /* synthetic */ void lambda$openEditorImpl$21(FileEditorNavigatable realDescriptor, boolean focusEditor, List result2, Ref selectedEditor) {
        VirtualFile file2 = realDescriptor.getFile();
        Object[] editors2 = this.openFile(file2, focusEditor, !realDescriptor.isUseCurrentWindow());
        ContainerUtil.addAll((Collection)result2, (Object[])editors2);
        boolean navigated = false;
        for (Object editor : editors2) {
            if (!(editor instanceof NavigatableFileEditor) || this.getSelectedEditor(realDescriptor.getFile()) != editor || !(navigated = this.navigateAndSelectEditor((NavigatableFileEditor)editor, (Navigatable)realDescriptor))) continue;
            selectedEditor.set(editor);
            break;
        }
        if (!navigated) {
            for (Object editor : editors2) {
                if (!(editor instanceof NavigatableFileEditor) || this.getSelectedEditor(realDescriptor.getFile()) == editor || !this.navigateAndSelectEditor((NavigatableFileEditor)editor, (Navigatable)realDescriptor)) continue;
                selectedEditor.set(editor);
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 66: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 119: 
            case 121: 
            case 127: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 66: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 119: 
            case 121: 
            case 127: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: 
            case 64: 
            case 72: 
            case 74: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 112: 
            case 113: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 66: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 119: 
            case 121: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 42: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 67: 
            case 78: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 90: 
            case 93: 
            case 118: 
            case 120: 
            case 122: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 43: 
            case 45: 
            case 48: 
            case 51: 
            case 55: 
            case 123: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 41: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitters";
                break;
            }
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeRef";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorProviderId";
                break;
            }
            case 69: 
            case 71: 
            case 73: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 99: 
            case 101: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 106: 
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 115: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSplitters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSplittersAsync";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initUI";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileColor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTooltipText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindows";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileWithProviders";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenMode";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl2";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl3";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl4";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyPublisher";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileEditor";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitters";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 91: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComposites";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponents";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblings";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionHistory";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDumbAware";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 66: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 119: 
            case 121: 
            case 127: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isProblem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileTooltipText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateFilePresentation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateFileColor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateFileBackgroundColor";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIcon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resetPreviewFlag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNextWindow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPrevWindow";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "closeFileImpl";
                break;
            }
            case 30: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "openFileWithProviders";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "openFileInNewWindow";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "openInRightSplit";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getOpenMode";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "openAssociatedFile";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl2";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl3";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl4";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl4Edt";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "restoreEditorState";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "notifyPublisher";
                break;
            }
            case 67: 
            case 68: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "openFileEditor";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "openEditorImpl";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndSelectEditor";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "openTextEditor";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "doOpenTextEditor";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditor";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorWithProvider";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsWithProviders";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getAllEditors";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEditorWithProviderComposite";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getEditorComposites";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getTopComponents";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "addTopComponent";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "removeTopComponent";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "addBottomComponent";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "removeBottomComponent";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "addFileEditorManagerListener";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "removeFileEditorManagerListener";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "projectOpened";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getEditorComposite";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "disposeComposite";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "runChange";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "runBulkTabChange";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getSiblings";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateFile";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionRecord";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionRecord";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 66: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 94: 
            case 95: 
            case 97: 
            case 119: 
            case 121: 
            case 127: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                MyUISettingsListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            FileEditorManagerImpl.this.mySplitters.revalidate();
            for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                each.setTabsPlacement(uiSettings.getEditorTabPlacement());
                each.trimToSize();
                if (JBTabsImpl.NEW_TABS) {
                    TabsLayoutInfo tabsLayoutInfo = TabsLayoutSettingsManager.getInstance().getSelectedTabsLayoutInfo();
                    each.updateTabsLayout(tabsLayoutInfo);
                    continue;
                }
                if (uiSettings.getScrollTabLayoutInEditor()) {
                    each.setTabLayoutPolicy(1);
                    continue;
                }
                each.setTabLayoutPolicy(0);
            }
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                FileEditorManagerImpl.this.updateFileIcon(file2);
                FileEditorManagerImpl.this.updateFileName(file2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
            }
            FileEditorManagerImpl.this.updateFrameTitle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyUISettingsListener", "uiSettingsChanged"));
        }
    }

    private class MyRootsListener
    implements ModuleRootListener {
        private MyRootsListener() {
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyRootsListener.$$$reportNull$$$0(0);
            }
            ((AppUIExecutor)AppUIExecutor.onUiThread((ModalityState)ModalityState.any()).expireWith((Disposable)FileEditorManagerImpl.this.myProject)).submit(() -> StreamEx.of((Object[])FileEditorManagerImpl.this.getWindows()).flatArray(EditorWindow::getEditors).toList()).onSuccess(allEditors -> ReadAction.nonBlocking(() -> this.calcEditorReplacements((List<EditorWithProviderComposite>)allEditors)).inSmartMode(FileEditorManagerImpl.this.myProject).finishOnUiThread(ModalityState.defaultModalityState(), this::replaceEditors).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        }

        private Map<EditorWithProviderComposite, Pair<VirtualFile, Integer>> calcEditorReplacements(List<EditorWithProviderComposite> allEditors) {
            List swappers = EditorFileSwapper.EP_NAME.getExtensionList();
            return StreamEx.of(allEditors).mapToEntry(editor -> {
                if (editor.getFile().isValid()) {
                    for (EditorFileSwapper each : swappers) {
                        Pair<VirtualFile, Integer> fileAndOffset = each.getFileToSwapTo(FileEditorManagerImpl.this.myProject, (EditorWithProviderComposite)editor);
                        if (fileAndOffset == null) continue;
                        return fileAndOffset;
                    }
                }
                return null;
            }).nonNullValues().toMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceEditors(Map<EditorWithProviderComposite, Pair<VirtualFile, Integer>> replacements) {
            if (replacements.isEmpty()) {
                return;
            }
            for (EditorWindow eachWindow : FileEditorManagerImpl.this.getWindows()) {
                EditorWithProviderComposite selected2 = eachWindow.getSelectedEditor();
                EditorWithProviderComposite[] editors2 = eachWindow.getEditors();
                for (int i2 = 0; i2 < editors2.length; ++i2) {
                    VirtualFile newFile;
                    Pair<VirtualFile, Integer> newFilePair;
                    EditorWithProviderComposite editor = editors2[i2];
                    VirtualFile file2 = editor.getFile();
                    if (!file2.isValid() || (newFilePair = replacements.get(editor)) == null || (newFile = (VirtualFile)newFilePair.first) == null || eachWindow.findFileIndex(newFile) != -1) continue;
                    try {
                        TextEditorImpl openedEditor;
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)i2);
                        Pair<FileEditor[], FileEditorProvider[]> pair = FileEditorManagerImpl.this.openFileImpl2(eachWindow, newFile, editor == selected2);
                        if (newFilePair.second != null && (openedEditor = EditorFileSwapper.findSinglePsiAwareEditor((FileEditor[])pair.first)) != null) {
                            openedEditor.getEditor().getCaretModel().moveToOffset(((Integer)newFilePair.second).intValue());
                            openedEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                        }
                    }
                    finally {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, null);
                    }
                    FileEditorManagerImpl.this.closeFile(file2, eachWindow);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyRootsListener", "rootsChanged"));
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                LOG.assertTrue(file2 != null);
                FileEditorManagerImpl.this.updateFileIcon(file2, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileTypeListener", "fileTypesChanged"));
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FileEditorManagerImpl.assertDispatchThread();
            LOG.debug("FileEditorManagerImpl.MyFileStatusListener.fileStatusesChanged()");
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                LOG.assertTrue(file2 != null);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("updating file status in tab for " + file2.getPath());
                    }
                    this.updateFileStatus(file2);
                }, ModalityState.NON_MODAL, FileEditorManagerImpl.this.myProject.getDisposed());
            }
        }

        public void fileStatusChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyFileStatusListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                this.updateFileStatus(file2);
            }
        }

        private void updateFileStatus(VirtualFile file2) {
            FileEditorManagerImpl.this.updateFileColor(file2);
            FileEditorManagerImpl.this.updateFileIcon(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileStatusListener", "fileStatusChanged"));
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            boolean valid;
            if (e == null) {
                MyEditorPropertyChangeListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            String propertyName = e.getPropertyName();
            if ("modified".equals(propertyName)) {
                FileEditor editor = (FileEditor)e.getSource();
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.updateFileIcon(composite.getFile());
                }
            } else if ("valid".equals(propertyName) && !(valid = ((Boolean)e.getNewValue()).booleanValue())) {
                FileEditor editor = (FileEditor)e.getSource();
                LOG.assertTrue(editor != null);
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.closeFile(composite.getFile());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyEditorPropertyChangeListener", "propertyChange"));
        }
    }

    private final class MyVirtualFileListener
    implements BulkFileListener {
        private MyVirtualFileListener() {
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                this.beforeFileDeletion((VFileDeleteEvent)vFileEvent);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    this.propertyChanged((VFilePropertyChangeEvent)vFileEvent);
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                this.fileMoved((VFileMoveEvent)vFileEvent);
            }
        }

        private void beforeFileDeletion(@NotNull VFileDeleteEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(2);
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = event.getFile();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFiles[i2], (boolean)false)) continue;
                FileEditorManagerImpl.this.closeFile(openFiles[i2], true, true);
            }
        }

        private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(3);
            }
            if ("name".equals(event.getPropertyName())) {
                FileEditorManagerImpl.assertDispatchThread();
                VirtualFile file2 = event.getFile();
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileName(file2);
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            } else if ("writable".equals(event.getPropertyName()) || "encoding".equals(event.getPropertyName())) {
                this.updateIcon(event);
            }
        }

        private void updateIcon(@NotNull VFilePropertyChangeEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(4);
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = event.getFile();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                FileEditorManagerImpl.this.updateFileIcon(file2);
            }
        }

        private void fileMoved(@NotNull VFileMoveEvent e) {
            if (e == null) {
                MyVirtualFileListener.$$$reportNull$$$0(5);
            }
            VirtualFile file2 = e.getFile();
            for (VirtualFile openFile2 : FileEditorManagerImpl.this.getOpenFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFile2, (boolean)false)) continue;
                FileEditorManagerImpl.this.updateFileName(openFile2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(openFile2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum OpenMode {
        NEW_WINDOW,
        RIGHT_SPLIT,
        DEFAULT;

    }
}

