/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.editor.actions.CaretStopBoundary;
import com.intellij.openapi.editor.actions.CaretStopOptions;
import com.intellij.openapi.editor.actions.CaretStopOptionsTransposed;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tabs.FileColorManagerImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class EditorSettingsStatisticsCollector
extends ApplicationUsagesCollector {
    EditorSettingsStatisticsCollector() {
    }

    @NotNull
    public String getGroupId() {
        return "editor.settings.ide";
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> set2 = new HashSet<MetricEvent>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsExternalizable esDefault = new EditorSettingsExternalizable(new EditorSettingsExternalizable.OsSpecificState());
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isVirtualSpace(), (String)"caretAfterLineEnd");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isCaretInsideTabs(), (String)"caretInsideTabs");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isAdditionalPageAtBottom(), (String)"virtualSpaceAtFileBottom");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), (String)"softWraps");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), (String)"softWraps.console");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), (String)"softWraps.preview");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isUseCustomSoftWrapIndent(), (String)"softWraps.relativeIndent");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isAllSoftWrapsShown(), (String)"softWraps.showAll");
        MetricEventUtilKt.addIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.getStripTrailingSpaces(), (String)"stripTrailingSpaces");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isEnsureNewLineAtEOF(), (String)"ensureNewlineAtEOF");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isShowQuickDocOnMouseOverElement(), (String)"quickDocOnMouseHover");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isBlinkCaret(), (String)"blinkingCaret");
        MetricEventUtilKt.addIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.getBlinkPeriod(), (String)"blinkPeriod");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isBlockCursor(), (String)"blockCaret");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isRightMarginShown(), (String)"rightMargin");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isLineNumbersShown(), (String)"lineNumbers");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.areGutterIconsShown(), (String)"gutterIcons");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isFoldingOutlineShown(), (String)"foldingOutline");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isWhitespacesShown() && s.isLeadingWhitespacesShown(), (String)"showLeadingWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isWhitespacesShown() && s.isInnerWhitespacesShown(), (String)"showInnerWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isWhitespacesShown() && s.isTrailingWhitespacesShown(), (String)"showTrailingWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isIndentGuidesShown(), (String)"indentGuides");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isSmoothScrolling(), (String)"animatedScroll");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isDndEnabled(), (String)"dragNDrop");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isWheelFontChangeEnabled(), (String)"wheelZoom");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isMouseClickSelectionHonorsCamelWords(), (String)"mouseCamel");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isVariableInplaceRenameEnabled(), (String)"inplaceRename");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isPreselectRename(), (String)"preselectOnRename");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isShowInlineLocalDialog(), (String)"inlineDialog");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isRefrainFromScrolling(), (String)"minimizeScrolling");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isShowNotificationAfterReformat(), (String)"afterReformatNotification");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isShowNotificationAfterOptimizeImports(), (String)"afterOptimizeNotification");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isSmartHome(), (String)"smartHome");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isCamelWords(), (String)"camelWords");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isShowParameterNameHints(), (String)"editor.inlay.parameter.hints");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isBreadcrumbsAbove(), (String)"breadcrumbsAbove");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isBreadcrumbsShown(), (String)"all.breadcrumbs");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isShowIntentionBulb(), (String)"intentionBulb");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isDocCommentRenderingEnabled(), (String)"renderDoc");
        for (String language : es.getOptions().getLanguageBreadcrumbsMap().keySet()) {
            FeatureUsageData data2 = new FeatureUsageData().addLanguage(language);
            MetricEventUtilKt.addBoolIfDiffers(set2, (Object)es, (Object)esDefault, s -> s.isBreadcrumbsShownFor(language), (String)"breadcrumbs", (FeatureUsageData)data2);
        }
        RichCopySettings rcs = RichCopySettings.getInstance();
        RichCopySettings rcsDefault = new RichCopySettings();
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)rcs, (Object)rcsDefault, s -> s.isEnabled(), (String)"richCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        CodeInsightSettings cisDefault = new CodeInsightSettings();
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.AUTO_POPUP_PARAMETER_INFO, (String)"parameterAutoPopup");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.AUTO_POPUP_JAVADOC_INFO, (String)"javadocAutoPopup");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.AUTO_POPUP_COMPLETION_LOOKUP, (String)"completionAutoPopup");
        MetricEventUtilKt.addIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.COMPLETION_CASE_SENSITIVE, (String)"completionCaseSensitivity");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.isSelectAutopopupSuggestionsByChars(), (String)"autoPopupCharComplete");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.AUTOCOMPLETE_ON_CODE_COMPLETION, (String)"autoCompleteBasic");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, (String)"autoCompleteSmart");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, (String)"parameterInfoFullSignature");
        MetricEventUtilKt.addIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.getBackspaceMode(), (String)"smartBackspace");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.SMART_INDENT_ON_ENTER, (String)"indentOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.INSERT_BRACE_ON_ENTER, (String)"braceOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.JAVADOC_STUB_ON_ENTER, (String)"javadocOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.INSERT_SCRIPTLET_END_ON_ENTER, (String)"scriptletEndOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.SMART_END_ACTION, (String)"smartEnd");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.JAVADOC_GENERATE_CLOSING_TAG, (String)"autoCloseJavadocTags");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.SURROUND_SELECTION_ON_QUOTE_TYPED, (String)"surroundByQuoteOrBrace");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.AUTOINSERT_PAIR_BRACKET, (String)"pairBracketAutoInsert");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.AUTOINSERT_PAIR_QUOTE, (String)"pairQuoteAutoInsert");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.REFORMAT_BLOCK_ON_RBRACE, (String)"reformatOnRBrace");
        MetricEventUtilKt.addIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.REFORMAT_ON_PASTE, (String)"reformatOnPaste");
        MetricEventUtilKt.addIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.ADD_IMPORTS_ON_PASTE, (String)"importsOnPaste");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.HIGHLIGHT_BRACES, (String)"bracesHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.HIGHLIGHT_SCOPE, (String)"scopeHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.HIGHLIGHT_IDENTIFIER_UNDER_CARET, (String)"identifierUnderCaretHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, (String)"autoAddImports");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION, (String)"completionHints");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.SHOW_EXTERNAL_ANNOTATIONS_INLINE, (String)"externalAnnotationsInline");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.SHOW_INFERRED_ANNOTATIONS_INLINE, (String)"inferredAnnotationsInline");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)cis, (Object)cisDefault, s -> s.TAB_EXITS_BRACKETS_AND_QUOTES, (String)"tabExitsBracketsAndQuotes");
        EditorSettingsStatisticsCollector.addTooltipActionsMetricIfDiffers(set2);
        DaemonCodeAnalyzerSettings dcas = DaemonCodeAnalyzerSettings.getInstance();
        DaemonCodeAnalyzerSettings dcasDefault = new DaemonCodeAnalyzerSettings();
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)dcas, (Object)dcasDefault, s -> s.isNextErrorActionGoesToErrorsFirst(), (String)"nextErrorActionGoesToErrorsFirst");
        MetricEventUtilKt.addIfDiffers(set2, (Object)dcas, (Object)dcasDefault, s -> s.getAutoReparseDelay(), (String)"autoReparseDelay");
        MetricEventUtilKt.addIfDiffers(set2, (Object)dcas, (Object)dcasDefault, s -> s.getErrorStripeMarkMinHeight(), (String)"errorStripeMarkMinHeight");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)dcas, (Object)dcasDefault, s -> s.isSuppressWarnings(), (String)"suppressWarnings");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)dcas, (Object)dcasDefault, s -> s.isImportHintEnabled(), (String)"importHintEnabled");
        MetricEventUtilKt.addBoolIfDiffers(set2, (Object)dcas, (Object)dcasDefault, s -> s.SHOW_METHOD_SEPARATORS, (String)"showMethodSeparators");
        CaretStopOptionsTransposed defaultCaretStop = CaretStopOptionsTransposed.fromCaretStopOptions(new CaretStopOptions());
        CaretStopOptionsTransposed caretStop = CaretStopOptionsTransposed.fromCaretStopOptions(es.getCaretStopOptions());
        MetricEventUtilKt.addIfDiffers(set2, (Object)caretStop.getLineBoundary(), (Object)defaultCaretStop.getLineBoundary(), s -> EditorSettingsStatisticsCollector.toCaretStopValue(s), (String)"caret.movement.line");
        MetricEventUtilKt.addIfDiffers(set2, (Object)caretStop.getWordBoundary(), (Object)defaultCaretStop.getWordBoundary(), s -> EditorSettingsStatisticsCollector.toCaretStopValue(s), (String)"caret.movement.word");
        if (!FileColorManagerImpl._isEnabled()) {
            set2.add(MetricEventFactoryKt.newBooleanMetric((String)"fileColorsEnabled", (boolean)false));
        }
        if (!FileColorManagerImpl._isEnabledForProjectView()) {
            set2.add(MetricEventFactoryKt.newBooleanMetric((String)"fileColorsEnabledForProjectView", (boolean)false));
        }
        if (!FileColorManagerImpl._isEnabledForTabs()) {
            set2.add(MetricEventFactoryKt.newBooleanMetric((String)"fileColorsEnabledForTabs", (boolean)false));
        }
        HashSet<MetricEvent> hashSet = set2;
        if (hashSet == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    private static String toCaretStopValue(@NotNull CaretStopBoundary boundary) {
        if (boundary == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(1);
        }
        if (boundary.equals(CaretStopBoundary.NONE)) {
            return "NONE";
        }
        if (boundary.equals(CaretStopBoundary.CURRENT)) {
            return "CURRENT";
        }
        if (boundary.equals(CaretStopBoundary.NEIGHBOR)) {
            return "NEIGHBOR";
        }
        if (boundary.equals(CaretStopBoundary.START)) {
            return "START";
        }
        if (boundary.equals(CaretStopBoundary.END)) {
            return "END";
        }
        if (boundary.equals(CaretStopBoundary.BOTH)) {
            return "BOTH";
        }
        return "OTHER";
    }

    private static void addTooltipActionsMetricIfDiffers(@NotNull Set<MetricEvent> set2) {
        boolean value2;
        if (set2 == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (!(value2 = TooltipActionProvider.isShowActions())) {
            set2.add(MetricEventFactoryKt.newBooleanMetric((String)"show.actions.in.tooltip", (boolean)value2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toCaretStopValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTooltipActionsMetricIfDiffers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProjectUsages
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            return "editor.settings.project";
        }

        public int getVersion() {
            return 2;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectUsages.$$$reportNull$$$0(0);
            }
            HashSet<MetricEvent> set2 = new HashSet<MetricEvent>();
            CodeInsightWorkspaceSettings ciws = CodeInsightWorkspaceSettings.getInstance(project);
            CodeInsightWorkspaceSettings ciwsDefault = new CodeInsightWorkspaceSettings();
            MetricEventUtilKt.addBoolIfDiffers(set2, (Object)((Object)ciws), (Object)((Object)ciwsDefault), s -> s.isOptimizeImportsOnTheFly(), (String)"autoOptimizeImports");
            HashSet<MetricEvent> hashSet = set2;
            if (hashSet == null) {
                ProjectUsages.$$$reportNull$$$0(1);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

