/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class DumpExtensionsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpExtensionsAction.$$$reportNull$$$0(0);
        }
        ArrayList<ExtensionsArea> areas = new ArrayList<ExtensionsArea>();
        areas.add(ApplicationManager.getApplication().getExtensionArea());
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            areas.add(project.getExtensionArea());
            Module[] modules2 = ModuleManager.getInstance((Project)project).getModules();
            if (modules2.length > 0) {
                areas.add(modules2[0].getExtensionArea());
            }
        }
        System.out.print(areas.size() + " extension areas: ");
        for (ExtensionsArea extensionsArea : areas) {
            System.out.print(extensionsArea.toString() + " ");
        }
        System.out.println("\n");
        ArrayList points = new ArrayList();
        for (ExtensionsArea area : areas) {
            points.addAll(area.getExtensionPoints());
        }
        System.out.println(points.size() + " extension points: ");
        for (ExtensionPoint point : points) {
            System.out.println(" " + ((ExtensionPointImpl)point).getName());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ExtensionPoint extensionPoint : points) {
            arrayList.addAll(Arrays.asList(extensionPoint.getExtensions()));
        }
        System.out.println("\n" + arrayList.size() + " extensions:");
        for (Object e2 : arrayList) {
            if (e2 instanceof Configurable) {
                System.out.println("!!!! Configurable extension found. Kill it !!!");
            }
            System.out.println(e2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/DumpExtensionsAction", "actionPerformed"));
    }
}

