/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Cursor;
import javax.swing.Icon;
import javax.swing.JLabel;

final class IdeErrorsIcon
extends JLabel {
    private final boolean myEnableBlink;

    IdeErrorsIcon(boolean enableBlink) {
        this.myEnableBlink = enableBlink;
    }

    void setState(MessagePool.State state) {
        Icon myUnreadIcon;
        Icon icon2 = myUnreadIcon = !this.myEnableBlink ? AllIcons.Ide.FatalError : new AnimatedIcon.Blinking(AllIcons.Ide.FatalError);
        if (state != null && state != MessagePool.State.NoErrors) {
            this.setIcon(state == MessagePool.State.ReadErrors ? AllIcons.Ide.FatalErrorRead : myUnreadIcon);
            this.setToolTipText(DiagnosticBundle.message("error.notification.tooltip", new Object[0]));
            if (!this.myEnableBlink) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else {
            this.setIcon(EmptyIcon.ICON_16);
            this.setToolTipText(null);
            if (!this.myEnableBlink) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

