/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyEditor {
    private final EventListenerList myListenerList = new EventListenerList();

    @NotNull
    public abstract JComponent getComponent(@Nullable PropertiesContainer var1, @Nullable PropertyContext var2, Object var3, @Nullable InplaceContext var4);

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public void activate() {
    }

    @Nullable
    public abstract Object getValue() throws Exception;

    public abstract void updateUI();

    public final void addPropertyEditorListener(PropertyEditorListener listener2) {
        this.myListenerList.add(PropertyEditorListener.class, listener2);
    }

    public final void removePropertyEditorListener(PropertyEditorListener listener2) {
        this.myListenerList.remove(PropertyEditorListener.class, listener2);
    }

    public final void fireEditingCancelled() {
        for (PropertyEditorListener listener2 : (PropertyEditorListener[])this.myListenerList.getListeners(PropertyEditorListener.class)) {
            listener2.editingCanceled(this);
        }
    }

    public final void fireValueCommitted(boolean continueEditing, boolean closeEditorOnError) {
        for (PropertyEditorListener listener2 : (PropertyEditorListener[])this.myListenerList.getListeners(PropertyEditorListener.class)) {
            listener2.valueCommitted(this, continueEditing, closeEditorOnError);
        }
    }

    protected final void preferredSizeChanged() {
        for (PropertyEditorListener listener2 : (PropertyEditorListener[])this.myListenerList.getListeners(PropertyEditorListener.class)) {
            listener2.preferredSizeChanged(this);
        }
    }
}

