/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionElementsMergerBase;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.NewInspectionProfile;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InspectionProfileImpl
extends NewInspectionProfile {
    @NonNls
    static final String INSPECTION_TOOL_TAG = "inspection_tool";
    @NonNls
    static final String CLASS_TAG = "class";
    protected static final Logger LOG = Logger.getInstance(InspectionProfileImpl.class);
    @NonNls
    private static final String VALID_VERSION = "1.0";
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String USED_LEVELS = "used_levels";
    @TestOnly
    public static boolean INIT_INSPECTIONS;
    @NotNull
    protected final InspectionToolsSupplier myToolSupplier;
    protected final Map<String, Element> myUninitializedSettings;
    protected Map<String, ToolsImpl> myTools;
    protected volatile Set<String> myChangedToolNames;
    @Attribute(value="is_locked")
    protected boolean myLockedProfile;
    protected final InspectionProfileImpl myBaseProfile;
    private volatile String myToolShortName;
    private String[] myScopesOrder;
    private @NlsContexts.DetailedDescription String myDescription;
    private SchemeDataHolder<? super InspectionProfileImpl> myDataHolder;

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolsSupplier toolSupplier, @NotNull BaseInspectionProfileManager profileManager) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(0);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(1);
        }
        if (profileManager == null) {
            InspectionProfileImpl.$$$reportNull$$$0(2);
        }
        this(profileName, toolSupplier, profileManager, InspectionProfileKt.getBASE_PROFILE(), null);
    }

    public InspectionProfileImpl(@NotNull String profileName) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(3);
        }
        this(profileName, InspectionToolRegistrar.getInstance(), (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), null, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolsSupplier toolSupplier, @Nullable InspectionProfileImpl baseProfile) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(4);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(5);
        }
        this(profileName, toolSupplier, (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), baseProfile, null);
    }

    protected InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolsSupplier toolSupplier, @NotNull BaseInspectionProfileManager profileManager, @Nullable InspectionProfileImpl baseProfile, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(6);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(7);
        }
        if (profileManager == null) {
            InspectionProfileImpl.$$$reportNull$$$0(8);
        }
        super(profileName, profileManager);
        this.myUninitializedSettings = new TreeMap<String, Element>();
        this.myTools = new THashMap();
        this.myToolSupplier = toolSupplier;
        this.myBaseProfile = baseProfile;
        this.myDataHolder = dataHolder;
        if (dataHolder != null) {
            this.schemeState = SchemeState.UNCHANGED;
        }
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolsSupplier toolSupplier, @NotNull BaseInspectionProfileManager profileManager, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(9);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(10);
        }
        if (profileManager == null) {
            InspectionProfileImpl.$$$reportNull$$$0(11);
        }
        this(profileName, toolSupplier, profileManager, InspectionProfileKt.getBASE_PROFILE(), dataHolder);
    }

    private static boolean toolSettingsAreEqual(@NotNull String toolName, @NotNull InspectionProfileImpl profile1, @NotNull InspectionProfileImpl profile2) {
        if (toolName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(12);
        }
        if (profile1 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(13);
        }
        if (profile2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(14);
        }
        Tools toolList1 = profile1.myTools.get(toolName);
        Tools toolList2 = profile2.myTools.get(toolName);
        return Comparing.equal((Object)toolList1, (Object)toolList2);
    }

    @NotNull
    protected static InspectionToolWrapper<?, ?> copyToolSettings(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(15);
        }
        InspectionToolWrapper inspectionTool = toolWrapper.createCopy();
        if (toolWrapper.isInitialized()) {
            Element config2 = new Element("config");
            ScopeToolState.tryWriteSettings((InspectionProfileEntry)toolWrapper.getTool(), (Element)config2);
            ScopeToolState.tryReadSettings((InspectionProfileEntry)inspectionTool.getTool(), (Element)config2);
        }
        InspectionToolWrapper inspectionToolWrapper = inspectionTool;
        if (inspectionToolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(16);
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element2) {
        HighlightDisplayLevel level;
        if (inspectionToolKey == null) {
            InspectionProfileImpl.$$$reportNull$$$0(17);
        }
        Project project = element2 == null ? null : element2.getProject();
        ToolsImpl tools = this.getToolsOrNull(inspectionToolKey.toString(), project);
        HighlightDisplayLevel highlightDisplayLevel = level = tools != null ? tools.getLevel(element2) : HighlightDisplayLevel.WARNING;
        if (!this.getProfileManager().getSeverityRegistrar().isSeverityValid(level.getSeverity().getName())) {
            level = HighlightDisplayLevel.WARNING;
            this.setErrorLevel(inspectionToolKey, level, project);
        }
        HighlightDisplayLevel highlightDisplayLevel2 = level;
        if (highlightDisplayLevel2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(18);
        }
        return highlightDisplayLevel2;
    }

    @Override
    public void readExternal(@NotNull Element element2) {
        String version2;
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(19);
        }
        this.mySerializer.readExternal((Object)this, element2);
        Element highlightElement = element2.getChild(USED_LEVELS);
        if (highlightElement != null) {
            this.getProfileManager().getSeverityRegistrar().readExternal(highlightElement);
        }
        if (!VALID_VERSION.equals(version2 = element2.getAttributeValue(VERSION_TAG))) {
            List<InspectionToolWrapper<?, ?>> tools = this.getInspectionTools(null);
            for (Element toolElement : element2.getChildren(INSPECTION_TOOL_TAG)) {
                String toolClassName = toolElement.getAttributeValue(CLASS_TAG);
                String shortName = InspectionProfileImpl.convertToShortName(toolClassName, tools);
                if (shortName == null) continue;
                toolElement.setAttribute(CLASS_TAG, shortName);
                this.myUninitializedSettings.put(shortName, JDOMUtil.internElement((Element)toolElement));
            }
        } else {
            for (Element toolElement : element2.getChildren(INSPECTION_TOOL_TAG)) {
                this.myUninitializedSettings.put(toolElement.getAttributeValue(CLASS_TAG), JDOMUtil.internElement((Element)toolElement));
            }
        }
    }

    @Nullable
    private static String convertToShortName(@Nullable String displayName, @NotNull List<InspectionToolWrapper<?, ?>> tools) {
        if (tools == null) {
            InspectionProfileImpl.$$$reportNull$$$0(20);
        }
        if (displayName == null) {
            return null;
        }
        for (InspectionToolWrapper<?, ?> tool : tools) {
            if (!displayName.equals(tool.getDisplayName())) continue;
            return tool.getShortName();
        }
        return null;
    }

    @NotNull
    public Set<HighlightSeverity> getUsedSeverities() {
        LOG.assertTrue(this.wasInitialized());
        THashSet result2 = new THashSet();
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                result2.add(state.getLevel().getSeverity());
            }
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            InspectionProfileImpl.$$$reportNull$$$0(21);
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        if (this.myDataHolder != null) {
            Element element2 = this.myDataHolder.read();
            if (element2 == null) {
                InspectionProfileImpl.$$$reportNull$$$0(22);
            }
            return element2;
        }
        Element element3 = new Element("profile");
        this.writeExternal(element3);
        if (this.isProjectLevel()) {
            element3.setAttribute(VERSION_TAG, VALID_VERSION);
        }
        if (this.isProjectLevel() && ProjectKt.isDirectoryBased(((ProjectInspectionProfileManager)this.getProfileManager()).getProject())) {
            Element element4 = new Element("component").setAttribute("name", "InspectionProjectProfileManager").addContent(element3);
            if (element4 == null) {
                InspectionProfileImpl.$$$reportNull$$$0(23);
            }
            return element4;
        }
        this.schemeState = SchemeState.UNCHANGED;
        Element element5 = element3;
        if (element5 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(24);
        }
        return element5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(25);
        }
        InspectionProfileImpl.writeVersion(element2);
        this.mySerializer.writeExternal((Object)this, element2);
        Object object = this.myLock;
        synchronized (object) {
            if (!this.wasInitialized()) {
                for (Element el : this.myUninitializedSettings.values()) {
                    element2.addContent(el.clone());
                }
                return;
            }
        }
        Set<String> changedToolNames = this.getChangedToolNames();
        if (changedToolNames == null) {
            return;
        }
        ArrayList<String> allToolNames = new ArrayList<String>(this.myTools.keySet());
        allToolNames.addAll(this.myUninitializedSettings.keySet());
        allToolNames.sort(null);
        for (String toolName : allToolNames) {
            Element toolElement = this.myUninitializedSettings.get(toolName);
            if (toolElement != null) {
                element2.addContent(toolElement.clone());
                continue;
            }
            if (!this.myLockedProfile && !changedToolNames.contains(toolName)) {
                this.markSettingsMerged(toolName, element2);
                continue;
            }
            ToolsImpl toolList = this.myTools.get(toolName);
            LOG.assertTrue(toolList != null);
            Element inspectionElement = new Element(INSPECTION_TOOL_TAG);
            inspectionElement.setAttribute(CLASS_TAG, toolName);
            try {
                toolList.writeExternal(inspectionElement);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (this.areSettingsMerged(toolName, inspectionElement)) continue;
            element2.addContent(inspectionElement);
        }
        this.getPathMacroManager().collapsePaths(element2);
    }

    protected static void writeVersion(@NotNull Element element2) {
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(26);
        }
        element2.setAttribute(VERSION_TAG, VALID_VERSION);
    }

    private void markSettingsMerged(@NotNull String toolName, @NotNull Element element2) {
        InspectionElementsMergerBase merger;
        String mergedName;
        if (toolName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(27);
        }
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(28);
        }
        if (!this.myUninitializedSettings.containsKey(mergedName = InspectionElementsMergerBase.getMergedMarkerName(toolName)) && (merger = InspectionProfileImpl.getMerger(toolName)) != null && merger.markSettingsMerged(this.myUninitializedSettings)) {
            element2.addContent(new Element(INSPECTION_TOOL_TAG).setAttribute(CLASS_TAG, mergedName));
        }
    }

    private boolean areSettingsMerged(@NotNull String toolName, @NotNull Element inspectionElement) {
        InspectionElementsMergerBase merger;
        if (toolName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(29);
        }
        if (inspectionElement == null) {
            InspectionProfileImpl.$$$reportNull$$$0(30);
        }
        return (merger = InspectionProfileImpl.getMerger(toolName)) != null && merger.areSettingsMerged(this.myUninitializedSettings, inspectionElement);
    }

    public void collectDependentInspections(@NotNull InspectionToolWrapper toolWrapper, @NotNull Set<? super InspectionToolWrapper<?, ?>> dependentEntries, Project project) {
        String mainToolId;
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(31);
        }
        if (dependentEntries == null) {
            InspectionProfileImpl.$$$reportNull$$$0(32);
        }
        if ((mainToolId = toolWrapper.getMainToolId()) != null) {
            InspectionToolWrapper dependentEntryWrapper = this.getInspectionTool(mainToolId, project);
            if (dependentEntryWrapper == null) {
                LOG.error("Can't find main tool: '" + mainToolId + "' which was specified in " + toolWrapper);
                return;
            }
            if (!dependentEntries.add(dependentEntryWrapper)) {
                this.collectDependentInspections(dependentEntryWrapper, dependentEntries, project);
            }
        }
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @Nullable PsiElement element2) {
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(33);
        }
        ToolsImpl toolList = this.getToolsOrNull(shortName, element2 == null ? null : element2.getProject());
        return toolList == null ? null : toolList.getInspectionTool(element2);
    }

    @Nullable
    public InspectionProfileEntry getUnwrappedTool(@NotNull String shortName, @NotNull PsiElement element2) {
        InspectionToolWrapper tool;
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(34);
        }
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(35);
        }
        return (tool = this.getInspectionTool(shortName, element2)) == null ? null : tool.getTool();
    }

    public <T extends InspectionProfileEntry> T getUnwrappedTool(@NotNull Key<T> shortNameKey, @NotNull PsiElement element2) {
        if (shortNameKey == null) {
            InspectionProfileImpl.$$$reportNull$$$0(36);
        }
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(37);
        }
        return (T)this.getUnwrappedTool(shortNameKey.toString(), element2);
    }

    public void modifyProfile(@NotNull Consumer<? super InspectionProfileModifiableModel> modelConsumer) {
        if (modelConsumer == null) {
            InspectionProfileImpl.$$$reportNull$$$0(38);
        }
        InspectionProfileModifiableModelKt.edit(this, (Function1<? super InspectionProfileModifiableModel, Unit>)((Function1)it -> {
            modelConsumer.consume(it);
            return null;
        }));
    }

    public <T extends InspectionProfileEntry> void modifyToolSettings(@NotNull Key<T> shortNameKey, @NotNull PsiElement psiElement, @NotNull Consumer<? super T> toolConsumer) {
        if (shortNameKey == null) {
            InspectionProfileImpl.$$$reportNull$$$0(39);
        }
        if (psiElement == null) {
            InspectionProfileImpl.$$$reportNull$$$0(40);
        }
        if (toolConsumer == null) {
            InspectionProfileImpl.$$$reportNull$$$0(41);
        }
        this.modifyProfile((Consumer<? super InspectionProfileModifiableModel>)((Consumer)model2 -> {
            InspectionProfileEntry tool = model2.getUnwrappedTool(shortNameKey.toString(), psiElement);
            toolConsumer.consume((Object)tool);
        }));
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, Project project) {
        ToolsImpl tools;
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(42);
        }
        return (tools = this.getToolsOrNull(shortName, project)) == null ? null : tools.getTool();
    }

    public InspectionToolWrapper getToolById(@NotNull String id2, @NotNull PsiElement element2) {
        if (id2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(43);
        }
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(44);
        }
        this.initInspectionTools(element2.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element2);
            if (!id2.equals(tool.getID())) continue;
            return tool;
        }
        return null;
    }

    @NotNull
    public List<InspectionToolWrapper<?, ?>> findToolsById(@NotNull String id2, @NotNull PsiElement element2) {
        if (id2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(45);
        }
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(46);
        }
        this.initInspectionTools(element2.getProject());
        ArrayList<InspectionToolWrapper> result2 = null;
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element2);
            if (!id2.equals(tool.getID())) continue;
            if (result2 == null) {
                result2 = new ArrayList<InspectionToolWrapper>();
            }
            result2.add(tool);
        }
        List list2 = ContainerUtil.notNullize(result2);
        if (list2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @Nullable
    public String getSingleTool() {
        return this.myToolShortName;
    }

    public void setSingleTool(@NotNull String toolShortName) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(48);
        }
        this.myToolShortName = toolShortName;
    }

    @NonNls
    @NotNull
    public String getDisplayName() {
        String string = this.getName();
        if (string == null) {
            InspectionProfileImpl.$$$reportNull$$$0(49);
        }
        return string;
    }

    public void scopesChanged() {
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl tools : this.myTools.values()) {
            tools.scopesChanged();
        }
        this.getProfileManager().fireProfileChanged(this);
    }

    @Transient
    public boolean isProfileLocked() {
        return this.myLockedProfile;
    }

    public void lockProfile(boolean isLocked) {
        this.myLockedProfile = isLocked;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public List<InspectionToolWrapper<?, ?>> getInspectionTools(@Nullable PsiElement element2) {
        this.initInspectionTools(element2 == null ? null : element2.getProject());
        ArrayList result2 = new ArrayList(this.myTools.size());
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getInspectionTool(element2));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    public List<Tools> getAllEnabledInspectionTools(Project project) {
        this.initInspectionTools(project);
        ArrayList<Tools> result2 = new ArrayList<Tools>();
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            result2.add(toolList);
        }
        ArrayList<Tools> arrayList = result2;
        if (arrayList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    public void disableToolByDefault(@NotNull Collection<String> toolShortNames, @Nullable Project project) {
        if (toolShortNames == null) {
            InspectionProfileImpl.$$$reportNull$$$0(52);
        }
        for (String toolId : toolShortNames) {
            this.getTools(toolId, project).setDefaultEnabled(false);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public ScopeToolState getToolDefaultState(@NotNull String toolShortName, @Nullable Project project) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(53);
        }
        ScopeToolState scopeToolState = this.getTools(toolShortName, project).getDefaultState();
        if (scopeToolState == null) {
            InspectionProfileImpl.$$$reportNull$$$0(54);
        }
        return scopeToolState;
    }

    public void enableToolsByDefault(@NotNull List<String> toolShortNames, Project project) {
        if (toolShortNames == null) {
            InspectionProfileImpl.$$$reportNull$$$0(55);
        }
        for (String shortName : toolShortNames) {
            this.getTools(shortName, project).setDefaultEnabled(true);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    protected List<InspectionToolWrapper<?, ?>> createTools(@Nullable Project project) {
        List<InspectionToolWrapper<?, ?>> list2 = this.myToolSupplier.createTools();
        if (list2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(56);
        }
        return list2;
    }

    @Override
    protected void initialize(final @Nullable Project project) {
        List<InspectionToolWrapper<?, ?>> tools;
        SchemeDataHolder<? super InspectionProfileImpl> dataHolder = this.myDataHolder;
        if (dataHolder != null) {
            this.myDataHolder = null;
            Element element2 = dataHolder.read();
            if (element2.getName().equals("component")) {
                element2 = element2.getChild("profile");
            }
            assert (element2 != null);
            this.readExternal(element2);
        }
        if (this.myBaseProfile != null) {
            this.myBaseProfile.initInspectionTools((Project)(this.myBaseProfile.getProfileManager() instanceof ProjectInspectionProfileManager ? project : null));
        }
        try {
            tools = this.createTools(project);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        THashMap dependencies = new THashMap();
        for (InspectionToolWrapper<?, ?> toolWrapper : tools) {
            ToolsImpl parent;
            this.addTool(project, toolWrapper, (Map<String, List<String>>)dependencies);
            if (!(toolWrapper instanceof LocalInspectionToolWrapper) || !((LocalInspectionToolWrapper)toolWrapper).isDynamicGroup() || !toolWrapper.isInitialized() || !(parent = this.myTools.get(toolWrapper.getShortName())).isEnabled()) continue;
            List<LocalInspectionToolWrapper> children2 = ((DynamicGroupTool)toolWrapper.getTool()).getChildren();
            if (tools.stream().anyMatch(i2 -> children2.stream().anyMatch(l -> i2.getShortName().equals(l.getShortName())))) continue;
            boolean isLocked = this.myLockedProfile;
            this.myLockedProfile = false;
            for (LocalInspectionToolWrapper wrapper2 : children2) {
                this.addTool(project, wrapper2, (Map<String, List<String>>)dependencies);
                String shortName = wrapper2.getShortName();
                if (InspectionElementsMerger.getMerger((String)shortName) != null) continue;
                InspectionElementsMerger.addMerger((String)shortName, (InspectionElementsMerger)new MyInspectionElementsMerger(shortName, wrapper2));
            }
            this.myLockedProfile = isLocked;
        }
        this.myToolSupplier.addListener(new InspectionToolsSupplier.Listener(){

            public void toolAdded(@NotNull InspectionToolWrapper inspectionTool) {
                if (inspectionTool == null) {
                    1.$$$reportNull$$$0(0);
                }
                InspectionProfileImpl.this.addTool(project, inspectionTool, null);
                InspectionProfileImpl.this.getProfileManager().fireProfileChanged(InspectionProfileImpl.this);
            }

            public void toolRemoved(@NotNull InspectionToolWrapper inspectionTool) {
                if (inspectionTool == null) {
                    1.$$$reportNull$$$0(1);
                }
                InspectionProfileImpl.this.removeTool(inspectionTool);
                InspectionProfileImpl.this.getProfileManager().fireProfileChanged(InspectionProfileImpl.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "inspectionTool";
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionProfileImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
        DFSTBuilder builder2 = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<String>((Map)dependencies){
            final /* synthetic */ Map val$dependencies;
            {
                this.val$dependencies = map2;
            }

            @NotNull
            public Collection<String> getNodes() {
                Set<String> set2 = this.val$dependencies.keySet();
                if (set2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return set2;
            }

            @NotNull
            public Iterator<String> getIn(String n) {
                Iterator<String> iterator2 = ((List)this.val$dependencies.get(n)).iterator();
                if (iterator2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/ex/InspectionProfileImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (builder2.isAcyclic()) {
            this.myScopesOrder = ArrayUtilRt.toStringArray((Collection)builder2.getSortedNodes());
        }
        this.copyToolsConfigurations(project);
        this.initialized = true;
        if (dataHolder != null) {
            dataHolder.updateDigest(this);
        }
    }

    protected void copyToolsConfigurations(@Nullable Project project) {
    }

    public void addTool(@Nullable Project project, @NotNull InspectionToolWrapper toolWrapper, @Nullable Map<String, List<String>> dependencies) {
        String shortName;
        HighlightDisplayKey key;
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(57);
        }
        if ((key = HighlightDisplayKey.find((String)(shortName = toolWrapper.getShortName()))) == null) {
            InspectionEP extension = toolWrapper.getExtension();
            Computable.PredefinedValueComputable computable = extension == null || extension.displayName == null && extension.key == null ? new Computable.PredefinedValueComputable((Object)toolWrapper.getDisplayName()) : () -> ((InspectionEP)extension).getDisplayName();
            key = toolWrapper instanceof LocalInspectionToolWrapper ? HighlightDisplayKey.register((String)shortName, (Computable)computable, (String)toolWrapper.getID(), (String)((LocalInspectionToolWrapper)toolWrapper).getAlternativeID()) : HighlightDisplayKey.register((String)shortName, (Computable)computable, (String)shortName);
        }
        if (key == null) {
            LOG.error(shortName + " ; number of initialized tools: " + this.myTools.size());
            return;
        }
        HighlightDisplayLevel baseLevel = this.myBaseProfile != null && this.myBaseProfile.getToolsOrNull(shortName, project) != null ? this.myBaseProfile.getErrorLevel(key, project) : HighlightDisplayLevel.DO_NOT_SHOW;
        HighlightDisplayLevel defaultLevel = toolWrapper.getDefaultLevel();
        HighlightDisplayLevel level = baseLevel.getSeverity().compareTo(defaultLevel.getSeverity()) > 0 ? baseLevel : defaultLevel;
        boolean enabled = this.myBaseProfile != null && this.myBaseProfile.getToolsOrNull(shortName, project) != null ? this.myBaseProfile.isToolEnabled(key) : toolWrapper.isEnabledByDefault();
        ToolsImpl toolsList = new ToolsImpl(toolWrapper, level, !this.myLockedProfile && enabled, enabled);
        Element element2 = this.myUninitializedSettings.remove(shortName);
        try {
            if (element2 != null) {
                element2 = element2.clone();
                this.getPathMacroManager().expandPaths(element2);
                toolsList.readExternal(element2, this.getProfileManager(), dependencies);
            } else if (!this.myUninitializedSettings.containsKey(InspectionElementsMergerBase.getMergedMarkerName(shortName))) {
                Element merged;
                InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(shortName);
                Element element3 = merged = merger == null ? null : merger.merge(this.myUninitializedSettings);
                if (merged != null) {
                    this.getPathMacroManager().expandPaths(merged);
                    toolsList.readExternal(merged, this.getProfileManager(), dependencies);
                } else if (this.isProfileLocked()) {
                    toolsList.setEnabled(false);
                    if (toolsList.getNonDefaultTools() == null) {
                        toolsList.getDefaultState().setEnabled(false);
                    }
                }
            }
        }
        catch (InvalidDataException e) {
            LOG.error("Can't read settings for " + toolWrapper, (Throwable)e);
        }
        this.myTools.put(shortName, toolsList);
    }

    public void removeTool(@NotNull InspectionToolWrapper inspectionTool) {
        if (inspectionTool == null) {
            InspectionProfileImpl.$$$reportNull$$$0(58);
        }
        String shortName = inspectionTool.getShortName();
        this.removeTool(shortName);
    }

    public void removeTool(@NotNull String shortName) {
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(59);
        }
        this.myTools.remove(shortName);
        HighlightDisplayKey.unregister((String)shortName);
    }

    @Nullable
    private static InspectionElementsMergerBase getMerger(@NotNull String shortName) {
        InspectionElementsMerger merger;
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(60);
        }
        if ((merger = InspectionElementsMerger.getMerger((String)shortName)) instanceof InspectionElementsMergerBase) {
            return (InspectionElementsMergerBase)merger;
        }
        return merger == null ? null : new InspectionElementsMergerBase(){

            @NotNull
            public String getMergedToolName() {
                String string = merger.getMergedToolName();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String @NotNull [] getSourceToolNames() {
                String[] stringArray = merger.getSourceToolNames();
                if (stringArray == null) {
                    3.$$$reportNull$$$0(1);
                }
                return stringArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/ex/InspectionProfileImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMergedToolName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSourceToolNames";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Transient
    public String @Nullable [] getScopesOrder() {
        return this.myScopesOrder;
    }

    public void setScopesOrder(String @NotNull [] scopesOrder) {
        if (scopesOrder == null) {
            InspectionProfileImpl.$$$reportNull$$$0(61);
        }
        this.myScopesOrder = scopesOrder;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    private HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, @Nullable Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(62);
        }
        HighlightDisplayLevel highlightDisplayLevel = this.getTools(key.toString(), project).getLevel();
        if (highlightDisplayLevel == null) {
            InspectionProfileImpl.$$$reportNull$$$0(63);
        }
        return highlightDisplayLevel;
    }

    @TestOnly
    @NotNull
    public InspectionProfileModifiableModel getModifiableModel() {
        return new InspectionProfileModifiableModel(this);
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(64);
        }
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            toolList.cleanupTools(project);
        }
    }

    public void enableTool(@NotNull String toolShortName, @Nullable Project project) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(65);
        }
        this.setToolEnabled(toolShortName, true, project);
    }

    public void enableTool(@NotNull String inspectionTool, @NotNull NamedScope namedScope, @NotNull Project project) {
        if (inspectionTool == null) {
            InspectionProfileImpl.$$$reportNull$$$0(66);
        }
        if (namedScope == null) {
            InspectionProfileImpl.$$$reportNull$$$0(67);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(68);
        }
        this.getTools(inspectionTool, project).enableTool(namedScope, project);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void enableTools(@NotNull List<String> inspectionTools, @NotNull NamedScope namedScope, @NotNull Project project) {
        if (inspectionTools == null) {
            InspectionProfileImpl.$$$reportNull$$$0(69);
        }
        if (namedScope == null) {
            InspectionProfileImpl.$$$reportNull$$$0(70);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(71);
        }
        for (String inspectionTool : inspectionTools) {
            this.enableTool(inspectionTool, namedScope, project);
        }
    }

    public void disableTools(@NotNull List<String> inspectionTools, @NotNull NamedScope namedScope, @NotNull Project project) {
        if (inspectionTools == null) {
            InspectionProfileImpl.$$$reportNull$$$0(72);
        }
        if (namedScope == null) {
            InspectionProfileImpl.$$$reportNull$$$0(73);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(74);
        }
        for (String inspectionTool : inspectionTools) {
            this.getTools(inspectionTool, project).disableTool(namedScope, project);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(75);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(76);
        }
        this.getTools(key.toString(), project).setLevel(level);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean isToolEnabled(@Nullable HighlightDisplayKey key, @Nullable PsiElement element2) {
        if (key == null) {
            return false;
        }
        ToolsImpl toolState = this.getToolsOrNull(key.toString(), element2 == null ? null : element2.getProject());
        return toolState != null && toolState.isEnabled(element2);
    }

    public boolean isExecutable(@Nullable Project project) {
        this.initInspectionTools(project);
        for (Tools tools : this.myTools.values()) {
            if (!tools.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Tag
    @NlsContexts.DetailedDescription
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NlsContexts.DetailedDescription @Nullable String description) {
        this.myDescription = StringUtil.nullize((String)description);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void resetToBase(@NotNull String toolId, NamedScope scope, @NotNull Project project) {
        ToolsImpl tools;
        if (toolId == null) {
            InspectionProfileImpl.$$$reportNull$$$0(77);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(78);
        }
        if ((tools = this.myBaseProfile.getToolsOrNull(toolId, project)) == null) {
            return;
        }
        InspectionToolWrapper baseDefaultWrapper = tools.getDefaultState().getTool();
        ScopeToolState state = this.myTools.get(toolId).getTools().stream().filter(s -> scope == s.getScope(project)).findFirst().orElseThrow(IllegalStateException::new);
        state.setTool(InspectionProfileImpl.copyToolSettings(baseDefaultWrapper));
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void convert(@NotNull Element element2, @NotNull Project project) {
        Element scopes;
        if (element2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(79);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(80);
        }
        if ((scopes = element2.getChild("scopes")) == null) {
            return;
        }
        this.initInspectionTools(project);
        for (Element scopeElement : scopes.getChildren("scope")) {
            NamedScope scope;
            String profile = scopeElement.getAttributeValue("profile");
            InspectionProfileImpl inspectionProfile = profile == null ? null : this.getProfileManager().getProfile(profile);
            NamedScope namedScope = scope = inspectionProfile == null ? null : this.getProfileManager().getScopesManager().getScope(scopeElement.getAttributeValue("name"));
            if (scope == null) continue;
            for (InspectionToolWrapper<?, ?> toolWrapper : inspectionProfile.getInspectionTools(null)) {
                HighlightDisplayKey key = HighlightDisplayKey.find((String)toolWrapper.getShortName());
                try {
                    InspectionToolWrapper<?, ?> toolWrapperCopy = InspectionProfileImpl.copyToolSettings(toolWrapper);
                    HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(key, null, project);
                    this.getTools(toolWrapper.getShortName(), project).addTool(scope, toolWrapperCopy, inspectionProfile.isToolEnabled(key), errorLevel);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        this.reduceConvertedScopes();
    }

    private void reduceConvertedScopes() {
        for (ToolsImpl tools : this.myTools.values()) {
            ScopeToolState toolState = tools.getDefaultState();
            List<ScopeToolState> nonDefaultTools = tools.getNonDefaultTools();
            if (nonDefaultTools == null) continue;
            boolean equal = true;
            boolean isEnabled = toolState.isEnabled();
            for (ScopeToolState state : nonDefaultTools) {
                isEnabled |= state.isEnabled();
                if (state.equalTo(toolState)) continue;
                equal = false;
            }
            tools.setEnabled(isEnabled);
            if (!equal) continue;
            tools.removeAllScopes();
        }
    }

    @NotNull
    public List<ScopeToolState> getAllTools() {
        this.initInspectionTools();
        NotNullList result2 = new NotNullList();
        for (Tools tools : this.myTools.values()) {
            tools.collectTools((List)result2);
        }
        NotNullList notNullList = result2;
        if (notNullList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(81);
        }
        return notNullList;
    }

    @NotNull
    public List<ScopeToolState> getDefaultStates(@Nullable Project project) {
        this.initInspectionTools(project);
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getDefaultState());
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(82);
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getNonDefaultTools(@NotNull String shortName, Project project) {
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(83);
        }
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        List<ScopeToolState> nonDefaultTools = this.getTools(shortName, project).getNonDefaultTools();
        if (nonDefaultTools != null) {
            result2.addAll(nonDefaultTools);
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(84);
        }
        return arrayList;
    }

    public boolean isToolEnabled(@NotNull HighlightDisplayKey key, NamedScope namedScope, Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(85);
        }
        return this.getTools(key.toString(), project).isEnabled(namedScope, project);
    }

    public void removeScope(@NotNull String toolShortName, @NotNull String scopeName, Project project) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(86);
        }
        if (scopeName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(87);
        }
        this.getTools(toolShortName, project).removeScope(scopeName);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void removeScopes(@NotNull List<String> shortNames, @NotNull String scopeName, Project project) {
        if (shortNames == null) {
            InspectionProfileImpl.$$$reportNull$$$0(88);
        }
        if (scopeName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(89);
        }
        for (String shortName : shortNames) {
            this.removeScope(shortName, scopeName, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<String> getChangedToolNames() {
        if (this.myBaseProfile == null) {
            return null;
        }
        if (this.myChangedToolNames == null) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myChangedToolNames == null) {
                    this.initInspectionTools(null);
                    Set<String> names2 = this.myTools.keySet();
                    THashSet map2 = new THashSet(names2.size());
                    for (String toolId : names2) {
                        if (InspectionProfileImpl.toolSettingsAreEqual(toolId, this.myBaseProfile, this)) continue;
                        map2.add(toolId);
                    }
                    this.myChangedToolNames = map2;
                    return map2;
                }
            }
        }
        return this.myChangedToolNames;
    }

    public void profileChanged() {
        this.myChangedToolNames = null;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @Transient
    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, NamedScope scope, Project project) {
        ToolsImpl tools;
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(90);
        }
        HighlightDisplayLevel highlightDisplayLevel = (tools = this.getToolsOrNull(key.toString(), project)) != null ? tools.getLevel(scope, project) : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            InspectionProfileImpl.$$$reportNull$$$0(91);
        }
        return highlightDisplayLevel;
    }

    public ScopeToolState addScope(@NotNull InspectionToolWrapper toolWrapper, NamedScope scope, @NotNull HighlightDisplayLevel level, boolean enabled, Project project) {
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(92);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(93);
        }
        return this.getTools(toolWrapper.getShortName(), project).prependTool(scope, toolWrapper, enabled, level);
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(94);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(95);
        }
        this.getTools(key.toString(), project).setLevel(level, scopeName, project);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void setErrorLevel(@NotNull List<? extends HighlightDisplayKey> keys2, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        if (keys2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(96);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(97);
        }
        for (HighlightDisplayKey highlightDisplayKey : keys2) {
            this.setErrorLevel(highlightDisplayKey, level, scopeName, project);
        }
    }

    @Override
    @Nullable
    public ToolsImpl getToolsOrNull(@NotNull String name, @Nullable Project project) {
        if (name == null) {
            InspectionProfileImpl.$$$reportNull$$$0(98);
        }
        this.initInspectionTools(project);
        return this.myTools.get(name);
    }

    public void enableAllTools(Project project) {
        for (InspectionToolWrapper<?, ?> entry : this.getInspectionTools(null)) {
            this.enableTool(entry.getShortName(), project);
        }
    }

    public void disableAllTools(Project project) {
        for (InspectionToolWrapper<?, ?> entry : this.getInspectionTools(null)) {
            this.setToolEnabled(entry.getShortName(), false, project);
        }
    }

    public static void setToolEnabled(boolean newState2, @NotNull InspectionProfileImpl profile, @NotNull String shortName, @NotNull Project project) {
        if (profile == null) {
            InspectionProfileImpl.$$$reportNull$$$0(99);
        }
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(100);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(101);
        }
        profile.setToolEnabled(shortName, newState2, project, false);
        for (ScopeToolState scopeToolState : profile.getTools(shortName, project).getTools()) {
            scopeToolState.setEnabled(newState2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 56: 
            case 63: 
            case 81: 
            case 82: 
            case 84: 
            case 91: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 56: 
            case 63: 
            case 81: 
            case 82: 
            case 84: 
            case 91: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolSupplier";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
            case 12: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile2";
                break;
            }
            case 15: 
            case 31: 
            case 57: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 56: 
            case 63: 
            case 81: 
            case 82: 
            case 84: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionProfileImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolKey";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 44: 
            case 46: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionElement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentEntries";
                break;
            }
            case 33: 
            case 34: 
            case 42: 
            case 59: 
            case 60: 
            case 83: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortNameKey";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConsumer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolConsumer";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 48: 
            case 53: 
            case 65: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortName";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortNames";
                break;
            }
            case 58: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTool";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopesOrder";
                break;
            }
            case 62: 
            case 75: 
            case 85: 
            case 90: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 64: 
            case 68: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 67: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedScope";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTools";
                break;
            }
            case 76: 
            case 93: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortNames";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionProfileImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToolSettings";
                break;
            }
            case 18: 
            case 63: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorLevel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedSeverities";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "findToolsById";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEnabledInspectionTools";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolDefaultState";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createTools";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTools";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStates";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDefaultTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toolSettingsAreEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyToolSettings";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 56: 
            case 63: 
            case 81: 
            case 82: 
            case 84: 
            case 91: {
                break;
            }
            case 17: 
            case 62: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLevel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertToShortName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeVersion";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "markSettingsMerged";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "areSettingsMerged";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectDependentInspections";
                break;
            }
            case 33: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTool";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getUnwrappedTool";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "modifyProfile";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "modifyToolSettings";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getToolById";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findToolsById";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setSingleTool";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "disableToolByDefault";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getToolDefaultState";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "enableToolsByDefault";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addTool";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeTool";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getMerger";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setScopesOrder";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "enableTool";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "enableTools";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "disableTools";
                break;
            }
            case 75: 
            case 76: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "setErrorLevel";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resetToBase";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getNonDefaultTools";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "removeScope";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "removeScopes";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getToolsOrNull";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "setToolEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 56: 
            case 63: 
            case 81: 
            case 82: 
            case 84: 
            case 91: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyInspectionElementsMerger
    extends InspectionElementsMergerBase {
        private final String myShortName;
        private final LocalInspectionToolWrapper myWrapper;

        private MyInspectionElementsMerger(@NotNull String shortName, @NotNull LocalInspectionToolWrapper wrapper2) {
            if (shortName == null) {
                MyInspectionElementsMerger.$$$reportNull$$$0(0);
            }
            if (wrapper2 == null) {
                MyInspectionElementsMerger.$$$reportNull$$$0(1);
            }
            this.myShortName = shortName;
            this.myWrapper = wrapper2;
        }

        @NotNull
        public String getMergedToolName() {
            String string = this.myShortName;
            if (string == null) {
                MyInspectionElementsMerger.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String @NotNull [] getSourceToolNames() {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                MyInspectionElementsMerger.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        @Override
        protected boolean areSettingsMerged(@NotNull Map<String, Element> settings, @NotNull Element element2) {
            if (settings == null) {
                MyInspectionElementsMerger.$$$reportNull$$$0(4);
            }
            if (element2 == null) {
                MyInspectionElementsMerger.$$$reportNull$$$0(5);
            }
            return Boolean.parseBoolean(element2.getAttributeValue("enabled")) == this.myWrapper.isEnabledByDefault() && this.myWrapper.getDefaultLevel().toString().equals(element2.getAttributeValue("level")) && Boolean.parseBoolean(element2.getAttributeValue("enabled_by_default")) == this.myWrapper.isEnabledByDefault();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/InspectionProfileImpl$MyInspectionElementsMerger";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/InspectionProfileImpl$MyInspectionElementsMerger";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedToolName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceToolNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "areSettingsMerged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

