/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2021.1")
public class CompletionVariant {
    protected static final TailType DEFAULT_TAIL_TYPE = TailType.SPACE;
    private final Set<Scope> myScopeClasses = new HashSet<Scope>();
    private ElementFilter myPosition;
    private final List<CompletionVariantItem> myCompletionsList = new ArrayList<CompletionVariantItem>();
    private InsertHandler myInsertHandler = null;
    private final Map<Object, Object> myItemProperties = new HashMap<Object, Object>();

    public CompletionVariant() {
    }

    public CompletionVariant(Class scopeClass, ElementFilter position) {
        this.includeScopeClass(scopeClass);
        this.myPosition = position;
    }

    public CompletionVariant(ElementFilter position) {
        this.myPosition = position;
    }

    boolean isScopeAcceptable(PsiElement scope) {
        return this.isScopeClassAcceptable(scope.getClass());
    }

    boolean isScopeFinal(PsiElement scope) {
        return this.isScopeClassFinal(scope.getClass());
    }

    InsertHandler getInsertHandler() {
        return this.myInsertHandler;
    }

    public void setInsertHandler(InsertHandler handler2) {
        this.myInsertHandler = handler2;
    }

    Map<Object, Object> getItemProperties() {
        return this.myItemProperties;
    }

    private boolean isScopeClassFinal(Class scopeClass) {
        Iterator<Scope> iterator2 = this.myScopeClasses.iterator();
        while (iterator2.hasNext()) {
            Scope myScopeClass;
            Scope scope = myScopeClass = iterator2.next();
            if (!ReflectionUtil.isAssignable((Class)scope.myClass, (Class)scopeClass) || !scope.myIsFinalScope) continue;
            return true;
        }
        return false;
    }

    private boolean isScopeClassAcceptable(Class scopeClass) {
        boolean ret = false;
        for (Scope myScopeClass : this.myScopeClasses) {
            Class aClass = myScopeClass.myClass;
            if (!ReflectionUtil.isAssignable((Class)aClass, (Class)scopeClass)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void includeScopeClass(Class<?> aClass) {
        this.myScopeClasses.add(new Scope(aClass, false));
    }

    public void includeScopeClass(Class<?> aClass, boolean isFinalScope) {
        this.myScopeClasses.add(new Scope(aClass, isFinalScope));
    }

    public void addCompletionFilter(ElementFilter filter2, TailType tailType) {
        this.addCompletion(filter2, tailType);
    }

    public void addCompletionFilter(ElementFilter filter2) {
        this.addCompletionFilter(filter2, TailType.NONE);
    }

    public void addCompletion(@NonNls String keyword) {
        this.addCompletion(keyword, DEFAULT_TAIL_TYPE);
    }

    public void addCompletion(@NonNls String keyword, TailType tailType) {
        this.addCompletion((Object)keyword, tailType);
    }

    private void addCompletion(Object completion, TailType tail) {
        this.myCompletionsList.add(new CompletionVariantItem(completion, tail));
    }

    boolean isVariantApplicable(PsiElement position, PsiElement scope) {
        return this.isScopeAcceptable(scope) && this.myPosition.isAcceptable((Object)position, scope);
    }

    void addReferenceCompletions(PsiReference reference2, PsiElement position, Set<? super LookupElement> set2, PsiFile file2, CompletionData completionData) {
        for (CompletionVariantItem ce : this.myCompletionsList) {
            if (!(ce.myCompletion instanceof ElementFilter)) continue;
            ElementFilter filter2 = (ElementFilter)ce.myCompletion;
            completionData.completeReference(reference2, position, set2, ce.myTailType, filter2, this);
        }
    }

    void addKeywords(Set<LookupElement> set2, CompletionData completionData) {
        for (CompletionVariantItem ce : this.myCompletionsList) {
            completionData.addKeywords(set2, this, ce.myCompletion, ce.myTailType);
        }
    }

    boolean hasReferenceFilter() {
        for (CompletionVariantItem item : this.myCompletionsList) {
            if (!(item.myCompletion instanceof ElementFilter)) continue;
            return true;
        }
        return false;
    }

    boolean hasKeywordCompletions() {
        for (CompletionVariantItem item : this.myCompletionsList) {
            if (item.myCompletion instanceof ElementFilter) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "completion variant at " + this.myPosition.toString() + " completions: " + this.myCompletionsList;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.myItemProperties.put(LookupItem.CASE_INSENSITIVE, caseInsensitive);
    }

    private static class CompletionVariantItem {
        public Object myCompletion;
        public TailType myTailType;

        CompletionVariantItem(Object completion, TailType tailtype) {
            this.myCompletion = completion;
            this.myTailType = tailtype;
        }

        public String toString() {
            return this.myCompletion.toString();
        }
    }

    private static class Scope {
        Class myClass;
        boolean myIsFinalScope;

        Scope(Class aClass, boolean isFinalScope) {
            this.myClass = aClass;
            this.myIsFinalScope = isFinalScope;
        }
    }
}

