/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.CommonBundle;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesUIConfiguration;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CodeStyleSchemesActions
extends AbstractSchemeActions<CodeStyleScheme> {
    CodeStyleSchemesActions(@NotNull AbstractSchemesPanel<CodeStyleScheme, ?> schemesPanel) {
        if (schemesPanel == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(0);
        }
        super(schemesPanel);
    }

    @Override
    protected void resetScheme(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(1);
        }
        if (Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"settings.code.style.reset.to.defaults.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"settings.code.style.reset.to.defaults.title", (Object[])new Object[0]), (String)LangBundle.message((String)"button.restore", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
            this.getModel().restoreDefaults(scheme);
        }
    }

    @Override
    protected void duplicateScheme(@NotNull CodeStyleScheme scheme, @NotNull String newName2) {
        if (scheme == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(2);
        }
        if (newName2 == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(3);
        }
        if (!this.getModel().isProjectScheme(scheme)) {
            CodeStyleScheme newScheme = this.getModel().createNewScheme(newName2, (CodeStyleScheme)this.getCurrentScheme());
            this.getModel().addScheme(newScheme, true);
        }
    }

    @Override
    protected void importScheme(@NotNull String importerName) {
        CodeStyleScheme currentScheme;
        if (importerName == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(4);
        }
        if ((currentScheme = (CodeStyleScheme)this.getCurrentScheme()) != null) {
            this.chooseAndImport(currentScheme, importerName);
        }
    }

    @Override
    protected void copyToIDE(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(5);
        }
        this.getSchemesPanel().editNewSchemeName(this.getProjectName(), false, newName2 -> {
            CodeStyleScheme newScheme = this.getModel().exportProjectScheme((String)newName2);
            this.getModel().selectScheme(newScheme, null);
        });
    }

    @NotNull
    private String getProjectName() {
        Project project = ProjectUtil.guessCurrentProject(this.getSchemesPanel());
        String string = project.getName();
        if (string == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void chooseAndImport(@NotNull CodeStyleScheme currentScheme, @NotNull String importerName) {
        if (currentScheme == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(7);
        }
        if (importerName == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(8);
        }
        if (importerName.equals(CodeStyleSchemesActions.getSharedImportSource())) {
            new SchemesToImportPopup<CodeStyleScheme>(this.getSchemesPanel()){

                @Override
                protected void onSchemeSelected(CodeStyleScheme scheme) {
                    if (scheme != null) {
                        CodeStyleSchemesActions.this.getModel().addScheme(scheme, true);
                    }
                }
            }.show(this.getModel().getSchemes());
        } else {
            SchemeImporter<CodeStyleScheme> importer = SchemeImporterEP.getImporter(importerName, CodeStyleScheme.class);
            if (importer == null) {
                return;
            }
            try {
                CodeStyleScheme scheme = this.importExternalCodeStyle(importer, currentScheme);
                if (scheme != null) {
                    String additionalImportInfo = StringUtil.notNullize((String)importer.getAdditionalImportInfo((Scheme)scheme));
                    this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"message.code.style.scheme.import.success", (Object[])new Object[]{importerName, scheme.getName(), additionalImportInfo}), MessageType.INFO);
                }
            }
            catch (SchemeImportException e) {
                if (e.isWarning()) {
                    this.getSchemesPanel().showStatus(e.getMessage(), MessageType.WARNING);
                    return;
                }
                String message = ApplicationBundle.message((String)"message.code.style.scheme.import.failure", (Object[])new Object[]{importerName, e.getMessage()});
                this.getSchemesPanel().showStatus(message, MessageType.ERROR);
            }
        }
    }

    @Nullable
    private CodeStyleScheme importExternalCodeStyle(@NotNull SchemeImporter<CodeStyleScheme> importer, @NotNull CodeStyleScheme currentScheme) throws SchemeImportException {
        VirtualFile selectedFile;
        if (importer == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(9);
        }
        if (currentScheme == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(10);
        }
        if ((selectedFile = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this.getSchemesPanel(), CodeStyleSchemesUIConfiguration.Util.getRecentImportFile(), null)) != null) {
            CodeStyleSchemesUIConfiguration.Util.setRecentImportFile(selectedFile);
            SchemeCreator schemeCreator = new SchemeCreator();
            CodeStyleScheme schemeImported = (CodeStyleScheme)importer.importScheme(this.getModel().getProject(), selectedFile, (Scheme)currentScheme, (SchemeFactory)schemeCreator);
            if (schemeImported != null) {
                if (schemeCreator.isSchemeWasCreated()) {
                    this.getModel().fireSchemeListChanged();
                } else {
                    this.getModel().updateScheme(schemeImported);
                }
                return schemeImported;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected Class<CodeStyleScheme> getSchemeType() {
        return CodeStyleScheme.class;
    }

    @Override
    public void copyToProject(@NotNull CodeStyleScheme scheme) {
        int copyToProjectConfirmation;
        if (scheme == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(11);
        }
        if ((copyToProjectConfirmation = MessageDialogBuilder.yesNo((String)ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project.message", (Object[])new Object[]{scheme.getName()})).show()) == 0) {
            this.getModel().copyToProject(scheme);
        }
    }

    @NotNull
    protected CodeStyleSchemesModel getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = (CodeStyleSchemesModel)super.getModel();
        if (codeStyleSchemesModel == null) {
            CodeStyleSchemesActions.$$$reportNull$$$0(12);
        }
        return codeStyleSchemesModel;
    }

    private static String getSharedImportSource() {
        return ApplicationBundle.message((String)"import.scheme.shared", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemesPanel";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerName";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesActions";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScheme";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "duplicateScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyToIDE";
                break;
            }
            case 6: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndImport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importExternalCodeStyle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyToProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SchemeCreator
    implements SchemeFactory<CodeStyleScheme> {
        private boolean mySchemeWasCreated;

        private SchemeCreator() {
        }

        @NotNull
        public CodeStyleScheme createNewScheme(@Nullable String targetName) {
            this.mySchemeWasCreated = true;
            if (targetName == null) {
                targetName = ApplicationBundle.message((String)"code.style.scheme.import.unnamed", (Object[])new Object[0]);
            }
            CodeStyleScheme newScheme = CodeStyleSchemesActions.this.getModel().createNewScheme(targetName, (CodeStyleScheme)CodeStyleSchemesActions.this.getCurrentScheme());
            CodeStyleSchemesActions.this.getModel().addScheme(newScheme, true);
            CodeStyleScheme codeStyleScheme = newScheme;
            if (codeStyleScheme == null) {
                SchemeCreator.$$$reportNull$$$0(0);
            }
            return codeStyleScheme;
        }

        boolean isSchemeWasCreated() {
            return this.mySchemeWasCreated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions$SchemeCreator", "createNewScheme"));
        }
    }
}

