/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyGenericType
implements PyType,
PyInstantiableType<PyGenericType> {
    @NotNull
    private final String myName;
    @Nullable
    private final PyType myBound;
    private final boolean myIsDefinition;
    @Nullable
    private final PyTargetExpression myTargetExpression;

    public PyGenericType(@NotNull String name, @Nullable PyType bound) {
        if (name == null) {
            PyGenericType.$$$reportNull$$$0(0);
        }
        this(name, bound, false);
    }

    public PyGenericType(@NotNull String name, @Nullable PyType bound, boolean isDefinition) {
        if (name == null) {
            PyGenericType.$$$reportNull$$$0(1);
        }
        this(name, bound, isDefinition, null);
    }

    public PyGenericType(@NotNull String name, @Nullable PyType bound, boolean isDefinition, @Nullable PyTargetExpression target) {
        if (name == null) {
            PyGenericType.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myBound = bound;
        this.myIsDefinition = isDefinition;
        this.myTargetExpression = target;
    }

    @Override
    @Nullable
    public PyTargetExpression getDeclarationElement() {
        return this.myTargetExpression;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PyType bound;
        if (name == null) {
            PyGenericType.$$$reportNull$$$0(3);
        }
        if (direction == null) {
            PyGenericType.$$$reportNull$$$0(4);
        }
        if (resolveContext == null) {
            PyGenericType.$$$reportNull$$$0(5);
        }
        if ((bound = this.getBoundPromotedToClassObjectTypesIfNeeded()) != null) {
            return bound.resolveMember(name, location, direction, resolveContext);
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        PyType bound = this.getBoundPromotedToClassObjectTypesIfNeeded();
        if (bound != null) {
            return bound.getCompletionVariants(completionPrefix, location, context);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    private PyType getBoundPromotedToClassObjectTypesIfNeeded() {
        if (this.myIsDefinition) {
            return (PyType)PyTypeUtil.toStream(this.myBound).map(t -> t instanceof PyInstantiableType ? ((PyInstantiableType)t).toClass() : t).collect(PyTypeUtil.toUnion());
        }
        return this.myBound;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyGenericType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyGenericType type = (PyGenericType)o;
        return this.myName.equals(type.myName) && this.myIsDefinition == type.isDefinition();
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @NotNull
    public String toString() {
        String string = "PyGenericType: " + this.getName();
        if (string == null) {
            PyGenericType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public PyType getBound() {
        return this.myBound;
    }

    @Override
    public boolean isDefinition() {
        return this.myIsDefinition;
    }

    @Override
    @NotNull
    public PyGenericType toInstance() {
        PyGenericType pyGenericType = this.myIsDefinition ? new PyGenericType(this.myName, this.myBound, false, this.myTargetExpression) : this;
        if (pyGenericType == null) {
            PyGenericType.$$$reportNull$$$0(8);
        }
        return pyGenericType;
    }

    @Override
    @NotNull
    public PyGenericType toClass() {
        return this.myIsDefinition ? this : new PyGenericType(this.myName, this.myBound, true, this.myTargetExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyGenericType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyGenericType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

