/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommand<T> {
    public static final int RUN = 101;
    public static final int CREATE_THREAD = 103;
    public static final int KILL_THREAD = 104;
    public static final int SUSPEND_THREAD = 105;
    public static final int RESUME_THREAD = 106;
    public static final int STEP_INTO = 107;
    public static final int STEP_OVER = 108;
    public static final int STEP_OUT = 109;
    public static final int GET_VARIABLE = 110;
    public static final int SET_BREAKPOINT = 111;
    public static final int REMOVE_BREAKPOINT = 112;
    public static final int EVALUATE = 113;
    public static final int GET_FRAME = 114;
    public static final int EXECUTE = 115;
    public static final int WRITE_TO_CONSOLE = 116;
    public static final int CHANGE_VARIABLE = 117;
    public static final int GET_COMPLETIONS = 120;
    public static final int CONSOLE_EXEC = 121;
    public static final int ADD_EXCEPTION_BREAKPOINT = 122;
    public static final int REMOVE_EXCEPTION_BREAKPOINT = 123;
    public static final int LOAD_SOURCE = 124;
    public static final int SET_NEXT_STATEMENT = 127;
    public static final int SMART_STEP_INTO = 128;
    public static final int EXIT = 129;
    public static final int GET_DESCRIPTION = 148;
    public static final int CALL_SIGNATURE_TRACE = 130;
    public static final int CMD_SET_PY_EXCEPTION = 131;
    public static final int CMD_GET_FILE_CONTENTS = 132;
    public static final int CMD_SET_PROPERTY_TRACE = 133;
    public static final int CMD_EVALUATE_CONSOLE_EXPRESSION = 134;
    public static final int CMD_RUN_CUSTOM_OPERATION = 135;
    public static final int CMD_GET_BREAKPOINT_EXCEPTION = 136;
    public static final int CMD_STEP_CAUGHT_EXCEPTION = 137;
    public static final int CMD_SEND_CURR_EXCEPTION_TRACE = 138;
    public static final int CMD_SEND_CURR_EXCEPTION_TRACE_PROCEEDED = 139;
    public static final int CMD_IGNORE_THROWN_EXCEPTION_AT = 140;
    public static final int CMD_ENABLE_DONT_TRACE = 141;
    public static final int SHOW_CONSOLE = 142;
    public static final int GET_ARRAY = 143;
    public static final int STEP_INTO_MY_CODE = 144;
    public static final int LOG_CONCURRENCY_EVENT = 145;
    public static final int SHOW_RETURN_VALUES = 146;
    public static final int INPUT_REQUESTED = 147;
    public static final int PROCESS_CREATED = 149;
    public static final int SHOW_WARNING = 150;
    public static final int LOAD_FULL_VALUE = 151;
    public static final int CMD_GET_SMART_STEP_INTO_VARIANTS = 160;
    public static final int CMD_SET_UNIT_TESTS_DEBUGGING_MODE = 170;
    public static final int CMD_DATAVIEWER_ACTION = 210;
    public static final int PROCESS_CREATED_MSG_RECEIVED = 159;
    public static final int ERROR = 901;
    public static final int VERSION = 501;
    public static final String NEW_LINE_CHAR = "@_@NEW_LINE_CHAR@_@";
    public static final String TAB_CHAR = "@_@TAB_CHAR@_@";
    @NotNull
    private final RemoteDebugger myDebugger;
    private final int myCommandCode;
    private final ResponseProcessor<T> myResponseProcessor;
    public static final Logger LOG = Logger.getInstance(MethodHandles.lookup().lookupClass());

    protected AbstractCommand(@NotNull RemoteDebugger debugger, int commandCode) {
        if (debugger == null) {
            AbstractCommand.$$$reportNull$$$0(0);
        }
        this.myDebugger = debugger;
        this.myCommandCode = commandCode;
        this.myResponseProcessor = this.createResponseProcessor();
    }

    protected ResponseProcessor<T> createResponseProcessor() {
        return null;
    }

    protected ResponseProcessor<T> getResponseProcessor() {
        return this.myResponseProcessor;
    }

    @NotNull
    public final String getPayload() {
        Payload payload = new Payload();
        this.buildPayload(payload);
        String string = payload.getText();
        if (string == null) {
            AbstractCommand.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected abstract void buildPayload(Payload var1);

    @NotNull
    public static String buildCondition(String expression) {
        String condition;
        if (expression != null) {
            condition = expression.replaceAll("\n", NEW_LINE_CHAR);
            condition = condition.replaceAll("\t", TAB_CHAR);
        } else {
            condition = "None";
        }
        String string = condition;
        if (string == null) {
            AbstractCommand.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isResponseExpected() {
        return false;
    }

    public void execute() throws PyDebuggerException {
        int sequence = this.myDebugger.getNextSequence();
        ResponseProcessor<T> processor2 = this.getResponseProcessor();
        if (processor2 != null || this.isResponseExpected()) {
            this.myDebugger.placeResponse(sequence, null);
        }
        ProtocolFrame frame = new ProtocolFrame(this.myCommandCode, sequence, this.getPayload());
        boolean frameSent = this.myDebugger.sendFrame(frame);
        if (processor2 == null && !this.isResponseExpected()) {
            return;
        }
        if (!frameSent) {
            LOG.error("Couldn't send frame " + this.myCommandCode);
            return;
        }
        frame = this.myDebugger.waitForResponse(sequence, this.getResponseTimeout());
        if (frame == null) {
            String errorMessage = "Timeout waiting for response on " + this.myCommandCode;
            if (!this.myDebugger.isConnected()) {
                errorMessage = "No connection (command:  " + this.myCommandCode + " )";
            }
            LOG.error(errorMessage);
            return;
        }
        if (processor2 != null) {
            processor2.processResponse(frame);
        } else {
            this.processResponse(frame);
        }
    }

    public void execute(PyDebugCallback<T> callback) {
        int sequence = this.myDebugger.getNextSequence();
        ResponseProcessor<T> processor2 = this.getResponseProcessor();
        if (processor2 != null) {
            this.myDebugger.placeResponse(sequence, null);
        }
        try {
            ProtocolFrame frame = new ProtocolFrame(this.myCommandCode, sequence, this.getPayload());
            boolean frameSent = this.myDebugger.sendFrame(frame);
            if (processor2 == null) {
                return;
            }
            if (!frameSent) {
                throw new PyDebuggerException("Couldn't send frame " + this.myCommandCode);
            }
        }
        catch (PyDebuggerException e) {
            callback.error(e);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                ProtocolFrame frame = this.myDebugger.waitForResponse(sequence, this.getResponseTimeout());
                if (frame == null) {
                    if (!this.myDebugger.isConnected()) {
                        throw new PyDebuggerException("No connection (command:  " + this.myCommandCode + " )");
                    }
                    throw new PyDebuggerException("Timeout waiting for response on " + this.myCommandCode);
                }
                callback.ok(processor2.processResponse(frame));
            }
            catch (PyDebuggerException e) {
                callback.error(e);
            }
        });
    }

    protected long getResponseTimeout() {
        return 60000L;
    }

    public static boolean isErrorCommand(int command) {
        return command >= 900 && command < 1000;
    }

    protected void processResponse(@NotNull ProtocolFrame response) throws PyDebuggerException {
        if (response == null) {
            AbstractCommand.$$$reportNull$$$0(3);
        }
        if (AbstractCommand.isErrorCommand(response.getCommand())) {
            throw new PyDebuggerException(response.getPayload());
        }
    }

    public static boolean isCallSignatureTrace(int command) {
        return command == 130;
    }

    public static boolean isConcurrencyEvent(int command) {
        return command == 145;
    }

    public static boolean isWriteToConsole(int command) {
        return command == 116;
    }

    public static boolean isInputRequested(int command) {
        return command == 147;
    }

    public static boolean isShowWarningCommand(int command) {
        return command == 150;
    }

    public static boolean isExitEvent(int command) {
        return command == 129;
    }

    public static boolean isErrorEvent(int command) {
        return command == 901;
    }

    @NotNull
    public RemoteDebugger getDebugger() {
        RemoteDebugger remoteDebugger = this.myDebugger;
        if (remoteDebugger == null) {
            AbstractCommand.$$$reportNull$$$0(4);
        }
        return remoteDebugger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/AbstractCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/AbstractCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPayload";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCondition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class Payload {
        private final StringBuilder myBuilder = new StringBuilder();
        private static final char SEPARATOR = '\t';

        protected Payload() {
        }

        public Payload add(boolean flag) {
            return this.doAdd(flag ? "1" : "0");
        }

        public Payload add(int value) {
            return this.doAdd(String.valueOf(value));
        }

        public Payload add(String text2) {
            return this.doAdd(text2);
        }

        private Payload doAdd(String text2) {
            if (this.myBuilder.length() > 0) {
                return this.separator().append(text2);
            }
            return this.append(text2);
        }

        private Payload append(String text2) {
            this.myBuilder.append(ProtocolParser.encodeExpression(text2));
            return this;
        }

        private Payload separator() {
            this.myBuilder.append('\t');
            return this;
        }

        public String getText() {
            return this.myBuilder.toString();
        }
    }

    protected static abstract class ResponseProcessor<T> {
        protected ResponseProcessor() {
        }

        protected T processResponse(ProtocolFrame response) throws PyDebuggerException {
            if (AbstractCommand.isErrorCommand(response.getCommand())) {
                throw new PyDebuggerException(response.getPayload());
            }
            return this.parseResponse(response);
        }

        protected abstract T parseResponse(ProtocolFrame var1) throws PyDebuggerException;
    }
}

