/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyJoinIfIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.join.if", new Object[0]);
        if (string == null) {
            PyJoinIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyPsiBundle.message("INTN.join.if", new Object[0]);
        if (string == null) {
            PyJoinIfIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyJoinIfIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyIfStatement expression = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyIfStatement.class);
        PyIfStatement outer = PyJoinIfIntention.getIfStatement(expression);
        if (outer != null) {
            if (outer.getElsePart() != null || outer.getElifParts().length > 0) {
                return false;
            }
            PyStatement firstStatement = PyJoinIfIntention.getFirstStatement(outer);
            PyStatementList outerStList = outer.getIfPart().getStatementList();
            if (outerStList != null && outerStList.getStatements().length != 1) {
                return false;
            }
            if (firstStatement instanceof PyIfStatement) {
                PyIfStatement inner = (PyIfStatement)firstStatement;
                if (inner.getElsePart() != null || inner.getElifParts().length > 0) {
                    return false;
                }
                PyStatementList stList = inner.getIfPart().getStatementList();
                if (stList != null && stList.getStatements().length != 0) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyJoinIfIntention.$$$reportNull$$$0(3);
        }
        PyIfStatement expression = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyIfStatement.class);
        PyIfStatement ifStatement = PyJoinIfIntention.getIfStatement(expression);
        PyStatement firstStatement = PyJoinIfIntention.getFirstStatement(ifStatement);
        if (ifStatement == null) {
            return;
        }
        if (firstStatement instanceof PyIfStatement) {
            PyExpression condition = ((PyIfStatement)firstStatement).getIfPart().getCondition();
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            PyExpression ifCondition = ifStatement.getIfPart().getCondition();
            if (ifCondition == null || condition == null) {
                return;
            }
            StringBuilder replacementText = new StringBuilder(ifCondition.getText() + " and ");
            if (condition instanceof PyBinaryExpression && ((PyBinaryExpression)condition).getOperator() == PyTokenTypes.OR_KEYWORD) {
                replacementText.append("(").append(condition.getText()).append(")");
            } else {
                replacementText.append(condition.getText());
            }
            PyExpression newCondition = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)file), replacementText.toString());
            ifCondition.replace((PsiElement)newCondition);
            PyStatementList stList = ((PyIfStatement)firstStatement).getIfPart().getStatementList();
            PyStatementList ifStatementList = ifStatement.getIfPart().getStatementList();
            if (ifStatementList == null || stList == null) {
                return;
            }
            List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)ifStatement.getIfPart(), PsiComment.class);
            comments.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PyIfStatement)firstStatement).getIfPart(), PsiComment.class));
            comments.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)ifStatementList, PsiComment.class));
            comments.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)stList, PsiComment.class));
            for (PsiElement comm : comments) {
                ifStatement.getIfPart().addBefore(comm, (PsiElement)ifStatementList);
                comm.delete();
            }
            ifStatementList.replace((PsiElement)stList);
        }
    }

    @Nullable
    private static PyStatement getFirstStatement(PyIfStatement ifStatement) {
        PyStatementList stList;
        PyStatement firstStatement = null;
        if (ifStatement != null && (stList = ifStatement.getIfPart().getStatementList()) != null && stList.getStatements().length != 0) {
            firstStatement = stList.getStatements()[0];
        }
        return firstStatement;
    }

    @Nullable
    private static PyIfStatement getIfStatement(PyIfStatement expression) {
        PyStatement firstStatement;
        PyStatementList stList;
        while (!(expression == null || (stList = expression.getIfPart().getStatementList()) != null && stList.getStatements().length != 0 && (firstStatement = stList.getStatements()[0]) instanceof PyIfStatement)) {
            expression = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PyIfStatement.class);
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyJoinIfIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyJoinIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

