/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.PyImportCandidateProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PyImportCollector {
    private final PyElement myNode;
    private final PsiReference myReference;
    private final String myRefText;
    private final String myAlias;
    private final AutoImportQuickFix fix;
    private final Set<String> seenCandidateNames;

    public PyImportCollector(PyElement node, PsiReference reference, String refText, String alias) {
        this.myNode = node;
        this.myReference = reference;
        this.myRefText = refText;
        this.myAlias = alias;
        boolean qualify = !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT;
        this.fix = new AutoImportQuickFix((PsiElement)node, reference.getClass(), refText, qualify);
        this.seenCandidateNames = new HashSet<String>();
    }

    public AutoImportQuickFix addCandidates() {
        PsiFile existingImportFile = this.addCandidatesFromExistingImports();
        ProgressManager.checkCanceled();
        this.addSymbolImportCandidates(existingImportFile);
        for (PyImportCandidateProvider provider : PyImportCandidateProvider.EP_NAME.getExtensionList()) {
            provider.addImportCandidates(this.myReference, this.myRefText, this.fix);
        }
        if (!this.fix.getCandidates().isEmpty()) {
            this.fix.sortCandidates();
            return this.fix;
        }
        return null;
    }

    private PsiFile addCandidatesFromExistingImports() {
        PsiFile existingImportFile = null;
        PsiFile file = this.myNode.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            for (PyImportElement importElement : pyFile.getImportTargets()) {
                existingImportFile = this.addImportViaElement(existingImportFile, importElement, importElement.resolve());
            }
            existingImportFile = this.addCandidatesViaFromImports(existingImportFile, pyFile);
        }
        return existingImportFile;
    }

    PsiFile addCandidatesViaFromImports(PsiFile existingImportFile, PyFile pyFile) {
        for (PyFromImportStatement fromImportStatement : pyFile.getFromImports()) {
            if (fromImportStatement.isStarImport() || fromImportStatement.getImportElements().length <= 0) continue;
            PsiFileSystemItem source = fromImportStatement.resolveImportSource();
            existingImportFile = this.addImportViaElement(existingImportFile, fromImportStatement.getImportElements()[0], (PsiElement)source);
        }
        return existingImportFile;
    }

    private PsiFile addImportViaElement(PsiFile existingImportFile, PyImportElement importElement, PsiElement source) {
        PyFile sourceFile = PyUtil.as(PyUtil.turnDirIntoInit(source), PyFile.class);
        if (sourceFile instanceof PyFileImpl) {
            String name;
            PsiElement res = sourceFile.findExportedName(this.myRefText);
            String string = name = res instanceof PyQualifiedNameOwner ? ((PyQualifiedNameOwner)res).getQualifiedName() : null;
            if (name != null && this.seenCandidateNames.contains(name)) {
                return existingImportFile;
            }
            if (res != null && !(res instanceof PyFile) && !(res instanceof PyImportElement) && res.getContainingFile() != null && PsiTreeUtil.isAncestor((PsiElement)source, (PsiElement)res.getContainingFile(), (boolean)false)) {
                existingImportFile = sourceFile;
                this.fix.addImport(res, sourceFile, importElement);
                if (name != null) {
                    this.seenCandidateNames.add(name);
                }
            }
        }
        return existingImportFile;
    }

    private void addSymbolImportCandidates(PsiFile existingImportFile) {
        Project project = this.myNode.getProject();
        ArrayList<PyClass> symbols = new ArrayList<PyClass>(PyClassNameIndex.find(this.myRefText, project, true));
        GlobalSearchScope scope = PySearchUtilBase.excludeSdkTestsScope((PsiElement)this.myNode);
        if (!this.isQualifier()) {
            symbols.addAll(PyFunctionNameIndex.find(this.myRefText, project, scope));
        }
        symbols.addAll(PyVariableNameIndex.find(this.myRefText, project, scope));
        if (this.isPossibleModuleReference()) {
            symbols.addAll(this.findImportableModules(project, scope));
        }
        if (!symbols.isEmpty()) {
            for (PsiElement psiElement : symbols) {
                String symbolImportQName;
                QualifiedName importPath;
                PsiFile srcfile;
                if (!PyImportCollector.isIndexableTopLevel(psiElement) || (srcfile = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getParent() : psiElement.getContainingFile()) == null || !this.isAcceptableForImport(existingImportFile, (PsiFileSystemItem)srcfile) || (importPath = QualifiedNameFinder.findCanonicalImportPath(psiElement, (PsiElement)this.myNode)) == null) continue;
                if (psiElement instanceof PsiFileSystemItem) {
                    importPath = importPath.removeTail(1);
                }
                if (this.seenCandidateNames.contains(symbolImportQName = importPath.append(this.myRefText).toString())) continue;
                this.fix.addImport(psiElement, (PsiFileSystemItem)srcfile, importPath, this.myAlias);
                this.seenCandidateNames.add(symbolImportQName);
            }
        }
    }

    PyElement getNode() {
        return this.myNode;
    }

    private boolean isAcceptableForImport(PsiFile existingImportFile, PsiFileSystemItem srcfile) {
        return srcfile != existingImportFile && srcfile != this.myNode.getContainingFile() && (PyUtil.isRoot(srcfile) || PyNames.isIdentifier(FileUtilRt.getNameWithoutExtension((String)srcfile.getName()))) && !PyImportCollector.isShadowedModule(srcfile);
    }

    private static boolean isShadowedModule(PsiFileSystemItem file) {
        if (file.isDirectory() || file.getName().equals("__init__.py")) {
            return false;
        }
        String name = FileUtilRt.getNameWithoutExtension((String)file.getName());
        PsiDirectory directory2 = ((PsiFile)file).getContainingDirectory();
        if (directory2 == null) {
            return false;
        }
        PsiDirectory packageDir = directory2.findSubdirectory(name);
        return packageDir != null && packageDir.findFile("__init__.py") != null;
    }

    private boolean isQualifier() {
        return this.myNode.getParent() instanceof PyReferenceExpression && this.myNode == ((PyReferenceExpression)this.myNode.getParent()).getQualifier();
    }

    private boolean isPossibleModuleReference() {
        PyClass pyClass;
        PyArgumentList argumentList;
        PyCallExpression callExpression = PyUtil.as(this.myNode.getParent(), PyCallExpression.class);
        if (callExpression != null && this.myNode == callExpression.getCallee()) {
            PyDecorator decorator = PyUtil.as(callExpression, PyDecorator.class);
            return decorator != null && !decorator.hasArgumentList();
        }
        return !(this.myNode.getParent() instanceof PyArgumentList) || !((argumentList = (PyArgumentList)this.myNode.getParent()).getParent() instanceof PyClass) || (pyClass = (PyClass)argumentList.getParent()).getSuperClassExpressionList() != argumentList;
    }

    private Collection<PsiElement> findImportableModules(Project project, GlobalSearchScope scope) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        FilenameIndex.processFilesByName((String)this.myRefText, (boolean)true, item -> {
            ProgressManager.checkCanceled();
            PsiDirectory candidatePackageDir = PyUtil.as(item, PsiDirectory.class);
            if (candidatePackageDir != null && candidatePackageDir.findFile("__init__.py") != null) {
                result.add((PsiElement)candidatePackageDir);
            }
            return true;
        }, (GlobalSearchScope)scope, (Project)project, null);
        FilenameIndex.processFilesByName((String)(this.myRefText + ".py"), (boolean)false, (boolean)true, item -> {
            ProgressManager.checkCanceled();
            if (PyUtil.isImportable(this.myNode.getContainingFile(), item)) {
                result.add((PsiElement)item);
            }
            return true;
        }, (GlobalSearchScope)scope, (Project)project, null);
        return result;
    }

    private static boolean isIndexableTopLevel(PsiElement symbol) {
        if (symbol instanceof PsiFileSystemItem) {
            return true;
        }
        if (symbol instanceof PyClass || symbol instanceof PyFunction) {
            return PyUtil.isTopLevel(symbol);
        }
        return symbol instanceof PyTargetExpression;
    }
}

