/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.completion.PyExtendedCompletionContributor;
import com.jetbrains.python.codeInsight.completion.PyExtendedCompletionContributorKt;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyExtendedCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "functionInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getFunctionInsertHandler", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "importingInsertHandler", "getImportingInsertHandler", "stringLiteralInsertHandler", "getStringLiteralInsertHandler", "doFillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillCompletionVariants", "insertStringLiteralPrefix", "qualifiedName", "", "name", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "shouldDoCompletion", "", "intellij.python.psi.impl"})
public abstract class PyExtendedCompletionContributor
extends CompletionContributor {
    @NotNull
    private final InsertHandler<LookupElement> importingInsertHandler = importingInsertHandler.1.INSTANCE;
    @NotNull
    private final InsertHandler<LookupElement> functionInsertHandler = (InsertHandler)new PyFunctionInsertHandler(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            int tailOffset = context.getTailOffset() - 1;
            super.handleInsert(context, item);
            context.commitDocument();
            PyExtendedCompletionContributorKt.access$addImportForLookupElement(context, item, tailOffset);
        }
    };
    @NotNull
    private final InsertHandler<LookupElement> stringLiteralInsertHandler = (InsertHandler)new InsertHandler<LookupElement>(this){
        final /* synthetic */ PyExtendedCompletionContributor this$0;

        public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            PsiElement element = item.getPsiElement();
            if (element == null) {
                return;
            }
            if (element instanceof PyQualifiedNameOwner) {
                PyExtendedCompletionContributor.access$insertStringLiteralPrefix(this.this$0, ((PyQualifiedNameOwner)element).getQualifiedName(), ((PyQualifiedNameOwner)element).getName(), context);
            } else {
                QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath(element, null);
                if (importPath != null) {
                    PyExtendedCompletionContributor.access$insertStringLiteralPrefix(this.this$0, importPath.toString(), String.valueOf(importPath.getLastComponent()), context);
                }
            }
        }
        {
            this.this$0 = pyExtendedCompletionContributor;
        }
    };

    @NotNull
    protected final InsertHandler<LookupElement> getImportingInsertHandler() {
        return this.importingInsertHandler;
    }

    @NotNull
    protected final InsertHandler<LookupElement> getFunctionInsertHandler() {
        return this.functionInsertHandler;
    }

    @NotNull
    protected final InsertHandler<LookupElement> getStringLiteralInsertHandler() {
        return this.stringLiteralInsertHandler;
    }

    private final void insertStringLiteralPrefix(String qualifiedName, String name, InsertionContext context) {
        if (qualifiedName != null && name != null) {
            String string = qualifiedName;
            int n = 0;
            int n2 = qualifiedName.length() - name.length();
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String qualifiedNamePrefix = string2;
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)qualifiedNamePrefix);
        }
    }

    public final void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!this.shouldDoCompletion(parameters, result)) {
            return;
        }
        this.doFillCompletionVariants(parameters, result);
    }

    protected abstract void doFillCompletionVariants(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2);

    private final boolean shouldDoCompletion(CompletionParameters parameters, CompletionResultSet result) {
        if (!parameters.isExtendedCompletion()) {
            return false;
        }
        PrefixMatcher prefixMatcher = result.getPrefixMatcher();
        Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"result.prefixMatcher");
        String string = prefixMatcher.getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.prefixMatcher.prefix");
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() == 0) {
            result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            return false;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        PsiElement element = psiElement;
        PsiElement parent = element.getParent();
        if (parent instanceof PyReferenceExpression && ((PyReferenceExpression)parent).isQualified()) {
            return false;
        }
        if (parent instanceof PyStringLiteralExpression) {
            String string2 = ((PyStringLiteralExpression)parent).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parent.text");
            String string3 = string2;
            int n = 0;
            int n2 = parameters.getOffset();
            TextRange textRange = ((PyStringLiteralExpression)parent).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"parent.textRange");
            int n3 = n2 - textRange.getStartOffset();
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String prefix = string5;
            if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)".", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"element.containingFile.viewProvider");
        FileViewProvider provider = fileViewProvider;
        if (provider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) == null;
    }

    public static final /* synthetic */ void access$insertStringLiteralPrefix(PyExtendedCompletionContributor $this, String qualifiedName, String name, InsertionContext context) {
        $this.insertStringLiteralPrefix(qualifiedName, name, context);
    }
}

