/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout;

import com.intellij.DynamicBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.buildout.BuildoutConfigPanel;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.buildout.BuildoutFacetConfigurator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BuildoutConfigurable
implements Configurable,
NonDefaultProjectConfigurable {
    private JCheckBox myEnabledCheckbox;
    private JPanel myPlaceholder;
    private JPanel myMainPanel;
    private final BuildoutConfigPanel mySettingsPanel;
    @NotNull
    private final Module myModule;

    public BuildoutConfigurable(@NotNull Module module) {
        if (module == null) {
            BuildoutConfigurable.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        BuildoutFacetConfiguration config = null;
        this.$$$setupUI$$$();
        BuildoutFacet facet = BuildoutFacet.getInstance((Module)this.myModule);
        if (facet != null) {
            config = (BuildoutFacetConfiguration)facet.getConfiguration();
        }
        if (config == null) {
            config = new BuildoutFacetConfiguration(null);
        }
        this.mySettingsPanel = new BuildoutConfigPanel(this.myModule, config);
        this.myPlaceholder.add((Component)this.mySettingsPanel, "Center");
        boolean isEnabled = !StringUtil.isEmptyOrSpaces((String)config.getScriptName());
        this.myEnabledCheckbox.setSelected(isEnabled);
        this.updateFacetEnabled(isEnabled);
        this.myEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = BuildoutConfigurable.this.myEnabledCheckbox.isSelected();
                BuildoutConfigurable.this.updateFacetEnabled(enabled);
            }
        });
        this.mySettingsPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                BuildoutConfigurable.this.switchNoticeText();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    private void updateFacetEnabled(boolean enabled) {
        this.mySettingsPanel.setFacetEnabled(enabled);
        UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)enabled, (boolean)true);
    }

    @Nls
    public String getDisplayName() {
        return PyBundle.message((String)"configurable.BuildoutConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference-python-buildout";
    }

    public JComponent createComponent() {
        this.switchNoticeText();
        return this.myMainPanel;
    }

    public boolean isModified() {
        boolean got_facet;
        if (!this.myEnabledCheckbox.isEnabled()) {
            return false;
        }
        BuildoutFacet facet = BuildoutFacet.getInstance((Module)this.myModule);
        boolean bl = got_facet = facet != null;
        if (this.myEnabledCheckbox.isSelected() != got_facet) {
            return true;
        }
        if (got_facet && this.myEnabledCheckbox.isSelected()) {
            return this.mySettingsPanel.isModified((BuildoutFacetConfiguration)facet.getConfiguration());
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        BuildoutFacet facet = BuildoutFacet.getInstance((Module)this.myModule);
        boolean got_facet = facet != null;
        boolean facet_is_desired = this.myEnabledCheckbox.isSelected();
        this.mySettingsPanel.apply();
        if (facet_is_desired) {
            String script_name = this.mySettingsPanel.getScriptName();
            VirtualFile script_file = BuildoutConfigPanel.getScriptFile((String)script_name);
            List paths_from_script = BuildoutFacet.extractBuildoutPaths((VirtualFile)script_file);
            if (paths_from_script == null) {
                throw new ConfigurationException(PyBundle.message((String)"python.buildout.failed.to.extract.path", (Object[])new Object[]{script_file.getPresentableName()}));
            }
            this.mySettingsPanel.getConfiguration().setPaths(paths_from_script);
        }
        if (facet_is_desired && !got_facet) {
            this.addFacet(this.mySettingsPanel.getConfiguration());
        }
        if (!facet_is_desired && got_facet) {
            this.removeFacet(facet);
        }
        if (got_facet) {
            if (facet_is_desired) {
                BuildoutFacet.attachLibrary((Module)this.myModule);
            } else {
                BuildoutFacet.detachLibrary((Module)this.myModule);
            }
            FacetManager.getInstance((Module)this.myModule).facetConfigurationChanged((Facet)facet);
        }
    }

    private void addFacet(BuildoutFacetConfiguration config) {
        BuildoutFacetConfigurator.setupFacet(this.myModule, config);
    }

    private void removeFacet(BuildoutFacet facet) {
        ModifiableFacetModel model = FacetManager.getInstance((Module)this.myModule).createModifiableModel();
        model.removeFacet((Facet)facet);
        ApplicationManager.getApplication().runWriteAction(() -> model.commit());
    }

    public void reset() {
        if (this.myModule == null) {
            this.myEnabledCheckbox.setSelected(false);
            this.myEnabledCheckbox.setEnabled(false);
        } else {
            this.myEnabledCheckbox.setEnabled(true);
            this.switchNoticeText();
            BuildoutFacet instance = BuildoutFacet.getInstance((Module)this.myModule);
            if (instance != null) {
                boolean selected = !StringUtil.isEmptyOrSpaces((String)((BuildoutFacetConfiguration)instance.getConfiguration()).getScriptName());
                this.myEnabledCheckbox.setSelected(selected);
                this.mySettingsPanel.setEnabled(selected);
                this.mySettingsPanel.reset();
            } else {
                this.myEnabledCheckbox.setSelected(false);
                this.mySettingsPanel.setEnabled(false);
            }
        }
    }

    private void switchNoticeText() {
        this.mySettingsPanel.showNoticeText(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/buildout/BuildoutConfigurable", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "North");
        this.myEnabledCheckbox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", BuildoutConfigurable.class).getString("buildout.configurable.enable.buildout.support.checkbox.text"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

