/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.AbstractDataStructure;
import org.jetbrains.jetCheck.CannotSatisfyCondition;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.GenerationEnvironment;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.IntData;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.IntSource;
import org.jetbrains.jetCheck.StructureKind;
import org.jetbrains.jetCheck.StructureNode;
import org.jetbrains.jetCheck.WrongDataStructure;

class GenerativeDataStructure
extends AbstractDataStructure {
    private final CurrentData dataTracker;
    private final IntSource random;

    GenerativeDataStructure(IntSource random, StructureNode node, int sizeHint) {
        this(null, random, node, sizeHint);
    }

    private GenerativeDataStructure(@Nullable CurrentData dataTracker, IntSource random, StructureNode node, int sizeHint) {
        super(node, sizeHint);
        this.random = random;
        this.dataTracker = dataTracker != null ? dataTracker : new CurrentData();
    }

    @Override
    int drawInt(@NotNull IntDistribution distribution) {
        this.ensureActiveStructure();
        int i = this.random.drawInt(distribution);
        this.node.addChild(new IntData(this.node.id.childId(null), i, distribution));
        return i;
    }

    void ensureActiveStructure() {
        this.dataTracker.checkContext(this);
    }

    @Override
    public <T> T generate(@NotNull Generator<T> generator) {
        return this.dataTracker.generateOn(generator, this.subStructure(generator, this.childSizeHint()), this);
    }

    @NotNull
    private GenerativeDataStructure subStructure(@NotNull Generator<?> generator, int childSizeHint) {
        return new GenerativeDataStructure(this.dataTracker, this.random, this.node.subStructure(generator), childSizeHint);
    }

    @Override
    <T> T generateNonShrinkable(@NotNull Generator<T> generator) {
        GenerativeDataStructure data = this.subStructure(generator, this.sizeHint);
        data.node.shrinkProhibited = true;
        return this.dataTracker.generateOn(generator, data, this);
    }

    @Override
    <T> T generateConditional(@NotNull Generator<T> generator, @NotNull Predicate<? super T> condition) {
        for (int i = 0; i < 100; ++i) {
            GenerativeDataStructure structure = this.subStructure(generator, this.childSizeHint());
            T value = this.dataTracker.generateOn(generator, structure, this);
            if (condition.test(value)) {
                return value;
            }
            if (this.random instanceof DataSerializer.SerializedIntSource) {
                throw DataSerializer.errorRestoringSerialized();
            }
            this.node.removeLastChild(structure.node);
        }
        throw new CannotSatisfyCondition(condition);
    }

    @Override
    void changeKind(StructureKind kind) {
        if (this.node.kind != StructureKind.GENERIC) {
            throw new IllegalStateException("Attempt to use incompatible generator on a same data structure which is already " + (Object)((Object)this.node.kind));
        }
        this.node.kind = kind;
    }

    private class CurrentData {
        GenerationEnvironment current;

        private CurrentData() {
            this.current = GenerativeDataStructure.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T generateOn(Generator<T> gen, GenerativeDataStructure data, GenerativeDataStructure parent) {
            this.checkContext(parent);
            this.current = data;
            try {
                T t = gen.getGeneratorFunction().apply(data);
                return t;
            }
            finally {
                this.current = parent;
            }
        }

        void checkContext(GenerativeDataStructure data) {
            if (this.current != data) {
                throw new WrongDataStructure();
            }
        }
    }
}

