/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.util.ObjectUtils;
import java.beans.Introspector;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.TestOnly;

public final class GCUtil {
    @TestOnly
    public static void tryGcSoftlyReachableObjects() {
        ReferenceQueue q = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q);
        ObjectUtils.reachabilityFence(ref.get());
        System.gc();
        StringBuilder log = new StringBuilder();
        if (!GCUtil.allocateTonsOfMemory(log, () -> ref.isEnqueued())) {
            System.out.println("GCUtil.tryGcSoftlyReachableObjects: giving up. Log:\n" + log);
        }
        ObjectUtils.reachabilityFence(ref.get());
    }

    static boolean allocateTonsOfMemory(StringBuilder log, BooleanSupplier until) {
        long freeMemory = Runtime.getRuntime().freeMemory();
        log.append("Free memory: " + freeMemory + "\n");
        int liveChunks = 0;
        ReferenceQueue queue = new ReferenceQueue();
        ArrayList<SoftReference<byte[]>> list = new ArrayList<SoftReference<byte[]>>();
        try {
            for (int i = 0; i < 1000 && !until.getAsBoolean(); ++i) {
                while (queue.poll() != null) {
                    --liveChunks;
                }
                int bytes = Math.min((int)(Runtime.getRuntime().totalMemory() / 20L), 0x3FFFFFFF);
                log.append("Iteration " + i + ", allocating new byte[" + bytes + "], live chunks: " + liveChunks + ", free memory: " + Runtime.getRuntime().freeMemory() + "\n");
                list.add(new SoftReference<byte[]>(new byte[bytes], queue));
                ++liveChunks;
                if (i <= 0 || i % 100 != 0 || until.getAsBoolean()) continue;
                log.append("  Calling System.gc()\n");
                System.gc();
            }
        }
        catch (OutOfMemoryError e) {
            int size = list.size();
            list.clear();
            e.printStackTrace();
            System.err.println("Log: " + log + "freeMemory() now: " + Runtime.getRuntime().freeMemory() + "; list.size(): " + size);
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw e;
        }
        finally {
            for (SoftReference softReference : list) {
                softReference.clear();
            }
        }
        return until.getAsBoolean();
    }

    public static void clearBeanInfoCache() {
        Introspector.flushCaches();
    }
}

