/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class FieldCache<T, Owner, AccessorParameter, Parameter> {
    private final ReentrantReadWriteLock.ReadLock r;
    private final ReentrantReadWriteLock.WriteLock w;

    protected FieldCache() {
        ReentrantReadWriteLock ourLock = new ReentrantReadWriteLock();
        this.r = ourLock.readLock();
        this.w = ourLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(AccessorParameter a, Owner owner, Parameter p) {
        T result;
        this.r.lock();
        try {
            result = this.getValue(owner, a);
        }
        finally {
            this.r.unlock();
        }
        if (result == null) {
            this.w.lock();
            try {
                result = this.getValue(owner, a);
                if (result == null) {
                    RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                    result = this.compute(owner, p);
                    if (stamp.mayCacheNow()) {
                        this.putValue(result, owner, a);
                    }
                }
            }
            finally {
                this.w.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getCached(AccessorParameter a, Owner owner) {
        this.r.lock();
        try {
            T t = this.getValue(owner, a);
            return t;
        }
        finally {
            this.r.unlock();
        }
    }

    public void clear(AccessorParameter a, Owner owner) {
        this.w.lock();
        try {
            this.putValue(null, owner, a);
        }
        finally {
            this.w.unlock();
        }
    }

    protected abstract T compute(Owner var1, Parameter var2);

    protected abstract T getValue(Owner var1, AccessorParameter var2);

    protected abstract void putValue(T var1, Owner var2, AccessorParameter var3);
}

