/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SchemaNSDescriptor
extends XmlNSDescriptorImpl {
    @NonNls
    private static final String MIN_OCCURS_ATTR_NAME = "minOccurs";
    @NonNls
    private static final String MAX_OCCURS_ATTR_VALUE = "maxOccurs";
    @NonNls
    private static final String MAX_OCCURS_ATTR_NAME = "maxOccurs";
    @NonNls
    private static final String ID_ATTR_NAME = "id";
    @NonNls
    private static final String REF_ATTR_NAME = "ref";
    @NonNls
    private static final String DEFAULT_ATTR_NAME = "default";
    @NonNls
    private static final String FIXED_ATTR_NAME = "fixed";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    private static final Validator<XmlTag> ELEMENT_VALIDATOR = new Validator<XmlTag>(){

        public void validate(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host) {
            boolean hasRefAttribute;
            if (tag == null) {
                1.$$$reportNull$$$0(0);
            }
            if (host == null) {
                1.$$$reportNull$$$0(1);
            }
            if (!SchemaNSDescriptor.isFromSchemaNs(tag)) {
                return;
            }
            boolean bl = hasRefAttribute = tag.getAttributeValue(SchemaNSDescriptor.REF_ATTR_NAME) != null;
            if (hasRefAttribute) {
                for (XmlAttribute attr : tag.getAttributes()) {
                    String name = attr.getName();
                    if (name.indexOf(58) != -1 || SchemaNSDescriptor.MIN_OCCURS_ATTR_NAME.equals(name) || "maxOccurs".equals(name) || SchemaNSDescriptor.ID_ATTR_NAME.equals(name) || SchemaNSDescriptor.REF_ATTR_NAME.equals(name)) continue;
                    host.addMessage((PsiElement)attr.getNameElement(), XmlPsiBundle.message((String)"xml.schema.validation.attr.not.allowed.with.ref", (Object[])new Object[]{name}), Validator.ValidationHost.ErrorType.ERROR);
                }
            }
            String minOccursValue = tag.getAttributeValue(SchemaNSDescriptor.MIN_OCCURS_ATTR_NAME);
            String maxOccursValue = tag.getAttributeValue("maxOccurs");
            if (minOccursValue != null && maxOccursValue != null) {
                try {
                    int minOccurs = Integer.parseInt(minOccursValue);
                    int maxOccurs = Integer.parseInt(maxOccursValue);
                    if (maxOccurs < minOccurs) {
                        host.addMessage((PsiElement)tag.getAttribute("maxOccurs", null).getValueElement(), XmlPsiBundle.message((String)"xml.schema.validation.max.occurs.should.be.not.less.than.min.occurs", (Object[])new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!hasRefAttribute && tag.getAttributeValue(SchemaNSDescriptor.NAME_ATTR_NAME) == null) {
                host.addMessage((PsiElement)tag, XmlPsiBundle.message((String)"xml.schema.validation.name.or.ref.should.present", (Object[])new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "host";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/impl/schema/SchemaNSDescriptor$1";
            objectArray[2] = "validate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Validator<XmlTag> ATTRIBUTE_VALIDATOR = new Validator<XmlTag>(){

        public void validate(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host) {
            if (tag == null) {
                2.$$$reportNull$$$0(0);
            }
            if (host == null) {
                2.$$$reportNull$$$0(1);
            }
            if (!SchemaNSDescriptor.isFromSchemaNs(tag)) {
                return;
            }
            if (tag.getAttributeValue(SchemaNSDescriptor.REF_ATTR_NAME) == null && tag.getAttributeValue(SchemaNSDescriptor.NAME_ATTR_NAME) == null) {
                host.addMessage((PsiElement)tag, XmlPsiBundle.message((String)"xml.schema.validation.name.or.ref.should.present", (Object[])new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
            }
            if (tag.getAttributeValue(SchemaNSDescriptor.DEFAULT_ATTR_NAME) != null && tag.getAttributeValue(SchemaNSDescriptor.FIXED_ATTR_NAME) != null) {
                host.addMessage((PsiElement)tag.getAttribute(SchemaNSDescriptor.DEFAULT_ATTR_NAME, null).getNameElement(), XmlPsiBundle.message((String)"xml.schema.validation.default.or.fixed.should.be.specified.but.not.both", (Object[])new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
                host.addMessage((PsiElement)tag.getAttribute(SchemaNSDescriptor.FIXED_ATTR_NAME, null).getNameElement(), XmlPsiBundle.message((String)"xml.schema.validation.default.or.fixed.should.be.specified.but.not.both", (Object[])new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "host";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/impl/schema/SchemaNSDescriptor$2";
            objectArray[2] = "validate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final XmlUtil.DuplicationInfoProvider<XmlTag> SCHEMA_ATTR_DUP_INFO_PROVIDER = new XmlUtil.DuplicationInfoProvider<XmlTag>(){

        @Override
        public String getName(@NotNull XmlTag t) {
            if (t == null) {
                3.$$$reportNull$$$0(0);
            }
            return t.getAttributeValue(SchemaNSDescriptor.NAME_ATTR_NAME);
        }

        @Override
        @NotNull
        public String getNameKey(@NotNull XmlTag t, @NotNull String name) {
            if (t == null) {
                3.$$$reportNull$$$0(1);
            }
            if (name == null) {
                3.$$$reportNull$$$0(2);
            }
            String string = name;
            if (string == null) {
                3.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public PsiElement getNodeForMessage(@NotNull XmlTag t) {
            if (t == null) {
                3.$$$reportNull$$$0(4);
            }
            XmlAttributeValue xmlAttributeValue = t.getAttribute(SchemaNSDescriptor.NAME_ATTR_NAME, null).getValueElement();
            if (xmlAttributeValue == null) {
                3.$$$reportNull$$$0(5);
            }
            return xmlAttributeValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = SchemaNSDescriptor.NAME_ATTR_NAME;
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/impl/schema/SchemaNSDescriptor$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/impl/schema/SchemaNSDescriptor$3";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameKey";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeForMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameKey";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeForMessage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final Validator<XmlTag> ELEMENT_AND_ATTR_VALIDATOR = new Validator<XmlTag>(){

        public void validate(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host) {
            if (tag == null) {
                4.$$$reportNull$$$0(0);
            }
            if (host == null) {
                4.$$$reportNull$$$0(1);
            }
            if (!SchemaNSDescriptor.isFromSchemaNs(tag)) {
                return;
            }
            String nsPrefix = tag.getNamespacePrefix();
            XmlTag[] attrDeclTags = tag.findSubTags((String)(nsPrefix.length() > 0 ? nsPrefix + ":" : "") + "attribute");
            XmlUtil.doDuplicationCheckForElements((PsiElement[])attrDeclTags, new HashMap(attrDeclTags.length), SCHEMA_ATTR_DUP_INFO_PROVIDER, (Validator.ValidationHost)host);
            XmlTag[] elementDeclTags = tag.findSubTags((String)(nsPrefix.length() > 0 ? nsPrefix + ":" : "") + "element");
            XmlUtil.doDuplicationCheckForElements((PsiElement[])elementDeclTags, new HashMap(elementDeclTags.length), SCHEMA_ATTR_DUP_INFO_PROVIDER, (Validator.ValidationHost)host);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "host";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xml/impl/schema/SchemaNSDescriptor$4";
            objectArray[2] = "validate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private static boolean isFromSchemaNs(XmlTag tag) {
        return "http://www.w3.org/2001/XMLSchema".equals(tag.getNamespace());
    }

    @Override
    protected XmlElementDescriptor createElementDescriptor(XmlTag tag) {
        XmlElementDescriptor descriptor = super.createElementDescriptor(tag);
        String localName = tag.getAttributeValue(NAME_ATTR_NAME);
        if ("element".equals(localName)) {
            ((XmlElementDescriptorImpl)descriptor).setValidator(ELEMENT_VALIDATOR);
        } else if ("complexType".equals(localName) || "schema".equals(localName) || "sequence".equals(localName)) {
            ((XmlElementDescriptorImpl)descriptor).setValidator(ELEMENT_AND_ATTR_VALIDATOR);
        } else if ("attribute".equals(localName)) {
            ((XmlElementDescriptorImpl)descriptor).setValidator(ATTRIBUTE_VALIDATOR);
        }
        return descriptor;
    }

    public String toString() {
        return this.getDefaultNamespace();
    }
}

