/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.conda;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.conda.InstallCondaUtils;
import com.jetbrains.python.conda.PythonMinicondaLocator;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170\u0016H\u0007J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u00020\u00078FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/conda/InstallCondaUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "defaultDirectoryFile", "Ljava/io/File;", "getDefaultDirectoryFile$annotations", "getDefaultDirectoryFile", "()Ljava/io/File;", "defaultDirectoryFile$delegate", "Lkotlin/Lazy;", "beatifyPath", "", "path", "checkPath", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "installationHandler", "Lcom/intellij/execution/process/CapturingProcessHandler;", "indicationFunction", "Lkotlin/Function1;", "", "checkCondaWrite", "", "intellij.pycharm.community"})
public final class InstallCondaUtils {
    private static final Logger LOG;
    @NotNull
    private static final Lazy defaultDirectoryFile$delegate;
    public static final InstallCondaUtils INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getDefaultDirectoryFile$annotations() {
    }

    @NotNull
    public static final File getDefaultDirectoryFile() {
        Lazy lazy = defaultDirectoryFile$delegate;
        InstallCondaUtils installCondaUtils = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final CapturingProcessHandler installationHandler(@NotNull String path, @NotNull Function1<? super String, Unit> indicationFunction) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(indicationFunction, (String)"indicationFunction");
        CapturingProcessHandler handler = new CapturingProcessHandler(INSTANCE.getCommandLine(path));
        handler.addProcessListener((ProcessListener)new ProcessAdapter(indicationFunction){
            final /* synthetic */ Function1 $indicationFunction;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                    String[] stringArray = StringUtil.splitByLines((String)event.getText());
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String line;
                        String string = line = stringArray[i];
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line");
                        this.$indicationFunction.invoke((Object)string);
                    }
                }
            }
            {
                this.$indicationFunction = $captured_local_variable$0;
            }
        });
        return handler;
    }

    @JvmStatic
    @NotNull
    public static final String beatifyPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!SystemInfo.isWindows && !StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            CharSequence charSequence = path;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                String string;
                String string2 = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SystemProperties.getUserHome()");
                String home = string2;
                if (StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null)) {
                    StringBuilder stringBuilder = new StringBuilder().append(home);
                    String string3 = path;
                    int n = 1;
                    boolean bl2 = false;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    string = stringBuilder.append(string4).toString();
                } else {
                    String string5 = new File(home, path).getAbsolutePath();
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"File(home, path).absolutePath");
                }
                return string;
            }
        }
        return path;
    }

    private final boolean checkCondaWrite(File $this$checkCondaWrite) {
        boolean bl;
        if ($this$checkCondaWrite.exists()) {
            bl = $this$checkCondaWrite.canWrite();
        } else {
            File file = $this$checkCondaWrite.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parentFile");
            bl = this.checkCondaWrite(file);
        }
        return bl;
    }

    private final GeneralCommandLine getCommandLine(String path) {
        GeneralCommandLine generalCommandLine;
        String string = PythonMinicondaLocator.INSTANCE.getMinicondaInstallerPath();
        Intrinsics.checkNotNull((Object)string);
        String installerPath = string;
        if (SystemInfo.isWindows) {
            generalCommandLine = new GeneralCommandLine(new String[]{installerPath, "/InstallationType=JustMe", "/AddToPath=0", "/RegisterPython=0", "/S", "/D=" + path});
        } else if (SystemInfo.isLinux || SystemInfo.isMac) {
            generalCommandLine = new GeneralCommandLine(new String[]{"bash", installerPath, "-b", "-p", path});
        } else {
            LOG.error(SystemInfo.OS_NAME + " isn't expected as a operation system");
            throw (Throwable)new IllegalArgumentException("OS " + SystemInfo.OS_NAME + " isn't supported for Miniconda installation");
        }
        return generalCommandLine;
    }

    @JvmStatic
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static final String checkPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.isBlank((CharSequence)path)) {
            return ActionsBundle.message((String)"action.SetupMiniconda.installDirectoryMissing", (Object[])new Object[0]);
        }
        File pathFile = new File(path);
        if (pathFile.exists()) {
            return ActionsBundle.message((String)"action.SetupMiniconda.installDirectoryIsNotEmpty", (Object[])new Object[]{path});
        }
        if (!INSTANCE.checkCondaWrite(pathFile)) {
            return ActionsBundle.message((String)"action.SetupMiniconda.canNotWriteToInstallationDirectory", (Object[])new Object[]{path});
        }
        if (!PythonMinicondaLocator.isInstallerExists()) {
            return ActionsBundle.message((String)"action.SetupMiniconda.installerMissing", (Object[])new Object[0]);
        }
        return null;
    }

    private InstallCondaUtils() {
    }

    static {
        InstallCondaUtils installCondaUtils;
        INSTANCE = installCondaUtils = new InstallCondaUtils();
        Logger logger = Logger.getInstance(InstallCondaUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(InstallCondaUtils::class.java)");
        LOG = logger;
        defaultDirectoryFile$delegate = LazyKt.lazy((Function0)defaultDirectoryFile.2.INSTANCE);
    }
}

