# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2020 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vcenter.namespaces.
#---------------------------------------------------------------------------

"""
The ``com.vmware.vcenter.namespaces_client`` module provides classes for
managing namespaces related methods.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Container(VapiStruct):
    """
    A ``Container`` holds the data that describes a container within a pod.
    **Note:** This class is restricted for **VMware internal use only**.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 name=None,
                 image=None,
                 status=None,
                 started_at=None,
                 finished_at=None,
                 reason=None,
                ):
        """
        :type  name: :class:`str`
        :param name: The name of the container.
        :type  image: :class:`str`
        :param image: The image the container is running.
        :type  status: :class:`str`
        :param status: The container's current condition.
        :type  started_at: :class:`str`
        :param started_at: Time at which the container was last (re-)started.
        :type  finished_at: :class:`str`
        :param finished_at: Time at which the container last terminated.
        :type  reason: :class:`str`
        :param reason: Details about the container's current condition, if any.
        """
        self.name = name
        self.image = image
        self.status = status
        self.started_at = started_at
        self.finished_at = finished_at
        self.reason = reason
        VapiStruct.__init__(self)


Container._set_binding_type(type.StructType(
    'com.vmware.vcenter.namespaces.container', {
        'name': type.StringType(),
        'image': type.StringType(),
        'status': type.StringType(),
        'started_at': type.StringType(),
        'finished_at': type.StringType(),
        'reason': type.StringType(),
    },
    Container,
    False,
    None))



class EndpointAddress(VapiStruct):
    """
    An ``EndpointAddress`` contains the data that describes an Endpoint's
    address in Kubernetes.
    **Note:** This class is restricted for **VMware internal use only**.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 service=None,
                 ip=None,
                 port=None,
                 protocol=None,
                ):
        """
        :type  service: :class:`str`
        :param service: The Kubernetes Service the Endpoint belongs to.
        :type  ip: :class:`str`
        :param ip: The IP address of the Endpoint.
        :type  port: :class:`long`
        :param port: The port of the Endpoint.
        :type  protocol: :class:`str`
        :param protocol: The protocol used by this Endpoint.
        """
        self.service = service
        self.ip = ip
        self.port = port
        self.protocol = protocol
        VapiStruct.__init__(self)


EndpointAddress._set_binding_type(type.StructType(
    'com.vmware.vcenter.namespaces.endpoint_address', {
        'service': type.StringType(),
        'ip': type.StringType(),
        'port': type.IntegerType(),
        'protocol': type.StringType(),
    },
    EndpointAddress,
    False,
    None))



class IngressRuleValue(VapiStruct):
    """
    An ``IngressRuleValue`` contains the data that describes an Ingress rule in
    Kubernetes.
    **Note:** This class is restricted for **VMware internal use only**.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 host=None,
                 path=None,
                 name=None,
                 port=None,
                ):
        """
        :type  host: :class:`str`
        :param host: The Ingress's host.
        :type  path: :class:`str`
        :param path: The Ingress's path filter.
        :type  name: :class:`str`
        :param name: The Ingress's name.
        :type  port: :class:`long`
        :param port: The Ingress's service port.
        """
        self.host = host
        self.path = path
        self.name = name
        self.port = port
        VapiStruct.__init__(self)


IngressRuleValue._set_binding_type(type.StructType(
    'com.vmware.vcenter.namespaces.ingress_rule_value', {
        'host': type.StringType(),
        'path': type.StringType(),
        'name': type.StringType(),
        'port': type.IntegerType(),
    },
    IngressRuleValue,
    False,
    None))



class ResourceQuotaOptionsV1(VapiStruct):
    """
    The ``ResourceQuotaOptionsV1`` class represents the resource quota limits
    which can be applied on the namespace. Refer to `
    <https://kubernetes.io/docs/concepts/policy/resource-quotas>`_ for
    information related to the properties of this object and what they map to.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 memory_limit=None,
                 memory_limit_default=None,
                 memory_request_default=None,
                 cpu_limit=None,
                 cpu_limit_default=None,
                 cpu_request_default=None,
                 storage_request_limit=None,
                 pod_count=None,
                 service_count=None,
                 deployment_count=None,
                 daemon_set_count=None,
                 replica_set_count=None,
                 replication_controller_count=None,
                 stateful_set_count=None,
                 config_map_count=None,
                 secret_count=None,
                 persistent_volume_claim_count=None,
                 job_count=None,
                ):
        """
        :type  memory_limit: :class:`long` or ``None``
        :param memory_limit: This is equivalent to 'limits.memory' option which is the maximum
            memory limit (in mebibytes) across all pods which exist in a
            non-terminal state in the namespace. This value translates to the
            memory limit on the ResourcePool in vCenter Server created for the
            namespace.
            If None, no memory limits are set on the ResourcePool for the
            namespace.
        :type  memory_limit_default: :class:`long` or ``None``
        :param memory_limit_default: This represents the default memory limit (in mebibytes) for
            containers in the pod. This translates to default memory limit in a
            LimitRange object. Refer ` for information about LimitRange.
            <https://kubernetes.io/docs/tasks/administer-cluster/manage-resources/memory-default-namespace/>`_
            If None, no default memory limits are set on containers in the pod.
        :type  memory_request_default: :class:`long` or ``None``
        :param memory_request_default: This represents the default memory request (in mebibytes) for
            containers in the pod. This translates to default memory request in
            a LimitRange object. Refer ` for information about LimitRange.
            <https://kubernetes.io/docs/tasks/administer-cluster/manage-resources/memory-default-namespace/>`_
            If None, no default memory requests are set on containers in the
            pod.
        :type  cpu_limit: :class:`long` or ``None``
        :param cpu_limit: This is equivalent to 'limits.cpu' option which is the maximum CPU
            limit (in MHz) across all pods which exist in a non-terminal state
            in the namespace. If specified, this limit should be at least 10
            MHz. This value translates to the CPU limit on the ResourcePool in
            vCenter Server created for the namespace.
            If None, no CPU limits are set on the ResourcePool for the
            namespace.
        :type  cpu_limit_default: :class:`long` or ``None``
        :param cpu_limit_default: This represents the default cpu limit (in MHz) for containers in
            the pod.
            If None, no default CPU limits are set on containers in the pod.
            Refer ` for information about LimitRange. If specified, this limit
            should be at least 10 MHz.
            <https://kubernetes.io/docs/tasks/administer-cluster/manage-resources/memory-default-namespace/>`_
        :type  cpu_request_default: :class:`long` or ``None``
        :param cpu_request_default: This represents the default CPU request (in MHz) for containers in
            the pod.
            If None, no default CPU requests are set on containers in the pod.
            Refer ` for information about LimitRange. If specified, this field
            should be at least 10 MHz.
            <https://kubernetes.io/docs/tasks/administer-cluster/manage-resources/cpu-default-namespace/>`_
        :type  storage_request_limit: :class:`long` or ``None``
        :param storage_request_limit: This represents 'requests.storage' option which is the maximum
            storage request (in mebibytes) across all persistent volume claims
            from pods which exist in a non-terminal state in the namespace.
            If None, no storage request limits are set on the namespace.
        :type  pod_count: :class:`long` or ``None``
        :param pod_count: This represents 'pods' option which is the maximum number of pods
            which exist in a non-terminal state in the namespace.
            If None, no pod limits are set on the namespace.
        :type  service_count: :class:`long` or ``None``
        :param service_count: This represents 'count/services' option which is the maximum number
            of services in the namespace.
            If None, no service limits are set on the namespace.
        :type  deployment_count: :class:`long` or ``None``
        :param deployment_count: This represents 'count/deployments.apps' option which is the
            maximum number of deployments in the namespace.
            If None, no deployment limits are set on the namespace.
        :type  daemon_set_count: :class:`long` or ``None``
        :param daemon_set_count: This represents 'count/daemonsets.apps' option which is the maximum
            number of DaemonSets in the namespace.
            If None, no daemonset limits are set on the namespace.
        :type  replica_set_count: :class:`long` or ``None``
        :param replica_set_count: This represents 'count/replicasets.apps' option which is the
            maximum number of ReplicaSets in the namespace.
            If None, no replicaset limits are set on the namespace.
        :type  replication_controller_count: :class:`long` or ``None``
        :param replication_controller_count: This represents 'count/replicationcontrollers' option which is the
            maximum number of ReplicationControllers in the namespace.
            If None, no replicationcontroller limits are set on the namespace.
        :type  stateful_set_count: :class:`long` or ``None``
        :param stateful_set_count: This represents 'count/statefulsets.apps' option which is the
            maximum number of StatefulSets in the namespace.
            If None, no statefulset limits are set on the namespace.
        :type  config_map_count: :class:`long` or ``None``
        :param config_map_count: This represents 'count/configmaps' option which is the maximum
            number of ConfigMaps in the namespace.
            If None, no configmap limits are set on the namespace.
        :type  secret_count: :class:`long` or ``None``
        :param secret_count: This represents 'count/secrets' option which is the maximum number
            of secrets in the namespace.
            If None, no secret limits are set on the namespace.
        :type  persistent_volume_claim_count: :class:`long` or ``None``
        :param persistent_volume_claim_count: This represents 'count/persistentvolumeclaims' option which is the
            maximum number of PersistentVolumeClaims in the namespace.
            If None, no persistentvolumeclaim limits are set on the namespace.
        :type  job_count: :class:`long` or ``None``
        :param job_count: This represents 'count/jobs.batch' option which is the maximum
            number jobs in the namespace.
            If None, no job limits are set on the namespace.
        """
        self.memory_limit = memory_limit
        self.memory_limit_default = memory_limit_default
        self.memory_request_default = memory_request_default
        self.cpu_limit = cpu_limit
        self.cpu_limit_default = cpu_limit_default
        self.cpu_request_default = cpu_request_default
        self.storage_request_limit = storage_request_limit
        self.pod_count = pod_count
        self.service_count = service_count
        self.deployment_count = deployment_count
        self.daemon_set_count = daemon_set_count
        self.replica_set_count = replica_set_count
        self.replication_controller_count = replication_controller_count
        self.stateful_set_count = stateful_set_count
        self.config_map_count = config_map_count
        self.secret_count = secret_count
        self.persistent_volume_claim_count = persistent_volume_claim_count
        self.job_count = job_count
        VapiStruct.__init__(self)


ResourceQuotaOptionsV1._set_binding_type(type.StructType(
    'com.vmware.vcenter.namespaces.resource_quota_options_v1', {
        'memory_limit': type.OptionalType(type.IntegerType()),
        'memory_limit_default': type.OptionalType(type.IntegerType()),
        'memory_request_default': type.OptionalType(type.IntegerType()),
        'cpu_limit': type.OptionalType(type.IntegerType()),
        'cpu_limit_default': type.OptionalType(type.IntegerType()),
        'cpu_request_default': type.OptionalType(type.IntegerType()),
        'storage_request_limit': type.OptionalType(type.IntegerType()),
        'pod_count': type.OptionalType(type.IntegerType()),
        'service_count': type.OptionalType(type.IntegerType()),
        'deployment_count': type.OptionalType(type.IntegerType()),
        'daemon_set_count': type.OptionalType(type.IntegerType()),
        'replica_set_count': type.OptionalType(type.IntegerType()),
        'replication_controller_count': type.OptionalType(type.IntegerType()),
        'stateful_set_count': type.OptionalType(type.IntegerType()),
        'config_map_count': type.OptionalType(type.IntegerType()),
        'secret_count': type.OptionalType(type.IntegerType()),
        'persistent_volume_claim_count': type.OptionalType(type.IntegerType()),
        'job_count': type.OptionalType(type.IntegerType()),
    },
    ResourceQuotaOptionsV1,
    False,
    None))



class ResourceQuotaOptionsV1Update(VapiStruct):
    """
    The ``ResourceQuotaOptionsV1Update`` class represents the changes to
    resource quota limits which are set on the namespace. Refer to ` <\a>
    Kubernetes Resource Quota
    <https://kubernetes.io/docs/concepts/policy/resource-quotas>`_ for
    information related to the properties of this object and what they map to.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 memory_limit=None,
                 memory_limit_unset=None,
                 memory_limit_default=None,
                 memory_limit_default_unset=None,
                 memory_request_default=None,
                 memory_request_default_unset=None,
                 cpu_limit=None,
                 cpu_limit_unset=None,
                 cpu_limit_default=None,
                 cpu_limit_default_unset=None,
                 cpu_request_default=None,
                 cpu_request_default_unset=None,
                 storage_request_limit=None,
                 storage_request_limit_unset=None,
                 pod_count=None,
                 pod_count_unset=None,
                 service_count=None,
                 service_count_unset=None,
                 deployment_count=None,
                 deployment_count_unset=None,
                 daemon_set_count=None,
                 daemon_set_count_unset=None,
                 replica_set_count=None,
                 replica_set_count_unset=None,
                 replication_controller_count=None,
                 replication_controller_count_unset=None,
                 stateful_set_count=None,
                 stateful_set_count_unset=None,
                 config_map_count=None,
                 config_map_count_unset=None,
                 secret_count=None,
                 secret_count_unset=None,
                 persistent_volume_claim_count=None,
                 persistent_volume_claim_count_unset=None,
                 job_count=None,
                 job_count_unset=None,
                ):
        """
        :type  memory_limit: :class:`long` or ``None``
        :param memory_limit: This represents the new value for 'limits.memory' option which is
            equivalent to the maximum memory limit (in mebibytes) across all
            pods in the namespace. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.memory_limit_unset` is set to
            ``true``.
            If None, the existing memory limit on the ResourcePool will be
            unchanged if
            :attr:`ResourceQuotaOptionsV1Update.memory_limit_unset` is None or
            set to ``false``.
        :type  memory_limit_unset: :class:`bool` or ``None``
        :param memory_limit_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.memory_limit`. If this field is
            set to ``true``, the existing memory limit on the ResourcePool is
            removed. If this field is set to ``false``, the existing memory
            limit will be changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.memory_limit`, if any.
            If None, the existing memory limit will be changed to the value
            specified in :attr:`ResourceQuotaOptionsV1Update.memory_limit`, if
            any.
        :type  memory_limit_default: :class:`long` or ``None``
        :param memory_limit_default: This represents the new value for the default memory limit (in
            mebibytes) for containers in the pod. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.memory_limit_default_unset` is
            set to ``true``.
            If None, the existing memory limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.memory_limit_default_unset` is
            None or set to ``false``.
        :type  memory_limit_default_unset: :class:`bool` or ``None``
        :param memory_limit_default_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.memory_limit_default`. If this
            field is set to ``true``, the existing default memory limit on
            containers in the pod is removed. If this field is set to
            ``false``, the existing default memory limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.memory_limit_default`, if any.
            If None, the existing default memory limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.memory_limit_default`, if any.
        :type  memory_request_default: :class:`long` or ``None``
        :param memory_request_default: This represents the new value for the default memory request (in
            mebibytes) for containers in the pod. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.memory_request_default_unset`
            is set to ``true``.
            If None, the existing memory request will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.memory_request_default_unset`
            is None or set to ``false``.
        :type  memory_request_default_unset: :class:`bool` or ``None``
        :param memory_request_default_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.memory_request_default`. If
            this field is set to ``true``, the existing default memory request
            on containers in the pod will be removed. If this field is set to
            ``false``, the existing default memory request will be changed to
            the value specified in
            :attr:`ResourceQuotaOptionsV1Update.memory_request_default`, if
            any.
            If None, the existing default memory request will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.memory_request_default`, if
            any.
        :type  cpu_limit: :class:`long` or ``None``
        :param cpu_limit: This represents the new value for 'limits.cpu' option which is
            equivalent to the maximum CPU limit (in MHz) across all pods in the
            namespace. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit_unset` is set to
            ``true``. If specified, this limit should be at least 10 MHz.
            If None, the existing CPU limit on the ResourcePool will be
            unchanged if :attr:`ResourceQuotaOptionsV1Update.cpu_limit_unset`
            is None or set to ``false``.
        :type  cpu_limit_unset: :class:`bool` or ``None``
        :param cpu_limit_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit`. If this field is
            set to ``true``, the existing CPU limit on the ResourcePool is
            removed. If this field is set to ``false``, the existing CPU limit
            will be changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit`, if any.
            If None, the existing CPU limit will be changed to the value
            specified in :attr:`ResourceQuotaOptionsV1Update.memory_limit`, if
            any.
        :type  cpu_limit_default: :class:`long` or ``None``
        :param cpu_limit_default: This represents the new value for the default CPU limit (in Mhz)
            for containers in the pod. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit_default_unset` is set
            to ``true``. If specified, this limit should be at least 10 MHz.
            If None, the existing default CPU limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit_default_unset` is
            None or set to ``false``.
        :type  cpu_limit_default_unset: :class:`bool` or ``None``
        :param cpu_limit_default_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit_default`. If this
            field is set to ``true``, the existing default CPU limit on
            containers in the pod is removed. If this field is set to
            ``false``, the existing default CPU limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit_default`, if any.
            If None, the existing default CPU limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.cpu_limit_default`, if any.
        :type  cpu_request_default: :class:`long` or ``None``
        :param cpu_request_default: This represents the new value for the default CPU request (in Mhz)
            for containers in the pod. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.cpu_request_default_unset` is
            set to ``true``. If specified, this field should be at least 10
            MHz.
            If None, the existing default CPU request will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.cpu_request_default_unset` is
            None or set to ``false``.
        :type  cpu_request_default_unset: :class:`bool` or ``None``
        :param cpu_request_default_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.cpu_request_default`. If this
            field is set to ``true``, the existing default CPU request on
            containers in the pod is removed. If this field is set to
            ``false``, the existing default CPU request will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.cpu_request_default`, if any.
            If None, the existing default CPU request will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.cpu_request_default`, if any.
        :type  storage_request_limit: :class:`long` or ``None``
        :param storage_request_limit: This represents the new value for 'requests.storage' which is the
            limit on storage requests (in mebibytes) across all persistent
            volume claims from pods in the namespace. This field is ignored if
            if :attr:`ResourceQuotaOptionsV1Update.storage_request_limit_unset`
            is set to ``true``.
            If None, the existing storage request limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.storage_request_limit_unset` is
            None or set to ``false``. the namespace.
        :type  storage_request_limit_unset: :class:`bool` or ``None``
        :param storage_request_limit_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.storage_request_limit`. If this
            field is set to ``true``, the existing storage request limit will
            be reset. If this field is set to ``false``, the existing storage
            request limit will be changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.storage_request_limit`, if any.
            If None, the existing storage request limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.storage_request_limit`, if any.
        :type  pod_count: :class:`long` or ``None``
        :param pod_count: This represents the new value for 'podCount' option which is the
            maximum number of pods in the namespace. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.pod_count_unset` is set to
            ``true``.
            If None, the existing 'podCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.pod_count_unset` is None or set
            to ``false``.
        :type  pod_count_unset: :class:`bool` or ``None``
        :param pod_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.pod_count`. If this field is
            set to ``true``, the existing 'podCount' limit on the namespace
            will be reset. If this field is set to ``false``, the existing CPU
            limit will be changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.pod_count`, if any.
            If None, the existing 'podCount' limit will be changed to the value
            specified in :attr:`ResourceQuotaOptionsV1Update.pod_count`, if
            any.
        :type  service_count: :class:`long` or ``None``
        :param service_count: This represents the new value for 'serviceCount' option which is
            the maximum number of services in the namespace. This field is
            ignored if :attr:`ResourceQuotaOptionsV1Update.service_count_unset`
            is set to ``true``.
            If None, the existing 'serviceCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.service_count_unset` is None or
            set to ``false``.
        :type  service_count_unset: :class:`bool` or ``None``
        :param service_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.service_count`. If this field
            is set to ``true``, the existing 'serviceCount' limit on the
            namespace will be reset. If this field is set to ``false``, the
            existing service count limit will be changed to the value specified
            in :attr:`ResourceQuotaOptionsV1Update.service_count`, if any.
            If None, the existing 'serviceCount' limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.service_count`, if any.
        :type  deployment_count: :class:`long` or ``None``
        :param deployment_count: This represents the new value for 'deploymentCount' option which is
            the maximum number of deployments in the namespace. This field is
            ignored if
            :attr:`ResourceQuotaOptionsV1Update.deployment_count_unset` is set
            to ``true``.
            If None, the existing 'deploymentCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.deployment_count_unset` is None
            or set to ``false``.
        :type  deployment_count_unset: :class:`bool` or ``None``
        :param deployment_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.deployment_count`. If this
            field is set to ``true``, the existing 'deploymentCount' limit on
            the namespace will be reset. If this field is set to ``false``, the
            existing deployment count limit will be changed to the value
            specified in :attr:`ResourceQuotaOptionsV1Update.deployment_count`,
            if any.
            If None, the existing 'deploymentCount' limit will be changed to
            the value specified in
            :attr:`ResourceQuotaOptionsV1Update.deployment_count`, if any.
        :type  daemon_set_count: :class:`long` or ``None``
        :param daemon_set_count: This represents the new value for 'daemonSetCount' option which is
            the maximum number of DaemonSets in the namespace. This field is
            ignored if
            :attr:`ResourceQuotaOptionsV1Update.daemon_set_count_unset` is set
            to ``true``.
            If None, the existing 'daemonSetCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.daemon_set_count_unset` is None
            or set to ``false``.
        :type  daemon_set_count_unset: :class:`bool` or ``None``
        :param daemon_set_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.daemon_set_count`. If this
            field is set to ``true``, the existing 'daemonSetCount' limit on
            the namespace will be reset. If this field is set to ``false``, the
            existing daemonset count limit will be changed to the value
            specified in :attr:`ResourceQuotaOptionsV1Update.daemon_set_count`,
            if any.
            If None, the existing 'daemonSetCount' limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.daemon_set_count`, if any.
        :type  replica_set_count: :class:`long` or ``None``
        :param replica_set_count: This represents the new value for 'replicaSetCount' option which is
            the maximum number of ReplicaSets in the namespace. This field is
            ignored if
            :attr:`ResourceQuotaOptionsV1Update.replica_set_count_unset` is set
            to ``true``.
            If None, the existing 'replicaSetCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.replica_set_count_unset` is
            None or set to ``false``.
        :type  replica_set_count_unset: :class:`bool` or ``None``
        :param replica_set_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.replica_set_count`. If this
            field is set to ``true``, the existing 'replicaSetCount' limit on
            the namespace will be reset. If this field is set to ``false``, the
            existing replicaset count limit will be changed to the value
            specified in
            :attr:`ResourceQuotaOptionsV1Update.replica_set_count`, if any.
            If None, the existing 'replicaSetCount' limit will be changed to
            the value specified in
            :attr:`ResourceQuotaOptionsV1Update.replica_set_count`, if any.
        :type  replication_controller_count: :class:`long` or ``None``
        :param replication_controller_count: This represents the new value for 'replicationControllerCount'
            option which is the maximum number of ReplicationControllers in the
            namespace. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.replication_controller_count_unset`
            is set to ``true``.
            If None, the existing 'replicationControllerCount' limit will be
            unchanged if
            :attr:`ResourceQuotaOptionsV1Update.replication_controller_count_unset`
            is None or set to ``false``.
        :type  replication_controller_count_unset: :class:`bool` or ``None``
        :param replication_controller_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.replication_controller_count`.
            If this field is set to ``true``, the existing
            'replicationControllerCount' limit on the namespace will be reset.
            If this field is set to ``false``, the existing
            replicationcontroller count limit will be changed to the value
            specified in
            :attr:`ResourceQuotaOptionsV1Update.replication_controller_count`,
            if any.
            If None, the existing 'replicationControllerCount' limit will be
            changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.replication_controller_count`,
            if any.
        :type  stateful_set_count: :class:`long` or ``None``
        :param stateful_set_count: This represents the new value for 'statefulSetCount' option which
            is the maximum number of StatefulSets in the namespace. This field
            is ignored if
            :attr:`ResourceQuotaOptionsV1Update.stateful_set_count_unset` is
            set to ``true``.
            If None, the existing 'statefulSetCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.stateful_set_count_unset` is
            None or set to ``false``.
        :type  stateful_set_count_unset: :class:`bool` or ``None``
        :param stateful_set_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.stateful_set_count`. If this
            field is set to ``true``, the existing 'statefulSetCount' limit on
            the namespace will be reset. If this field is set to ``false``, the
            existing statefulset count limit will be changed to the value
            specified in
            :attr:`ResourceQuotaOptionsV1Update.stateful_set_count`, if any.
            If None, the existing 'statefulSetCount' limit will be changed to
            the value specified in
            :attr:`ResourceQuotaOptionsV1Update.stateful_set_count`, if any.
        :type  config_map_count: :class:`long` or ``None``
        :param config_map_count: This represents the new value for 'configMapCount' option which is
            the maximum number of ConfigMaps in the namespace. This field is
            ignored if
            :attr:`ResourceQuotaOptionsV1Update.config_map_count_unset` is set
            to ``true``.
            If None, the existing 'configMapCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.config_map_count_unset` is None
            or set to ``false``.
        :type  config_map_count_unset: :class:`bool` or ``None``
        :param config_map_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.config_map_count`. If this
            field is set to ``true``, the existing 'configMapCount' limit on
            the namespace will be reset. If this field is set to ``false``, the
            existing configmap count limit will be changed to the value
            specified in :attr:`ResourceQuotaOptionsV1Update.config_map_count`,
            if any.
            If None, the existing 'configMapCount' limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.config_map_count`, if any.
        :type  secret_count: :class:`long` or ``None``
        :param secret_count: This represents the new value for 'secretCount' option which is the
            maximum number of secrets in the namespace. This field is ignored
            if :attr:`ResourceQuotaOptionsV1Update.secret_count_unset` is set
            to ``true``.
            If None, the existing 'secretCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.secret_count_unset` is None or
            set to ``false``.
        :type  secret_count_unset: :class:`bool` or ``None``
        :param secret_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.secret_count`. If this field is
            set to ``true``, the existing 'secretCount' limit on the namespace
            will be reset. If this field is set to ``false``, the existing
            secret count limit will be changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.secret_count`, if any.
            If None, the existing 'secretCount' limit will be changed to the
            value specified in
            :attr:`ResourceQuotaOptionsV1Update.secret_count`, if any.
        :type  persistent_volume_claim_count: :class:`long` or ``None``
        :param persistent_volume_claim_count: This represents the new value for 'persistentVolumeClaimCount'
            option which is the maximum number of PersistentVolumeClaims in the
            namespace. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.persistent_volume_claim_count_unset`
            is set to ``true``.
            If None, the existing 'persistentVolumeClaimCount' limit will be
            unchanged if
            :attr:`ResourceQuotaOptionsV1Update.persistent_volume_claim_count_unset`
            is None or set to ``false``.
        :type  persistent_volume_claim_count_unset: :class:`bool` or ``None``
        :param persistent_volume_claim_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.persistent_volume_claim_count`.
            If this field is set to ``true``, the existing
            'persistentVolumeClaimCount' limit on the namespace will be reset.
            If this field is set to ``false``, the existing
            replicationcontroller count limit will be changed to the value
            specified in
            :attr:`ResourceQuotaOptionsV1Update.persistent_volume_claim_count`,
            if any.
            If None, the existing 'persistentVolumeClaimCount' limit will be
            changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.persistent_volume_claim_count`,
            if any.
        :type  job_count: :class:`long` or ``None``
        :param job_count: This represents the new value for 'jobCount' option which is the
            maximum number of jobs in the namespace. This field is ignored if
            :attr:`ResourceQuotaOptionsV1Update.job_count_unset` is set to
            ``true``.
            If None, the existing 'jobCount' limit will be unchanged if
            :attr:`ResourceQuotaOptionsV1Update.job_count_unset` is None or set
            to ``false``.
        :type  job_count_unset: :class:`bool` or ``None``
        :param job_count_unset: This represents the intent of the change to
            :attr:`ResourceQuotaOptionsV1Update.job_count`. If this field is
            set to ``true``, the existing 'jobCount' limit on the namespace
            will be reset. If this field is set to ``false``, the existing
            secret count limit will be changed to the value specified in
            :attr:`ResourceQuotaOptionsV1Update.job_count`, if any.
            If None, the existing 'jobCount' limit will be changed to the value
            specified in :attr:`ResourceQuotaOptionsV1Update.job_count`, if
            any.
        """
        self.memory_limit = memory_limit
        self.memory_limit_unset = memory_limit_unset
        self.memory_limit_default = memory_limit_default
        self.memory_limit_default_unset = memory_limit_default_unset
        self.memory_request_default = memory_request_default
        self.memory_request_default_unset = memory_request_default_unset
        self.cpu_limit = cpu_limit
        self.cpu_limit_unset = cpu_limit_unset
        self.cpu_limit_default = cpu_limit_default
        self.cpu_limit_default_unset = cpu_limit_default_unset
        self.cpu_request_default = cpu_request_default
        self.cpu_request_default_unset = cpu_request_default_unset
        self.storage_request_limit = storage_request_limit
        self.storage_request_limit_unset = storage_request_limit_unset
        self.pod_count = pod_count
        self.pod_count_unset = pod_count_unset
        self.service_count = service_count
        self.service_count_unset = service_count_unset
        self.deployment_count = deployment_count
        self.deployment_count_unset = deployment_count_unset
        self.daemon_set_count = daemon_set_count
        self.daemon_set_count_unset = daemon_set_count_unset
        self.replica_set_count = replica_set_count
        self.replica_set_count_unset = replica_set_count_unset
        self.replication_controller_count = replication_controller_count
        self.replication_controller_count_unset = replication_controller_count_unset
        self.stateful_set_count = stateful_set_count
        self.stateful_set_count_unset = stateful_set_count_unset
        self.config_map_count = config_map_count
        self.config_map_count_unset = config_map_count_unset
        self.secret_count = secret_count
        self.secret_count_unset = secret_count_unset
        self.persistent_volume_claim_count = persistent_volume_claim_count
        self.persistent_volume_claim_count_unset = persistent_volume_claim_count_unset
        self.job_count = job_count
        self.job_count_unset = job_count_unset
        VapiStruct.__init__(self)


ResourceQuotaOptionsV1Update._set_binding_type(type.StructType(
    'com.vmware.vcenter.namespaces.resource_quota_options_v1_update', {
        'memory_limit': type.OptionalType(type.IntegerType()),
        'memory_limit_unset': type.OptionalType(type.BooleanType()),
        'memory_limit_default': type.OptionalType(type.IntegerType()),
        'memory_limit_default_unset': type.OptionalType(type.BooleanType()),
        'memory_request_default': type.OptionalType(type.IntegerType()),
        'memory_request_default_unset': type.OptionalType(type.BooleanType()),
        'cpu_limit': type.OptionalType(type.IntegerType()),
        'cpu_limit_unset': type.OptionalType(type.BooleanType()),
        'cpu_limit_default': type.OptionalType(type.IntegerType()),
        'cpu_limit_default_unset': type.OptionalType(type.BooleanType()),
        'cpu_request_default': type.OptionalType(type.IntegerType()),
        'cpu_request_default_unset': type.OptionalType(type.BooleanType()),
        'storage_request_limit': type.OptionalType(type.IntegerType()),
        'storage_request_limit_unset': type.OptionalType(type.BooleanType()),
        'pod_count': type.OptionalType(type.IntegerType()),
        'pod_count_unset': type.OptionalType(type.BooleanType()),
        'service_count': type.OptionalType(type.IntegerType()),
        'service_count_unset': type.OptionalType(type.BooleanType()),
        'deployment_count': type.OptionalType(type.IntegerType()),
        'deployment_count_unset': type.OptionalType(type.BooleanType()),
        'daemon_set_count': type.OptionalType(type.IntegerType()),
        'daemon_set_count_unset': type.OptionalType(type.BooleanType()),
        'replica_set_count': type.OptionalType(type.IntegerType()),
        'replica_set_count_unset': type.OptionalType(type.BooleanType()),
        'replication_controller_count': type.OptionalType(type.IntegerType()),
        'replication_controller_count_unset': type.OptionalType(type.BooleanType()),
        'stateful_set_count': type.OptionalType(type.IntegerType()),
        'stateful_set_count_unset': type.OptionalType(type.BooleanType()),
        'config_map_count': type.OptionalType(type.IntegerType()),
        'config_map_count_unset': type.OptionalType(type.BooleanType()),
        'secret_count': type.OptionalType(type.IntegerType()),
        'secret_count_unset': type.OptionalType(type.BooleanType()),
        'persistent_volume_claim_count': type.OptionalType(type.IntegerType()),
        'persistent_volume_claim_count_unset': type.OptionalType(type.BooleanType()),
        'job_count': type.OptionalType(type.IntegerType()),
        'job_count_unset': type.OptionalType(type.BooleanType()),
    },
    ResourceQuotaOptionsV1Update,
    False,
    None))



class Access(VapiInterface):
    """
    The ``Access`` class provides methods to manage access control of subjects
    on namespaces.
    """

    _VAPI_SERVICE_ID = 'com.vmware.vcenter.namespaces.access'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AccessStub)
        self._VAPI_OPERATION_IDS = {}

    class Role(Enum):
        """
        The ``Access.Role`` class lists the default roles which can be associated
        with a subject on a domain on the namespace.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        EDIT = None
        """
        This role allows modification of the namespace.

        """
        VIEW = None
        """
        This is a read-only role on the namespace.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`Role` instance.
            """
            Enum.__init__(string)

    Role._set_values([
        Role('EDIT'),
        Role('VIEW'),
    ])
    Role._set_binding_type(type.EnumType(
        'com.vmware.vcenter.namespaces.access.role',
        Role))


    class SubjectType(Enum):
        """
        The ``Access.SubjectType`` class lists the types of subjects who can be
        associated with a ``Access.Role`` on the namespace.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        USER = None
        """
        Single user.

        """
        GROUP = None
        """
        Group of users.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`SubjectType` instance.
            """
            Enum.__init__(string)

    SubjectType._set_values([
        SubjectType('USER'),
        SubjectType('GROUP'),
    ])
    SubjectType._set_binding_type(type.EnumType(
        'com.vmware.vcenter.namespaces.access.subject_type',
        SubjectType))


    class Info(VapiStruct):
        """
        The ``Access.Info`` class contains the information about the access control
        of the subject on given domain on the namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     role=None,
                    ):
            """
            :type  role: :class:`Access.Role`
            :param role: Role of the subject on the namespace.
            """
            self.role = role
            VapiStruct.__init__(self)


    Info._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.access.info', {
            'role': type.ReferenceType(__name__, 'Access.Role'),
        },
        Info,
        False,
        None))


    class CreateSpec(VapiStruct):
        """
        The ``Access.CreateSpec`` class contains the specification required to
        create access control on the namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     role=None,
                    ):
            """
            :type  role: :class:`Access.Role`
            :param role: Role to be assigned.
            """
            self.role = role
            VapiStruct.__init__(self)


    CreateSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.access.create_spec', {
            'role': type.ReferenceType(__name__, 'Access.Role'),
        },
        CreateSpec,
        False,
        None))


    class SetSpec(VapiStruct):
        """
        The ``Access.SetSpec`` class contains the specification required to set new
        access control on the namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     role=None,
                    ):
            """
            :type  role: :class:`Access.Role`
            :param role: Role to be assigned.
            """
            self.role = role
            VapiStruct.__init__(self)


    SetSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.access.set_spec', {
            'role': type.ReferenceType(__name__, 'Access.Role'),
        },
        SetSpec,
        False,
        None))



    def create(self,
               namespace,
               domain,
               subject,
               type,
               spec,
               ):
        """
        Set up access control for the subject on given domain on the namespace.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :type  domain: :class:`str`
        :param domain: The domain of the subject.
        :type  subject: :class:`str`
        :param subject: The principal for this operation.
        :type  type: :class:`Access.SubjectType`
        :param type: The type of subject (user or group).
        :type  spec: :class:`Access.CreateSpec`
        :param spec: Information about the access control to be created.
        :raise: :class:`com.vmware.vapi.std.errors_client.AlreadyExists` 
            if the specified principal on given domain is already associated
            with a role on the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotAllowedInCurrentState` 
            if the namespace is marked for deletion or the associated cluster
            is being disabled.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if ``namespace`` cannot be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have Namespaces.Configure privilege or the
            namespace identifier begins with "vmware-system" prefix.
        """
        return self._invoke('create',
                            {
                            'namespace': namespace,
                            'domain': domain,
                            'subject': subject,
                            'type': type,
                            'spec': spec,
                            })

    def delete(self,
               namespace,
               domain,
               subject,
               type,
               ):
        """
        Remove access control of the subject on given domain from the
        namespace.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :type  domain: :class:`str`
        :param domain: The domain of the subject.
        :type  subject: :class:`str`
        :param subject: The principal for this operation.
        :type  type: :class:`Access.SubjectType`
        :param type: The type of subject (user or group).
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotAllowedInCurrentState` 
            if the namespace is marked for deletion or the associated cluster
            is being disabled.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if ``namespace`` cannot be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unsupported` 
            if the specified principal on given domain is not associated with
            the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have Namespaces.Configure privilege or the
            namespace identifier begins with "vmware-system" prefix.
        """
        return self._invoke('delete',
                            {
                            'namespace': namespace,
                            'domain': domain,
                            'subject': subject,
                            'type': type,
                            })

    def set(self,
            namespace,
            domain,
            subject,
            type,
            spec,
            ):
        """
        Set new access control on the namespace for the subject on given
        domain.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :type  domain: :class:`str`
        :param domain: The domain of the subject.
        :type  subject: :class:`str`
        :param subject: The principal for this operation.
        :type  type: :class:`Access.SubjectType`
        :param type: The type of subject (user or group).
        :type  spec: :class:`Access.SetSpec`
        :param spec: Information about the new access control to be assigned.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotAllowedInCurrentState` 
            if the namespace is marked for deletion or the associated cluster
            is being disabled.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if ``namespace`` cannot be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unsupported` 
            if the specified principal on given domain is not associated with
            the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have Namespaces.Configure privilege or the
            namespace identifier begins with "vmware-system" prefix.
        """
        return self._invoke('set',
                            {
                            'namespace': namespace,
                            'domain': domain,
                            'subject': subject,
                            'type': type,
                            'spec': spec,
                            })

    def get(self,
            namespace,
            domain,
            subject,
            type,
            ):
        """
        Get the information about the access control of the subject on given
        domain on the namespace.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :type  domain: :class:`str`
        :param domain: The domain of the subject.
        :type  subject: :class:`str`
        :param subject: The principal for this operation.
        :type  type: :class:`Access.SubjectType`
        :param type: The type of subject (user or group).
        :rtype: :class:`Access.Info`
        :return: Information about the subject including the type and the role on
            the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if ``namespace`` cannot be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unsupported` 
            if the specified principal on given domain is not associated with
            the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have System.Read privilege.
        """
        return self._invoke('get',
                            {
                            'namespace': namespace,
                            'domain': domain,
                            'subject': subject,
                            'type': type,
                            })
class Instances(VapiInterface):
    """
    The ``Instances`` class provides methods to create and delete a namespace
    object. In this version, an Instance is an abstraction around a Kubernetes
    namespace.
    """
    RESOURCE_TYPE = "com.vmware.vcenter.namespaces.Instance"
    """
    The resource type for namespace.

    """

    _VAPI_SERVICE_ID = 'com.vmware.vcenter.namespaces.instances'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _InstancesStub)
        self._VAPI_OPERATION_IDS = {}

    class ConfigStatus(Enum):
        """
        The ``Instances.ConfigStatus`` class describes the status of reaching the
        desired state configuration for the namespace.

        .. note::
            This class represents an enumerated type in the interface language
            definition. The class contains class attributes which represent the
            values in the current version of the enumerated type. Newer versions of
            the enumerated type may contain new values. To use new values of the
            enumerated type in communication with a server that supports the newer
            version of the API, you instantiate this class. See :ref:`enumerated
            type description page <enumeration_description>`.
        """
        CONFIGURING = None
        """
        The configuration is being applied to the namespace.

        """
        REMOVING = None
        """
        The configuration is being removed and namespace is being deleted.

        """
        RUNNING = None
        """
        The namespace is configured correctly.

        """
        ERROR = None
        """
        Failed to apply the configuration to the namespace, user intervention
        needed.

        """

        def __init__(self, string):
            """
            :type  string: :class:`str`
            :param string: String value for the :class:`ConfigStatus` instance.
            """
            Enum.__init__(string)

    ConfigStatus._set_values([
        ConfigStatus('CONFIGURING'),
        ConfigStatus('REMOVING'),
        ConfigStatus('RUNNING'),
        ConfigStatus('ERROR'),
    ])
    ConfigStatus._set_binding_type(type.EnumType(
        'com.vmware.vcenter.namespaces.instances.config_status',
        ConfigStatus))


    class Access(VapiStruct):
        """
        The ``Instances.Access`` class contains the access control information for
        a subject on a namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     subject_type=None,
                     subject=None,
                     domain=None,
                     role=None,
                    ):
            """
            :type  subject_type: :class:`Access.SubjectType`
            :param subject_type: Type of the subject.
            :type  subject: :class:`str`
            :param subject: Name of the subject.
            :type  domain: :class:`str`
            :param domain: Domain of the subject.
            :type  role: :class:`Access.Role`
            :param role: Role of the subject on the namespace instance.
            """
            self.subject_type = subject_type
            self.subject = subject
            self.domain = domain
            self.role = role
            VapiStruct.__init__(self)


    Access._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.access', {
            'subject_type': type.ReferenceType(__name__, 'Access.SubjectType'),
            'subject': type.StringType(),
            'domain': type.StringType(),
            'role': type.ReferenceType(__name__, 'Access.Role'),
        },
        Access,
        False,
        None))


    class StorageSpec(VapiStruct):
        """
        The ``Instances.StorageSpec`` class contains the specification required to
        configure storage associated with a namespace. Information in this class
        will result in storage quotas on the Kubernetes namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     policy=None,
                     limit=None,
                    ):
            """
            :type  policy: :class:`str`
            :param policy: ID of the storage policy. A Kubernetes storage class is created for
                this storage policy if it does not exist already.
                When clients pass a value of this class as a parameter, the
                attribute must be an identifier for the resource type:
                ``SpsStorageProfile``. When methods return a value of this class as
                a return value, the attribute will be an identifier for the
                resource type: ``SpsStorageProfile``.
            :type  limit: :class:`long` or ``None``
            :param limit: The maximum amount of storage (in mebibytes) which can be utilized
                by the namespace for this specification.
                If None, no limits are placed.
            """
            self.policy = policy
            self.limit = limit
            VapiStruct.__init__(self)


    StorageSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.storage_spec', {
            'policy': type.IdType(resource_types='SpsStorageProfile'),
            'limit': type.OptionalType(type.IntegerType()),
        },
        StorageSpec,
        False,
        None))


    class Message(VapiStruct):
        """
        The ``Instances.Message`` class contains the information about the object
        configuration.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     severity=None,
                     details=None,
                    ):
            """
            :type  severity: :class:`Instances.Message.MessageSeverity`
            :param severity: Type of the message.
            :type  details: :class:`com.vmware.vapi.std_client.LocalizableMessage` or ``None``
            :param details: Details about the message.
                If None, message details are not required for taking actions.
            """
            self.severity = severity
            self.details = details
            VapiStruct.__init__(self)


        class MessageSeverity(Enum):
            """
            The ``Instances.Message.MessageSeverity`` class represents the severity of
            the message.

            .. note::
                This class represents an enumerated type in the interface language
                definition. The class contains class attributes which represent the
                values in the current version of the enumerated type. Newer versions of
                the enumerated type may contain new values. To use new values of the
                enumerated type in communication with a server that supports the newer
                version of the API, you instantiate this class. See :ref:`enumerated
                type description page <enumeration_description>`.
            """
            INFO = None
            """
            Informational message. This may be accompanied by vCenter event.

            """
            WARNING = None
            """
            Warning message. This may be accompanied by vCenter event.

            """
            ERROR = None
            """
            Error message. This is accompanied by vCenter event and/or alarm.

            """

            def __init__(self, string):
                """
                :type  string: :class:`str`
                :param string: String value for the :class:`MessageSeverity` instance.
                """
                Enum.__init__(string)

        MessageSeverity._set_values([
            MessageSeverity('INFO'),
            MessageSeverity('WARNING'),
            MessageSeverity('ERROR'),
        ])
        MessageSeverity._set_binding_type(type.EnumType(
            'com.vmware.vcenter.namespaces.instances.message.message_severity',
            MessageSeverity))

    Message._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.message', {
            'severity': type.ReferenceType(__name__, 'Instances.Message.MessageSeverity'),
            'details': type.OptionalType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
        },
        Message,
        False,
        None))


    class Stats(VapiStruct):
        """
        The ``Instances.Stats`` class contains the basic runtime statistics about
        the namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     cpu_used=None,
                     memory_used=None,
                     storage_used=None,
                    ):
            """
            :type  cpu_used: :class:`long`
            :param cpu_used: Overall CPU usage of the namespace, in MHz. This is the sum of CPU
                usage across all pods in the Kubernetes namespace.
            :type  memory_used: :class:`long`
            :param memory_used: Overall memory usage of the namespace (in mebibytes). This is the
                sum of memory usage across all pods.
            :type  storage_used: :class:`long`
            :param storage_used: Overall storage used by the namespace (in mebibytes). This is the
                sum of storage used by pods across all datastores in the cluster
                associated with storage policies configured for the namespace.
            """
            self.cpu_used = cpu_used
            self.memory_used = memory_used
            self.storage_used = storage_used
            VapiStruct.__init__(self)


    Stats._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.stats', {
            'cpu_used': type.IntegerType(),
            'memory_used': type.IntegerType(),
            'storage_used': type.IntegerType(),
        },
        Stats,
        False,
        None))


    class Summary(VapiStruct):
        """
        The ``Instances.Summary`` class contains basic information about the
        namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     namespace=None,
                     description=None,
                     cluster=None,
                     config_status=None,
                     stats=None,
                    ):
            """
            :type  namespace: :class:`str`
            :param namespace: Identifier of the namespace.
                When clients pass a value of this class as a parameter, the
                attribute must be an identifier for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``. When methods return a
                value of this class as a return value, the attribute will be an
                identifier for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``.
            :type  description: :class:`str`
            :param description: Description of the namespace.
            :type  cluster: :class:`str`
            :param cluster: Identifier for the cluster hosting the namespace.
                When clients pass a value of this class as a parameter, the
                attribute must be an identifier for the resource type:
                ``ClusterComputeResource``. When methods return a value of this
                class as a return value, the attribute will be an identifier for
                the resource type: ``ClusterComputeResource``.
            :type  config_status: :class:`Instances.ConfigStatus`
            :param config_status: Current setting for ``Instances.ConfigStatus``.
            :type  stats: :class:`Instances.Stats`
            :param stats: Basic runtime statistics for the namespace.
            """
            self.namespace = namespace
            self.description = description
            self.cluster = cluster
            self.config_status = config_status
            self.stats = stats
            VapiStruct.__init__(self)


    Summary._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.summary', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'description': type.StringType(),
            'cluster': type.IdType(resource_types='ClusterComputeResource'),
            'config_status': type.ReferenceType(__name__, 'Instances.ConfigStatus'),
            'stats': type.ReferenceType(__name__, 'Instances.Stats'),
        },
        Summary,
        False,
        None))


    class Info(VapiStruct):
        """
        The ``Instances.Info`` class contains detailed information about the
        namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     cluster=None,
                     config_status=None,
                     messages=None,
                     stats=None,
                     description=None,
                     resource_spec=None,
                     access_list=None,
                     storage_specs=None,
                     networks=None,
                    ):
            """
            :type  cluster: :class:`str`
            :param cluster: Identifier for the cluster hosting the namespace.
                When clients pass a value of this class as a parameter, the
                attribute must be an identifier for the resource type:
                ``ClusterComputeResource``. When methods return a value of this
                class as a return value, the attribute will be an identifier for
                the resource type: ``ClusterComputeResource``.
            :type  config_status: :class:`Instances.ConfigStatus`
            :param config_status: Current setting for ``Instances.ConfigStatus``.
            :type  messages: :class:`list` of :class:`Instances.Message`
            :param messages: Current set of messages associated with the object.
            :type  stats: :class:`Instances.Stats`
            :param stats: Basic runtime statistics for the namespace.
            :type  description: :class:`str`
            :param description: Description of the namespace.
            :type  resource_spec: :class:`vmware.vapi.struct.VapiStruct` or ``None``
            :param resource_spec: Quotas on the namespace resources. Refer to
                com.vmware.vcenter.namespace_management.NamespaceResourceOptions#get
                for the type of the value for this field.
                If None, no resource constraints are associated with the namespace.
            :type  access_list: :class:`list` of :class:`Instances.Access`
            :param access_list: Access controls associated with the namespace.
            :type  storage_specs: :class:`list` of :class:`Instances.StorageSpec`
            :param storage_specs: Storage associated with the namespace.
            :type  networks: :class:`list` of :class:`str` or ``None``
            :param networks: vSphere Networks associated with the namespace. This attribute was
                added in vSphere API 7.0.1.0.
                When clients pass a value of this class as a parameter, the
                attribute must contain identifiers for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``. When methods return a
                value of this class as a return value, the attribute will contain
                identifiers for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``.
                This field is None if the cluster hosting this namespace uses
                NSXT_CONTAINER_PLUGIN as its network provider.
            """
            self.cluster = cluster
            self.config_status = config_status
            self.messages = messages
            self.stats = stats
            self.description = description
            self.resource_spec = resource_spec
            self.access_list = access_list
            self.storage_specs = storage_specs
            self.networks = networks
            VapiStruct.__init__(self)


    Info._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.info', {
            'cluster': type.IdType(resource_types='ClusterComputeResource'),
            'config_status': type.ReferenceType(__name__, 'Instances.ConfigStatus'),
            'messages': type.ListType(type.ReferenceType(__name__, 'Instances.Message')),
            'stats': type.ReferenceType(__name__, 'Instances.Stats'),
            'description': type.StringType(),
            'resource_spec': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
            'access_list': type.ListType(type.ReferenceType(__name__, 'Instances.Access')),
            'storage_specs': type.ListType(type.ReferenceType(__name__, 'Instances.StorageSpec')),
            'networks': type.OptionalType(type.ListType(type.IdType())),
        },
        Info,
        False,
        None))


    class UpdateSpec(VapiStruct):
        """
        The ``Instances.UpdateSpec`` class contains the specification required to
        update the configuration on the namespace. This class is applied partially,
        and only the specified fields will replace or modify their existing
        counterparts.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     description=None,
                     resource_spec=None,
                     access_list=None,
                     storage_specs=None,
                    ):
            """
            :type  description: :class:`str` or ``None``
            :param description: Description for the namespace.
                If None, the description of the namespace will not be modified.
            :type  resource_spec: :class:`vmware.vapi.struct.VapiStruct` or ``None``
            :param resource_spec: Resource quota updates on the namespace. Refer to
                com.vmware.vcenter.namespace_management.NamespaceResourceOptions.Info#updateResourceQuotaType
                and use
                com.vmware.vcenter.namespace_management.NamespaceResourceOptions#get
                for retrieving the type for the value for this field. For an
                example of this, see :class:`ResourceQuotaOptionsV1Update`.
                If None, the resource constraints on the namespace will not be
                modified.
            :type  access_list: :class:`list` of :class:`Instances.Access` or ``None``
            :param access_list: Access control associated with the namespace.
                If None, access controls on the namespace will not be modified.
                Existing pods from users will continue to run.
            :type  storage_specs: :class:`list` of :class:`Instances.StorageSpec` or ``None``
            :param storage_specs: Storage associated with the namespace.
                If None, storage policies and their limit will not be modified.
                Pods which are already using persistent storage from the earlier
                version of storage policies will be able to access them till the
                datastores are attached to the worker nodes.
            """
            self.description = description
            self.resource_spec = resource_spec
            self.access_list = access_list
            self.storage_specs = storage_specs
            VapiStruct.__init__(self)


    UpdateSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.update_spec', {
            'description': type.OptionalType(type.StringType()),
            'resource_spec': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
            'access_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Instances.Access'))),
            'storage_specs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Instances.StorageSpec'))),
        },
        UpdateSpec,
        False,
        None))


    class SetSpec(VapiStruct):
        """
        The ``Instances.SetSpec`` class contains the specification required to set
        a new configuration on the namespace. This class is applied in entirety,
        replacing the current specification fully.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     description=None,
                     resource_spec=None,
                     access_list=None,
                     storage_specs=None,
                    ):
            """
            :type  description: :class:`str` or ``None``
            :param description: Description for the namespace.
                If None, the description of the namespace will be cleared.
            :type  resource_spec: :class:`vmware.vapi.struct.VapiStruct` or ``None``
            :param resource_spec: Resource quota for the namespace. This will replace the existing
                resource constraints on the namespace in entirety. Refer to
                com.vmware.vcenter.namespace_management.NamespaceResourceOptions.Info#createResourceQuotaType
                and use
                com.vmware.vcenter.namespace_management.NamespaceResourceOptions#get
                for retrieving the type for the value for this field. For an
                example of this, see :class:`ResourceQuotaOptionsV1`.
                If None, the resource constraints on the namespace will be cleared.
            :type  access_list: :class:`list` of :class:`Instances.Access` or ``None``
            :param access_list: Access control associated with the namespace.
                If None, the existing access controls on the namespace will be
                removed and users will not be able to access this namespace to
                create new pods. Existing pods from users will continue to run.
            :type  storage_specs: :class:`list` of :class:`Instances.StorageSpec` or ``None``
            :param storage_specs: Storage associated with the namespace.
                If None, the existing storage policies will be disassociated with
                the namespace and existing limits will be cleared. Pods which are
                already using persistent storage from the earlier version of
                storage policies will be able to access them till the datastores
                are attached to the worker nodes.
            """
            self.description = description
            self.resource_spec = resource_spec
            self.access_list = access_list
            self.storage_specs = storage_specs
            VapiStruct.__init__(self)


    SetSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.set_spec', {
            'description': type.OptionalType(type.StringType()),
            'resource_spec': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
            'access_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Instances.Access'))),
            'storage_specs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Instances.StorageSpec'))),
        },
        SetSpec,
        False,
        None))


    class CreateSpec(VapiStruct):
        """
        The ``Instances.CreateSpec`` class contains the specification required to
        set up a namespace.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     namespace=None,
                     cluster=None,
                     description=None,
                     resource_spec=None,
                     access_list=None,
                     storage_specs=None,
                     networks=None,
                    ):
            """
            :type  namespace: :class:`str`
            :param namespace: Identifier of the namespace. This has DNS_LABEL restrictions as
                specified in ` <https://tools.ietf.org/html/rfc1123>`_. This must
                be an alphanumeric (a-z and 0-9) string and with maximum length of
                63 characters and with the '-' character allowed anywhere except
                the first or last character. This name is unique across all
                Namespaces in this vCenter server. In this version, this maps to
                the name of a Kubernetes namespace.
                When clients pass a value of this class as a parameter, the
                attribute must be an identifier for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``. When methods return a
                value of this class as a return value, the attribute will be an
                identifier for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``.
            :type  cluster: :class:`str`
            :param cluster: Identifier of the cluster on which the namespace is being created.
                When clients pass a value of this class as a parameter, the
                attribute must be an identifier for the resource type:
                ``ClusterComputeResource``. When methods return a value of this
                class as a return value, the attribute will be an identifier for
                the resource type: ``ClusterComputeResource``.
            :type  description: :class:`str` or ``None``
            :param description: Description for the namespace.
                If None, no description is added to the namespace.
            :type  resource_spec: :class:`vmware.vapi.struct.VapiStruct` or ``None``
            :param resource_spec: Resource quota on the namespace. Refer to
                com.vmware.vcenter.namespace_management.NamespaceResourceOptions.Info#createResourceQuotaType
                and use
                com.vmware.vcenter.namespace_management.NamespaceResourceOptions#get
                for retrieving the type for the value for this field. For an
                example of this, see :class:`ResourceQuotaOptionsV1`.
                If None, no resource limits will be set on the namespace.
            :type  access_list: :class:`list` of :class:`Instances.Access` or ``None``
            :param access_list: Access controls associated with the namespace.
                If None, only users with Administrator role can access the
                namespace.
            :type  storage_specs: :class:`list` of :class:`Instances.StorageSpec` or ``None``
            :param storage_specs: Storage associated with the namespace.
                If None, storage policies will not be associated with the namespace
                which will prevent users from being able to provision pods with
                persistent storage on the namespace. Users will be able to
                provision pods which use local storage.
            :type  networks: :class:`list` of :class:`str` or ``None``
            :param networks: vSphere Namespaces network objects to be associated with the
                namespace. The values of this list need to reference names of
                pre-existing ``Networks.Info`` classs. This attribute was added in
                vSphere API 7.0.1.0.
                When clients pass a value of this class as a parameter, the
                attribute must contain identifiers for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``. When methods return a
                value of this class as a return value, the attribute will contain
                identifiers for the resource type:
                ``com.vmware.vcenter.namespaces.Instance``.
                The field must be left None if the cluster hosting the namespace
                uses NSXT_CONTAINER_PLUGIN as the network provider, since the
                network(s) for this namespace will be managed by NSX-T Container
                Plugin. If field is None when the cluster hosting the namespace
                uses VSPHERE_NETWORK as its network provider, the namespace will
                automatically be associated with the cluster's Supervisor Primary
                Workload Network. The field currently accepts at most only 1
                vSphere Namespaces network object reference.
            """
            self.namespace = namespace
            self.cluster = cluster
            self.description = description
            self.resource_spec = resource_spec
            self.access_list = access_list
            self.storage_specs = storage_specs
            self.networks = networks
            VapiStruct.__init__(self)


    CreateSpec._set_binding_type(type.StructType(
        'com.vmware.vcenter.namespaces.instances.create_spec', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'cluster': type.IdType(resource_types='ClusterComputeResource'),
            'description': type.OptionalType(type.StringType()),
            'resource_spec': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct)),
            'access_list': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Instances.Access'))),
            'storage_specs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Instances.StorageSpec'))),
            'networks': type.OptionalType(type.ListType(type.IdType())),
        },
        CreateSpec,
        False,
        None))



    def create(self,
               spec,
               ):
        """
        Create namespace object in the cluster.

        :type  spec: :class:`Instances.CreateSpec`
        :param spec: Specification for setting up the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.AlreadyExists` 
            if a namespace with the same name exists in vCenter server.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if ``spec`` contain any errors or if an invalid name is specified.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotAllowedInCurrentState` 
            if the associated cluster is deing disabled.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if :attr:`Instances.CreateSpec.cluster` is not registered on this
            vCenter server.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unsupported` 
            if :attr:`Instances.CreateSpec.cluster` is not enabled for
            Namespaces, or if the networks field is set when the
            :attr:`Instances.CreateSpec.cluster` hosting the namespace uses
            NSXT_CONTAINER_PLUGIN as its network provider.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have Namespaces.Configure privilege or the
            namespace identifier begins with "vmware-system" prefix.
        """
        return self._invoke('create',
                            {
                            'spec': spec,
                            })

    def delete(self,
               namespace,
               ):
        """
        Delete the namespace object in the cluster.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if the specified namespace could not be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have Namespaces.Configure privilege or the
            namespace identifier begins with "vmware-system" prefix.
        """
        return self._invoke('delete',
                            {
                            'namespace': namespace,
                            })

    def get(self,
            namespace,
            ):
        """
        Returns information about a specific namespace.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :rtype: :class:`Instances.Info`
        :return: Information about the desired state of the specified namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if namespace could not be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have System.Read privilege.
        """
        return self._invoke('get',
                            {
                            'namespace': namespace,
                            })

    def list(self):
        """
        Returns the information about all namespaces on this vCenter.


        :rtype: :class:`list` of :class:`Instances.Summary`
        :return: The list of summary of all namespaces.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have System.Read privilege.
        """
        return self._invoke('list', None)

    def set(self,
            namespace,
            spec,
            ):
        """
        Set a new configuration on the namespace object. The specified
        configuration is applied in entirety and will replace the current
        configuration fully.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :type  spec: :class:`Instances.SetSpec`
        :param spec: New specification for the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if ``spec`` contain any errors.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotAllowedInCurrentState` 
            if the namespace is marked for deletion or the associated cluster
            is being disabled.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if namespace with the name ``namespace`` could not be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have Namespaces.Configure privilege or the
            namespace identifier begins with "vmware-system" prefix.
        """
        return self._invoke('set',
                            {
                            'namespace': namespace,
                            'spec': spec,
                            })

    def update(self,
               namespace,
               spec,
               ):
        """
        Update the namespace object. The specified configuration is applied
        partially and None fields in ``spec`` will leave those parts of
        configuration as-is.

        :type  namespace: :class:`str`
        :param namespace: Identifier for the namespace.
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.namespaces.Instance``.
        :type  spec: :class:`Instances.UpdateSpec`
        :param spec: Specification for updating the namespace.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            if the system reports an error while responding to the request.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            if ``spec`` contain any errors.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotAllowedInCurrentState` 
            if the namespace is marked for deletion or the associated cluster
            is being disabled.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            if namespace with the name ``namespace`` could not be located.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            if the user does not have Namespaces.Configure privilege or the
            namespace identifier begins with "vmware-system" prefix.
        """
        return self._invoke('update',
                            {
                            'namespace': namespace,
                            'spec': spec,
                            })
class _AccessStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'domain': type.StringType(),
            'subject': type.StringType(),
            'type': type.ReferenceType(__name__, 'Access.SubjectType'),
            'spec': type.ReferenceType(__name__, 'Access.CreateSpec'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.already_exists':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'AlreadyExists'),
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.not_allowed_in_current_state':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotAllowedInCurrentState'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vcenter/namespaces/instances/{namespace}/access/{domain}/{subject}',
            request_body_parameter='spec',
            path_variables={
                'namespace': 'namespace',
                'domain': 'domain',
                'subject': 'subject',
            },
            query_parameters={
                'type': 'type',
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'domain': type.StringType(),
            'subject': type.StringType(),
            'type': type.ReferenceType(__name__, 'Access.SubjectType'),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.not_allowed_in_current_state':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotAllowedInCurrentState'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unsupported':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unsupported'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/vcenter/namespaces/instances/{namespace}/access/{domain}/{subject}',
            path_variables={
                'namespace': 'namespace',
                'domain': 'domain',
                'subject': 'subject',
            },
            query_parameters={
                'type': 'type',
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for set operation
        set_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'domain': type.StringType(),
            'subject': type.StringType(),
            'type': type.ReferenceType(__name__, 'Access.SubjectType'),
            'spec': type.ReferenceType(__name__, 'Access.SetSpec'),
        })
        set_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.not_allowed_in_current_state':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotAllowedInCurrentState'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unsupported':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unsupported'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        set_input_value_validator_list = [
        ]
        set_output_validator_list = [
        ]
        set_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/vcenter/namespaces/instances/{namespace}/access/{domain}/{subject}',
            request_body_parameter='spec',
            path_variables={
                'namespace': 'namespace',
                'domain': 'domain',
                'subject': 'subject',
            },
            query_parameters={
                'type': 'type',
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'domain': type.StringType(),
            'subject': type.StringType(),
            'type': type.ReferenceType(__name__, 'Access.SubjectType'),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unsupported':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unsupported'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/namespaces/instances/{namespace}/access/{domain}/{subject}',
            path_variables={
                'namespace': 'namespace',
                'domain': 'domain',
                'subject': 'subject',
            },
            query_parameters={
                'type': 'type',
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.VoidType(),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'set': {
                'input_type': set_input_type,
                'output_type': type.VoidType(),
                'errors': set_error_dict,
                'input_value_validator_list': set_input_value_validator_list,
                'output_validator_list': set_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType(__name__, 'Access.Info'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'set': set_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vcenter.namespaces.access',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)

class _InstancesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'spec': type.ReferenceType(__name__, 'Instances.CreateSpec'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.already_exists':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'AlreadyExists'),
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.not_allowed_in_current_state':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotAllowedInCurrentState'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unsupported':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unsupported'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vcenter/namespaces/instances',
            request_body_parameter='spec',
            path_variables={
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/vcenter/namespaces/instances/{namespace}',
            path_variables={
                'namespace': 'namespace',
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/namespaces/instances/{namespace}',
            path_variables={
                'namespace': 'namespace',
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {})
        list_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/namespaces/instances',
            path_variables={
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for set operation
        set_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'spec': type.ReferenceType(__name__, 'Instances.SetSpec'),
        })
        set_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.not_allowed_in_current_state':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotAllowedInCurrentState'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        set_input_value_validator_list = [
        ]
        set_output_validator_list = [
        ]
        set_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/vcenter/namespaces/instances/{namespace}',
            request_body_parameter='spec',
            path_variables={
                'namespace': 'namespace',
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'namespace': type.IdType(resource_types='com.vmware.vcenter.namespaces.Instance'),
            'spec': type.ReferenceType(__name__, 'Instances.UpdateSpec'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.not_allowed_in_current_state':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotAllowedInCurrentState'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/vcenter/namespaces/instances/{namespace}',
            request_body_parameter='spec',
            path_variables={
                'namespace': 'namespace',
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.VoidType(),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType(__name__, 'Instances.Info'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ListType(type.ReferenceType(__name__, 'Instances.Summary')),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'set': {
                'input_type': set_input_type,
                'output_type': type.VoidType(),
                'errors': set_error_dict,
                'input_value_validator_list': set_input_value_validator_list,
                'output_validator_list': set_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.VoidType(),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'set': set_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vcenter.namespaces.instances',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Access': Access,
        'Instances': Instances,
        'user': 'com.vmware.vcenter.namespaces.user_client.StubFactory',
    }

