/* gtksourceview-5.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gtk", gir_namespace = "GtkSource", gir_version = "5", lower_case_cprefix = "gtk_")]
namespace Gtk {
	namespace SourceUtils {
		[CCode (cheader_filename = "gtksourceview/gtksource.h")]
		[Version (since = "3.10")]
		public static string escape_search_text (string text);
		[CCode (cheader_filename = "gtksourceview/gtksource.h")]
		[Version (since = "3.10")]
		public static string unescape_search_text (string text);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_buffer_get_type ()")]
	[GIR (name = "Buffer")]
	public class SourceBuffer : Gtk.TextBuffer {
		[CCode (has_construct_function = false)]
		public SourceBuffer (Gtk.TextTagTable? table);
		[Version (since = "2.2")]
		public bool backward_iter_to_source_mark (ref Gtk.TextIter iter, string? category);
		[Version (since = "3.12")]
		public void change_case (Gtk.SourceChangeCaseType case_type, Gtk.TextIter start, Gtk.TextIter end);
		[Version (since = "2.2")]
		public unowned Gtk.SourceMark create_source_mark (string? name, string category, Gtk.TextIter where);
		public void ensure_highlight (Gtk.TextIter start, Gtk.TextIter end);
		[Version (since = "2.2")]
		public bool forward_iter_to_source_mark (ref Gtk.TextIter iter, string? category);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.10")]
		public string[] get_context_classes_at_iter (Gtk.TextIter iter);
		public bool get_highlight_matching_brackets ();
		public bool get_highlight_syntax ();
		[Version (since = "3.14")]
		public bool get_implicit_trailing_newline ();
		public unowned Gtk.SourceLanguage? get_language ();
		[Version (since = "2.2")]
		public GLib.SList<weak Gtk.SourceMark> get_source_marks_at_iter (Gtk.TextIter iter, string? category);
		[Version (since = "2.2")]
		public GLib.SList<weak Gtk.SourceMark> get_source_marks_at_line (int line, string? category);
		public unowned Gtk.SourceStyleScheme? get_style_scheme ();
		[Version (since = "2.10")]
		public bool iter_backward_to_context_class_toggle (ref Gtk.TextIter iter, string context_class);
		[Version (since = "2.10")]
		public bool iter_forward_to_context_class_toggle (ref Gtk.TextIter iter, string context_class);
		[Version (since = "2.10")]
		public bool iter_has_context_class (Gtk.TextIter iter, string context_class);
		[Version (since = "3.16")]
		public void join_lines (Gtk.TextIter start, Gtk.TextIter end);
		[Version (since = "2.2")]
		public void remove_source_marks (Gtk.TextIter start, Gtk.TextIter end, string? category);
		public void set_highlight_matching_brackets (bool highlight);
		public void set_highlight_syntax (bool highlight);
		[Version (since = "3.14")]
		public void set_implicit_trailing_newline (bool implicit_trailing_newline);
		public void set_language (Gtk.SourceLanguage? language);
		public void set_style_scheme (Gtk.SourceStyleScheme? scheme);
		[Version (since = "3.18")]
		public void sort_lines (Gtk.TextIter start, Gtk.TextIter end, Gtk.SourceSortFlags flags, int column);
		[CCode (has_construct_function = false)]
		public SourceBuffer.with_language (Gtk.SourceLanguage language);
		public bool highlight_matching_brackets { get; set; }
		public bool highlight_syntax { get; set; }
		[Version (since = "3.14")]
		public bool implicit_trailing_newline { get; set construct; }
		public Gtk.SourceLanguage language { get; set; }
		public Gtk.SourceStyleScheme style_scheme { get; set; }
		[Version (since = "2.12")]
		public virtual signal void bracket_matched (Gtk.TextIter? iter, Gtk.SourceBracketMatchType state);
		[Version (since = "5.0")]
		public signal void cursor_moved ();
		public signal void highlight_updated (Gtk.TextIter start, Gtk.TextIter end);
		public signal void source_mark_updated (Gtk.TextMark mark);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_get_type ()")]
	[GIR (name = "Completion")]
	public class SourceCompletion : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceCompletion ();
		[Version (since = "5.0")]
		public void add_provider (Gtk.SourceCompletionProvider provider);
		public void block_interactive ();
		[Version (since = "5.0")]
		public static Pango.AttrList? fuzzy_highlight (string haystack, string casefold_query);
		[Version (since = "5.0")]
		public static bool fuzzy_match (string? haystack, string casefold_needle, out uint priority);
		[Version (since = "5.0")]
		public unowned Gtk.SourceBuffer get_buffer ();
		public uint get_page_size ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceView get_view ();
		[Version (since = "5.0")]
		public void remove_provider (Gtk.SourceCompletionProvider provider);
		public void set_page_size (uint page_size);
		public void unblock_interactive ();
		[Version (since = "5.0")]
		public Gtk.TextView buffer { get; }
		[Version (since = "5.0")]
		public uint page_size { get; set; }
		[NoAccessorMethod]
		public bool remember_info_visibility { get; set; }
		[NoAccessorMethod]
		public bool select_on_show { get; set; }
		[NoAccessorMethod]
		public bool show_icons { get; set; }
		[Version (since = "5.0")]
		public Gtk.SourceView view { get; construct; }
		[HasEmitter]
		[Version (since = "5.0")]
		public signal void hide ();
		[Version (since = "5.0")]
		public signal void provider_added (Gtk.SourceCompletionProvider provider);
		[Version (since = "5.0")]
		public signal void provider_removed (Gtk.SourceCompletionProvider provider);
		[HasEmitter]
		[Version (since = "5.0")]
		public signal void show ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_cell_get_type ()")]
	[GIR (name = "CompletionCell")]
	public class SourceCompletionCell : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected SourceCompletionCell ();
		public Gtk.SourceCompletionColumn get_column ();
		[Version (since = "5.0")]
		public unowned Gtk.Widget? get_widget ();
		public void set_gicon (GLib.Icon gicon);
		public void set_icon_name (string icon_name);
		public void set_markup (string markup);
		public void set_paintable (Gdk.Paintable paintable);
		public void set_text (string text);
		public void set_text_with_attributes (string text, Pango.AttrList attrs);
		public void set_widget (Gtk.Widget child);
		public Gtk.SourceCompletionColumn column { get; construct; }
		[NoAccessorMethod]
		public string markup { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Paintable paintable { owned get; set; }
		[NoAccessorMethod]
		public string text { owned get; set; }
		public Gtk.Widget widget { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_context_get_type ()")]
	[GIR (name = "CompletionContext")]
	public class SourceCompletionContext : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected SourceCompletionContext ();
		[Version (since = "5.0")]
		public Gtk.SourceCompletionActivation get_activation ();
		[Version (since = "5.0")]
		public bool get_bounds (out Gtk.TextIter begin, out Gtk.TextIter end);
		[Version (since = "5.0")]
		public unowned Gtk.SourceBuffer? get_buffer ();
		[Version (since = "5.0")]
		public bool get_busy ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceCompletion? get_completion ();
		[Version (since = "5.0")]
		public bool get_empty ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceLanguage? get_language ();
		public void get_start_iter (Gtk.TextIter iter);
		[Version (since = "5.0")]
		public unowned Gtk.SourceView? get_view ();
		[Version (since = "5.0")]
		public string get_word ();
		[Version (since = "5.0")]
		public void set_proposals_for_provider (Gtk.SourceCompletionProvider provider, GLib.ListModel? results);
		[Version (since = "5.0")]
		public bool busy { get; }
		[Version (since = "5.0")]
		public Gtk.SourceCompletion completion { get; construct; }
		[Version (since = "5.0")]
		public bool empty { get; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_snippets_get_type ()")]
	[GIR (name = "CompletionSnippets")]
	public class SourceCompletionSnippets : GLib.Object, Gtk.SourceCompletionProvider {
		[CCode (has_construct_function = false)]
		public SourceCompletionSnippets ();
		[NoAccessorMethod]
		public int priority { get; set construct; }
		[NoAccessorMethod]
		public string title { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_completion_words_get_type ()")]
	[GIR (name = "CompletionWords")]
	public class SourceCompletionWords : GLib.Object, Gtk.SourceCompletionProvider {
		[CCode (has_construct_function = false)]
		public SourceCompletionWords (string? title);
		public void register (Gtk.TextBuffer buffer);
		public void unregister (Gtk.TextBuffer buffer);
		[NoAccessorMethod]
		public uint minimum_word_size { get; set construct; }
		[NoAccessorMethod]
		public int priority { get; set construct; }
		[NoAccessorMethod]
		public uint proposals_batch_size { get; set construct; }
		[NoAccessorMethod]
		public uint scan_batch_size { get; set construct; }
		[NoAccessorMethod]
		public string title { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gtk_source_encoding_get_type ()")]
	[Compact]
	[GIR (name = "Encoding")]
	public class SourceEncoding {
		[Version (since = "3.14")]
		public Gtk.SourceEncoding copy ();
		[CCode (cname = "gtk_source_encoding_get_all")]
		[Version (since = "3.14")]
		public static GLib.SList<weak Gtk.SourceEncoding> et_all ();
		[CCode (cname = "gtk_source_encoding_get_current")]
		[Version (since = "3.14")]
		public static unowned Gtk.SourceEncoding et_current ();
		[CCode (cname = "gtk_source_encoding_get_default_candidates")]
		[Version (since = "3.18")]
		public static GLib.SList<weak Gtk.SourceEncoding> et_default_candidates ();
		[CCode (cname = "gtk_source_encoding_get_from_charset")]
		[Version (since = "3.14")]
		public static unowned Gtk.SourceEncoding? et_from_charset (string charset);
		[CCode (cname = "gtk_source_encoding_get_utf8")]
		[Version (since = "3.14")]
		public static unowned Gtk.SourceEncoding et_utf8 ();
		[Version (since = "3.14")]
		public void free ();
		[Version (since = "3.14")]
		public unowned string get_charset ();
		[Version (since = "3.14")]
		public unowned string get_name ();
		[Version (since = "3.14")]
		public string to_string ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_file_get_type ()")]
	[GIR (name = "File")]
	public class SourceFile : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.14")]
		public SourceFile ();
		[Version (since = "3.18")]
		public void check_file_on_disk ();
		[Version (since = "3.14")]
		public Gtk.SourceCompressionType get_compression_type ();
		[Version (since = "3.14")]
		public unowned Gtk.SourceEncoding get_encoding ();
		[Version (since = "3.14")]
		public unowned GLib.File get_location ();
		[Version (since = "3.14")]
		public Gtk.SourceNewlineType get_newline_type ();
		[Version (since = "3.18")]
		public bool is_deleted ();
		[Version (since = "3.18")]
		public bool is_externally_modified ();
		[Version (since = "3.18")]
		public bool is_local ();
		[Version (since = "3.18")]
		public bool is_readonly ();
		[Version (since = "3.14")]
		public void set_location (GLib.File? location);
		[Version (since = "3.14")]
		public Gtk.SourceCompressionType compression_type { get; }
		[Version (since = "3.14")]
		public Gtk.SourceEncoding encoding { get; }
		[Version (since = "3.14")]
		public GLib.File location { get; set construct; }
		[Version (since = "3.14")]
		public Gtk.SourceNewlineType newline_type { get; }
		[NoAccessorMethod]
		[Version (since = "3.18")]
		public bool read_only { get; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_file_loader_get_type ()")]
	[GIR (name = "FileLoader")]
	public class SourceFileLoader : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.14")]
		public SourceFileLoader (Gtk.SourceBuffer buffer, Gtk.SourceFile file);
		[CCode (has_construct_function = false)]
		[Version (since = "3.14")]
		public SourceFileLoader.from_stream (Gtk.SourceBuffer buffer, Gtk.SourceFile file, GLib.InputStream stream);
		[Version (since = "3.14")]
		public unowned Gtk.SourceBuffer get_buffer ();
		[Version (since = "3.14")]
		public Gtk.SourceCompressionType get_compression_type ();
		[Version (since = "3.14")]
		public unowned Gtk.SourceEncoding get_encoding ();
		[Version (since = "3.14")]
		public unowned Gtk.SourceFile get_file ();
		[Version (since = "3.14")]
		public unowned GLib.InputStream? get_input_stream ();
		[Version (since = "3.14")]
		public unowned GLib.File? get_location ();
		[Version (since = "3.14")]
		public Gtk.SourceNewlineType get_newline_type ();
		[Version (since = "3.14")]
		public async bool load_async (int io_priority, GLib.Cancellable? cancellable, owned GLib.FileProgressCallback? progress_callback) throws GLib.Error;
		[Version (since = "3.14")]
		public void set_candidate_encodings (GLib.SList<Gtk.SourceEncoding> candidate_encodings);
		[Version (since = "3.14")]
		public Gtk.SourceBuffer buffer { get; construct; }
		[Version (since = "3.14")]
		public Gtk.SourceFile file { get; construct; }
		[Version (since = "3.14")]
		public GLib.InputStream input_stream { get; construct; }
		[Version (since = "3.14")]
		public GLib.File location { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_file_saver_get_type ()")]
	[GIR (name = "FileSaver")]
	public class SourceFileSaver : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.14")]
		public SourceFileSaver (Gtk.SourceBuffer buffer, Gtk.SourceFile file);
		[Version (since = "3.14")]
		public unowned Gtk.SourceBuffer get_buffer ();
		[Version (since = "3.14")]
		public Gtk.SourceCompressionType get_compression_type ();
		[Version (since = "3.14")]
		public unowned Gtk.SourceEncoding get_encoding ();
		[Version (since = "3.14")]
		public unowned Gtk.SourceFile get_file ();
		[Version (since = "3.14")]
		public Gtk.SourceFileSaverFlags get_flags ();
		[Version (since = "3.14")]
		public unowned GLib.File get_location ();
		[Version (since = "3.14")]
		public Gtk.SourceNewlineType get_newline_type ();
		[Version (since = "3.14")]
		public async bool save_async (int io_priority, GLib.Cancellable? cancellable, owned GLib.FileProgressCallback? progress_callback) throws GLib.Error;
		[Version (since = "3.14")]
		public void set_compression_type (Gtk.SourceCompressionType compression_type);
		[Version (since = "3.14")]
		public void set_encoding (Gtk.SourceEncoding? encoding);
		[Version (since = "3.14")]
		public void set_flags (Gtk.SourceFileSaverFlags flags);
		[Version (since = "3.14")]
		public void set_newline_type (Gtk.SourceNewlineType newline_type);
		[CCode (has_construct_function = false)]
		[Version (since = "3.14")]
		public SourceFileSaver.with_target (Gtk.SourceBuffer buffer, Gtk.SourceFile file, GLib.File target_location);
		[Version (since = "3.14")]
		public Gtk.SourceBuffer buffer { get; construct; }
		[Version (since = "3.14")]
		public Gtk.SourceCompressionType compression_type { get; set construct; }
		[Version (since = "3.14")]
		public Gtk.SourceEncoding encoding { get; set construct; }
		[Version (since = "3.14")]
		public Gtk.SourceFile file { get; construct; }
		[Version (since = "3.14")]
		public Gtk.SourceFileSaverFlags flags { get; set construct; }
		[Version (since = "3.14")]
		public GLib.File location { get; construct; }
		[Version (since = "3.14")]
		public Gtk.SourceNewlineType newline_type { get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_get_type ()")]
	[GIR (name = "Gutter")]
	public class SourceGutter : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected SourceGutter ();
		[Version (since = "3.24")]
		public unowned Gtk.SourceView get_view ();
		[Version (since = "3.0")]
		public bool insert (Gtk.SourceGutterRenderer renderer, int position);
		public void remove (Gtk.SourceGutterRenderer renderer);
		[Version (since = "2.8")]
		public void reorder (Gtk.SourceGutterRenderer renderer, int position);
		public Gtk.SourceView view { get; construct; }
		[NoAccessorMethod]
		public Gtk.TextWindowType window_type { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_lines_get_type ()")]
	[GIR (name = "GutterLines")]
	public class SourceGutterLines : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceGutterLines ();
		[Version (since = "5.0")]
		public void add_class (uint line, string name);
		[Version (since = "5.0")]
		public void add_qclass (uint line, GLib.Quark qname);
		[Version (since = "5.0")]
		public unowned Gtk.TextBuffer get_buffer ();
		[Version (since = "5.0")]
		public uint get_first ();
		[Version (since = "5.0")]
		public void get_iter_at_line (out Gtk.TextIter iter, uint line);
		[Version (since = "5.0")]
		public uint get_last ();
		[Version (since = "5.0")]
		public void get_line_yrange (uint line, Gtk.SourceGutterRendererAlignmentMode mode, out int y, out int height);
		[Version (since = "5.0")]
		public unowned Gtk.TextView get_view ();
		public void get_yrange (uint line, uint line_y, uint line_height);
		[Version (since = "5.0")]
		public bool has_class (uint line, string name);
		[Version (since = "5.0")]
		public bool has_qclass (uint line, GLib.Quark qname);
		[Version (since = "5.0")]
		public bool is_cursor (uint line);
		[Version (since = "5.0")]
		public bool is_prelit (uint line);
		[Version (since = "5.0")]
		public bool is_selected (uint line);
		[Version (since = "5.0")]
		public void remove_class (uint line, string name);
		[Version (since = "5.0")]
		public void remove_qclass (uint line, GLib.Quark qname);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_renderer_get_type ()")]
	[GIR (name = "GutterRenderer")]
	public abstract class SourceGutterRenderer : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected SourceGutterRenderer ();
		[Version (since = "5.0")]
		public void align_cell (uint line, float width, float height, out float x, out float y);
		[NoWrapper]
		public virtual void begin (Gtk.SourceGutterLines lines);
		[NoWrapper]
		public virtual void change_buffer (Gtk.SourceBuffer? old_buffer);
		[NoWrapper]
		public virtual void change_view (Gtk.SourceView? old_view);
		[NoWrapper]
		public virtual void end ();
		public Gtk.SourceGutterRendererAlignmentMode get_alignment_mode ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceBuffer? get_buffer ();
		public unowned Gtk.SourceView get_view ();
		[Version (since = "5.0")]
		public float get_xalign ();
		[Version (since = "5.0")]
		public int get_xpad ();
		[Version (since = "5.0")]
		public float get_yalign ();
		[Version (since = "5.0")]
		public int get_ypad ();
		public void set_alignment_mode (Gtk.SourceGutterRendererAlignmentMode mode);
		[Version (since = "5.0")]
		public void set_xalign (float xalign);
		[Version (since = "5.0")]
		public void set_xpad (int xpad);
		[Version (since = "5.0")]
		public void set_yalign (float yalign);
		[Version (since = "5.0")]
		public void set_ypad (int ypad);
		[NoWrapper]
		public virtual void snapshot_line (Gtk.Snapshot snapshot, Gtk.SourceGutterLines lines, uint line);
		public Gtk.SourceGutterRendererAlignmentMode alignment_mode { get; set; }
		[NoAccessorMethod]
		public Gtk.SourceGutterLines lines { owned get; }
		public Gtk.TextView view { get; }
		public float xalign { get; set; }
		public int xpad { get; set; }
		public float yalign { get; set; }
		public int ypad { get; set; }
		[HasEmitter]
		public virtual signal void activate (Gtk.TextIter iter, Gdk.Rectangle area, uint button, Gdk.ModifierType state, int n_presses);
		[HasEmitter]
		public virtual signal bool query_activatable (Gtk.TextIter iter, Gdk.Rectangle area);
		public virtual signal void query_data (GLib.Object lines, uint line);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_renderer_pixbuf_get_type ()")]
	[GIR (name = "GutterRendererPixbuf")]
	public class SourceGutterRendererPixbuf : Gtk.SourceGutterRenderer, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false, type = "GtkSourceGutterRenderer*")]
		public SourceGutterRendererPixbuf ();
		public unowned GLib.Icon get_gicon ();
		public unowned string get_icon_name ();
		[Version (since = "5.0")]
		public unowned Gdk.Paintable? get_paintable ();
		public unowned Gdk.Pixbuf get_pixbuf ();
		[Version (since = "5.0")]
		public void overlay_paintable (Gdk.Paintable paintable);
		public void set_gicon (GLib.Icon? icon);
		public void set_icon_name (string? icon_name);
		public void set_paintable (Gdk.Paintable? paintable);
		public void set_pixbuf (Gdk.Pixbuf? pixbuf);
		public GLib.Icon gicon { get; set; }
		public string icon_name { get; set; }
		public Gdk.Paintable paintable { get; set; }
		public Gdk.Pixbuf pixbuf { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_gutter_renderer_text_get_type ()")]
	[GIR (name = "GutterRendererText")]
	public class SourceGutterRendererText : Gtk.SourceGutterRenderer, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false, type = "GtkSourceGutterRenderer*")]
		public SourceGutterRendererText ();
		public void measure (string text, out int width, out int height);
		public void measure_markup (string markup, out int width, out int height);
		public void set_markup (string markup, int length);
		public void set_text (string text, int length);
		[NoAccessorMethod]
		public string markup { owned get; set construct; }
		[NoAccessorMethod]
		public string text { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_hover_get_type ()")]
	[GIR (name = "Hover")]
	public class SourceHover : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceHover ();
		public void add_provider (Gtk.SourceHoverProvider provider);
		public void remove_provider (Gtk.SourceHoverProvider provider);
		[NoAccessorMethod]
		public uint hover_delay { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_hover_context_get_type ()")]
	[GIR (name = "HoverContext")]
	public class SourceHoverContext : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceHoverContext ();
		public bool get_bounds (Gtk.TextIter begin, Gtk.TextIter end);
		public unowned Gtk.SourceBuffer get_buffer ();
		public bool get_iter (Gtk.TextIter iter);
		public unowned Gtk.SourceView get_view ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_hover_display_get_type ()")]
	[GIR (name = "HoverDisplay")]
	public class SourceHoverDisplay : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget {
		[CCode (has_construct_function = false)]
		protected SourceHoverDisplay ();
		public void append (Gtk.Widget child);
		public void insert_after (Gtk.Widget child, Gtk.Widget sibling);
		public void prepend (Gtk.Widget child);
		public void remove (Gtk.Widget child);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_language_get_type ()")]
	[GIR (name = "Language")]
	public class SourceLanguage : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceLanguage ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_globs ();
		public bool get_hidden ();
		public unowned string get_id ();
		public unowned string? get_metadata (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_mime_types ();
		public unowned string get_name ();
		public unowned string get_section ();
		[Version (since = "3.4")]
		public unowned string? get_style_fallback (string style_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_style_ids ();
		public unowned string? get_style_name (string style_id);
		public bool hidden { get; }
		public string id { get; }
		public string name { get; }
		public string section { get; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_language_manager_get_type ()")]
	[GIR (name = "LanguageManager")]
	public class SourceLanguageManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceLanguageManager ();
		public static unowned Gtk.SourceLanguageManager get_default ();
		public unowned Gtk.SourceLanguage? get_language (string id);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_language_ids ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_search_path ();
		[Version (since = "2.4")]
		public unowned Gtk.SourceLanguage? guess_language (string? filename, string? content_type);
		public void set_search_path ([CCode (array_length = false, array_null_terminated = true)] string[]? dirs);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] language_ids { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] search_path { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_map_get_type ()")]
	[GIR (name = "Map")]
	public class SourceMap : Gtk.SourceView, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.18")]
		public SourceMap ();
		[Version (since = "3.18")]
		public unowned Gtk.SourceView? get_view ();
		[Version (since = "3.18")]
		public void set_view (Gtk.SourceView view);
		[NoAccessorMethod]
		public Pango.FontDescription font_desc { owned get; set; }
		public Gtk.SourceView view { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_mark_get_type ()")]
	[GIR (name = "Mark")]
	public class SourceMark : Gtk.TextMark {
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public SourceMark (string name, string category);
		[Version (since = "2.2")]
		public unowned string get_category ();
		[Version (since = "2.2")]
		public unowned Gtk.SourceMark? next (string? category);
		[Version (since = "2.2")]
		public unowned Gtk.SourceMark? prev (string category);
		public string category { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_mark_attributes_get_type ()")]
	[GIR (name = "MarkAttributes")]
	public class SourceMarkAttributes : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceMarkAttributes ();
		public bool get_background (out Gdk.RGBA background);
		public unowned GLib.Icon get_gicon ();
		public unowned string get_icon_name ();
		public unowned Gdk.Pixbuf get_pixbuf ();
		public string get_tooltip_markup (Gtk.SourceMark mark);
		public string get_tooltip_text (Gtk.SourceMark mark);
		public unowned Gdk.Paintable render_icon (Gtk.Widget widget, int size);
		public void set_background (Gdk.RGBA background);
		public void set_gicon (GLib.Icon gicon);
		public void set_icon_name (string icon_name);
		public void set_pixbuf (Gdk.Pixbuf pixbuf);
		[NoAccessorMethod]
		public Gdk.RGBA background { owned get; set; }
		public GLib.Icon gicon { get; set; }
		public string icon_name { get; set; }
		public Gdk.Pixbuf pixbuf { get; set; }
		public signal string query_tooltip_markup (Gtk.SourceMark mark);
		public signal string query_tooltip_text (Gtk.SourceMark mark);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_print_compositor_get_type ()")]
	[GIR (name = "PrintCompositor")]
	public class SourcePrintCompositor : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public SourcePrintCompositor (Gtk.SourceBuffer buffer);
		public void draw_page (Gtk.PrintContext context, int page_nr);
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public SourcePrintCompositor.from_view (Gtk.SourceView view);
		[Version (since = "2.2")]
		public string get_body_font_name ();
		[Version (since = "2.2")]
		public double get_bottom_margin (Gtk.Unit unit);
		[Version (since = "2.2")]
		public unowned Gtk.SourceBuffer get_buffer ();
		[Version (since = "2.2")]
		public string get_footer_font_name ();
		[Version (since = "2.2")]
		public string get_header_font_name ();
		[Version (since = "2.2")]
		public bool get_highlight_syntax ();
		[Version (since = "2.2")]
		public double get_left_margin (Gtk.Unit unit);
		[Version (since = "2.2")]
		public string get_line_numbers_font_name ();
		[Version (since = "2.2")]
		public int get_n_pages ();
		[Version (since = "2.2")]
		public double get_pagination_progress ();
		[Version (since = "2.2")]
		public bool get_print_footer ();
		[Version (since = "2.2")]
		public bool get_print_header ();
		[Version (since = "2.2")]
		public uint get_print_line_numbers ();
		[Version (since = "2.2")]
		public double get_right_margin (Gtk.Unit unit);
		[Version (since = "2.2")]
		public uint get_tab_width ();
		[Version (since = "2.2")]
		public double get_top_margin (Gtk.Unit unit);
		[Version (since = "2.2")]
		public Gtk.WrapMode get_wrap_mode ();
		[Version (since = "2.2")]
		public bool paginate (Gtk.PrintContext context);
		[Version (since = "2.2")]
		public void set_body_font_name (string font_name);
		[Version (since = "2.2")]
		public void set_bottom_margin (double margin, Gtk.Unit unit);
		[Version (since = "2.2")]
		public void set_footer_font_name (string? font_name);
		[Version (since = "2.2")]
		public void set_footer_format (bool separator, string? left, string? center, string? right);
		[Version (since = "2.2")]
		public void set_header_font_name (string? font_name);
		[Version (since = "2.2")]
		public void set_header_format (bool separator, string? left, string? center, string? right);
		[Version (since = "2.2")]
		public void set_highlight_syntax (bool highlight);
		[Version (since = "2.2")]
		public void set_left_margin (double margin, Gtk.Unit unit);
		[Version (since = "2.2")]
		public void set_line_numbers_font_name (string? font_name);
		[Version (since = "2.2")]
		public void set_print_footer (bool print);
		[Version (since = "2.2")]
		public void set_print_header (bool print);
		[Version (since = "2.2")]
		public void set_print_line_numbers (uint interval);
		[Version (since = "2.2")]
		public void set_right_margin (double margin, Gtk.Unit unit);
		[Version (since = "2.2")]
		public void set_tab_width (uint width);
		[Version (since = "2.2")]
		public void set_top_margin (double margin, Gtk.Unit unit);
		[Version (since = "2.2")]
		public void set_wrap_mode (Gtk.WrapMode wrap_mode);
		[Version (since = "2.2")]
		public string body_font_name { owned get; set; }
		[Version (since = "2.2")]
		public Gtk.SourceBuffer buffer { get; construct; }
		[Version (since = "2.2")]
		public string footer_font_name { owned get; set; }
		[Version (since = "2.2")]
		public string header_font_name { owned get; set; }
		[Version (since = "2.2")]
		public bool highlight_syntax { get; set; }
		[Version (since = "2.2")]
		public string line_numbers_font_name { owned get; set; }
		[Version (since = "2.2")]
		public int n_pages { get; }
		[Version (since = "2.2")]
		public bool print_footer { get; set; }
		[Version (since = "2.2")]
		public bool print_header { get; set; }
		[Version (since = "2.2")]
		public uint print_line_numbers { get; set; }
		[Version (since = "2.2")]
		public uint tab_width { get; set; }
		[Version (since = "2.2")]
		public Gtk.WrapMode wrap_mode { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_region_get_type ()")]
	[GIR (name = "Region")]
	public class SourceRegion : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.22")]
		public SourceRegion (Gtk.TextBuffer buffer);
		[Version (since = "3.22")]
		public void add_region (Gtk.SourceRegion? region_to_add);
		[Version (since = "3.22")]
		public void add_subregion (Gtk.TextIter _start, Gtk.TextIter _end);
		[Version (since = "3.22")]
		public bool get_bounds (out Gtk.TextIter start, out Gtk.TextIter end);
		[Version (since = "3.22")]
		public unowned Gtk.TextBuffer? get_buffer ();
		[Version (since = "3.22")]
		public Gtk.SourceRegionIter get_start_region_iter ();
		[Version (since = "3.22")]
		public Gtk.SourceRegion? intersect_region (Gtk.SourceRegion? region2);
		[Version (since = "3.22")]
		public Gtk.SourceRegion? intersect_subregion (Gtk.TextIter _start, Gtk.TextIter _end);
		[Version (since = "3.22")]
		public bool is_empty ();
		[Version (since = "3.22")]
		public void subtract_region (Gtk.SourceRegion? region_to_subtract);
		[Version (since = "3.22")]
		public void subtract_subregion (Gtk.TextIter _start, Gtk.TextIter _end);
		[Version (since = "3.22")]
		public string? to_string ();
		[Version (since = "3.22")]
		public Gtk.TextBuffer buffer { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_search_context_get_type ()")]
	[GIR (name = "SearchContext")]
	public class SourceSearchContext : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.10")]
		public SourceSearchContext (Gtk.SourceBuffer buffer, Gtk.SourceSearchSettings? settings);
		[Version (since = "4.0")]
		public bool backward (Gtk.TextIter iter, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around);
		[Version (since = "3.10")]
		public async bool backward_async (Gtk.TextIter iter, GLib.Cancellable? cancellable, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around) throws GLib.Error;
		[Version (since = "4.0")]
		public bool forward (Gtk.TextIter iter, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around);
		[Version (since = "3.10")]
		public async bool forward_async (Gtk.TextIter iter, GLib.Cancellable? cancellable, out Gtk.TextIter match_start, out Gtk.TextIter match_end, out bool has_wrapped_around) throws GLib.Error;
		[Version (since = "3.10")]
		public unowned Gtk.SourceBuffer get_buffer ();
		[Version (since = "3.10")]
		public bool get_highlight ();
		[Version (since = "3.16")]
		public unowned Gtk.SourceStyle get_match_style ();
		[Version (since = "3.10")]
		public int get_occurrence_position (Gtk.TextIter match_start, Gtk.TextIter match_end);
		[Version (since = "3.10")]
		public int get_occurrences_count ();
		[Version (since = "3.10")]
		public GLib.Error? get_regex_error ();
		[Version (since = "3.10")]
		public unowned Gtk.SourceSearchSettings get_settings ();
		[Version (since = "4.0")]
		public bool replace (Gtk.TextIter match_start, Gtk.TextIter match_end, string replace, int replace_length) throws GLib.Error;
		[Version (since = "3.10")]
		public uint replace_all (string replace, int replace_length) throws GLib.Error;
		[Version (since = "3.10")]
		public void set_highlight (bool highlight);
		[Version (since = "3.16")]
		public void set_match_style (Gtk.SourceStyle? match_style);
		[Version (since = "3.10")]
		public Gtk.SourceBuffer buffer { get; construct; }
		[Version (since = "3.10")]
		public bool highlight { get; set construct; }
		[Version (since = "3.16")]
		public Gtk.SourceStyle match_style { get; set construct; }
		[Version (since = "3.10")]
		public int occurrences_count { get; }
		[Version (since = "3.10")]
		public GLib.Error? regex_error { owned get; }
		[Version (since = "3.10")]
		public Gtk.SourceSearchSettings settings { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_search_settings_get_type ()")]
	[GIR (name = "SearchSettings")]
	public class SourceSearchSettings : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.10")]
		public SourceSearchSettings ();
		[Version (since = "3.10")]
		public bool get_at_word_boundaries ();
		[Version (since = "3.10")]
		public bool get_case_sensitive ();
		[Version (since = "3.10")]
		public bool get_regex_enabled ();
		[Version (since = "3.10")]
		public unowned string? get_search_text ();
		[Version (since = "3.10")]
		public bool get_wrap_around ();
		[Version (since = "3.10")]
		public void set_at_word_boundaries (bool at_word_boundaries);
		[Version (since = "3.10")]
		public void set_case_sensitive (bool case_sensitive);
		[Version (since = "3.10")]
		public void set_regex_enabled (bool regex_enabled);
		[Version (since = "3.10")]
		public void set_search_text (string? search_text);
		[Version (since = "3.10")]
		public void set_wrap_around (bool wrap_around);
		[Version (since = "3.10")]
		public bool at_word_boundaries { get; set construct; }
		[Version (since = "3.10")]
		public bool case_sensitive { get; set construct; }
		[Version (since = "3.10")]
		public bool regex_enabled { get; set construct; }
		[Version (since = "3.10")]
		public string search_text { get; set construct; }
		[Version (since = "3.10")]
		public bool wrap_around { get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_get_type ()")]
	[GIR (name = "Snippet")]
	public class SourceSnippet : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "5.0")]
		public SourceSnippet (string? trigger, string? language_id);
		[Version (since = "5.0")]
		public void add_chunk (Gtk.SourceSnippetChunk chunk);
		[Version (since = "5.0")]
		public Gtk.SourceSnippet copy ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceSnippetContext? get_context ();
		[Version (since = "5.0")]
		public unowned string get_description ();
		[Version (since = "5.0")]
		public int get_focus_position ();
		[Version (since = "5.0")]
		public unowned string get_language_id ();
		[Version (since = "5.0")]
		public uint get_n_chunks ();
		[Version (since = "5.0")]
		public unowned string get_name ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceSnippetChunk get_nth_chunk (uint nth);
		[Version (since = "5.0")]
		public unowned string? get_trigger ();
		[Version (since = "5.0")]
		public void set_description (string description);
		[Version (since = "5.0")]
		public void set_language_id (string language_id);
		[Version (since = "5.0")]
		public void set_name (string name);
		[Version (since = "5.0")]
		public void set_trigger (string trigger);
		[NoAccessorMethod]
		public Gtk.TextBuffer buffer { owned get; }
		public string description { get; set; }
		public int focus_position { get; }
		public string language_id { get; set; }
		public string name { get; set; }
		public string trigger { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_chunk_get_type ()")]
	[GIR (name = "SnippetChunk")]
	public class SourceSnippetChunk : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		[Version (since = "5.0")]
		public SourceSnippetChunk ();
		[Version (since = "5.0")]
		public Gtk.SourceSnippetChunk copy ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceSnippetContext get_context ();
		[Version (since = "5.0")]
		public int get_focus_position ();
		[Version (since = "5.0")]
		public unowned string? get_spec ();
		[Version (since = "5.0")]
		public unowned string get_text ();
		[Version (since = "5.0")]
		public bool get_text_set ();
		public unowned string get_tooltip_text ();
		public void set_context (Gtk.SourceSnippetContext context);
		[Version (since = "5.0")]
		public void set_focus_position (int focus_position);
		[Version (since = "5.0")]
		public void set_spec (string spec);
		[Version (since = "5.0")]
		public void set_text (string text);
		[Version (since = "5.0")]
		public void set_text_set (bool text_set);
		public void set_tooltip_text (string tooltip_text);
		public Gtk.SourceSnippetContext context { get; set; }
		public int focus_position { get; set; }
		public string spec { get; set; }
		public string text { get; set; }
		public bool text_set { get; set; }
		public string tooltip_text { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_context_get_type ()")]
	[GIR (name = "SnippetContext")]
	public class SourceSnippetContext : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "5.0")]
		public SourceSnippetContext ();
		[Version (since = "5.0")]
		public void clear_variables ();
		public string expand (string input);
		[Version (since = "5.0")]
		public unowned string? get_variable (string key);
		[Version (since = "5.0")]
		public void set_constant (string key, string value);
		public void set_line_prefix (string line_prefix);
		public void set_tab_width (int tab_width);
		public void set_use_spaces (bool use_spaces);
		[Version (since = "5.0")]
		public void set_variable (string key, string value);
		[Version (since = "5.0")]
		public signal void changed ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_snippet_manager_get_type ()")]
	[GIR (name = "SnippetManager")]
	public class SourceSnippetManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceSnippetManager ();
		[Version (since = "5.0")]
		public static unowned Gtk.SourceSnippetManager get_default ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "5.0")]
		public unowned string[] get_search_path ();
		[Version (since = "5.0")]
		public Gtk.SourceSnippet? get_snippet (string? group, string? language_id, string trigger);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "5.0")]
		public (unowned string)[] list_groups ();
		[Version (since = "5.0")]
		public GLib.ListModel list_matching (string? group, string? language_id, string? trigger_prefix);
		[Version (since = "5.0")]
		public void set_search_path ([CCode (array_length = false, array_null_terminated = true)] string[]? dirs);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "5.0")]
		public string[] search_path { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_space_drawer_get_type ()")]
	[GIR (name = "SpaceDrawer")]
	public class SourceSpaceDrawer : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.24")]
		public SourceSpaceDrawer ();
		[Version (since = "3.24")]
		public void bind_matrix_setting (GLib.Settings settings, string key, GLib.SettingsBindFlags flags);
		[Version (since = "3.24")]
		public bool get_enable_matrix ();
		[Version (since = "3.24")]
		public GLib.Variant get_matrix ();
		[Version (since = "3.24")]
		public Gtk.SourceSpaceTypeFlags get_types_for_locations (Gtk.SourceSpaceLocationFlags locations);
		[Version (since = "3.24")]
		public void set_enable_matrix (bool enable_matrix);
		[Version (since = "3.24")]
		public void set_matrix (GLib.Variant? matrix);
		[Version (since = "3.24")]
		public void set_types_for_locations (Gtk.SourceSpaceLocationFlags locations, Gtk.SourceSpaceTypeFlags types);
		[Version (since = "3.24")]
		public bool enable_matrix { get; set construct; }
		[Version (since = "3.24")]
		public GLib.Variant matrix { owned get; set construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_get_type ()")]
	[GIR (name = "Style")]
	public class SourceStyle : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceStyle ();
		[Version (since = "3.22")]
		public void apply (Gtk.TextTag tag);
		[Version (since = "2.0")]
		public Gtk.SourceStyle copy ();
		[NoAccessorMethod]
		public string background { owned get; construct; }
		[NoAccessorMethod]
		public bool background_set { get; construct; }
		[NoAccessorMethod]
		public bool bold { get; construct; }
		[NoAccessorMethod]
		public bool bold_set { get; construct; }
		[NoAccessorMethod]
		public string foreground { owned get; construct; }
		[NoAccessorMethod]
		public bool foreground_set { get; construct; }
		[NoAccessorMethod]
		public bool italic { get; construct; }
		[NoAccessorMethod]
		public bool italic_set { get; construct; }
		[NoAccessorMethod]
		public string line_background { owned get; construct; }
		[NoAccessorMethod]
		public bool line_background_set { get; construct; }
		[NoAccessorMethod]
		public Pango.Underline pango_underline { get; construct; }
		[NoAccessorMethod]
		public string scale { owned get; construct; }
		[NoAccessorMethod]
		public bool scale_set { get; construct; }
		[NoAccessorMethod]
		public bool strikethrough { get; construct; }
		[NoAccessorMethod]
		public bool strikethrough_set { get; construct; }
		[NoAccessorMethod]
		public string underline_color { owned get; construct; }
		[NoAccessorMethod]
		public bool underline_color_set { get; construct; }
		[NoAccessorMethod]
		public bool underline_set { get; construct; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_get_type ()")]
	[GIR (name = "StyleScheme")]
	public class SourceStyleScheme : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SourceStyleScheme ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.0")]
		public unowned string[]? get_authors ();
		[Version (since = "2.0")]
		public unowned string? get_description ();
		[Version (since = "2.0")]
		public unowned string? get_filename ();
		[Version (since = "2.0")]
		public unowned string get_id ();
		[Version (since = "2.0")]
		public unowned string get_name ();
		[Version (since = "2.0")]
		public unowned Gtk.SourceStyle? get_style (string style_id);
		public string description { get; }
		public string filename { get; }
		public string id { get; construct; }
		public string name { get; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_chooser_button_get_type ()")]
	[GIR (name = "StyleSchemeChooserButton")]
	public class SourceStyleSchemeChooserButton : Gtk.Button, Gtk.Accessible, Gtk.Actionable, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.SourceStyleSchemeChooser {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.16")]
		public SourceStyleSchemeChooserButton ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_chooser_widget_get_type ()")]
	[GIR (name = "StyleSchemeChooserWidget")]
	public class SourceStyleSchemeChooserWidget : Gtk.Widget, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.SourceStyleSchemeChooser {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.16")]
		public SourceStyleSchemeChooserWidget ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_style_scheme_manager_get_type ()")]
	[GIR (name = "StyleSchemeManager")]
	public class SourceStyleSchemeManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceStyleSchemeManager ();
		public void append_search_path (string path);
		public void force_rescan ();
		public static unowned Gtk.SourceStyleSchemeManager get_default ();
		public unowned Gtk.SourceStyleScheme? get_scheme (string scheme_id);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_scheme_ids ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_search_path ();
		public void prepend_search_path (string path);
		public void set_search_path ([CCode (array_length = false, array_null_terminated = true)] string[]? path);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] scheme_ids { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] search_path { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_tag_get_type ()")]
	[GIR (name = "Tag")]
	public class SourceTag : Gtk.TextTag {
		[CCode (has_construct_function = false, type = "GtkTextTag*")]
		[Version (since = "3.20")]
		public SourceTag (string? name);
		[NoAccessorMethod]
		[Version (since = "3.20")]
		public bool draw_spaces { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.20")]
		public bool draw_spaces_set { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_id = "gtk_source_view_get_type ()")]
	[GIR (name = "View")]
	public class SourceView : Gtk.TextView, Gtk.Accessible, Gtk.Buildable, Gtk.ConstraintTarget, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SourceView ();
		public bool get_auto_indent ();
		[Version (since = "3.16")]
		public Gtk.SourceBackgroundPatternType get_background_pattern ();
		public unowned Gtk.SourceCompletion get_completion ();
		[Version (since = "5.0")]
		public bool get_enable_snippets ();
		[Version (since = "2.8")]
		public unowned Gtk.SourceGutter get_gutter (Gtk.TextWindowType window_type);
		public bool get_highlight_current_line ();
		public unowned Gtk.SourceHover get_hover ();
		public bool get_indent_on_tab ();
		public int get_indent_width ();
		[Version (since = "5.0")]
		public unowned Gtk.SourceIndenter? get_indenter ();
		public bool get_insert_spaces_instead_of_tabs ();
		public unowned Gtk.SourceMarkAttributes get_mark_attributes (string category, int priority);
		public uint get_right_margin_position ();
		[Version (since = "2.2")]
		public bool get_show_line_marks ();
		public bool get_show_line_numbers ();
		public bool get_show_right_margin ();
		[Version (since = "3.18")]
		public bool get_smart_backspace ();
		public Gtk.SourceSmartHomeEndType get_smart_home_end ();
		[Version (since = "3.24")]
		public unowned Gtk.SourceSpaceDrawer get_space_drawer ();
		public uint get_tab_width ();
		public uint get_visual_column (Gtk.TextIter iter);
		[Version (since = "3.16")]
		public void indent_lines (Gtk.TextIter start, Gtk.TextIter end);
		public void set_auto_indent (bool enable);
		[Version (since = "3.16")]
		public void set_background_pattern (Gtk.SourceBackgroundPatternType background_pattern);
		[Version (since = "5.0")]
		public void set_enable_snippets (bool enable_snippets);
		public void set_highlight_current_line (bool highlight);
		public void set_indent_on_tab (bool enable);
		public void set_indent_width (int width);
		[Version (since = "5.0")]
		public void set_indenter (Gtk.SourceIndenter? indenter);
		public void set_insert_spaces_instead_of_tabs (bool enable);
		public void set_mark_attributes (string category, Gtk.SourceMarkAttributes attributes, int priority);
		public void set_right_margin_position (uint pos);
		[Version (since = "2.2")]
		public void set_show_line_marks (bool show);
		public void set_show_line_numbers (bool show);
		public void set_show_right_margin (bool show);
		[Version (since = "3.18")]
		public void set_smart_backspace (bool smart_backspace);
		public void set_smart_home_end (Gtk.SourceSmartHomeEndType smart_home_end);
		public void set_tab_width (uint width);
		[Version (since = "3.16")]
		public void unindent_lines (Gtk.TextIter start, Gtk.TextIter end);
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SourceView.with_buffer (Gtk.SourceBuffer buffer);
		public bool auto_indent { get; set; }
		[Version (since = "3.16")]
		public Gtk.SourceBackgroundPatternType background_pattern { get; set; }
		public Gtk.SourceCompletion completion { get; }
		[Version (since = "5.0")]
		public bool enable_snippets { get; set; }
		public bool highlight_current_line { get; set; }
		public bool indent_on_tab { get; set; }
		public int indent_width { get; set; }
		[Version (since = "5.0")]
		public Gtk.SourceIndenter indenter { get; set; }
		public bool insert_spaces_instead_of_tabs { get; set; }
		public uint right_margin_position { get; set; }
		public bool show_line_marks { get; set; }
		public bool show_line_numbers { get; set; }
		public bool show_right_margin { get; set; }
		[Version (since = "3.18")]
		public bool smart_backspace { get; set; }
		[Version (since = "2.0")]
		public Gtk.SourceSmartHomeEndType smart_home_end { get; set; }
		[Version (since = "3.24")]
		public Gtk.SourceSpaceDrawer space_drawer { get; }
		public uint tab_width { get; set; }
		[Version (since = "3.16")]
		public signal void change_case (Gtk.SourceChangeCaseType case_type);
		[Version (since = "3.16")]
		public signal void change_number (int count);
		[Version (since = "3.16")]
		public signal void join_lines ();
		public virtual signal void line_mark_activated (Gtk.TextIter iter, uint button, Gdk.ModifierType state, int n_presses);
		public virtual signal void move_lines (bool down);
		[Version (since = "3.16")]
		public signal void move_to_matching_bracket (bool extend_selection);
		[Version (since = "3.0")]
		public virtual signal void move_words (int step);
		[HasEmitter]
		[Version (since = "5.0")]
		public virtual signal void push_snippet (Gtk.SourceSnippet snippet, ref Gtk.TextIter location);
		public virtual signal void show_completion ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceCompletionProposalInterface", type_id = "gtk_source_completion_proposal_get_type ()")]
	[GIR (name = "CompletionProposal")]
	public interface SourceCompletionProposal : GLib.Object {
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceCompletionProviderInterface", type_id = "gtk_source_completion_provider_get_type ()")]
	[GIR (name = "CompletionProvider")]
	public interface SourceCompletionProvider : GLib.Object {
		[Version (since = "5.0")]
		public virtual void activate (Gtk.SourceCompletionContext context, Gtk.SourceCompletionProposal proposal);
		[Version (since = "5.0")]
		public virtual void display (Gtk.SourceCompletionContext context, Gtk.SourceCompletionProposal proposal, Gtk.SourceCompletionCell cell);
		[Version (since = "5.0")]
		public virtual int get_priority (Gtk.SourceCompletionContext context);
		[Version (since = "5.0")]
		public virtual string? get_title ();
		[Version (since = "5.0")]
		public virtual bool is_trigger (Gtk.TextIter iter, unichar ch);
		[Version (since = "5.0")]
		public virtual bool key_activates (Gtk.SourceCompletionContext context, Gtk.SourceCompletionProposal proposal, uint keyval, Gdk.ModifierType state);
		[Version (since = "5.0")]
		public virtual GLib.GenericArray<Gtk.SourceCompletionProposal>? list_alternates (Gtk.SourceCompletionContext context, Gtk.SourceCompletionProposal proposal);
		[Version (since = "5.0")]
		public virtual async GLib.ListModel populate_async (Gtk.SourceCompletionContext context, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "5.0")]
		public virtual void refilter (Gtk.SourceCompletionContext context, GLib.ListModel model);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceHoverProviderInterface", type_id = "gtk_source_hover_provider_get_type ()")]
	[GIR (name = "HoverProvider")]
	public interface SourceHoverProvider : GLib.Object {
		[NoWrapper]
		public abstract bool populate (Gtk.SourceHoverContext context, Gtk.SourceHoverDisplay display) throws GLib.Error;
		public abstract async bool populate_async (Gtk.SourceHoverContext context, Gtk.SourceHoverDisplay display, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceIndenterInterface", type_id = "gtk_source_indenter_get_type ()")]
	[GIR (name = "Indenter")]
	public interface SourceIndenter : GLib.Object {
		[Version (since = "5.0")]
		public abstract void indent (Gtk.SourceView view, ref Gtk.TextIter iter);
		[Version (since = "5.0")]
		public abstract bool is_trigger (Gtk.SourceView view, Gtk.TextIter location, Gdk.ModifierType state, uint keyval);
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", type_cname = "GtkSourceStyleSchemeChooserInterface", type_id = "gtk_source_style_scheme_chooser_get_type ()")]
	[GIR (name = "StyleSchemeChooser")]
	public interface SourceStyleSchemeChooser : GLib.Object {
		[Version (since = "3.16")]
		public abstract unowned Gtk.SourceStyleScheme get_style_scheme ();
		[Version (since = "3.16")]
		public abstract void set_style_scheme (Gtk.SourceStyleScheme scheme);
		[Version (since = "3.16")]
		public abstract Gtk.SourceStyleScheme style_scheme { get; set; }
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", has_type_id = false)]
	[GIR (name = "RegionIter")]
	[Version (since = "3.22")]
	public struct SourceRegionIter {
		public bool get_subregion (out Gtk.TextIter start, out Gtk.TextIter end);
		public bool is_end ();
		public bool next ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_BACKGROUND_PATTERN_TYPE_", type_id = "gtk_source_background_pattern_type_get_type ()")]
	[GIR (name = "BackgroundPatternType")]
	[Version (since = "3.16")]
	public enum SourceBackgroundPatternType {
		NONE,
		GRID
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_BRACKET_MATCH_", type_id = "gtk_source_bracket_match_type_get_type ()")]
	[GIR (name = "BracketMatchType")]
	public enum SourceBracketMatchType {
		NONE,
		OUT_OF_RANGE,
		NOT_FOUND,
		FOUND
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_CHANGE_CASE_", type_id = "gtk_source_change_case_type_get_type ()")]
	[GIR (name = "ChangeCaseType")]
	[Version (since = "3.12")]
	public enum SourceChangeCaseType {
		LOWER,
		UPPER,
		TOGGLE,
		TITLE
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_COMPLETION_ACTIVATION_", type_id = "gtk_source_completion_activation_get_type ()")]
	[GIR (name = "CompletionActivation")]
	public enum SourceCompletionActivation {
		NONE,
		INTERACTIVE,
		USER_REQUESTED
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_COMPLETION_COLUMN_", type_id = "gtk_source_completion_column_get_type ()")]
	[GIR (name = "CompletionColumn")]
	public enum SourceCompletionColumn {
		ICON,
		BEFORE,
		TYPED_TEXT,
		AFTER,
		COMMENT,
		DETAILS
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_COMPRESSION_TYPE_", type_id = "gtk_source_compression_type_get_type ()")]
	[GIR (name = "CompressionType")]
	[Version (since = "3.14")]
	public enum SourceCompressionType {
		NONE,
		GZIP
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_FILE_SAVER_FLAGS_", type_id = "gtk_source_file_saver_flags_get_type ()")]
	[Flags]
	[GIR (name = "FileSaverFlags")]
	[Version (since = "3.14")]
	public enum SourceFileSaverFlags {
		NONE,
		IGNORE_INVALID_CHARS,
		IGNORE_MODIFICATION_TIME,
		CREATE_BACKUP
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_", type_id = "gtk_source_gutter_renderer_alignment_mode_get_type ()")]
	[GIR (name = "GutterRendererAlignmentMode")]
	public enum SourceGutterRendererAlignmentMode {
		CELL,
		FIRST,
		LAST
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_NEWLINE_TYPE_", type_id = "gtk_source_newline_type_get_type ()")]
	[GIR (name = "NewlineType")]
	[Version (since = "3.14")]
	public enum SourceNewlineType {
		LF,
		CR,
		CR_LF
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SMART_HOME_END_", type_id = "gtk_source_smart_home_end_type_get_type ()")]
	[GIR (name = "SmartHomeEndType")]
	public enum SourceSmartHomeEndType {
		DISABLED,
		BEFORE,
		AFTER,
		ALWAYS
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SORT_FLAGS_", type_id = "gtk_source_sort_flags_get_type ()")]
	[Flags]
	[GIR (name = "SortFlags")]
	[Version (since = "3.18")]
	public enum SourceSortFlags {
		NONE,
		CASE_SENSITIVE,
		REVERSE_ORDER,
		REMOVE_DUPLICATES
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SPACE_LOCATION_", type_id = "gtk_source_space_location_flags_get_type ()")]
	[Flags]
	[GIR (name = "SpaceLocationFlags")]
	[Version (since = "3.24")]
	public enum SourceSpaceLocationFlags {
		NONE,
		LEADING,
		INSIDE_TEXT,
		TRAILING,
		ALL
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_SPACE_TYPE_", type_id = "gtk_source_space_type_flags_get_type ()")]
	[Flags]
	[GIR (name = "SpaceTypeFlags")]
	[Version (since = "3.24")]
	public enum SourceSpaceTypeFlags {
		NONE,
		SPACE,
		TAB,
		NEWLINE,
		NBSP,
		ALL
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_VIEW_GUTTER_POSITION_", type_id = "gtk_source_view_gutter_position_get_type ()")]
	[GIR (name = "ViewGutterPosition")]
	public enum SourceViewGutterPosition {
		LINES,
		MARKS
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_FILE_LOADER_ERROR_")]
	[GIR (name = "FileLoaderError")]
	public errordomain SourceFileLoaderError {
		TOO_BIG,
		ENCODING_AUTO_DETECTION_FAILED,
		CONVERSION_FALLBACK;
		[CCode (cname = "gtk_source_file_loader_error_quark")]
		public static GLib.Quark uark ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cprefix = "GTK_SOURCE_FILE_SAVER_ERROR_")]
	[GIR (name = "FileSaverError")]
	[Version (since = "3.14")]
	public errordomain SourceFileSaverError {
		INVALID_CHARS,
		EXTERNALLY_MODIFIED;
		[CCode (cname = "gtk_source_file_saver_error_quark")]
		public static GLib.Quark uark ();
	}
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cname = "gtk_source_finalize")]
	[Version (since = "4.0")]
	public static void Sourcefinalize ();
	[CCode (cheader_filename = "gtksourceview/gtksource.h", cname = "gtk_source_init")]
	[Version (since = "4.0")]
	public static void Sourceinit ();
}
