/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.bulk.BulkRequestParser;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class BulkRequest
extends ActionRequest
implements CompositeIndicesRequest,
WriteRequest<BulkRequest>,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(BulkRequest.class);
    private static final int REQUEST_OVERHEAD = 50;
    final List<DocWriteRequest<?>> requests = new ArrayList();
    private final Set<String> indices = new HashSet<String>();
    protected TimeValue timeout = BulkShardRequest.DEFAULT_TIMEOUT;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private String globalPipeline;
    private String globalRouting;
    private String globalIndex;
    private String globalType;
    private Boolean globalRequireAlias;
    private long sizeInBytes = 0L;

    public BulkRequest() {
    }

    public BulkRequest(StreamInput in) throws IOException {
        super(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.requests.addAll(in.readList(i -> DocWriteRequest.readDocumentRequest(null, i)));
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        this.timeout = in.readTimeValue();
    }

    public BulkRequest(@Nullable String globalIndex) {
        this.globalIndex = globalIndex;
    }

    @Deprecated
    public BulkRequest(@Nullable String globalIndex, @Nullable String globalType) {
        this.globalIndex = globalIndex;
        this.globalType = globalType;
    }

    public BulkRequest add(DocWriteRequest<?> ... requests) {
        for (DocWriteRequest<?> request : requests) {
            this.add(request);
        }
        return this;
    }

    public BulkRequest add(DocWriteRequest<?> request) {
        if (request instanceof IndexRequest) {
            this.add((IndexRequest)request);
        } else if (request instanceof DeleteRequest) {
            this.add((DeleteRequest)request);
        } else if (request instanceof UpdateRequest) {
            this.add((UpdateRequest)request);
        } else {
            throw new IllegalArgumentException("No support for request [" + request + "]");
        }
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(Iterable<DocWriteRequest<?>> requests) {
        for (DocWriteRequest<?> request : requests) {
            this.add(request);
        }
        return this;
    }

    public BulkRequest add(IndexRequest request) {
        return this.internalAdd(request);
    }

    BulkRequest internalAdd(IndexRequest request) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.applyGlobalMandatoryParameters(request);
        this.requests.add(request);
        this.sizeInBytes += (long)((request.source() != null ? request.source().length() : 0) + 50);
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(UpdateRequest request) {
        return this.internalAdd(request);
    }

    BulkRequest internalAdd(UpdateRequest request) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.applyGlobalMandatoryParameters(request);
        this.requests.add(request);
        if (request.doc() != null) {
            this.sizeInBytes += (long)request.doc().source().length();
        }
        if (request.upsertRequest() != null) {
            this.sizeInBytes += (long)request.upsertRequest().source().length();
        }
        if (request.script() != null) {
            this.sizeInBytes += (long)(request.script().getIdOrCode().length() * 2);
        }
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(DeleteRequest request) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.applyGlobalMandatoryParameters(request);
        this.requests.add(request);
        this.sizeInBytes += 50L;
        this.indices.add(request.index());
        return this;
    }

    public List<DocWriteRequest<?>> requests() {
        return this.requests;
    }

    public int numberOfActions() {
        return this.requests.size();
    }

    public long estimatedSizeInBytes() {
        return this.sizeInBytes;
    }

    public BulkRequest add(byte[] data, int from, int length, XContentType xContentType) throws IOException {
        return this.add(data, from, length, null, null, xContentType);
    }

    @Deprecated
    public BulkRequest add(byte[] data, int from, int length, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws IOException {
        return this.add((BytesReference)new BytesArray(data, from, length), defaultIndex, defaultType, xContentType);
    }

    public BulkRequest add(byte[] data, int from, int length, @Nullable String defaultIndex, XContentType xContentType) throws IOException {
        return this.add((BytesReference)new BytesArray(data, from, length), defaultIndex, "_doc", xContentType);
    }

    @Deprecated
    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, true, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, "_doc", null, null, null, null, true, xContentType);
    }

    @Deprecated
    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, allowExplicitIndex, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, "_doc", null, null, null, null, allowExplicitIndex, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, "_doc", defaultRouting, defaultFetchSourceContext, defaultPipeline, null, allowExplicitIndex, xContentType);
    }

    @Deprecated
    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultRouting, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Boolean defaultRequireAlias, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        String routing = BulkRequest.valueOrDefault(defaultRouting, this.globalRouting);
        String pipeline = BulkRequest.valueOrDefault(defaultPipeline, this.globalPipeline);
        Boolean requireAlias = BulkRequest.valueOrDefault(defaultRequireAlias, this.globalRequireAlias);
        new BulkRequestParser(true).parse(data, defaultIndex, defaultType, routing, defaultFetchSourceContext, pipeline, requireAlias, allowExplicitIndex, xContentType, this::internalAdd, this::internalAdd, this::add);
        return this;
    }

    public BulkRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public BulkRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public BulkRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public final BulkRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public final BulkRequest pipeline(String globalPipeline) {
        this.globalPipeline = globalPipeline;
        return this;
    }

    public final BulkRequest routing(String globalRouting) {
        this.globalRouting = globalRouting;
        return this;
    }

    public final BulkRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public String pipeline() {
        return this.globalPipeline;
    }

    public String routing() {
        return this.globalRouting;
    }

    public Boolean requireAlias() {
        return this.globalRequireAlias;
    }

    public BulkRequest requireAlias(Boolean globalRequireAlias) {
        this.globalRequireAlias = globalRequireAlias;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (DocWriteRequest<?> request : this.requests) {
            ActionRequestValidationException ex;
            if (((WriteRequest)((Object)request)).getRefreshPolicy() != WriteRequest.RefreshPolicy.NONE) {
                validationException = ValidateActions.addValidationError("RefreshPolicy is not supported on an item request. Set it on the BulkRequest instead.", validationException);
            }
            if ((ex = ((WriteRequest)((Object)request)).validate()) == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeCollection(this.requests, DocWriteRequest::writeDocumentRequest);
        this.refreshPolicy.writeTo(out);
        out.writeTimeValue(this.timeout);
    }

    @Override
    public String getDescription() {
        return "requests[" + this.requests.size() + "], indices[" + Strings.collectionToDelimitedString(this.indices, ", ") + "]";
    }

    private void applyGlobalMandatoryParameters(DocWriteRequest<?> request) {
        request.index(BulkRequest.valueOrDefault(request.index(), this.globalIndex));
        if (!Strings.isNullOrEmpty(this.globalType) && !"_doc".equals(this.globalType)) {
            request.defaultTypeIfNull(this.globalType);
        }
    }

    private static String valueOrDefault(String value, String globalDefault) {
        if (Strings.isNullOrEmpty(value) && !Strings.isNullOrEmpty(globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    private static Boolean valueOrDefault(Boolean value, Boolean globalDefault) {
        if (Objects.isNull(value) && !Objects.isNull(globalDefault)) {
            return globalDefault;
        }
        return value;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.requests.stream().mapToLong(Accountable::ramBytesUsed).sum();
    }

    public Set<String> getIndices() {
        return Collections.unmodifiableSet(this.indices);
    }
}

