/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

class GeoSouthLatitudeZone
extends GeoBaseBBox {
    protected final double topLat;
    protected final double cosTopLat;
    protected final SidedPlane topPlane;
    protected final GeoPoint interiorPoint;
    protected static final GeoPoint[] planePoints = new GeoPoint[0];
    protected final GeoPoint topBoundaryPoint;
    protected final GeoPoint[] edgePoints;

    public GeoSouthLatitudeZone(PlanetModel planetModel, double topLat) {
        super(planetModel);
        this.topLat = topLat;
        double sinTopLat = Math.sin(topLat);
        this.cosTopLat = Math.cos(topLat);
        double middleLat = (topLat - 1.5707963267948966) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.interiorPoint = new GeoPoint(planetModel, sinMiddleLat, 0.0, Math.sqrt(1.0 - sinMiddleLat * sinMiddleLat), 1.0);
        this.topBoundaryPoint = new GeoPoint(planetModel, sinTopLat, 0.0, Math.sqrt(1.0 - sinTopLat * sinTopLat), 1.0);
        this.topPlane = new SidedPlane((Vector)this.interiorPoint, planetModel, sinTopLat);
        this.edgePoints = new GeoPoint[]{this.topBoundaryPoint};
    }

    public GeoSouthLatitudeZone(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.topLat);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = -1.5707963267948966;
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, -1.5707963267948966, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.topPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        if (this.topLat > 0.0) {
            return Math.PI;
        }
        double maxCosLat = this.cosTopLat;
        return maxCosLat * Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.topPlane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.topPlane, planePoints, new Membership[0]);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addHorizontalPlane(this.planetModel, this.topLat, this.topPlane, new Membership[0]);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.planetModel, (Plane)this.topPlane, x, y, z, new Membership[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoSouthLatitudeZone)) {
            return false;
        }
        GeoSouthLatitudeZone other = (GeoSouthLatitudeZone)o;
        return super.equals(other) && other.topBoundaryPoint.equals(this.topBoundaryPoint);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.topBoundaryPoint.hashCode();
        return result;
    }

    public String toString() {
        return "GeoSouthLatitudeZone: {planetmodel=" + this.planetModel + ", toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + ")}";
    }
}

