/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.build.aws.maven;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionListener;
import org.springframework.build.aws.maven.SessionListenerSupport;

final class StandardSessionListenerSupport
implements SessionListenerSupport {
    private final Wagon wagon;
    private final Set<SessionListener> sessionListeners = new HashSet<SessionListener>();

    StandardSessionListenerSupport(Wagon wagon) {
        this.wagon = wagon;
    }

    @Override
    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListeners.add(sessionListener);
    }

    @Override
    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionListeners.remove(sessionListener);
    }

    @Override
    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.sessionListeners.contains(sessionListener);
    }

    @Override
    public void fireSessionOpening() {
        SessionEvent event = new SessionEvent(this.wagon, 5);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionOpening(event);
        }
    }

    @Override
    public void fireSessionOpened() {
        SessionEvent event = new SessionEvent(this.wagon, 6);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionOpened(event);
        }
    }

    @Override
    public void fireSessionDisconnecting() {
        SessionEvent event = new SessionEvent(this.wagon, 2);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionDisconnecting(event);
        }
    }

    @Override
    public void fireSessionDisconnected() {
        SessionEvent event = new SessionEvent(this.wagon, 3);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionDisconnected(event);
        }
    }

    @Override
    public void fireSessionConnectionRefused() {
        SessionEvent event = new SessionEvent(this.wagon, 4);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionConnectionRefused(event);
        }
    }

    @Override
    public void fireSessionLoggedIn() {
        SessionEvent event = new SessionEvent(this.wagon, 7);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionLoggedIn(event);
        }
    }

    @Override
    public void fireSessionLoggedOff() {
        SessionEvent event = new SessionEvent(this.wagon, 8);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionLoggedOff(event);
        }
    }

    @Override
    public void fireSessionError(Exception exception) {
        SessionEvent event = new SessionEvent(this.wagon, exception);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.sessionError(event);
        }
    }
}

