/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class ShowNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected ShowNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map2 = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try (RevWalk walk2 = new RevWalk(this.repo);){
            Ref ref2 = this.repo.exactRef(this.notesRef);
            if (ref2 != null) {
                notesCommit = walk2.parseCommit(ref2.getObjectId());
                map2 = NoteMap.read(walk2.getObjectReader(), notesCommit);
            }
            Note note = map2.getNote(this.id);
            return note;
        }
        catch (IOException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
    }

    public ShowNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public ShowNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

