/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ObjectRestoreResult;
import com.amazonaws.services.s3.internal.S3RequesterChargedResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazonaws.util.DateUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class ObjectMetadata
implements ServerSideEncryptionResult,
S3RequesterChargedResult,
ObjectExpirationResult,
ObjectRestoreResult,
Cloneable,
Serializable {
    private Map<String, String> userMetadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> metadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    public static final String AES_256_SERVER_SIDE_ENCRYPTION = SSEAlgorithm.AES256.getAlgorithm();
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;

    public ObjectMetadata() {
    }

    private ObjectMetadata(ObjectMetadata from) {
        this.userMetadata = from.userMetadata == null ? null : new TreeMap<String, String>(from.userMetadata);
        this.metadata = from.metadata == null ? null : new TreeMap<String, Object>(from.metadata);
        this.expirationTime = DateUtils.cloneDate(from.expirationTime);
        this.expirationTimeRuleId = from.expirationTimeRuleId;
        this.httpExpiresDate = DateUtils.cloneDate(from.httpExpiresDate);
        this.ongoingRestore = from.ongoingRestore;
        this.restoreExpirationTime = DateUtils.cloneDate(from.restoreExpirationTime);
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public void setHeader(String key2, Object value) {
        this.metadata.put(key2, value);
    }

    public void addUserMetadata(String key2, String value) {
        this.userMetadata.put(key2, value);
    }

    public Map<String, Object> getRawMetadata() {
        TreeMap<String, Object> copy2 = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        copy2.putAll(this.metadata);
        return Collections.unmodifiableMap(copy2);
    }

    public Object getRawMetadataValue(String key2) {
        return this.metadata.get(key2);
    }

    public Date getLastModified() {
        return DateUtils.cloneDate((Date)this.metadata.get("Last-Modified"));
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public long getInstanceLength() {
        int pos;
        String contentRange = (String)this.metadata.get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.metadata.put("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentLanguage() {
        return (String)this.metadata.get("Content-Language");
    }

    public void setContentLanguage(String contentLanguage) {
        this.metadata.put("Content-Language", contentLanguage);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding2) {
        this.metadata.put("Content-Encoding", encoding2);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public void setContentMD5(String md5Base64) {
        if (md5Base64 == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", md5Base64);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-amz-version-id");
    }

    @Override
    public String getSSEAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    @Deprecated
    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-amz-server-side-encryption");
    }

    @Override
    public void setSSEAlgorithm(String algorithm) {
        this.metadata.put("x-amz-server-side-encryption", algorithm);
    }

    @Deprecated
    public void setServerSideEncryption(String algorithm) {
        this.metadata.put("x-amz-server-side-encryption", algorithm);
    }

    @Override
    public String getSSECustomerAlgorithm() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-algorithm");
    }

    @Override
    public void setSSECustomerAlgorithm(String algorithm) {
        this.metadata.put("x-amz-server-side-encryption-customer-algorithm", algorithm);
    }

    @Override
    public String getSSECustomerKeyMd5() {
        return (String)this.metadata.get("x-amz-server-side-encryption-customer-key-MD5");
    }

    @Override
    public void setSSECustomerKeyMd5(String md5Digest) {
        this.metadata.put("x-amz-server-side-encryption-customer-key-MD5", md5Digest);
    }

    @Override
    public Date getExpirationTime() {
        return DateUtils.cloneDate(this.expirationTime);
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public String getExpirationTimeRuleId() {
        return this.expirationTimeRuleId;
    }

    @Override
    public void setExpirationTimeRuleId(String expirationTimeRuleId) {
        this.expirationTimeRuleId = expirationTimeRuleId;
    }

    @Override
    public Date getRestoreExpirationTime() {
        return DateUtils.cloneDate(this.restoreExpirationTime);
    }

    @Override
    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    @Override
    public void setOngoingRestore(boolean ongoingRestore) {
        this.ongoingRestore = ongoingRestore;
    }

    @Override
    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public void setHttpExpiresDate(Date httpExpiresDate) {
        this.httpExpiresDate = httpExpiresDate;
    }

    public Date getHttpExpiresDate() {
        return DateUtils.cloneDate(this.httpExpiresDate);
    }

    public String getStorageClass() {
        Object storageClass = this.metadata.get("x-amz-storage-class");
        if (storageClass == null) {
            return null;
        }
        return storageClass.toString();
    }

    public String getUserMetaDataOf(String key2) {
        return this.userMetadata == null ? null : this.userMetadata.get(key2);
    }

    public ObjectMetadata clone() {
        return new ObjectMetadata(this);
    }

    public String getSSEAwsKmsKeyId() {
        return (String)this.metadata.get("x-amz-server-side-encryption-aws-kms-key-id");
    }

    @Override
    public boolean isRequesterCharged() {
        return this.metadata.get("x-amz-request-charged") != null;
    }

    @Override
    public void setRequesterCharged(boolean isRequesterCharged) {
        if (isRequesterCharged) {
            this.metadata.put("x-amz-request-charged", "requester");
        }
    }

    public Integer getPartCount() {
        return (Integer)this.metadata.get("x-amz-mp-parts-count");
    }

    public Long[] getContentRange() {
        String contentRange = (String)this.metadata.get("Content-Range");
        Long[] range2 = null;
        if (contentRange != null) {
            String[] tokens = contentRange.split("[ -/]+");
            try {
                range2 = new Long[]{Long.parseLong(tokens[1]), Long.parseLong(tokens[2])};
            }
            catch (NumberFormatException nfe) {
                throw new SdkClientException("Unable to parse content range. Header 'Content-Range' has corrupted data" + nfe.getMessage(), nfe);
            }
        }
        return range2;
    }

    public String getReplicationStatus() {
        return (String)this.metadata.get("x-amz-replication-status");
    }
}

