/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.ColumnNotDisplayableException;
import ca.sqlpower.sql.NoRowidException;
import ca.sqlpower.sql.WebResultFormatter;
import ca.sqlpower.sql.WebResultSet;
import ca.sqlpower.util.NaanSafeNumberFormat;
import java.io.PrintWriter;
import java.sql.SQLException;

public class WebResultFormFormatter
extends WebResultFormatter {
    private int numHTMLCols = 3;

    public WebResultFormFormatter() {
        this.moneyFormatter = new NaanSafeNumberFormat("#0.00");
        this.numberFormatter = new NaanSafeNumberFormat("#.#");
    }

    public void setNumHTMLCols(int numCols) {
        this.numHTMLCols = numCols;
    }

    public int getNumHTMLCols() {
        return this.numHTMLCols;
    }

    @Override
    public void formatToStream(WebResultSet wrs, PrintWriter out) throws SQLException, NoRowidException {
        int numCols = wrs.getColumnCount();
        int cell = 0;
        int col = 0;
        StringBuffer contents = new StringBuffer(60);
        StringBuffer align = new StringBuffer(10);
        StringBuffer label = new StringBuffer(20);
        if (!wrs.next()) {
            return;
        }
        out.println("<table>");
        out.println(" <tr>");
        do {
            contents.setLength(0);
            align.setLength(0);
            label.setLength(0);
            try {
                this.getColumnFormatted(wrs, cell + 1, contents, align);
                label.append(wrs.getColumnLabel(cell + 1));
            }
            catch (ColumnNotDisplayableException e) {
                ++cell;
                continue;
            }
            out.println("  <td align=\"right\" class=\"searchForm\">");
            out.println(this.beautifyHeading(label.toString()));
            out.println("  </td>");
            out.println("  <td>");
            switch (wrs.getColumnType(cell + 1)) {
                case 14: {
                    out.print("   <input type=\"password\" length=\"30\" name=\"");
                    out.print(label);
                    out.print("\" />");
                    break;
                }
                case 4: {
                    out.print("   <input type=\"checkbox\" name=\"");
                    out.print(label);
                    out.print("\" ");
                    if (contents.toString().equals("True")) {
                        out.print("checked=\"checked\"");
                    }
                    out.print(" />");
                    break;
                }
                default: {
                    out.print("   <input type=\"text\" length=\"30\" name=\"");
                    out.print(label);
                    out.print("\" value=\"");
                    out.print(contents.toString());
                    out.println("\" />");
                }
            }
            out.println("  </td>");
            if (col == this.numHTMLCols - 1) {
                col = 0;
                out.println(" </tr>");
                out.println(" <tr>");
            } else {
                ++col;
            }
            ++cell;
        } while (cell < numCols);
        out.println(" </tr>");
        out.println("</table>");
        out.flush();
    }
}

