/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PStack;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PPaintContext {
    public static final int LOW_QUALITY_RENDERING = 0;
    public static final int HIGH_QUALITY_RENDERING = 1;
    public static FontRenderContext RENDER_QUALITY_LOW_FRC = new FontRenderContext(null, false, true);
    public static FontRenderContext RENDER_QUALITY_HIGH_FRC = new FontRenderContext(null, true, true);
    public static PPaintContext CURRENT_PAINT_CONTEXT;
    private static double[] PTS;
    private Graphics2D graphics;
    protected PStack compositeStack;
    protected PStack clipStack;
    protected PStack localClipStack;
    protected PStack cameraStack;
    protected PStack transformStack;
    protected int renderQuality;

    public PPaintContext(Graphics2D graphics2D) {
        this.graphics = graphics2D;
        this.compositeStack = new PStack();
        this.clipStack = new PStack();
        this.localClipStack = new PStack();
        this.cameraStack = new PStack();
        this.transformStack = new PStack();
        this.renderQuality = 1;
        Shape shape = graphics2D.getClip();
        if (shape == null) {
            shape = new PBounds(-1.073741823E9, -1.073741823E9, 2.147483647E9, 2.147483647E9);
            graphics2D.setClip(shape);
        }
        this.localClipStack.push(shape.getBounds2D());
        CURRENT_PAINT_CONTEXT = this;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public Rectangle2D getLocalClip() {
        return (Rectangle2D)this.localClipStack.peek();
    }

    public double getScale() {
        PPaintContext.PTS[0] = 0.0;
        PPaintContext.PTS[1] = 0.0;
        PPaintContext.PTS[2] = 1.0;
        PPaintContext.PTS[3] = 0.0;
        this.graphics.getTransform().transform(PTS, 0, PTS, 0, 2);
        return Point2D.distance(PTS[0], PTS[1], PTS[2], PTS[3]);
    }

    public void pushCamera(PCamera pCamera) {
        this.cameraStack.push(pCamera);
    }

    public void popCamera(PCamera pCamera) {
        this.cameraStack.pop();
    }

    public PCamera getCamera() {
        return (PCamera)this.cameraStack.peek();
    }

    public void pushClip(Shape shape) {
        Shape shape2 = this.graphics.getClip();
        this.clipStack.push(shape2);
        this.graphics.clip(shape);
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D.intersect(this.getLocalClip(), rectangle2D, rectangle2D);
        this.localClipStack.push(rectangle2D);
    }

    public void popClip(Shape shape) {
        Shape shape2 = (Shape)this.clipStack.pop();
        this.graphics.setClip(shape2);
        this.localClipStack.pop();
    }

    public void pushTransparency(float f) {
        if (f == 1.0f) {
            return;
        }
        Composite composite = this.graphics.getComposite();
        float f2 = 1.0f;
        this.compositeStack.push(composite);
        if (composite instanceof AlphaComposite) {
            f2 = ((AlphaComposite)composite).getAlpha();
        }
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2 * f);
        this.graphics.setComposite(alphaComposite);
    }

    public void popTransparency(float f) {
        if (f == 1.0f) {
            return;
        }
        Composite composite = (Composite)this.compositeStack.pop();
        this.graphics.setComposite(composite);
    }

    public void pushTransform(PAffineTransform pAffineTransform) {
        if (pAffineTransform == null) {
            return;
        }
        Rectangle2D rectangle2D = (Rectangle2D)this.getLocalClip().clone();
        pAffineTransform.inverseTransform(rectangle2D, rectangle2D);
        this.transformStack.push(this.graphics.getTransform());
        this.localClipStack.push(rectangle2D);
        this.graphics.transform(pAffineTransform);
    }

    public void popTransform(PAffineTransform pAffineTransform) {
        if (pAffineTransform == null) {
            return;
        }
        this.graphics.setTransform((AffineTransform)this.transformStack.pop());
        this.localClipStack.pop();
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(int n) {
        this.renderQuality = n;
        switch (this.renderQuality) {
            case 1: {
                this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                break;
            }
            case 0: {
                this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
        }
    }

    static {
        PTS = new double[4];
    }
}

