"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
function run(opts) {
    const { port } = opts;
    return new stream_1.Writable({
        autoDestroy: true,
        write(chunk, enc, cb) {
            port.postMessage(chunk.toString());
            cb();
        }
    });
}
exports.default = run;
