/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.UnwrapLinksEmitter;
import javax.xml.transform.TransformerException;

public class UnwrapLinks {
    private static boolean foStylesheet = false;

    protected static String getVariable(Context context, String varName) {
        Value variable = null;
        String varString = null;
        try {
            variable = Extensions.evaluate((Context)context, (String)("$" + varName));
            varString = variable.asString();
            return varString;
        }
        catch (TransformerException te) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
    }

    private static void setupUnwrapLinks(Context context) {
        String varString = UnwrapLinks.getVariable(context, "stylesheet.result.type");
        foStylesheet = varString.equals("fo");
    }

    public static NodeSetValue unwrapLinks(Context context, NodeSetValue rtf_ns) {
        FragmentValue rtf = (FragmentValue)rtf_ns;
        boolean tryAgain = true;
        UnwrapLinks.setupUnwrapLinks(context);
        try {
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            while (tryAgain) {
                UnwrapLinksEmitter ulEmitter = new UnwrapLinksEmitter(controller, namePool, foStylesheet);
                rtf.replay((Emitter)ulEmitter);
                tryAgain = ulEmitter.tryAgain();
                rtf = ulEmitter.getResultTreeFragment();
            }
            return rtf;
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in unwrapLinks");
            return rtf;
        }
    }
}

