/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class TinyParentNodeImpl
extends TinyNodeImpl {
    public final boolean hasChildNodes() {
        return this.nodeNr + 1 < this.tree.numberOfNodes && this.tree.depth[this.nodeNr + 1] > this.tree.depth[this.nodeNr];
    }

    public final String getStringValue() {
        return ((Object)TinyParentNodeImpl.getStringValueCS(this.tree, this.nodeNr)).toString();
    }

    public CharSequence getStringValueCS() {
        return TinyParentNodeImpl.getStringValueCS(this.tree, this.nodeNr);
    }

    public static CharSequence getStringValueCS(TinyTree tree, int nodeNr) {
        int next = nodeNr + 1;
        short level = tree.depth[nodeNr];
        if (tree.depth[next] <= level) {
            return "";
        }
        if (tree.nodeKind[next] == 3 && (next + 1 >= tree.numberOfNodes || tree.depth[next + 1] <= level)) {
            return TinyTextImpl.getStringValue(tree, next);
        }
        FastStringBuffer sb = null;
        while (next < tree.numberOfNodes && tree.depth[next] > level) {
            byte kind = tree.nodeKind[next];
            if (kind == 3) {
                if (sb == null) {
                    sb = new FastStringBuffer(256);
                }
                sb.append(TinyTextImpl.getStringValue(tree, next));
            } else if (kind == 4) {
                if (sb == null) {
                    sb = new FastStringBuffer(256);
                }
                WhitespaceTextImpl.appendStringValue(tree, next, sb);
            }
            ++next;
        }
        if (sb == null) {
            return "";
        }
        return sb.condense();
    }
}

